/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.org.biz.view.OrgViewSchemaRefrenceChecker;
import kd.bos.org.utils.Utils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class OrgRelationTreePlugin
extends AbstractTreeListPlugin
implements TreeNodeClickListener,
RowClickEventListener,
TabSelectListener,
HyperLinkClickListener {
    public static final String ENTITY_TYPERELATION = "bos_org_typerelation";
    public static final String ENTITY_ORGRELATION = "bos_org_orgrelation";
    public static final String ENTITY_ORGRELATION_COND = "bos_org_relationcond";
    private static final String LEFT_ENTRY = "leftentry";
    private static final String RIGHT_ENTRY = "rightentry";
    private static final String TAB_TOORGTAB = "toorgtab";
    private static final String TOORG = "toorg";
    private static final String FROMORG = "fromorg";
    private static final String IS_CONDITION_CHANGED = "is_condition_changed";
    public static final String RELATIONCONDCACHE = "relationCondCache";
    private static final String ERROR_COLOR = "#FD6C6A";
    private static final String DEFAULT_COLOR = "#FFFFFF";
    private static final String IMG_NEW = "img_new";
    private static final String IMG_EDIT = "img_edit";
    private static final String IMG_DEL = "img_del";
    private static final String TREEVIEWAP = "treeviewap";
    private static final String BAR_SAVE = "bar_save";
    private static final String SELECTTAB = "selectTab";
    private static final String IS_DEFAULT_FROMORG = "isdefaultfromorg";
    private static final String IS_DEFAULT_TOORG = "isdefaulttoorg";
    private static final String ORG_RELATION = "orgrelation";
    private static final String BIZ_OBJECT = "bizobject";
    private static final String SAVE_DATA = "SAVE_DATA";
    private static final String IS_CONDITION_FROM_DB = "isconditionfromdb";
    private static final String FROM_TYPE = "fromtype";
    private static final String TO_TYPE = "totype";
    private static final String CUR_RELATION_TYPEID = "curRelationTypeId";
    private static final String LEFT_ORG = "leftorg";
    private static final String RIGHT_ORG = "rightorg";
    private static final String DELETE_LEFT_ENTRY_ORG = "deleteLeftEntryOrg";
    private static final String DELETE_RIGHT_ENTRY_ORG = "deleteRightEntryOrg";
    private static final String DELETED_RELATION = "deletedRelation";
    private static final String ORG_RELATION_ID = "orgRelationId";
    private static final String RIGHT_ORGID = "rightOrgId";
    private static final String CONDITION = "condition";
    private static final String OPERATE_IMPORT_BY_FROMORG = "importbyfromorg";
    private static final String BAR_IMPORT_BY_FROMORG = "bar_importbyfromorg";
    private static final String OPERATE_IMPORT_BY_TOORG = "importbytoorg";
    private static final String BAR_IMPORT_BY_TOORG = "bar_importbytoorg";
    private static final String DESCRIPTION = "description";

    public void registerListener(EventObject e) {
        Tab tab;
        EntryGrid rightEntry;
        EntryGrid leftEntry;
        super.registerListener(e);
        this.addClickListeners(new String[]{IMG_NEW, IMG_EDIT, IMG_DEL, "conditionlink"});
        this.addItemClickListeners(new String[]{IMG_NEW, IMG_EDIT, IMG_DEL, "leftbar", "rightbar", "tbmain"});
        TreeView tv = (TreeView)this.getControl(TREEVIEWAP);
        if (tv != null) {
            tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        }
        if ((leftEntry = (EntryGrid)this.getControl(LEFT_ENTRY)) != null) {
            leftEntry.addRowClickListener((RowClickEventListener)this);
        }
        if ((rightEntry = (EntryGrid)this.getControl(RIGHT_ENTRY)) != null) {
            rightEntry.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((tab = (Tab)this.getControl("tabap")) != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        if (!this.hasSavePermission()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SAVE, BAR_IMPORT_BY_FROMORG, BAR_IMPORT_BY_TOORG});
        }
    }

    private boolean hasSavePermission() {
        String hasSavePermissionCache = this.getPageCache().get("hasSavePermission");
        boolean hasSavePermission = false;
        if (hasSavePermissionCache == null) {
            hasSavePermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)"bos_org_orgrelation_tree", (String)"0=KX5+QVF5+R");
            this.getPageCache().put("hasSavePermission", Boolean.toString(hasSavePermission));
        } else {
            hasSavePermission = Boolean.parseBoolean(hasSavePermissionCache);
        }
        return hasSavePermission;
    }

    public void afterCreateNewData(EventObject eventobject) {
        this.getPageCache().put(SELECTTAB, TAB_TOORGTAB);
        this.initTree();
        this.switchDefaultOrgVisible();
        this.enableEditPanel(false);
    }

    private void switchDefaultOrgVisible() {
        String curTab = this.getPageCache().get(SELECTTAB);
        if (TAB_TOORGTAB.equals(curTab)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{IS_DEFAULT_FROMORG});
            this.getView().setVisible(Boolean.FALSE, new String[]{IS_DEFAULT_TOORG});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{IS_DEFAULT_FROMORG});
            this.getView().setVisible(Boolean.TRUE, new String[]{IS_DEFAULT_TOORG});
        }
    }

    private void initTree() {
        this.getPageCache().remove(FROM_TYPE);
        this.getPageCache().remove(TO_TYPE);
        TreeView tv = (TreeView)this.getControl(TREEVIEWAP);
        tv.deleteAllNodes();
        TreeNode root = new TreeNode("", "0", ResManager.loadKDString((String)"\u4e1a\u52a1\u534f\u4f5c\u7c7b\u578b", (String)"OrgRelationTreePlugin_0", (String)"bos-org-formplugin", (Object[])new Object[0]));
        QFilter visibleFilter = new QFilter("isvisible", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{visibleFilter};
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_TYPERELATION, (String)"totype,fromtype,name", (QFilter[])filters, (String)"number");
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                TreeNode treeNode = new TreeNode("0", dynamicObject.getPkValue().toString(), dynamicObject.getLocaleString("name").getLocaleValue());
                root.addChild(treeNode);
            }
        }
        root.setIsOpened(true);
        tv.addNode(root);
        tv.focusNode(root);
        this.getPageCache().remove(CUR_RELATION_TYPEID);
        this.getModel().deleteEntryData(LEFT_ENTRY);
        this.getModel().deleteEntryData(RIGHT_ENTRY);
        this.switchRelationEntryTitle(this.getPageCache().get(SELECTTAB));
    }

    private void switchRelationEntryTitle(String curTabName) {
        this.getPageCache().put(SELECTTAB, curTabName);
        String fromTypeTabName = ResManager.loadKDString((String)"\u59d4\u6258\u65b9", (String)"OrgRelationTreePlugin_1", (String)"bos-org-formplugin", (Object[])new Object[0]);
        String toTypeTabName = ResManager.loadKDString((String)"\u53d7\u6258\u65b9", (String)"OrgRelationTreePlugin_2", (String)"bos-org-formplugin", (Object[])new Object[0]);
        if (TAB_TOORGTAB.equals(curTabName)) {
            HashMap<String, LocaleString> propertiesMap = new HashMap<String, LocaleString>(1);
            propertiesMap.put("text", new LocaleString(toTypeTabName));
            this.getView().updateControlMetadata("leftadvconap", propertiesMap);
            propertiesMap = new HashMap(1);
            propertiesMap.put("text", new LocaleString(fromTypeTabName));
            this.getView().updateControlMetadata("rightadvconap", propertiesMap);
            Label leftDutyTitle = (Label)this.getControl("leftdutytitle");
            leftDutyTitle.setText(this.getViewSchemaName(TO_TYPE));
            Label rightDutyTitle = (Label)this.getControl("rightdutytitle");
            rightDutyTitle.setText(this.getViewSchemaName(FROM_TYPE));
        } else {
            HashMap<String, LocaleString> propertiesMap = new HashMap<String, LocaleString>(1);
            propertiesMap.put("text", new LocaleString(fromTypeTabName));
            this.getView().updateControlMetadata("leftadvconap", propertiesMap);
            propertiesMap = new HashMap(1);
            propertiesMap.put("text", new LocaleString(toTypeTabName));
            this.getView().updateControlMetadata("rightadvconap", propertiesMap);
            Label leftDutyTitle = (Label)this.getControl("leftdutytitle");
            leftDutyTitle.setText(this.getViewSchemaName(FROM_TYPE));
            Label rightDutyTitle = (Label)this.getControl("rightdutytitle");
            rightDutyTitle.setText(this.getViewSchemaName(TO_TYPE));
        }
    }

    private String getViewSchemaName(String treeType) {
        String fromtype = this.getPageCache().get(treeType);
        if (StringUtils.isBlank((CharSequence)fromtype)) {
            return "";
        }
        QFilter numberFilter = new QFilter("fnumber", "=", (Object)fromtype);
        QFilter[] filters = new QFilter[]{numberFilter};
        DynamicObject viewschemaObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_biz", (String)"fname", (QFilter[])filters);
        if (viewschemaObj == null) {
            return "";
        }
        return viewschemaObj.getString("fname");
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "bar_save": {
                if (!this.isHasEmptyRelation()) break;
                String curTabName = this.getPageCache().get(SELECTTAB);
                if (TAB_TOORGTAB.equals(curTabName)) {
                    this.getView().showErrorNotification(OrgMessage.getMessage((String)"M00032"));
                } else {
                    this.getView().showErrorNotification(OrgMessage.getMessage((String)"M00033"));
                }
                evt.setCancel(true);
                break;
            }
            case "rightadd": {
                this.addOrgToRightEntry(evt);
                break;
            }
        }
    }

    private void addOrgToRightEntry(BeforeItemClickEvent evt) {
        EntryGrid leftEntry = (EntryGrid)this.getControl(LEFT_ENTRY);
        int[] selectRows = leftEntry.getEntryState().getSelectedRows();
        if (selectRows != null && selectRows.length > 1) {
            if (TAB_TOORGTAB.equals(this.getPageCache().get(SELECTTAB))) {
                this.getView().showTipNotification(OrgMessage.getMessage((String)"M00034"));
            } else {
                this.getView().showTipNotification(OrgMessage.getMessage((String)"M00035"));
            }
            evt.setCancel(true);
        } else if (CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity(LEFT_ENTRY)) || leftEntry.getEntryState() == null || leftEntry.getEntryState().getFocusRow() < 0) {
            if (TAB_TOORGTAB.equals(this.getPageCache().get(SELECTTAB))) {
                this.getView().showTipNotification(OrgMessage.getMessage((String)"M00036"));
            } else {
                this.getView().showTipNotification(OrgMessage.getMessage((String)"M00037"));
            }
            evt.setCancel(true);
        }
    }

    private boolean isHasEmptyRelation() {
        int nIdx;
        Iterator iterator;
        int index;
        DynamicObjectCollection leftEntryCol;
        String curRelationTypeId = this.getPageCache().get(CUR_RELATION_TYPEID);
        if (StringUtils.isBlank((CharSequence)curRelationTypeId)) {
            return false;
        }
        Map<String, List<Map<String, String>>> relationMap = this.getCurrentRelationCache(curRelationTypeId);
        if (relationMap == null || relationMap.isEmpty()) {
            this.getPageCache().remove(IS_CONDITION_CHANGED);
        }
        if (Utils.isListEmpty((List)(leftEntryCol = this.getModel().getEntryEntity(LEFT_ENTRY)))) {
            this.getPageCache().remove(IS_CONDITION_CHANGED);
            return false;
        }
        ArrayList<Integer> markList = new ArrayList<Integer>();
        ArrayList<Integer> normalList = new ArrayList<Integer>();
        boolean isHasEmptyRelation = this.isHasEmptyRelation(leftEntryCol, relationMap, markList, normalList);
        EntryGrid grid = (EntryGrid)this.getControl(LEFT_ENTRY);
        if (!normalList.isEmpty()) {
            int[] indexArr = new int[normalList.size()];
            index = 0;
            iterator = normalList.iterator();
            while (iterator.hasNext()) {
                nIdx = (Integer)iterator.next();
                indexArr[index++] = nIdx;
            }
            grid.setRowBackcolor(null, indexArr);
        }
        if (isHasEmptyRelation) {
            int[] markIndexArr = new int[markList.size()];
            index = 0;
            iterator = markList.iterator();
            while (iterator.hasNext()) {
                nIdx = (Integer)iterator.next();
                markIndexArr[index++] = nIdx;
            }
            grid.setRowBackcolor(ERROR_COLOR, markIndexArr);
        }
        return isHasEmptyRelation;
    }

    private boolean isHasEmptyRelation(DynamicObjectCollection leftEntryCol, Map<String, List<Map<String, String>>> relationMap, List<Integer> markList, List<Integer> normalList) {
        boolean isHasEmptyRelation = false;
        int leftEntryCount = leftEntryCol.size();
        for (int i = 0; i < leftEntryCount; ++i) {
            DynamicObject leftEntryObj = (DynamicObject)leftEntryCol.get(i);
            DynamicObject orgObj = leftEntryObj.getDynamicObject(LEFT_ORG);
            if (orgObj == null) continue;
            if (relationMap == null || Utils.isListEmpty(relationMap.get(orgObj.getString("id")))) {
                isHasEmptyRelation = true;
                markList.add(i);
                continue;
            }
            normalList.add(i);
        }
        return isHasEmptyRelation;
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "bar_save": {
                this.save();
                break;
            }
            case "leftadd": {
                this.showOrgF7(true);
                break;
            }
            case "rightadd": {
                this.showOrgF7(false);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String operateKey;
        super.afterDoOperation(eventArgs);
        switch (operateKey = eventArgs.getOperateKey()) {
            case "importbyfromorg": {
                this.showImportList("bos_org_relation_ipbyfo");
                break;
            }
            case "importbytoorg": {
                this.showImportList("bos_org_relation_ipbyto");
            }
        }
    }

    private void showImportList(String formId) {
        ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)formId, (boolean)true, (int)0, (boolean)false);
        this.getView().showForm((FormShowParameter)showListForm);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        int[] indexArr = e.getRowIndexs();
        if (indexArr == null || indexArr.length == 0) {
            return;
        }
        String entryName = e.getEntryProp().getName();
        if (LEFT_ENTRY.equals(entryName)) {
            this.beforeDeleteLeftEntryRow(indexArr);
        } else {
            this.beforeDeleteRightEntryRow(indexArr);
        }
    }

    private void beforeDeleteLeftEntryRow(int[] indexArr) {
        ArrayList<String> orgList = new ArrayList<String>();
        for (int index : indexArr) {
            DynamicObject orgObj;
            DynamicObject leftEntryObj = this.getModel().getEntryRowEntity(LEFT_ENTRY, index);
            if (leftEntryObj == null || (orgObj = leftEntryObj.getDynamicObject(LEFT_ORG)) == null) continue;
            orgList.add(orgObj.getString("id"));
        }
        if (!orgList.isEmpty()) {
            this.getPageCache().put(DELETE_LEFT_ENTRY_ORG, SerializationUtils.toJsonString(orgList));
        }
    }

    private void beforeDeleteRightEntryRow(int[] indexArr) {
        ArrayList<String> orgList = new ArrayList<String>();
        for (int index : indexArr) {
            DynamicObject orgObj;
            DynamicObject rightEntryObj = this.getModel().getEntryRowEntity(RIGHT_ENTRY, index);
            if (rightEntryObj == null || (orgObj = rightEntryObj.getDynamicObject(RIGHT_ORG)) == null) continue;
            orgList.add(orgObj.getString("id"));
        }
        if (!orgList.isEmpty()) {
            this.getPageCache().put(DELETE_RIGHT_ENTRY_ORG, SerializationUtils.toJsonString(orgList));
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.updateCacheAfterDeleteEntry();
        int[] rowIndexs = e.getRowIndexs();
        if (rowIndexs != null && rowIndexs.length > 0) {
            EntryGrid leftEntry = (EntryGrid)this.getControl(e.getEntryProp().getName());
            int rowIndex = rowIndexs[rowIndexs.length - 1] - 1;
            leftEntry.entryRowClick(Integer.valueOf(rowIndex));
        }
    }

    private void updateCacheAfterDeleteEntry() {
        String curRelationTypeId = this.getPageCache().get(CUR_RELATION_TYPEID);
        if (StringUtils.isBlank((CharSequence)curRelationTypeId)) {
            return;
        }
        Map<String, List<Map<String, String>>> relationMap = this.getCurrentRelationCache(curRelationTypeId);
        if (relationMap == null || relationMap.isEmpty()) {
            return;
        }
        String deletedCache = this.getPageCache().get(DELETED_RELATION);
        ArrayList<String> deleteList = null;
        if (StringUtils.isNotBlank((CharSequence)deletedCache)) {
            deleteList = (ArrayList<String>)SerializationUtils.fromJsonString((String)deletedCache, List.class);
        }
        if (deleteList == null) {
            deleteList = new ArrayList<String>(1);
        }
        this.deleteLeftEntry(relationMap, (List<String>)deleteList);
        this.deleteRightEntry(relationMap, deleteList);
        this.getPageCache().put(DELETED_RELATION, SerializationUtils.toJsonString(deleteList));
        this.getPageCache().put(curRelationTypeId, SerializationUtils.toJsonString(relationMap));
        this.getPageCache().put(IS_CONDITION_CHANGED, "");
    }

    private void deleteLeftEntry(Map<String, List<Map<String, String>>> relationMap, List<String> deleteList) {
        String leftOrgCache = this.getPageCache().get(DELETE_LEFT_ENTRY_ORG);
        this.getPageCache().remove(DELETE_LEFT_ENTRY_ORG);
        if (StringUtils.isBlank((CharSequence)leftOrgCache)) {
            return;
        }
        List leftOrgList = (List)SerializationUtils.fromJsonString((String)leftOrgCache, List.class);
        if (Utils.isListEmpty((List)leftOrgList)) {
            return;
        }
        for (String leftOrg : leftOrgList) {
            List<Map<String, String>> rightMapList = relationMap.get(leftOrg);
            if (Utils.isListNotEmpty(rightMapList)) {
                for (Map<String, String> map : rightMapList) {
                    String orgRelationId = map.get(ORG_RELATION_ID);
                    if (!StringUtils.isNotBlank((CharSequence)orgRelationId) || "0".equals(orgRelationId)) continue;
                    deleteList.add(orgRelationId);
                }
            }
            relationMap.remove(leftOrg);
        }
        this.getModel().deleteEntryData(RIGHT_ENTRY);
    }

    private void deleteRightEntry(Map<String, List<Map<String, String>>> relationMap, List<String> deleteList) {
        String leftOrg = this.getLeftOrgForDeleteRightEntry();
        if (StringUtils.isBlank((CharSequence)leftOrg)) {
            return;
        }
        List<Map<String, String>> rightMapList = relationMap.get(leftOrg);
        if (rightMapList == null) {
            return;
        }
        if (!rightMapList.isEmpty()) {
            List<String> rightOrgList = this.getRightOrgFromCache();
            Iterator<Map<String, String>> iterator = rightMapList.iterator();
            while (iterator.hasNext()) {
                Map<String, String> map = iterator.next();
                String rightOrgId = map.get(RIGHT_ORGID);
                if (!rightOrgList.contains(rightOrgId)) continue;
                String orgRelationId = map.get(ORG_RELATION_ID);
                if (StringUtils.isNotBlank((CharSequence)orgRelationId) && !"0".equals(orgRelationId)) {
                    deleteList.add(orgRelationId);
                }
                iterator.remove();
                rightOrgList.remove(rightOrgId);
                if (!rightOrgList.isEmpty()) continue;
                break;
            }
        }
        if (rightMapList.isEmpty()) {
            relationMap.remove(leftOrg);
        }
    }

    private String getLeftOrgForDeleteRightEntry() {
        EntryGrid leftEntry = (EntryGrid)this.getControl(LEFT_ENTRY);
        if (leftEntry.getEntryState() == null || leftEntry.getEntryState().getFocusRow() < 0) {
            return "";
        }
        int leftEntryIndex = leftEntry.getEntryState().getFocusRow();
        DynamicObject leftEntryObj = this.getModel().getEntryRowEntity(LEFT_ENTRY, leftEntryIndex);
        if (leftEntryObj == null) {
            return "";
        }
        DynamicObject leftOrgObj = leftEntryObj.getDynamicObject(LEFT_ORG);
        if (leftOrgObj == null) {
            return "";
        }
        return leftOrgObj.getString("id");
    }

    private List<String> getRightOrgFromCache() {
        String rightOrgCache = this.getPageCache().get(DELETE_RIGHT_ENTRY_ORG);
        this.getPageCache().remove(DELETE_RIGHT_ENTRY_ORG);
        if (StringUtils.isBlank((CharSequence)rightOrgCache)) {
            return new ArrayList<String>();
        }
        List rightOrgList = (List)SerializationUtils.fromJsonString((String)rightOrgCache, List.class);
        if (Utils.isListEmpty((List)rightOrgList)) {
            return new ArrayList<String>();
        }
        return rightOrgList;
    }

    private void save() {
        String curRelationTypeId = this.getPageCache().get(CUR_RELATION_TYPEID);
        if (StringUtils.isBlank((CharSequence)curRelationTypeId)) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                this.doSave(curRelationTypeId);
                IPageCache pageCache = this.getPageCache();
                pageCache.remove(IS_CONDITION_CHANGED);
                pageCache.remove(curRelationTypeId);
                TreeView tv = (TreeView)this.getControl(TREEVIEWAP);
                String focusNodeId = tv.getTreeState().getFocusNodeId();
                pageCache.put(CUR_RELATION_TYPEID, "");
                tv.treeNodeClick("", focusNodeId);
                this.getView().showSuccessNotification(BaseMessage.getMessage((String)"M00021"));
            }
            catch (Exception e) {
                this.getView().showErrorNotification(BaseMessage.getMessage((String)"M00022") + e.getMessage());
                h.markRollback();
            }
        }
    }

    private void doSave(String curRelationTypeId) {
        int conditionCount;
        this.deleteRelation();
        Map<String, List<Map<String, String>>> relationMap = this.getCurrentRelationCache(curRelationTypeId);
        if (relationMap == null || relationMap.isEmpty()) {
            this.getPageCache().remove(IS_CONDITION_CHANGED);
            return;
        }
        String selectTab = this.getPageCache().get(SELECTTAB);
        ArrayList<Long> updateRelationIds = new ArrayList<Long>();
        HashMap<Long, Map<String, String>> updateRelationMap = new HashMap<Long, Map<String, String>>();
        HashMap<Long, String> updateRelationCondMap = new HashMap<Long, String>();
        ArrayList<DynamicObject> addRelationList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> addConditionList = new ArrayList<DynamicObject>();
        long[] idArr = this.genRelationIds(relationMap);
        int idIndex = 0;
        for (Map.Entry<String, List<Map<String, String>>> entry : relationMap.entrySet()) {
            List<Map<String, String>> rightEntryList = entry.getValue();
            if (Utils.isListEmpty(rightEntryList)) continue;
            String leftOrgId = entry.getKey();
            for (Map<String, String> rightEntryMap : rightEntryList) {
                String orgRelationId = rightEntryMap.get(ORG_RELATION_ID);
                String condition = rightEntryMap.get(CONDITION);
                if (StringUtils.isBlank((CharSequence)orgRelationId)) {
                    long id = idArr[idIndex++];
                    this.addRelation(id, condition, selectTab, leftOrgId, rightEntryMap, curRelationTypeId, addRelationList, addConditionList);
                    continue;
                }
                Long orgRelationIdLong = Long.valueOf(orgRelationId);
                updateRelationIds.add(orgRelationIdLong);
                updateRelationMap.put(orgRelationIdLong, rightEntryMap);
                updateRelationCondMap.put(orgRelationIdLong, condition);
            }
        }
        int relationCount = addRelationList.size();
        if (relationCount > 0) {
            SaveServiceHelper.save((DynamicObject[])addRelationList.toArray(new DynamicObject[relationCount]));
        }
        if ((conditionCount = addConditionList.size()) > 0) {
            SaveServiceHelper.save((DynamicObject[])addConditionList.toArray(new DynamicObject[conditionCount]));
        }
        this.updateRelation(updateRelationIds, updateRelationMap);
        this.updateCondition(updateRelationCondMap);
    }

    private void addRelation(long id, String condition, String selectTab, String leftOrgId, Map<String, String> rightEntryMap, String curRelationTypeId, List<DynamicObject> addRelationList, List<DynamicObject> addConditionList) {
        String fromOrgId = "";
        String toOrgId = "";
        String rightOrgId = rightEntryMap.get(RIGHT_ORGID);
        if (TAB_TOORGTAB.equals(selectTab)) {
            fromOrgId = rightOrgId;
            toOrgId = leftOrgId;
        } else {
            fromOrgId = leftOrgId;
            toOrgId = rightOrgId;
        }
        DynamicObject relationObj = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ORGRELATION);
        relationObj.set("id", (Object)id);
        relationObj.set("typerelation", (Object)curRelationTypeId);
        relationObj.set(FROMORG, (Object)fromOrgId);
        relationObj.set(TOORG, (Object)toOrgId);
        relationObj.set(IS_DEFAULT_FROMORG, (Object)rightEntryMap.get(IS_DEFAULT_FROMORG));
        relationObj.set(IS_DEFAULT_TOORG, (Object)rightEntryMap.get(IS_DEFAULT_TOORG));
        addRelationList.add(relationObj);
        if (StringUtils.isBlank((CharSequence)condition)) {
            return;
        }
        List conditionList = (List)SerializationUtils.fromJsonString((String)condition, List.class);
        for (Map conditionMap : conditionList) {
            for (Map.Entry conditionEntry : conditionMap.entrySet()) {
                DynamicObject conditionObj = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ORGRELATION_COND);
                conditionObj.set(ORG_RELATION, (Object)id);
                conditionObj.set(BIZ_OBJECT, conditionEntry.getKey());
                conditionObj.set(CONDITION, conditionEntry.getValue());
                addConditionList.add(conditionObj);
            }
        }
    }

    private long[] genRelationIds(Map<String, List<Map<String, String>>> relationMap) {
        int count = 0;
        for (Map.Entry<String, List<Map<String, String>>> entry : relationMap.entrySet()) {
            List<Map<String, String>> rightEntryList = entry.getValue();
            if (Utils.isListEmpty(rightEntryList)) continue;
            for (Map<String, String> rightEntryMap : rightEntryList) {
                String orgRelationId = rightEntryMap.get(ORG_RELATION_ID);
                if (!StringUtils.isBlank((CharSequence)orgRelationId)) continue;
                ++count;
            }
        }
        if (count == 0) {
            return new long[0];
        }
        return ORM.create().genLongIds(ENTITY_ORGRELATION, count);
    }

    private void deleteRelationType() {
        TreeView tv = (TreeView)this.getControl(TREEVIEWAP);
        String focusNodeIdStr = tv.getTreeState().getFocusNodeId();
        if (StringUtils.isBlank((CharSequence)focusNodeIdStr)) {
            return;
        }
        Long focusNodeId = Long.valueOf(focusNodeIdStr);
        ArrayList<Long> relationList = new ArrayList<Long>();
        QFilter[] filters = new QFilter[]{new QFilter("typerelation", "=", (Object)focusNodeId)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.bos.org.OrgRelationTreePlugin.deleteRelationType", (String)ENTITY_ORGRELATION, (String)"id", (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                relationList.add(row.getLong("id"));
            }
        }
        if (!relationList.isEmpty()) {
            DeleteServiceHelper.delete((String)ENTITY_ORGRELATION_COND, (QFilter[])new QFilter[]{new QFilter(ORG_RELATION, "in", relationList)});
            DeleteServiceHelper.delete((String)ENTITY_ORGRELATION, (QFilter[])filters);
        }
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)ENTITY_TYPERELATION), (Object[])new Object[]{focusNodeId});
        this.removeCache();
        this.clickRootTreeNode();
    }

    private void deleteRelation() {
        String deletedCache = this.getPageCache().get(DELETED_RELATION);
        if (StringUtils.isBlank((CharSequence)deletedCache)) {
            return;
        }
        List deleteList = (List)SerializationUtils.fromJsonString((String)deletedCache, List.class);
        if (Utils.isListNotEmpty((List)deleteList)) {
            ArrayList<Long> relationIds = new ArrayList<Long>(deleteList.size());
            for (String id : deleteList) {
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                relationIds.add(Long.valueOf(id));
            }
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)ENTITY_ORGRELATION);
            DeleteServiceHelper.delete((IDataEntityType)type, (Object[])relationIds.toArray(new Object[relationIds.size()]));
            QFilter relationFilter = new QFilter(ORG_RELATION, "in", relationIds);
            QFilter[] filters = new QFilter[]{relationFilter};
            DeleteServiceHelper.delete((String)ENTITY_ORGRELATION_COND, (QFilter[])filters);
        }
    }

    private void updateRelation(List<Long> updateRelationIds, Map<Long, Map<String, String>> updateRelationMap) {
        if (updateRelationIds.isEmpty()) {
            return;
        }
        QFilter idFilter = new QFilter("id", "in", updateRelationIds);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject[] relationObjArr = BusinessDataServiceHelper.load((String)ENTITY_ORGRELATION, (String)"id,isdefaultfromorg,isdefaulttoorg", (QFilter[])filters);
        if (relationObjArr == null || relationObjArr.length == 0) {
            return;
        }
        for (DynamicObject relationObj : relationObjArr) {
            Map<String, String> rightEntryMap = updateRelationMap.get(relationObj.getLong("id"));
            if (rightEntryMap == null) continue;
            relationObj.set(IS_DEFAULT_FROMORG, (Object)rightEntryMap.get(IS_DEFAULT_FROMORG));
            relationObj.set(IS_DEFAULT_TOORG, (Object)rightEntryMap.get(IS_DEFAULT_TOORG));
        }
        SaveServiceHelper.save((DynamicObject[])relationObjArr);
    }

    private void updateCondition(Map<Long, String> updateRelationMap) {
        if (updateRelationMap.isEmpty()) {
            return;
        }
        int count = updateRelationMap.size();
        ArrayList<Long> deleteList = new ArrayList<Long>(count);
        ArrayList<DynamicObject> addConditionList = new ArrayList<DynamicObject>(count);
        for (Map.Entry<Long, String> relationEntry : updateRelationMap.entrySet()) {
            Long relationId = relationEntry.getKey();
            deleteList.add(relationId);
            String condition = relationEntry.getValue();
            if (StringUtils.isBlank((CharSequence)condition)) continue;
            List conditionMapList = (List)SerializationUtils.fromJsonString((String)condition, List.class);
            for (Map conditionMap : conditionMapList) {
                for (Map.Entry conditionEntry : conditionMap.entrySet()) {
                    DynamicObject conditionObj = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ORGRELATION_COND);
                    conditionObj.set(ORG_RELATION, (Object)relationId);
                    conditionObj.set(BIZ_OBJECT, conditionEntry.getKey());
                    conditionObj.set(CONDITION, conditionEntry.getValue());
                    addConditionList.add(conditionObj);
                }
            }
        }
        QFilter relationFilter = new QFilter(ORG_RELATION, "in", deleteList);
        QFilter[] filters = new QFilter[]{relationFilter};
        DeleteServiceHelper.delete((String)ENTITY_ORGRELATION_COND, (QFilter[])filters);
        int conditionCount = addConditionList.size();
        if (conditionCount > 0) {
            SaveServiceHelper.save((DynamicObject[])addConditionList.toArray(new DynamicObject[conditionCount]));
        }
    }

    private void showOrgF7(boolean isOpenLeftOrgF7) {
        TreeView tv = (TreeView)this.getControl(TREEVIEWAP);
        String focusNodeId = tv.getTreeState().getFocusNodeId();
        if (StringUtils.isBlank((CharSequence)focusNodeId) || "0".equals(focusNodeId)) {
            this.getView().showTipNotification(OrgMessage.getMessage((String)"M00038"));
            return;
        }
        String selectTab = this.getPageCache().get(SELECTTAB);
        String entryId = "";
        String orgFieldName = "";
        String orgFuncId = "";
        if (isOpenLeftOrgF7) {
            entryId = LEFT_ENTRY;
            orgFieldName = LEFT_ORG;
            orgFuncId = TAB_TOORGTAB.equals(selectTab) ? this.getPageCache().get(TO_TYPE) : this.getPageCache().get(FROM_TYPE);
        } else {
            entryId = RIGHT_ENTRY;
            orgFieldName = RIGHT_ORG;
            orgFuncId = TAB_TOORGTAB.equals(selectTab) ? this.getPageCache().get(FROM_TYPE) : this.getPageCache().get(TO_TYPE);
        }
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bos_org", (boolean)true);
        if (StringUtils.isBlank((CharSequence)orgFuncId)) {
            lsp.setCustomParam("orgFuncId", (Object)"15");
        } else {
            lsp.setCustomParam("orgFuncId", (Object)orgFuncId);
        }
        this.addShowOrgF7Filter(entryId, orgFieldName, lsp);
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, entryId));
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void addShowOrgF7Filter(String entryId, String orgFieldName, ListShowParameter lsp) {
        int orgListCount = this.getModel().getEntryRowCount(entryId);
        ArrayList<Object> seletedOrgList = new ArrayList<Object>(orgListCount);
        for (int i = 0; i < orgListCount; ++i) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(orgFieldName, i);
            if (org == null) continue;
            seletedOrgList.add(org.getPkValue());
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        if (!seletedOrgList.isEmpty()) {
            QFilter orgFilter = new QFilter("id", "not in", seletedOrgList);
            enableFilter = enableFilter.and(orgFilter);
        }
        lsp.getListFilterParameter().getQFilters().add(enableFilter);
    }

    public void entryRowClick(RowClickEvent evt) {
        String evtKey;
        Object source = evt.getSource();
        if (source instanceof EntryGrid && LEFT_ENTRY.equals(evtKey = ((EntryGrid)source).getKey())) {
            this.leftEntryRowClick(evt);
        }
        this.getPageCache().put("entryRowClickIndex", Integer.toString(evt.getRow()));
    }

    private void leftEntryRowClick(RowClickEvent evt) {
        String curRelationTypeId = this.getPageCache().get(CUR_RELATION_TYPEID);
        if (StringUtils.isBlank((CharSequence)curRelationTypeId)) {
            return;
        }
        String orgRatationCache = this.getPageCache().get(curRelationTypeId);
        if (StringUtils.isBlank((CharSequence)orgRatationCache)) {
            return;
        }
        DynamicObject leftOrgObj = (DynamicObject)this.getModel().getValue(LEFT_ORG, evt.getRow());
        if (leftOrgObj == null) {
            return;
        }
        Map orgConditionMap = (Map)SerializationUtils.fromJsonString((String)orgRatationCache, Map.class);
        String leftOrgId = leftOrgObj.getString("id");
        List rightEntryMapList = (List)orgConditionMap.get(leftOrgId);
        this.getModel().deleteEntryData(RIGHT_ENTRY);
        if (Utils.isListNotEmpty((List)rightEntryMapList)) {
            this.getModel().beginInit();
            for (Map rightEntryMap : rightEntryMapList) {
                this.createRightEntryRow(rightEntryMap);
            }
            this.getModel().endInit();
            this.getView().updateView(RIGHT_ENTRY);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        if ("0".equals(nodeId)) {
            this.initTree();
            this.enableEditPanel(false);
            this.setTypeRelationInfo(nodeId);
            return;
        }
        String oldNodeId = this.getPageCache().get(CUR_RELATION_TYPEID);
        if (nodeId.equals(oldNodeId)) {
            return;
        }
        this.enableEditPanel(this.hasSavePermission());
        if (this.getPageCache().get(IS_CONDITION_CHANGED) == null) {
            if (StringUtils.isNotBlank((CharSequence)oldNodeId)) {
                this.getPageCache().remove(oldNodeId);
            }
            this.loadOrgRelation(nodeId);
            this.getPageCache().put(CUR_RELATION_TYPEID, nodeId);
        } else {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(SAVE_DATA, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u4fdd\u5b58\u66f4\u6539", (String)"OrgRelationTreePlugin_4", (String)"bos-org-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u5207\u6362", (String)"OrgRelationTreePlugin_3", (String)"bos-org-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(BaseMessage.getMessage((String)"M00023"), "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
    }

    private void enableEditPanel(boolean enable) {
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{"splitpanelap1", "tabap", "flexpanelap2", BAR_SAVE});
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if (!MessageBoxResult.Yes.equals((Object)event.getResult())) {
            this.confirmNo(callBackId);
            return;
        }
        String nodeId = this.getPageCache().get(CUR_RELATION_TYPEID);
        switch (callBackId) {
            case "delete": {
                this.deleteRelationType();
                break;
            }
            case "SAVE_DATA": {
                TreeView tv = (TreeView)this.getControl(TREEVIEWAP);
                String focusNodeId = tv.getTreeState().getFocusNodeId();
                this.removeCache();
                this.loadOrgRelation(focusNodeId);
                break;
            }
            case "img_new": {
                this.save();
                this.loadOrgRelation(nodeId);
                break;
            }
            case "img_edit": {
                this.save();
                this.loadOrgRelation(nodeId);
                break;
            }
            case "close": {
                this.getPageCache().remove(IS_CONDITION_CHANGED);
                this.getView().close();
                break;
            }
        }
    }

    private void confirmNo(String callBackId) {
        String nodeId = this.getPageCache().get(CUR_RELATION_TYPEID);
        if (SAVE_DATA.equals(callBackId)) {
            this.save();
            TreeView tv = (TreeView)this.getControl(TREEVIEWAP);
            String focusNodeId = tv.getTreeState().getFocusNodeId();
            if (StringUtils.isBlank((CharSequence)focusNodeId)) {
                focusNodeId = nodeId;
            }
            this.loadOrgRelation(focusNodeId);
        } else if (IMG_NEW.equals(callBackId)) {
            this.removeCache();
            this.showAddTypeRelationForm(null);
        } else if (IMG_EDIT.equals(callBackId)) {
            TreeView tv = (TreeView)this.getControl(TREEVIEWAP);
            String focusNodeId = tv.getTreeState().getFocusNodeId();
            if (!"0".equals(focusNodeId) && StringUtils.isNotBlank((CharSequence)focusNodeId)) {
                this.removeCache();
                this.showAddTypeRelationForm(focusNodeId);
            } else {
                this.getView().showTipNotification(OrgMessage.getMessage((String)"M00038"));
            }
        }
    }

    private void removeCache() {
        IPageCache pageCache = this.getPageCache();
        pageCache.remove(IS_CONDITION_CHANGED);
        String oldCache = this.getPageCache().get(CUR_RELATION_TYPEID);
        if (StringUtils.isNotBlank((CharSequence)oldCache)) {
            this.getPageCache().remove(oldCache);
        }
        this.getPageCache().put(CUR_RELATION_TYPEID, "");
    }

    private void loadOrgRelation(String nodeId) {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return;
        }
        this.switchDefaultOrgVisible();
        this.getModel().deleteEntryData(LEFT_ENTRY);
        this.getModel().deleteEntryData(RIGHT_ENTRY);
        this.getPageCache().put(CUR_RELATION_TYPEID, nodeId);
        String orgRatationCache = this.getPageCache().get(nodeId);
        Map<String, List<Map<String, String>>> relationMap = new HashMap<String, List<Map<String, String>>>();
        if (orgRatationCache == null) {
            this.loadOrgRelationFromDb(nodeId, relationMap);
        } else if (StringUtils.isNotBlank((CharSequence)orgRatationCache)) {
            relationMap = (Map)SerializationUtils.fromJsonString((String)orgRatationCache, Map.class);
            this.queryRelationType(nodeId);
        }
        this.setTypeRelationInfo(nodeId);
        this.createOrgRelationEntry(relationMap);
        this.setSelectRows(LEFT_ENTRY, 0);
        this.switchRelationEntryTitle(this.getPageCache().get(SELECTTAB));
    }

    private void setSelectRows(String entryKey, int row) {
        EntryGrid leftEntry = (EntryGrid)this.getControl(entryKey);
        if (this.getModel().getEntryEntity(LEFT_ENTRY).size() > row) {
            leftEntry.selectRows(row);
        }
    }

    private void setTypeRelationInfo(String typeRelationId) {
        String number = "";
        String name = "";
        String description = "";
        boolean isRootNode = "0".equals(typeRelationId);
        if (!isRootNode) {
            Map<String, String> typeRelationMap = this.getNodeInfoFromPageCache(typeRelationId);
            number = typeRelationMap.get("number");
            name = typeRelationMap.get("name");
            description = typeRelationMap.get(DESCRIPTION);
        }
        this.getModel().setValue(DESCRIPTION, (Object)description);
        this.getModel().setValue("number", (Object)number);
        this.getModel().setValue("name", (Object)name);
    }

    private Map<String, String> getNodeInfoFromPageCache(String typeRelationId) {
        HashMap<String, String> typeRelationMap = new HashMap(3);
        String nodeInfoCache = this.getPageCache().get(typeRelationId + "_info");
        if (StringUtils.isBlank((CharSequence)nodeInfoCache)) {
            DynamicObject dynamicObject = this.queryRelationTypeObj(typeRelationId);
            if (dynamicObject != null) {
                typeRelationMap.put("number", dynamicObject.getString("number"));
                typeRelationMap.put("name", dynamicObject.getString("name"));
                typeRelationMap.put(DESCRIPTION, dynamicObject.getString(DESCRIPTION));
                this.getPageCache().put(typeRelationId + "_info", SerializationUtils.toJsonString(typeRelationMap));
            }
        } else {
            typeRelationMap = (Map)SerializationUtils.fromJsonString((String)nodeInfoCache, Map.class);
        }
        return typeRelationMap;
    }

    private void loadOrgRelationFromDb(String nodeId, Map<String, List<Map<String, String>>> relationMap) {
        String selectFields = "id,typerelation.fromtype fromtype,typerelation.totype totype,toorg,fromorg,isdefaultfromorg,isdefaulttoorg";
        QFilter typeFilter = new QFilter("typerelation", "=", (Object)Long.valueOf(nodeId));
        QFilter[] filters = new QFilter[]{typeFilter};
        DynamicObjectCollection relationCol = QueryServiceHelper.query((String)ENTITY_ORGRELATION, (String)selectFields, (QFilter[])filters, (String)"toorg.number,fromorg.number");
        if (Utils.isListEmpty((List)relationCol)) {
            this.getPageCache().put("conditionCache", "");
            this.queryRelationType(nodeId);
            return;
        }
        String fromtype = "";
        String totype = "";
        boolean isSelectedToTab = TAB_TOORGTAB.equals(this.getPageCache().get(SELECTTAB));
        for (DynamicObject relationObj : relationCol) {
            fromtype = relationObj.getString(FROM_TYPE);
            totype = relationObj.getString(TO_TYPE);
            String orgRelationId = relationObj.getString("id");
            String rightOrgId = "";
            String leftOrgId = "";
            if (isSelectedToTab) {
                rightOrgId = relationObj.getString(FROMORG);
                leftOrgId = relationObj.getString(TOORG);
            } else {
                leftOrgId = relationObj.getString(FROMORG);
                rightOrgId = relationObj.getString(TOORG);
            }
            List<Map<String, String>> rightEntryMapList = relationMap.get(leftOrgId);
            if (rightEntryMapList == null) {
                rightEntryMapList = new ArrayList<Map<String, String>>();
                relationMap.put(leftOrgId, rightEntryMapList);
            }
            Map<String, String> rightEntryMap = this.getNewRightEntreMap(orgRelationId, rightOrgId);
            rightEntryMap.put(IS_CONDITION_FROM_DB, "1");
            rightEntryMap.put("baseleftorg", leftOrgId);
            rightEntryMap.put(IS_DEFAULT_FROMORG, relationObj.getString(IS_DEFAULT_FROMORG));
            rightEntryMap.put(IS_DEFAULT_TOORG, relationObj.getString(IS_DEFAULT_TOORG));
            rightEntryMapList.add(rightEntryMap);
        }
        String orgRatationCache = SerializationUtils.toJsonString(relationMap);
        this.getPageCache().put(nodeId, orgRatationCache);
        this.getPageCache().put(FROM_TYPE, fromtype);
        this.getPageCache().put(TO_TYPE, totype);
    }

    private void queryRelationType(String typerelationId) {
        DynamicObject typeObj = this.queryRelationTypeObj(typerelationId);
        if (typeObj != null) {
            this.getPageCache().put(FROM_TYPE, typeObj.getString(FROM_TYPE));
            this.getPageCache().put(TO_TYPE, typeObj.getString(TO_TYPE));
        }
    }

    private DynamicObject queryRelationTypeObj(String typerelationId) {
        QFilter typeIdFilter = new QFilter("id", "=", (Object)Long.valueOf(typerelationId));
        QFilter[] typeFilters = new QFilter[]{typeIdFilter};
        String selectFields = "number,name,fromtype,totype,description";
        return QueryServiceHelper.queryOne((String)ENTITY_TYPERELATION, (String)selectFields, (QFilter[])typeFilters);
    }

    private void createOrgRelationEntry(Map<String, List<Map<String, String>>> relationMap) {
        int count = relationMap.size();
        if (count == 0) {
            return;
        }
        this.getModel().beginInit();
        Map<Object, DynamicObject> orgObjMap = this.getOrgDynamicObjectFromCache(relationMap);
        int[] entryIndexArr = this.getModel().batchCreateNewEntryRow(LEFT_ENTRY, count);
        DynamicObjectCollection leftEntity = this.getModel().getEntryEntity(LEFT_ENTRY);
        int entryIndex = 0;
        boolean isFirstOrgRelation = true;
        block0: for (Map.Entry<String, List<Map<String, String>>> entry : relationMap.entrySet()) {
            int rCount;
            if (entryIndex >= count) break;
            if (StringUtils.isNotBlank((CharSequence)entry.getKey())) {
                ((DynamicObject)leftEntity.get(entryIndexArr[entryIndex++])).set(LEFT_ORG, (Object)orgObjMap.get(Long.valueOf(entry.getKey())));
            }
            if (!isFirstOrgRelation) continue;
            isFirstOrgRelation = false;
            List<Map<String, String>> rightEntryMapList = entry.getValue();
            if (rightEntryMapList == null || (rCount = rightEntryMapList.size()) == 0) continue;
            int[] rEntryIndexArr = this.getModel().batchCreateNewEntryRow(RIGHT_ENTRY, rCount);
            DynamicObjectCollection rightEntity = this.getModel().getEntryEntity(RIGHT_ENTRY);
            int rEntryIndex = 0;
            for (Map<String, String> rightEntryMap : rightEntryMapList) {
                if (rEntryIndex >= rCount) continue block0;
                this.createRightEntryRow((DynamicObject)rightEntity.get(rEntryIndexArr[rEntryIndex++]), rightEntryMap, orgObjMap);
            }
        }
        this.getModel().endInit();
        this.getView().updateView(LEFT_ENTRY);
        this.getView().updateView(RIGHT_ENTRY);
    }

    private Map<Object, DynamicObject> getOrgDynamicObjectFromCache(Map<String, List<Map<String, String>>> relationMap) {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        boolean isFirstOrgRelation = true;
        for (Map.Entry<String, List<Map<String, String>>> entry : relationMap.entrySet()) {
            if (StringUtils.isNotBlank((CharSequence)entry.getKey())) {
                orgIds.add(Long.valueOf(entry.getKey()));
            }
            if (!isFirstOrgRelation) continue;
            isFirstOrgRelation = false;
            List<Map<String, String>> rightEntryMapList = entry.getValue();
            if (rightEntryMapList == null) continue;
            for (Map<String, String> rightEntryMap : rightEntryMapList) {
                String rightOrgId = rightEntryMap.get(RIGHT_ORGID);
                if (!StringUtils.isNotBlank((CharSequence)rightOrgId)) continue;
                orgIds.add(Long.valueOf(rightOrgId));
            }
        }
        if (orgIds.isEmpty()) {
            return new HashMap<Object, DynamicObject>(0);
        }
        return BusinessDataServiceHelper.loadFromCache((Object[])orgIds.toArray(new Object[orgIds.size()]), (String)"bos_org");
    }

    private void createRightEntryRow(DynamicObject rightEntryObj, Map<String, String> rightEntryMap, Map<Object, DynamicObject> orgObjMap) {
        String rightOrgId = rightEntryMap.get(RIGHT_ORGID);
        if (StringUtils.isNotBlank((CharSequence)rightOrgId)) {
            rightEntryObj.set(RIGHT_ORG, (Object)orgObjMap.get(Long.valueOf(rightOrgId)));
        }
        DynamicObject orgRelationObj = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ORGRELATION);
        orgRelationObj.set("id", (Object)rightEntryMap.get(ORG_RELATION_ID));
        rightEntryObj.set(ORG_RELATION, (Object)orgRelationObj);
        rightEntryObj.set(CONDITION, (Object)rightEntryMap.get(CONDITION));
        rightEntryObj.set(IS_CONDITION_FROM_DB, (Object)rightEntryMap.get(IS_CONDITION_FROM_DB));
        rightEntryObj.set(IS_DEFAULT_FROMORG, (Object)rightEntryMap.get(IS_DEFAULT_FROMORG));
        rightEntryObj.set(IS_DEFAULT_TOORG, (Object)rightEntryMap.get(IS_DEFAULT_TOORG));
    }

    private void createRightEntryRow(Map<String, String> rightEntryMap) {
        int curIndex = this.getModel().createNewEntryRow(RIGHT_ENTRY);
        this.getModel().setValue(RIGHT_ORG, (Object)rightEntryMap.get(RIGHT_ORGID), curIndex);
        this.getModel().setValue(ORG_RELATION, (Object)rightEntryMap.get(ORG_RELATION_ID), curIndex);
        this.getModel().setValue(CONDITION, (Object)rightEntryMap.get(CONDITION), curIndex);
        this.getModel().setValue(IS_CONDITION_FROM_DB, (Object)rightEntryMap.get(IS_CONDITION_FROM_DB), curIndex);
        this.getModel().setValue(IS_DEFAULT_FROMORG, (Object)rightEntryMap.get(IS_DEFAULT_FROMORG), curIndex);
        this.getModel().setValue(IS_DEFAULT_TOORG, (Object)rightEntryMap.get(IS_DEFAULT_TOORG), curIndex);
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (!(source instanceof Control)) {
            return;
        }
        String key = ((Control)source).getKey();
        if (IMG_DEL.equals(key)) {
            this.clickDelImg();
        } else {
            this.clickMOdifyImg(key);
        }
    }

    private void clickDelImg() {
        TreeView tv = (TreeView)this.getControl(TREEVIEWAP);
        String focusNodeId = tv.getTreeState().getFocusNodeId();
        if (!"0".equals(focusNodeId) && StringUtils.isNotBlank((CharSequence)focusNodeId)) {
            if (this.isPresetRelationType(focusNodeId)) {
                this.getView().showTipNotification(OrgMessage.getMessage((String)"M00039"));
                return;
            }
            String errorMsg = OrgViewSchemaRefrenceChecker.isRefrenced(Collections.singletonList(Long.valueOf(focusNodeId)), null, ENTITY_TYPERELATION);
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                this.getView().showTipNotification(errorMsg);
                return;
            }
            this.getView().showConfirm(OrgMessage.getMessage((String)"M00040"), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete"));
        } else {
            this.getView().showTipNotification(OrgMessage.getMessage((String)"M00038"));
        }
    }

    private void clickMOdifyImg(String key) {
        if (this.getPageCache().get(IS_CONDITION_CHANGED) != null) {
            String opName = IMG_NEW.equals(key) ? ResManager.loadKDString((String)"\u65b0\u589e\u9875\u9762", (String)"OrgRelationTreePlugin_5", (String)"bos-org-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4fee\u6539\u9875\u9762", (String)"OrgRelationTreePlugin_6", (String)"bos-org-formplugin", (Object[])new Object[0]);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(key, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), String.format(ResManager.loadKDString((String)"\u6253\u5f00%1$s", (String)"OrgRelationTreePlugin_7", (String)"bos-org-formplugin", (Object[])new Object[0]), opName));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u4fdd\u5b58\u66f4\u6539", (String)"OrgRelationTreePlugin_4", (String)"bos-org-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(BaseMessage.getMessage((String)"M00023"), "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
            return;
        }
        if (IMG_NEW.equals(key)) {
            this.showAddTypeRelationForm(null);
        } else if (IMG_EDIT.equals(key)) {
            TreeView tv = (TreeView)this.getControl(TREEVIEWAP);
            String focusNodeId = tv.getTreeState().getFocusNodeId();
            if (!"0".equals(focusNodeId) && StringUtils.isNotBlank((CharSequence)focusNodeId)) {
                this.showAddTypeRelationForm(focusNodeId);
            } else {
                this.getView().showTipNotification(OrgMessage.getMessage((String)"M00038"));
            }
        }
    }

    private boolean isPresetRelationType(String focusNodeId) {
        QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(focusNodeId));
        QFilter presetFilter = new QFilter("ispreset", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{idFilter, presetFilter};
        return QueryServiceHelper.exists((String)ENTITY_TYPERELATION, (QFilter[])filters);
    }

    private void showAddTypeRelationForm(Object pkValue) {
        BillShowParameter param = new BillShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId(ENTITY_TYPERELATION);
        param.setPkId(pkValue);
        if (pkValue == null) {
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addRelationType"));
        } else {
            param.setStatus(OperationStatus.EDIT);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "editRelationType"));
        }
        this.getView().showForm((FormShowParameter)param);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if ("editRelationCondition".equals(actionId)) {
            this.editRelationConditionCallBack(returnData);
        } else if (LEFT_ENTRY.equals(actionId)) {
            this.fillBackOrgF7SelectedData(actionId, returnData);
        } else if (RIGHT_ENTRY.equals(actionId)) {
            this.fillBackOrgF7SelectedData(actionId, returnData);
        } else if ("addRelationType".equals(actionId)) {
            this.clickRootTreeNode();
        } else if ("editRelationType".equals(actionId)) {
            if (returnData == null) {
                return;
            }
            this.loadOrgRelation(returnData.toString());
        }
    }

    private void editRelationConditionCallBack(Object returnData) {
        if (returnData == null) {
            return;
        }
        String curRelationTypeId = this.getPageCache().get(CUR_RELATION_TYPEID);
        if (StringUtils.isBlank((CharSequence)curRelationTypeId)) {
            return;
        }
        Map<String, List<Map<String, String>>> relationMap = this.getCurrentRelationCache(curRelationTypeId);
        if (relationMap == null || relationMap.isEmpty()) {
            return;
        }
        EntryGrid leftEntry = (EntryGrid)this.getControl(LEFT_ENTRY);
        EntryGrid rightEntry = (EntryGrid)this.getControl(RIGHT_ENTRY);
        DynamicObject leftEntryObj = this.getModel().getEntryRowEntity(LEFT_ENTRY, leftEntry.getEntryState().getFocusRow());
        int rightEntryIndex = rightEntry.getEntryState().getFocusRow();
        this.getModel().setValue(IS_CONDITION_FROM_DB, (Object)"0", rightEntryIndex);
        DynamicObject rightEntryObj = this.getModel().getEntryRowEntity(RIGHT_ENTRY, rightEntryIndex);
        if (leftEntryObj == null || rightEntryObj == null) {
            return;
        }
        DynamicObject leftOrgObj = leftEntryObj.getDynamicObject(LEFT_ORG);
        DynamicObject rightOrgObj = rightEntryObj.getDynamicObject(RIGHT_ORG);
        if (leftOrgObj == null || rightEntryObj == null) {
            return;
        }
        String leftOrgId = leftOrgObj.getString("id");
        String rightOrgId = rightOrgObj.getString("id");
        List<Map<String, String>> rightOrgMapList = relationMap.get(leftOrgId);
        if (rightOrgMapList == null) {
            return;
        }
        String condition = SerializationUtils.toJsonString((Object)returnData);
        this.getModel().setValue(CONDITION, (Object)condition, rightEntryIndex);
        for (Map<String, String> rightOrgMap : rightOrgMapList) {
            if (!rightOrgId.equals(rightOrgMap.get(RIGHT_ORGID))) continue;
            rightOrgMap.put(IS_CONDITION_FROM_DB, "0");
            rightOrgMap.put(CONDITION, condition);
            break;
        }
        this.getPageCache().put(curRelationTypeId, SerializationUtils.toJsonString(relationMap));
        this.getPageCache().put(IS_CONDITION_CHANGED, "");
    }

    private void clickRootTreeNode() {
        this.getModel().createNewData();
    }

    private void fillBackOrgF7SelectedData(String actionId, Object returnData) {
        if (returnData == null) {
            return;
        }
        String curRelationTypeId = this.getPageCache().get(CUR_RELATION_TYPEID);
        if (StringUtils.isBlank((CharSequence)curRelationTypeId)) {
            return;
        }
        ArrayList<String> selectedOrgList = new ArrayList<String>();
        if (StringUtils.isNotBlank((Object)returnData) && returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
            for (ListSelectedRow row : rows) {
                selectedOrgList.add(row.getPrimaryKeyValue().toString());
            }
        }
        if (selectedOrgList.isEmpty()) {
            return;
        }
        this.getPageCache().put(IS_CONDITION_CHANGED, "");
        Map<String, List<Map<String, String>>> relationMap = this.getCurrentRelationCache(curRelationTypeId);
        if (LEFT_ENTRY.equals(actionId)) {
            this.fillBackLeftEntryOrgF7SelectedData(selectedOrgList, relationMap);
        } else {
            this.fillBackRightEntryOrgF7SelectedData(selectedOrgList, relationMap);
        }
        this.getPageCache().put(curRelationTypeId, SerializationUtils.toJsonString(relationMap));
    }

    private void fillBackLeftEntryOrgF7SelectedData(List<String> selectedOrgList, Map<String, List<Map<String, String>>> relationMap) {
        for (String newLeftOrgId : selectedOrgList) {
            ArrayList emptyList = new ArrayList(0);
            relationMap.put(newLeftOrgId, emptyList);
            this.createLeftEntryRow(newLeftOrgId);
        }
        EntryGrid leftEntry = (EntryGrid)this.getControl(LEFT_ENTRY);
        if (leftEntry != null) {
            int lastRowIndex = this.getModel().getEntryRowCount(LEFT_ENTRY) - 1;
            leftEntry.addRowClickListener((RowClickEventListener)this);
            leftEntry.entryRowClick(Integer.valueOf(lastRowIndex));
            leftEntry.selectRows(lastRowIndex);
        }
    }

    private void createLeftEntryRow(String orgId) {
        int curIndex = this.getModel().createNewEntryRow(LEFT_ENTRY);
        this.getModel().setValue(LEFT_ORG, (Object)orgId, curIndex);
    }

    private void fillBackRightEntryOrgF7SelectedData(List<String> selectedOrgList, Map<String, List<Map<String, String>>> relationMap) {
        EntryGrid leftEntry = (EntryGrid)this.getControl(LEFT_ENTRY);
        int focusRow = leftEntry.getEntryState().getFocusRow();
        DynamicObject leftOrgObj = (DynamicObject)this.getModel().getValue(LEFT_ORG, focusRow);
        if (leftOrgObj == null) {
            return;
        }
        String leftOrgId = leftOrgObj.getString("id");
        List<Map<String, String>> rightEntryMapList = relationMap.get(leftOrgId);
        if (rightEntryMapList == null) {
            rightEntryMapList = new ArrayList<Map<String, String>>(selectedOrgList.size());
            for (String newRightOrgId : selectedOrgList) {
                Map<String, String> rightEntryMap = this.getNewRightEntreMap("", newRightOrgId);
                rightEntryMapList.add(rightEntryMap);
                this.createRightEntryRow(rightEntryMap);
            }
            relationMap.put(leftOrgId, rightEntryMapList);
        } else {
            for (String newRightOrgId : selectedOrgList) {
                Map<String, String> rightEntryMap = this.getNewRightEntreMap("", newRightOrgId);
                rightEntryMapList.add(rightEntryMap);
                this.createRightEntryRow(rightEntryMap);
            }
        }
    }

    private Map<String, String> getNewRightEntreMap(String relationId, String rightOrgId) {
        HashMap<String, String> rightEntryMap = new HashMap<String, String>();
        rightEntryMap.put(ORG_RELATION_ID, relationId);
        rightEntryMap.put(RIGHT_ORGID, rightOrgId);
        rightEntryMap.put(CONDITION, "");
        return rightEntryMap;
    }

    private Map<String, List<Map<String, String>>> getCurrentRelationCache(String curRelationTypeId) {
        String orgRatationCache;
        Map<String, List<Map<String, String>>> relationMap = new HashMap<String, List<Map<String, String>>>();
        if (StringUtils.isNotBlank((CharSequence)curRelationTypeId) && StringUtils.isNotBlank((CharSequence)(orgRatationCache = this.getPageCache().get(curRelationTypeId)))) {
            relationMap = (Map)SerializationUtils.fromJsonString((String)orgRatationCache, Map.class);
        }
        return relationMap;
    }

    public void tabSelected(TabSelectEvent tab) {
        String curTabId = tab.getTabKey();
        String tabOld = this.getPageCache().get(SELECTTAB);
        if (tabOld == null || curTabId.equals(tabOld)) {
            return;
        }
        this.switchRelationEntryTitle(curTabId);
        String orgRelationId = this.getPageCache().get(CUR_RELATION_TYPEID);
        if (StringUtils.isBlank((CharSequence)orgRelationId)) {
            return;
        }
        this.switchRelationEntryCache(orgRelationId);
        this.loadOrgRelation(orgRelationId);
    }

    private void switchRelationEntryCache(String curRelationTypeId) {
        String orgRatationCache = this.getPageCache().get(curRelationTypeId);
        if (StringUtils.isBlank((CharSequence)orgRatationCache)) {
            return;
        }
        Map relationMap = (Map)SerializationUtils.fromJsonString((String)orgRatationCache, Map.class);
        if (relationMap == null || relationMap.isEmpty()) {
            return;
        }
        HashMap exchangedRelationMap = new HashMap();
        ArrayList<String> newRightOrgIds = new ArrayList<String>();
        for (Map.Entry entry : relationMap.entrySet()) {
            List rightEntryMapList = (List)entry.getValue();
            String oldLeftOrgId = (String)entry.getKey();
            for (Map rightEntryMap : rightEntryMapList) {
                String oldRightOrgId = (String)rightEntryMap.get(RIGHT_ORGID);
                String relationOrgKey = oldLeftOrgId + oldRightOrgId;
                if (newRightOrgIds.contains(relationOrgKey)) continue;
                newRightOrgIds.add(relationOrgKey);
                String orgRelationId = (String)rightEntryMap.get(ORG_RELATION_ID);
                String condition = (String)rightEntryMap.get(CONDITION);
                String isconditionfromdb = (String)rightEntryMap.get(IS_CONDITION_FROM_DB);
                ArrayList newRightEntryMapList = (ArrayList)exchangedRelationMap.get(oldRightOrgId);
                if (newRightEntryMapList == null) {
                    newRightEntryMapList = new ArrayList();
                    exchangedRelationMap.put(oldRightOrgId, newRightEntryMapList);
                }
                HashMap<String, String> newRightEntryMap = new HashMap<String, String>();
                newRightEntryMap.put(ORG_RELATION_ID, orgRelationId);
                newRightEntryMap.put(RIGHT_ORGID, oldLeftOrgId);
                newRightEntryMap.put(CONDITION, condition);
                newRightEntryMap.put(IS_CONDITION_FROM_DB, isconditionfromdb);
                newRightEntryMap.put(IS_DEFAULT_FROMORG, (String)rightEntryMap.get(IS_DEFAULT_FROMORG));
                newRightEntryMap.put(IS_DEFAULT_TOORG, (String)rightEntryMap.get(IS_DEFAULT_TOORG));
                newRightEntryMapList.add(newRightEntryMap);
            }
        }
        this.getPageCache().put(curRelationTypeId, SerializationUtils.toJsonString(exchangedRelationMap));
    }

    private List<Map<String, String>> loadConditionFromDB(long relationId) {
        QFilter relationFilter = new QFilter(ORG_RELATION, "=", (Object)relationId);
        QFilter[] qfilters = new QFilter[]{relationFilter};
        DynamicObjectCollection conditionCol = QueryServiceHelper.query((String)ENTITY_ORGRELATION_COND, (String)"orgrelation,condition,bizobject", (QFilter[])qfilters);
        if (Utils.isListEmpty((List)conditionCol)) {
            return null;
        }
        ArrayList<Map<String, String>> conditionMapList = new ArrayList<Map<String, String>>(conditionCol.size());
        for (DynamicObject conditionObj : conditionCol) {
            HashMap<String, String> conditionMap = new HashMap<String, String>();
            conditionMap.put(conditionObj.getString(BIZ_OBJECT), conditionObj.getString(CONDITION));
            conditionMapList.add(conditionMap);
        }
        return conditionMapList;
    }

    private List<Map<String, String>> loadConditionFromCache(DynamicObject rightEntry) {
        String condition = rightEntry.getString(CONDITION);
        if (StringUtils.isBlank((CharSequence)condition)) {
            return null;
        }
        return (List)SerializationUtils.fromJsonString((String)condition, List.class);
    }

    private void showRelationCond(List<Map<String, String>> conditionMapList) {
        FormShowParameter formParam = new FormShowParameter();
        formParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "editRelationCondition"));
        formParam.getOpenStyle().setShowType(ShowType.Modal);
        formParam.setFormId("bos_relationcond_new");
        formParam.setCustomParam(CONDITION, conditionMapList);
        if (conditionMapList != null) {
            formParam.setStatus(OperationStatus.EDIT);
        }
        this.getView().showForm(formParam);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (this.getPageCache().get(IS_CONDITION_CHANGED) != null) {
            e.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("close", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u4fdd\u5b58", (String)"OrgRelationTreePlugin_8", (String)"bos-org-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"OrgRelationTreePlugin_9", (String)"bos-org-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(BaseMessage.getMessage((String)"M00024"), "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        String fieldKey = arg0.getFieldName();
        int row = arg0.getRowIndex();
        if ("conditionlink".equals(fieldKey)) {
            DynamicObject rightEntry = this.getModel().getEntryRowEntity(RIGHT_ENTRY, row);
            if (rightEntry == null) {
                return;
            }
            List<Map<String, String>> conditionMapList = null;
            if (rightEntry.getBoolean(IS_CONDITION_FROM_DB)) {
                DynamicObject orgrelationObj = rightEntry.getDynamicObject(ORG_RELATION);
                if (orgrelationObj != null) {
                    conditionMapList = this.loadConditionFromDB(orgrelationObj.getLong("id"));
                }
            } else {
                conditionMapList = this.loadConditionFromCache(rightEntry);
            }
            this.showRelationCond(conditionMapList);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        if (IS_DEFAULT_FROMORG.equals(proName) || IS_DEFAULT_TOORG.equals(proName)) {
            DynamicObjectCollection rightEntryCol = this.getModel().getEntryEntity(RIGHT_ENTRY);
            if (Utils.isListEmpty((List)rightEntryCol)) {
                return;
            }
            String curRelationTypeId = this.getPageCache().get(CUR_RELATION_TYPEID);
            Map<String, List<Map<String, String>>> relationCacheMap = this.getCurrentRelationCache(curRelationTypeId);
            String leftOrgId = this.getCellClickLeftOrg();
            List<Map<String, String>> rightEntryCacheList = relationCacheMap.get(leftOrgId);
            this.loadRightDataAfterCellClick(rightEntryCol, e, rightEntryCacheList);
            this.getPageCache().put(curRelationTypeId, SerializationUtils.toJsonString(relationCacheMap));
            this.getPageCache().put(IS_CONDITION_CHANGED, "");
        }
    }

    private String getCellClickLeftOrg() {
        DynamicObject leftOrgObj;
        DynamicObject leftEntryObj;
        EntryGrid leftEntry = (EntryGrid)this.getControl(LEFT_ENTRY);
        String leftOrgId = "";
        int leftEntryIndex = leftEntry.getEntryState().getFocusRow();
        if (leftEntryIndex >= 0 && (leftEntryObj = this.getModel().getEntryRowEntity(LEFT_ENTRY, leftEntryIndex)) != null && (leftOrgObj = leftEntryObj.getDynamicObject(LEFT_ORG)) != null) {
            leftOrgId = leftOrgObj.getString("id");
        }
        return leftOrgId;
    }

    private void loadRightDataAfterCellClick(DynamicObjectCollection rightEntryCol, PropertyChangedArgs arg0, List<Map<String, String>> rightEntryCacheList) {
        Boolean newIsDefault;
        ChangeData[] changeSet = arg0.getChangeSet();
        ChangeData changeData = changeSet[0];
        int currentRow = changeData.getRowIndex();
        if (CollectionUtils.isEmpty(rightEntryCacheList) || currentRow < 0) {
            return;
        }
        String fieldKey = arg0.getProperty().getName();
        int rightEntryCount = rightEntryCol.size();
        String rightOrgId = "";
        DynamicObject rightOrgObj = (DynamicObject)this.getModel().getValue(RIGHT_ORG, currentRow);
        if (rightOrgObj != null) {
            rightOrgId = rightOrgObj.getString("id");
        }
        if ((newIsDefault = (Boolean)changeData.getNewValue()) == null) {
            newIsDefault = Boolean.FALSE;
        }
        for (Map<String, String> rightMap : rightEntryCacheList) {
            Boolean isDefault = Boolean.FALSE;
            if (rightOrgId.equals(rightMap.get(RIGHT_ORGID))) {
                isDefault = newIsDefault;
            }
            rightMap.put(fieldKey, Boolean.toString(isDefault));
        }
        if (newIsDefault.booleanValue()) {
            for (int i = 0; i < rightEntryCount; ++i) {
                if (currentRow == i || !((Boolean)this.getModel().getValue(fieldKey)).booleanValue()) continue;
                this.getModel().setValue(fieldKey, (Object)Boolean.FALSE, i);
            }
        }
    }
}

