/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.SetEntryBottom;
import kd.bos.form.operate.SetEntryTop;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.yzj.config.YzjConfigServiceHelper;
import kd.bos.yzj.interfaces.IYzjOrgService;
import kd.bos.yzj.model.YzjConfig;
import kd.bos.yzj.model.org.YzjOrgParam;
import kd.bos.yzj.service.YzjServiceFactory;

public class OrgSortFormPlugin
extends AbstractFormPlugin {
    private static final String IS_SHOW_DISABLED = "isshowdisabled";
    private static final String KEY_BUTTON_SET_TOP = "btnsettop";
    private static final String KEY_BUTTON_SET_BOTTOM = "btnsetbottom";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initByViewParam();
        this.initOrgEntryEntity();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (IS_SHOW_DISABLED.equals(e.getProperty().getName())) {
            this.getModel().deleteEntryData("entryentity");
            this.initOrgEntryEntity();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "btnsettop": {
                this.setTop();
                break;
            }
            case "btnsetbottom": {
                this.setBottom();
                break;
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        Control c = (Control)evt.getSource();
        String itemKey = c.getKey().toLowerCase();
        if ("btnok".equals(itemKey)) {
            this.save();
        }
    }

    protected Long getCustomViewId() {
        Long viewId = null;
        Object viewIdParam = this.getView().getFormShowParameter().getCustomParam("view");
        if (viewIdParam != null) {
            viewId = Long.valueOf(viewIdParam.toString());
        }
        return viewId;
    }

    private long getViewId() {
        Long viewId = this.getCustomViewId();
        if (viewId == null || viewId == 0L) {
            viewId = 15L;
        }
        return viewId;
    }

    private void save() {
        YzjConfig yzjConfig;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        int count = entryEntity.size();
        ArrayList<Object> ids = new ArrayList<Object>(count);
        HashMap<Object, Integer> orgSortMap = new HashMap<Object, Integer>(count);
        int sort = 1;
        Long customViewId = this.getCustomViewId();
        for (DynamicObject entryObj : entryEntity) {
            Object orgId = entryObj.get("org");
            Object structureId = entryObj.get("structure");
            orgSortMap.put(orgId, sort++);
            if (customViewId == null) {
                ids.add(orgId);
                continue;
            }
            ids.add(structureId);
        }
        QFilter filter = new QFilter("parent", "=", (Object)this.getParentId());
        if (customViewId == null) {
            filter = filter.and(new QFilter("org", "in", ids));
            filter = filter.and(new QFilter("view.treetypeid.category", "=", (Object)"1"));
        } else {
            filter = filter.and(new QFilter("id", "in", ids));
        }
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject[] structObjArr = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)"id,yzjorgid,org,level,sortcode,sortnumber", (QFilter[])filters);
        if (structObjArr == null || structObjArr.length == 0) {
            return;
        }
        HashMap<String, String> resortOrgMap = new HashMap<String, String>(structObjArr.length);
        HashMap<String, DynamicObject> yzjOrgIdToOrg = new HashMap<String, DynamicObject>(structObjArr.length);
        for (DynamicObject structObj : structObjArr) {
            DynamicObject orgObj = structObj.getDynamicObject("org");
            if (orgObj == null) continue;
            Integer newSort = (Integer)orgSortMap.get(orgObj.getPkValue());
            if (newSort == null) {
                newSort = 1;
            }
            int sortNumber = OrgViewUtils.getOrgSortCode((int)structObj.getInt("level"), (int)newSort);
            structObj.set("sortcode", (Object)sortNumber);
            structObj.set("sortnumber", (Object)sortNumber);
            String yzjOrgId = structObj.getString("yzjorgid");
            if (yzjOrgId.isEmpty()) continue;
            resortOrgMap.put(yzjOrgId, String.valueOf(sortNumber));
            yzjOrgIdToOrg.put(yzjOrgId, orgObj);
        }
        HashMap<String, String> errorMsgMap = new HashMap<String, String>();
        if (customViewId != null && customViewId == 1L && 3 == (yzjConfig = YzjConfigServiceHelper.getConfig()).getSyncMode() && yzjConfig.isSyncOrgSortNumberToYzj()) {
            this.updateYunZhiJiaOrgWeight(resortOrgMap, errorMsgMap);
        }
        if (!errorMsgMap.isEmpty()) {
            this.showSyncErrorMsg(errorMsgMap, yzjOrgIdToOrg);
            return;
        }
        SaveServiceHelper.save((DynamicObject[])structObjArr);
        IFormView parentView = this.getView().getParentView();
        if (null != parentView) {
            parentView.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"OrgSortFormPlugin_1", (String)"bos-org-formplugin", (Object[])new Object[0]));
            this.getView().sendFormAction(parentView);
        }
        this.getView().returnDataToParent((Object)"save");
        this.getView().close();
    }

    private void showSyncErrorMsg(Map<String, String> errorMsgMap, Map<String, DynamicObject> yzjOrgIdToOrg) {
        OperationResult operationResult = new OperationResult();
        operationResult.setBillCount(yzjOrgIdToOrg.size());
        ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>(errorMsgMap.size());
        operationResult.setAllErrorInfo(errorInfos);
        for (Map.Entry<String, String> entry : errorMsgMap.entrySet()) {
            DynamicObject org = yzjOrgIdToOrg.remove(entry.getKey());
            String errorMsg = String.format(ResManager.loadKDString((String)"\u3010\u7f16\u7801\uff1a%1$s \u540d\u79f0\uff1a%2$s\u3011 \u6392\u5e8f\u7801\u5728\u4e91\u4e4b\u5bb6\u5904\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u5177\u4f53\u539f\u56e0\u662f\uff1a\u201c%3$s\u201d\u3002", (String)"OrgSortFormPlugin_2", (String)"bos-org-formplugin", (Object[])new Object[0]), org.getString("number"), org.getString("name"), entry.getValue());
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setLevel(ErrorLevel.Warning);
            operateErrorInfo.setMessage(errorMsg);
            errorInfos.add(operateErrorInfo);
            operationResult.setSuccess(false);
        }
        ArrayList<String> successId = new ArrayList<String>(yzjOrgIdToOrg.keySet());
        operationResult.setSuccessPkIds(successId);
        if (!operationResult.isSuccess()) {
            this.getView().showOperationResult(operationResult);
        }
    }

    private void updateYunZhiJiaOrgWeight(Map<String, String> resortOrgMap, Map<String, String> errorMsgMap) {
        ArrayList<YzjOrgParam> orgModelList = new ArrayList<YzjOrgParam>(resortOrgMap.size());
        for (Map.Entry<String, String> entry : resortOrgMap.entrySet()) {
            YzjOrgParam yzjOrg = new YzjOrgParam();
            yzjOrg.setYzjOrgId(entry.getKey());
            yzjOrg.setSortCode(entry.getValue());
            orgModelList.add(yzjOrg);
        }
        int batch = orgModelList.size() / 1000 + 1;
        for (int i = 0; i < batch; ++i) {
            List<YzjOrgParam> batchOrgModelList = orgModelList.subList(0, Math.min(orgModelList.size(), 1000));
            IYzjOrgService orgService = YzjServiceFactory.getOrgService();
            orgService.updateWeightById(batchOrgModelList);
            this.addSyncError(batchOrgModelList, errorMsgMap);
            orgModelList.removeAll(batchOrgModelList);
        }
    }

    private void addSyncError(List<YzjOrgParam> batchOrgModelList, Map<String, String> errorMsgMap) {
        for (YzjOrgParam yzjOrgParam : batchOrgModelList) {
            if (yzjOrgParam.isSuccess()) continue;
            errorMsgMap.put(yzjOrgParam.getYzjOrgId(), yzjOrgParam.getMsg());
        }
    }

    private void setTop() {
        SetEntryTop setEntryTop = new SetEntryTop("entryentity", this.getView());
        setEntryTop.invokeOperation();
    }

    private void setBottom() {
        SetEntryBottom setEntryBottom = new SetEntryBottom("entryentity", this.getView());
        setEntryBottom.invokeOperation();
    }

    private void initOrgEntryEntity() {
        Map structObjMap;
        QFilter[] filters = this.getOrgFilters();
        String selectFields = "id,fullname,isfreeze,org";
        String orderBy = "sortnumber";
        if ("sortcode".equals(OrgUnitServiceHelper.getOrgSortSchema())) {
            orderBy = "sortcode";
        }
        if ((structObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)orderBy)) == null || structObjMap.isEmpty()) {
            return;
        }
        int count = structObjMap.size();
        IDataModel model = this.getModel();
        model.batchCreateNewEntryRow("entryentity", count);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        int rowIndex = 0;
        for (Map.Entry orgEntry : structObjMap.entrySet()) {
            DynamicObject structObj = (DynamicObject)orgEntry.getValue();
            DynamicObject row = (DynamicObject)entryEntity.get(rowIndex);
            DynamicObject orgObj = structObj.getDynamicObject("org");
            if (orgObj != null) {
                row.set("org", orgObj.getPkValue());
                row.set("number", orgObj.get("number"));
                row.set("name", orgObj.get("name"));
                row.set("enable", orgObj.get("enable"));
            }
            row.set("structure", structObj.getPkValue());
            row.set("fullname", structObj.get("fullname"));
            row.set("isfreeze", structObj.get("isfreeze"));
            ++rowIndex;
        }
        this.getView().updateView("entryentity");
    }

    private QFilter[] getOrgFilters() {
        QFilter viewFilter = new QFilter("view", "=", (Object)this.getViewId());
        QFilter orgFilter = new QFilter("parent", "=", (Object)this.getParentId());
        if (!((Boolean)this.getModel().getValue(IS_SHOW_DISABLED)).booleanValue()) {
            orgFilter = orgFilter.and(new QFilter("isfreeze", "=", (Object)Boolean.FALSE));
            orgFilter = orgFilter.and(new QFilter("org.enable", "=", (Object)Boolean.TRUE));
        }
        return new QFilter[]{viewFilter, orgFilter};
    }

    private Long getParentId() {
        Long parentId = OrgUnitServiceHelper.getRootOrgId();
        Object parentIdParam = this.getView().getFormShowParameter().getCustomParam("parent");
        if (StringUtils.isNotBlank((Object)parentIdParam)) {
            parentId = Long.valueOf(parentIdParam.toString());
        }
        return parentId;
    }

    private void initByViewParam() {
        Long customViewId = this.getCustomViewId();
        this.getModel().setValue("view", (Object)customViewId);
        if (customViewId == null || customViewId == 15L) {
            return;
        }
        if (customViewId == 1L) {
            FieldEdit isShowDisabledCkb = (FieldEdit)this.getControl(IS_SHOW_DISABLED);
            isShowDisabledCkb.setCaption(new LocaleString(ResManager.loadKDString((String)"\u663e\u793a\u5c01\u5b58", (String)"OrgSortFormPlugin_0", (String)"bos-org-formplugin", (Object[])new Object[0])));
        } else {
            DynamicObject viewObj = BusinessDataServiceHelper.loadSingleFromCache((Object)customViewId, (String)"bos_org_viewschema");
            if (viewObj != null) {
                DynamicObject bizObj;
                String title = "";
                title = viewObj.getBoolean("isdefault") ? ((bizObj = viewObj.getDynamicObject("treetypeid")) == null ? viewObj.getString("name") : bizObj.getString("fname")) : viewObj.getString("name");
                this.getView().setFormTitle(new LocaleString(title));
            }
        }
    }
}

