/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org;

import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class OrgUnitReferenceFormPlugin
extends AbstractFormPlugin {
    private static final String SAVE_CONFIRM_FLAG = "saveConfirmFlag_reference";
    private static final String IS_ADMIN_ORG_EXISTS = "isAdminOrgExists";

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        if ("name".equals(proName) || "parent".equals(proName)) {
            this.checkAdminOrgExists();
        }
    }

    private void checkAdminOrgExists() {
        this.getPageCache().remove(IS_ADMIN_ORG_EXISTS);
        DynamicObject orgObj = this.getModel().getDataEntity();
        if (orgObj.getDataEntityState().getFromDatabase()) {
            return;
        }
        String name = orgObj.getString("name");
        if (StringUtils.isBlank((CharSequence)name)) {
            return;
        }
        DynamicObject parentObj = orgObj.getDynamicObject("parent");
        if (parentObj == null) {
            return;
        }
        QFilter viewFilter = new QFilter("view", "=", (Object)1L);
        QFilter nameFilter = new QFilter("org.name", "=", (Object)name);
        long parentId = parentObj.getLong("id");
        QFilter parentFilter = new QFilter("parent", "=", (Object)parentId);
        QFilter[] filters = new QFilter[]{viewFilter, nameFilter, parentFilter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.bos.org.OrgUnitReferenceFormPlugin.checkAdminOrgExists", (String)"bos_org_structure", (String)"org,org.number number", (QFilter[])filters, (String)"", (int)1);){
            if (ds.hasNext()) {
                Row row = ds.next();
                this.getPageCache().put("loadAdminParentOrgId", Long.toString(parentId));
                this.getPageCache().put("loadAdminOrgId", row.getString("org"));
                this.getView().showConfirm(OrgMessage.getMessage((String)"M00028", (Object[])new Object[]{row.getString("number")}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("loadAdminOrg"));
                this.getPageCache().put(IS_ADMIN_ORG_EXISTS, "1");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        this.getPageCache().remove(IS_ADMIN_ORG_EXISTS);
        if (evt.getResult().getValue() == MessageBoxResult.Cancel.getValue()) {
            return;
        }
        String callBackId = evt.getCallBackId();
        if ("loadAdminOrg".equals(callBackId)) {
            ((IBillView)this.getView()).load((Object)this.getPageCache().get("loadAdminOrgId"));
            this.getModel().setValue("parent", (Object)this.getPageCache().get("loadAdminParentOrgId"));
            this.getView().setEnable(Boolean.FALSE, new String[]{"number", "name", "parent"});
        } else if (SAVE_CONFIRM_FLAG.equals(callBackId)) {
            this.getPageCache().put(SAVE_CONFIRM_FLAG, "1");
            this.getView().invokeOperation("save");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if ("1".equals(this.getPageCache().get(IS_ADMIN_ORG_EXISTS))) {
            this.getPageCache().remove(IS_ADMIN_ORG_EXISTS);
            args.setCancel(true);
        }
        if (args.isCancel()) {
            return;
        }
        boolean doOperation = true;
        Object source = args.getSource();
        if (source instanceof Save && !this.getModel().getDataEntity().getDataEntityState().getFromDatabase() && !"1".equals(this.getPageCache().get(SAVE_CONFIRM_FLAG))) {
            this.getView().showConfirm(OrgMessage.getMessage((String)"M00030"), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(SAVE_CONFIRM_FLAG));
            args.setCancel(true);
            doOperation = false;
        }
        if (doOperation) {
            super.beforeDoOperation(args);
            this.getPageCache().remove(SAVE_CONFIRM_FLAG);
        }
    }
}

