/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.org.utils.OrgUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrgUnitStructureCreateFormPlugin
extends AbstractFormPlugin {
    protected Map<Object, DynamicObject> defaultViewObjMap;
    protected Map<String, DynamicObjectType> dynamicObjectTypeMap;
    private static final String SAVE_CONFIRM_FLAG = "saveConfirmFlag_deleteView";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.isCancel()) {
            return;
        }
        if (args.getSource() instanceof Save) {
            this.validateParent(args);
            this.createStructureEntry(args);
            if (args.isCancel()) {
                this.getView().showTipNotification(args.getCancelMessage());
                return;
            }
            this.addDeleteViewConfirm(args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        OperationResult operationResult = event.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            this.getView().updateView("structure");
        }
    }

    protected void validateParent(BeforeDoOperationEventArgs operationEvent) {
        long currentParentId = this.getCurrentParentId();
        if (this.getModel().getDataEntity().getLong("id") == currentParentId) {
            operationEvent.setCancel(true);
            operationEvent.setCancelMessage(OrgMessage.getMessage((String)"M00192"));
        }
    }

    private void createStructureEntry(BeforeDoOperationEventArgs operationEvent) {
        if (operationEvent.isCancel()) {
            return;
        }
        this.getCheckedViewDynamicObject(operationEvent);
        if (operationEvent.isCancel()) {
            return;
        }
        this.dynamicObjectTypeMap = OrgUtils.getOrgEntityDynamicObjectType((DynamicObject)this.getModel().getDataEntity());
        HashMap<Long, DynamicObject> dbViewStructureMap = new HashMap<Long, DynamicObject>(this.defaultViewObjMap.size());
        HashMap<Long, DynamicObject> dbStructureViewMap = new HashMap<Long, DynamicObject>(this.defaultViewObjMap.size());
        this.getStructureFromDataBase(dbStructureViewMap, dbViewStructureMap, operationEvent);
        if (operationEvent.isCancel()) {
            return;
        }
        this.checkView(this.getModel().getEntryEntity("structure"), dbStructureViewMap, operationEvent);
        if (operationEvent.isCancel()) {
            return;
        }
        this.createStructureEntry(dbViewStructureMap);
    }

    private void createStructureEntry(Map<Long, DynamicObject> dbViewStructureMap) {
        Map<Long, DynamicObject> currentStructureMap = this.getExistsViewStructureMap();
        DynamicObjectCollection currentStructureCol = this.getModel().getEntryEntity("structure");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        CloneUtils cloneUtils = new CloneUtils(true, false);
        Map orgTypeMap = OrgUtils.getOrgEntityDynamicObjectType((DynamicObject)dataEntity);
        DynamicObjectType viewOrgType = (DynamicObjectType)orgTypeMap.get("org");
        DynamicObject orgObject = (DynamicObject)cloneUtils.clone((IDataEntityType)viewOrgType, (Object)dataEntity);
        boolean fromDatabase = dataEntity.getDataEntityState().getFromDatabase();
        for (Map.Entry<Object, DynamicObject> viewEntry : this.defaultViewObjMap.entrySet()) {
            DynamicObject structureObj;
            DynamicObject viewObj = viewEntry.getValue();
            long viewId = viewObj.getLong("id");
            if (fromDatabase && 16L == viewId || (structureObj = currentStructureMap.get(viewId)) != null) continue;
            structureObj = dbViewStructureMap.get(viewId);
            if (structureObj == null) {
                structureObj = currentStructureCol.addNew();
                structureObj.set("view", (Object)viewObj);
                structureObj.set("vieworg", (Object)orgObject);
                continue;
            }
            currentStructureCol.add((Object)structureObj);
        }
        long currentParentId = this.getCurrentParentId();
        for (DynamicObject structureObj : currentStructureCol) {
            DynamicObject viewObj = structureObj.getDynamicObject("view");
            if (!viewObj.getBoolean("isdefault")) continue;
            this.setStructureParent(structureObj, viewObj.getLong("id"), currentParentId);
        }
        this.getModel().updateEntryCache(currentStructureCol);
    }

    protected Map<Long, DynamicObject> getExistsViewStructureMap() {
        DynamicObjectCollection currentStructureCol = this.getModel().getEntryEntity("structure");
        HashMap<Long, DynamicObject> currentStructureMap = new HashMap<Long, DynamicObject>(currentStructureCol.size());
        Iterator iterator = currentStructureCol.iterator();
        while (iterator.hasNext()) {
            DynamicObject structureObj = (DynamicObject)iterator.next();
            DynamicObject viewObj = structureObj.getDynamicObject("view");
            if (viewObj == null) {
                iterator.remove();
                continue;
            }
            if (!viewObj.getBoolean("isdefault")) continue;
            if (this.defaultViewObjMap.remove(viewObj.getLong("id")) == null) {
                iterator.remove();
                continue;
            }
            long viewId = viewObj.getLong("id");
            currentStructureMap.put(viewId, structureObj);
        }
        return currentStructureMap;
    }

    protected long getCurrentParentId() {
        long currentParentId = 0L;
        DynamicObject parentObj = (DynamicObject)this.getModel().getValue("parent");
        if (parentObj != null) {
            currentParentId = parentObj.getLong("id");
        }
        return currentParentId;
    }

    protected void setStructureParent(DynamicObject structureObj, long viewId, long currentParentId) {
        if (viewId == 15L) {
            this.setCurrentParent(structureObj, currentParentId);
        } else if (!structureObj.getDataEntityState().getFromDatabase()) {
            long viewParentId = OrgUnitServiceHelper.getParentIdBySelfOrOrgUnitView((long)currentParentId, (long)viewId);
            structureObj.set("viewparent", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)viewParentId, (DynamicObjectType)this.dynamicObjectTypeMap.get("parent")));
        }
    }

    protected void setCurrentParent(DynamicObject structureObj, long currentParentId) {
        if (currentParentId == 0L) {
            structureObj.set("viewparent", null);
        } else {
            structureObj.set("viewparent", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)currentParentId, (DynamicObjectType)this.dynamicObjectTypeMap.get("parent")));
        }
    }

    private void checkView(DynamicObjectCollection currentStructureCol, Map<Long, DynamicObject> dbStructureViewMap, BeforeDoOperationEventArgs operationEvent) {
        ArrayList<Long> viewIds = new ArrayList<Long>(currentStructureCol.size());
        Iterator iterator = currentStructureCol.iterator();
        while (iterator.hasNext()) {
            long structureId;
            DynamicObject dbViewObj;
            DynamicObject structureObj = (DynamicObject)iterator.next();
            DynamicObject viewObj = structureObj.getDynamicObject("view");
            if (viewObj == null) {
                iterator.remove();
                continue;
            }
            long viewId = viewObj.getLong("id");
            if (viewIds.contains(viewId)) {
                operationEvent.setCancel(true);
                operationEvent.setCancelMessage(OrgMessage.getMessage((String)"M00177", (Object[])new Object[]{this.getModel().getDataEntity().getString("name"), viewObj.getString("name")}));
                return;
            }
            viewIds.add(viewId);
            if (!structureObj.getDataEntityState().getFromDatabase() || (dbViewObj = dbStructureViewMap.get(structureId = structureObj.getLong("id"))) == null || dbViewObj.getLong("id") == viewId) continue;
            operationEvent.setCancel(true);
            operationEvent.setCancelMessage(OrgMessage.getMessage((String)"M00178", (Object[])new Object[]{dbViewObj.getString("name"), viewObj.getString("name")}));
            return;
        }
    }

    private void getCheckedViewDynamicObject(BeforeDoOperationEventArgs operationEvent) {
        String selectFields = "id,number,name,treetype,treetypeid,isdefault";
        QFilter[] filters = new QFilter[]{this.getCheckedViewFilter()};
        this.defaultViewObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_viewschema", (String)selectFields, (QFilter[])filters);
        if (CollectionUtils.isEmpty(this.defaultViewObjMap)) {
            operationEvent.setCancel(true);
            operationEvent.setCancelMessage(OrgMessage.getMessage((String)"M00015"));
            return;
        }
        DataEntityPropertyCollection properties = this.getModel().getDataEntity().getDynamicObjectType().getProperties();
        Iterator<Map.Entry<Object, DynamicObject>> iterator = this.defaultViewObjMap.entrySet().iterator();
        while (iterator.hasNext()) {
            String propertyName;
            Map.Entry<Object, DynamicObject> viewEntry = iterator.next();
            DynamicObject viewObj = viewEntry.getValue();
            long viewId = viewObj.getLong("id");
            if (15L == viewId || 16L == viewId) continue;
            boolean checked = false;
            DynamicObject bizObj = viewObj.getDynamicObject("treetypeid");
            if (bizObj != null && properties.get((Object)(propertyName = bizObj.getString("propertyname"))) != null && this.getModel().getDataEntity().getBoolean(propertyName)) {
                checked = true;
            }
            if (checked) continue;
            iterator.remove();
        }
    }

    protected QFilter getCheckedViewFilter() {
        return new QFilter("isdefault", "=", (Object)Boolean.TRUE);
    }

    private void parseStructureCollectionToMap(Map<Long, DynamicObject> dbStructureViewMap, Map<Long, DynamicObject> dbViewStructureMap, DynamicObjectCollection structureObjCol) {
        for (DynamicObject structureObj : structureObjCol) {
            DynamicObject viewObj = structureObj.getDynamicObject("view");
            if (viewObj == null) continue;
            if (dbStructureViewMap != null) {
                dbStructureViewMap.put(structureObj.getLong("id"), viewObj);
            }
            dbViewStructureMap.put(viewObj.getLong("id"), structureObj);
        }
    }

    private void getStructureFromDataBase(Map<Long, DynamicObject> dbStructureMap, Map<Long, DynamicObject> dbViewStructureMap, BeforeDoOperationEventArgs operationEvent) {
        if (!this.getModel().getDataEntity().getDataEntityState().getFromDatabase()) {
            return;
        }
        DynamicObject orgObj = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getModel().getDataEntity().getPkValue(), (DynamicObjectType)this.getModel().getDataEntity().getDynamicObjectType());
        if (orgObj == null) {
            operationEvent.setCancel(true);
            operationEvent.setCancelMessage(BaseMessage.getMessage((String)"M00062"));
            return;
        }
        this.parseStructureCollectionToMap(dbStructureMap, dbViewStructureMap, orgObj.getDynamicObjectCollection("structure"));
    }

    private void addDeleteViewConfirm(BeforeDoOperationEventArgs args) {
        if ("1".equals(this.getPageCache().get(SAVE_CONFIRM_FLAG))) {
            this.getPageCache().remove(SAVE_CONFIRM_FLAG);
            return;
        }
        String originalCheckedParentView = this.getPageCache().get("originalCheckedParentView");
        if (StringUtils.isBlank((CharSequence)originalCheckedParentView)) {
            return;
        }
        Map checkedParentViewMap = (Map)SerializationUtils.fromJsonString((String)originalCheckedParentView, TreeMap.class);
        DynamicObjectCollection structureObjCol = this.getModel().getDataEntity().getDynamicObjectCollection("structure");
        for (DynamicObject structureObj : structureObjCol) {
            DynamicObject viewObj = structureObj.getDynamicObject("view");
            if (viewObj == null || !viewObj.getBoolean("isdefault")) continue;
            checkedParentViewMap.remove(viewObj.getString("number"));
        }
        if (CollectionUtils.isEmpty((Map)checkedParentViewMap)) {
            return;
        }
        StringBuilder bizNames = new StringBuilder();
        boolean first = true;
        String caesura = BaseMessage.getMessage((String)"M00071");
        String doubleQuotation = BaseMessage.getMessage((String)"M00072");
        for (Map.Entry entry : checkedParentViewMap.entrySet()) {
            if (first) {
                first = false;
            } else {
                bizNames.append(caesura);
            }
            bizNames.append(String.format(doubleQuotation, entry.getValue()));
        }
        args.setCancel(true);
        this.getView().showConfirm(OrgMessage.getMessage((String)"M00190", (Object[])new Object[]{bizNames}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(SAVE_CONFIRM_FLAG));
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getResult().getValue() == MessageBoxResult.Cancel.getValue()) {
            return;
        }
        String callBackId = evt.getCallBackId();
        if (SAVE_CONFIRM_FLAG.equals(callBackId)) {
            this.getPageCache().put(SAVE_CONFIRM_FLAG, "1");
            this.getView().invokeOperation("save");
        }
    }
}

