/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.biz.plugin;

import java.util.ArrayList;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrgBizDeleteOperationPlugin
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        String pages = "bos_org_viewschema_main,bos_org_viewschema,bos_org_viewschema_ou,bos_org_viewschema_biz";
        this.getOption().setVariableValue("ignorerefentityids", pages);
        e.addValidator((AbstractValidator)new OrgBizDeleteValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        ArrayList<Object> ids = new ArrayList<Object>(dataEntities.length);
        for (DynamicObject bizObj : dataEntities) {
            ids.add(bizObj.getPkValue());
        }
        QFilter treetypeFilter = new QFilter("view.treetypeid", "in", ids);
        QFilter[] filters = new QFilter[]{treetypeFilter};
        DeleteServiceHelper.delete((String)"bos_org_structure", (QFilter[])filters);
        treetypeFilter = new QFilter("treetypeid", "in", ids);
        filters = new QFilter[]{treetypeFilter};
        DeleteServiceHelper.delete((String)"bos_org_viewschema", (QFilter[])filters);
    }

    private static class OrgBizDeleteValidator
    extends AbstractValidator {
        private OrgBizDeleteValidator() {
        }

        public void validate() {
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                this.validateOrgStructure(dataEntity);
            }
        }

        private void validateOrgStructure(ExtendedDataEntity dataEntity) {
            DynamicObject orgBizObj = dataEntity.getDataEntity();
            QFilter viewFilter = new QFilter("view.treetypeid", "=", orgBizObj.getPkValue());
            QFilter orgFilter = new QFilter("org", "!=", (Object)OrgUnitServiceHelper.getRootOrgId());
            QFilter[] filters = new QFilter[]{viewFilter, orgFilter};
            DynamicObject structObj = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"view.name view,org.name org", (QFilter[])filters);
            if (structObj != null) {
                this.addErrorMessage(dataEntity, OrgMessage.getMessage((String)"M00133", (Object[])new Object[]{structObj.getString("view"), structObj.getString("org")}));
            }
        }
    }
}

