/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.biz.plugin;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.org.model.OrgParam;
import kd.bos.org.utils.Utils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrgBizSaveOperationPlugin
extends AbstractOperationServicePlugIn {
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        for (DynamicObject bizObj : e.getDataEntities()) {
            this.saveViewSchema(bizObj);
        }
    }

    private void saveViewSchema(DynamicObject bizObj) {
        Object treeTypeId = bizObj.getPkValue();
        String number = bizObj.getString("fnumber");
        String name = bizObj.getString("fname");
        String userId = RequestContext.get().getUserId();
        Date time = new Date();
        if (bizObj.getDataEntityState().getFromDatabase()) {
            String selectFields = "id,number,name,treetype,modifier,modifytime";
            QFilter treetypeFilter = new QFilter("treetypeid", "=", treeTypeId);
            QFilter defaultFilter = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
            QFilter[] filters = new QFilter[]{treetypeFilter, defaultFilter};
            DynamicObject[] viewArr = BusinessDataServiceHelper.load((String)"bos_org_viewschema", (String)selectFields, (QFilter[])filters);
            if (viewArr == null || viewArr.length == 0) {
                return;
            }
            for (DynamicObject viewObj : viewArr) {
                viewObj.set("number", (Object)number);
                viewObj.set("treetype", (Object)number);
                if (bizObj.getBoolean("fuserdefine")) {
                    viewObj.set("name", (Object)name);
                }
                viewObj.set("modifier", (Object)userId);
                viewObj.set("modifytime", (Object)time);
            }
            SaveServiceHelper.save((DynamicObject[])viewArr);
        } else {
            DynamicObject viewObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_org_viewschema");
            long id = ORM.create().genLongId("bos_org_viewschema");
            viewObj.set("id", (Object)id);
            viewObj.set("masterid", (Object)id);
            viewObj.set("number", (Object)number);
            viewObj.set("treetype", (Object)number);
            viewObj.set("treetypeid", treeTypeId);
            viewObj.set("name", (Object)name);
            viewObj.set("isdefault", (Object)Boolean.TRUE);
            viewObj.set("status", (Object)"C");
            viewObj.set("enable", (Object)1);
            viewObj.set("startdate", (Object)Utils.getDate((int)0));
            viewObj.set("enddate", (Object)Utils.getEndDate());
            viewObj.set("creator", (Object)userId);
            viewObj.set("createtime", (Object)time);
            viewObj.set("modifier", (Object)userId);
            viewObj.set("modifytime", (Object)time);
            DynamicObject[] viewArr = new DynamicObject[]{viewObj};
            SaveServiceHelper.save((DynamicObject[])viewArr);
            this.saveRootOrg(bizObj);
        }
    }

    private void saveRootOrg(DynamicObject bizObj) {
        OrgParam orgParam = new OrgParam();
        orgParam.setDuty(bizObj.getString("fnumber"));
        orgParam.setControlUnit(true);
        OrgUnitServiceHelper.addDutyRoot((OrgParam)orgParam);
        if (!orgParam.isSuccess()) {
            throw new KDBizException(orgParam.getMsg());
        }
    }
}

