/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.biz.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.IBaseCallbackHandler;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.biz.view.OrgTreeViewCache;
import kd.bos.org.model.OrgTreeBuildType;
import kd.bos.org.model.OrgTreeNodeLabel;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.org.utils.OrgTreeUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrgSourceTreeView {
    protected static final Log logger = LogFactory.getLog(OrgSourceTreeView.class);
    protected String orgBizFunction;
    protected long viewId;
    protected TreeView treeView;
    protected TreeNode rootNode;
    protected IFormView view;
    protected OrgTreeViewCache cache;
    private List<String> selectedNodes;
    private static final String CACHE_ROOT_NODE = "CACHE_ROOT_NODE";
    private static final String CACHE_ROOT_NODE_ID = "CACHE_ROOT_NODE_ID";
    private static final String CACHE_ALL_INITIAL_NODES = "CACHE_ALL_INITIAL_NODES_";
    private static final String CACHE_SELECTED_NODE = "CACHE_SELECTED_NODE_";

    public OrgSourceTreeView(long viewId, TreeView treeView, boolean isInitTree) {
        this.viewId = viewId;
        this.treeView = treeView;
        this.view = this.treeView.getView();
        this.cache = new OrgTreeViewCache(this.view.getPageCache());
        if (!isInitTree) {
            this.initRootNodeFromCache();
        }
    }

    public void initTree() {
        logger.info("\u521d\u59cb\u5316\u7ec4\u7ec7\u6811", (Object)this.treeView.getKey(), (Object)this.viewId);
        this.treeView.deleteAllNodes();
        this.initCache();
        OrgTreeParam orgTreeParam = this.getOrgTreeParam();
        this.rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)orgTreeParam);
        if (this.rootNode == null) {
            logger.info(this.viewId + "\uff1a\u67e5\u8be2\u4e0d\u5230\u89c6\u56fe\u65b9\u6848\u7684\u6839\u7ec4\u7ec7\u3002");
            return;
        }
        orgTreeParam = this.getOrgTreeParam();
        orgTreeParam.setId(Long.parseLong(this.rootNode.getId()));
        orgTreeParam.setTreeBuildType(OrgTreeBuildType.FILL_HIDDEN_PARENT_ALL);
        this.rootNode.setChildren(OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)orgTreeParam));
        this.setTreeNodeLeaf(this.rootNode);
        this.cache.put(this.getRootNodeIdCacheKey(), this.rootNode.getId());
        this.updateRootNodeCache();
        TreeNode viewRootNode = this.shallowCloneTreeNode(this.rootNode);
        List children = this.rootNode.getChildren();
        if (!CollectionUtils.isEmpty((Collection)children)) {
            ArrayList<TreeNode> viewChildren = new ArrayList<TreeNode>(children.size());
            for (TreeNode child : children) {
                viewChildren.add(this.shallowCloneTreeNode(child));
            }
            viewRootNode.setChildren(viewChildren);
        }
        this.setTreeNodeLeaf(viewRootNode);
        viewRootNode.setIsOpened(true);
        this.treeView.addNode(viewRootNode);
        this.treeView.focusNode(viewRootNode);
        logger.info("\u521d\u59cb\u5316\u7ec4\u7ec7\u6811", (Object)this.treeView.getKey(), (Object)this.viewId);
    }

    protected OrgTreeParam getOrgTreeParam() {
        DynamicObject viewObj;
        OrgTreeParam orgTreeParam = new OrgTreeParam();
        orgTreeParam.setOrgViewId(this.viewId);
        orgTreeParam.setMarkFreeze(true);
        orgTreeParam.setLockDisableType(true);
        if (this.orgBizFunction == null && (viewObj = BusinessDataServiceHelper.loadSingleFromCache((Object)this.viewId, (String)"bos_org_viewschema", (String)"treetype")) != null) {
            this.orgBizFunction = viewObj.getString("treetype");
        }
        if ("16".equals(this.orgBizFunction)) {
            orgTreeParam.getCustomLabelList().add(new OrgTreeNodeLabel("structure.isctrlunit", (Object)Boolean.TRUE, "CU", "#55A0F5"));
        }
        return orgTreeParam;
    }

    protected boolean setTreeNodeLeaf(TreeNode node) {
        if (node == null) {
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)node.getChildren())) {
            node.setLeaf(true);
            node.setChildren(null);
            return true;
        }
        return false;
    }

    private void initCache() {
        this.view.getPageCache().remove("isdatachangedflag");
        this.cache.remove(this.getRootNodeIdCacheKey());
        this.updateRootNodeCache(null);
        this.updateAllInitialNodesCache(null);
        this.updateSelectedNodeCache(null);
    }

    public String getInitRootNodeId() {
        return this.cache.get(this.getRootNodeIdCacheKey());
    }

    public TreeNode getRootNode() {
        return this.rootNode;
    }

    private void initRootNodeFromCache() {
        if (this.rootNode != null) {
            return;
        }
        String rootNodeCache = this.cache.get(this.getRootNodeCacheKey());
        if (StringUtils.isNotBlank((CharSequence)rootNodeCache)) {
            this.rootNode = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeCache, TreeNode.class);
        }
    }

    public List<TreeNode> getAllNodes() {
        TreeNode cacheRootNode = this.getRootNode();
        if (cacheRootNode == null) {
            return new ArrayList<TreeNode>(0);
        }
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        this.queryChildren(cacheRootNode, nodes);
        return nodes;
    }

    public void cacheAllInitialNodes() {
        logger.info(this.viewId + "\uff1a\u8bb0\u5f55\u6240\u6709\u8282\u70b9\u4fe1\u606f\u5230\u7f13\u5b58");
        LinkedHashMap<String, String> initialNodes = null;
        TreeNode cacheRootNode = this.getRootNode();
        if (cacheRootNode != null) {
            initialNodes = new LinkedHashMap<String, String>();
            this.queryChildren(cacheRootNode, initialNodes);
        }
        this.updateAllInitialNodesCache(initialNodes);
        logger.info(this.viewId + "\uff1a\u8bb0\u5f55\u6240\u6709\u8282\u70b9\u4fe1\u606f\u5230\u7f13\u5b58");
    }

    private void queryChildren(TreeNode node, LinkedHashMap<String, String> initialNodes) {
        if (node == null) {
            return;
        }
        if (!node.isDisabled()) {
            initialNodes.put(node.getId(), node.getParentid());
        }
        if (node.getChildren() == null) {
            return;
        }
        for (TreeNode childNode : node.getChildren()) {
            this.queryChildren(childNode, initialNodes);
        }
    }

    public LinkedHashMap<String, String> getAllInitialNodes() {
        LinkedHashMap<String, String> nodeInfo = new LinkedHashMap<String, String>(64);
        this.getAllOrgs(this.getRootNode() == null, params -> {
            Row row = (Row)params[0];
            nodeInfo.put(row.getString("org"), row.getString("parent"));
            return null;
        });
        return nodeInfo;
    }

    public LinkedHashMap<String, Map<String, Object>> getAllOrgs(boolean isDeleteAll) {
        LinkedHashMap<String, Map<String, Object>> nodeInfo = new LinkedHashMap<String, Map<String, Object>>(64);
        this.getAllOrgs(isDeleteAll, params -> {
            Row row = (Row)params[0];
            HashMap<String, Object> dataMap = new HashMap<String, Object>(4);
            dataMap.put("parent", row.getString("parent"));
            dataMap.put("enable", row.getBoolean("enable"));
            dataMap.put("isfreeze", row.getBoolean("isfreeze"));
            nodeInfo.put(row.getString("org"), dataMap);
            return null;
        });
        return nodeInfo;
    }

    private void getAllOrgs(boolean isDeleteAll, IBaseCallbackHandler handler) {
        QFilter viewFilter = new QFilter("view", "=", (Object)this.viewId);
        if (!isDeleteAll) {
            viewFilter = viewFilter.and(new QFilter("org.status", "=", (Object)"C"));
            if (!this.isIncludeDisabled()) {
                viewFilter = viewFilter.and(new QFilter("org.enable", "=", (Object)Boolean.TRUE));
                viewFilter = viewFilter.and(new QFilter("isfreeze", "=", (Object)Boolean.FALSE));
            }
        }
        QFilter[] filters = new QFilter[]{viewFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgSourceTreeView.getAllOrgs", (String)"bos_org_structure", (String)"org,parent,org.enable enable,isfreeze", (QFilter[])filters, (String)"longnumber");){
            for (Row row : dataSet) {
                handler.handle(new Object[]{row});
            }
        }
    }

    protected void getAllNodesMap(Map<String, TreeNode> nodesMap, TreeNode node) {
        if (node == null) {
            return;
        }
        nodesMap.put(node.getId(), node);
        if (node.getChildren() == null) {
            return;
        }
        Iterator iterator = node.getChildren().iterator();
        while (iterator.hasNext()) {
            TreeNode childNode = (TreeNode)iterator.next();
            if (nodesMap.containsKey(childNode.getId())) {
                iterator.remove();
                continue;
            }
            this.getAllNodesMap(nodesMap, childNode);
        }
    }

    private void queryChildren(TreeNode node, List<TreeNode> nodes) {
        if (node == null) {
            return;
        }
        nodes.add(node);
        if (node.getChildren() == null) {
            return;
        }
        for (TreeNode childNode : node.getChildren()) {
            this.queryChildren(childNode, nodes);
        }
    }

    public void addChildren(String nodeId, boolean checkChild) {
        List<TreeNode> children = this.queryChildren(nodeId);
        if (CollectionUtils.isEmpty(children)) {
            return;
        }
        this.treeView.addNodes(children);
        if (!checkChild) {
            List<String> selectedNodes = this.getSelectedNodes();
            if (CollectionUtils.isEmpty(selectedNodes)) {
                return;
            }
            ArrayList<TreeNode> checkNodes = new ArrayList<TreeNode>(children.size());
            for (TreeNode node : children) {
                if (!selectedNodes.contains(node.getId())) continue;
                checkNodes.add(node);
            }
            this.treeView.checkNodes(checkNodes);
        }
    }

    public List<TreeNode> queryChildren(String nodeId) {
        ArrayList<TreeNode> children;
        TreeNode treeNode = OrgTreeUtils.getNode((TreeNode)this.rootNode, (Object)nodeId);
        if (treeNode == null) {
            children = new ArrayList<TreeNode>();
            logger.error(nodeId + "\uff1a\u8282\u70b9\u4e0d\u5728\u7f13\u5b58\u4e2d\uff0c\u67e5\u8be2\u4e0b\u7ea7\u7ec4\u7ec7\u5931\u8d25\u3002");
        } else {
            List childrenCache = treeNode.getChildren();
            if (childrenCache == null) {
                children = new ArrayList();
            } else {
                children = new ArrayList(childrenCache.size());
                for (TreeNode node : childrenCache) {
                    children.add(this.shallowCloneTreeNode(node));
                }
            }
        }
        return children;
    }

    public void cacheSelectNodes(String nodeId, boolean includeChildren) {
        this.cacheSelectNodes(Collections.singletonList(nodeId), includeChildren);
    }

    public void cacheSelectNodes(List<String> nodeIds, boolean includeChildren) {
        if (this.rootNode == null || CollectionUtils.isEmpty(nodeIds)) {
            return;
        }
        this.cacheSelectNodes(nodeIds, includeChildren, null);
    }

    private void cacheSelectNodes(List<String> nodeIds, boolean includeChildren, Map<String, TreeNode> dirtySelectedNodes) {
        logger.info("\u7f13\u5b58\u5df2\u9009\u8282\u70b9\uff1a" + nodeIds.size());
        HashSet<String> selectedNodeSet = new HashSet<String>(this.getSelectedNodes());
        selectedNodeSet.addAll(nodeIds);
        this.selectedNodes = new ArrayList<String>(selectedNodeSet);
        LinkedHashSet<String> orderSelectedNodes = new LinkedHashSet<String>(this.selectedNodes.size());
        this.querySelectNodes(this.rootNode, orderSelectedNodes, includeChildren, dirtySelectedNodes);
        this.selectedNodes = new ArrayList<String>(orderSelectedNodes);
        this.updateSelectedNodeCache(this.selectedNodes);
        logger.info("\u7f13\u5b58\u5df2\u9009\u8282\u70b9\uff1a" + nodeIds.size());
    }

    private void querySelectNodes(TreeNode node, Set<String> orderSelectedNodes, boolean includeChildren, Map<String, TreeNode> dirtySelectedNodes) {
        if (node == null) {
            return;
        }
        if (this.selectedNodes.remove(node.getId())) {
            orderSelectedNodes.add(node.getId());
            if (includeChildren) {
                ArrayList<String> selectedChildren = new ArrayList<String>();
                this.querySelectedChildren(node, selectedChildren, dirtySelectedNodes);
                orderSelectedNodes.addAll(selectedChildren);
                this.selectedNodes.removeAll(selectedChildren);
            }
        }
        if (this.selectedNodes.isEmpty() || node.getChildren() == null) {
            return;
        }
        for (TreeNode childNode : node.getChildren()) {
            if (dirtySelectedNodes != null) {
                dirtySelectedNodes.put(childNode.getId(), childNode);
            }
            if (orderSelectedNodes.contains(childNode.getId())) continue;
            this.querySelectNodes(childNode, orderSelectedNodes, includeChildren, dirtySelectedNodes);
        }
    }

    public void selectNodes(List<String> nodeIds, boolean includeChildren) {
        logger.info("\u83b7\u53d6\u5df2\u9009\u8282\u70b9\u4fe1\u606f\uff1a" + nodeIds.size());
        if (this.rootNode == null) {
            return;
        }
        HashMap<String, TreeNode> dirtySelectedNodes = new HashMap<String, TreeNode>(nodeIds.size());
        this.cacheSelectNodes(nodeIds, includeChildren, dirtySelectedNodes);
        if (CollectionUtils.isEmpty(this.selectedNodes)) {
            return;
        }
        ArrayList<TreeNode> checkNodes = new ArrayList<TreeNode>(this.selectedNodes.size());
        for (String nodeId : this.selectedNodes) {
            TreeNode treeNode = (TreeNode)dirtySelectedNodes.get(nodeId);
            if (treeNode == null) {
                treeNode = OrgTreeUtils.getNode((TreeNode)this.rootNode, (Object)nodeId);
            }
            if (treeNode == null || treeNode.isDisabled()) continue;
            checkNodes.add(treeNode);
        }
        this.treeView.checkNodes(checkNodes);
        logger.info("\u83b7\u53d6\u5df2\u9009\u8282\u70b9\u4fe1\u606f\uff1a" + nodeIds.size());
    }

    public List<String> getSelectedNodes() {
        if (this.selectedNodes != null) {
            return this.selectedNodes;
        }
        String selectedNodesCache = this.cache.get(this.getSelectedNodeCacheKey());
        this.selectedNodes = StringUtils.isBlank((CharSequence)selectedNodesCache) ? new ArrayList<String>() : (List)SerializationUtils.fromJsonString((String)selectedNodesCache, List.class);
        return this.selectedNodes;
    }

    private void querySelectedChildren(TreeNode node, List<String> selectNodes, Map<String, TreeNode> dirtySelectedNodes) {
        if (node.getChildren() == null) {
            return;
        }
        for (TreeNode childNode : node.getChildren()) {
            selectNodes.add(childNode.getId());
            if (dirtySelectedNodes != null) {
                dirtySelectedNodes.put(childNode.getId(), childNode);
            }
            this.querySelectedChildren(childNode, selectNodes, dirtySelectedNodes);
        }
    }

    public void unSelectAll() {
        this.selectedNodes = this.getSelectedNodes();
        if (CollectionUtils.isEmpty(this.selectedNodes)) {
            return;
        }
        this.treeView.uncheckNodes(new ArrayList<String>(this.selectedNodes));
        this.updateSelectedNodeCache(null);
        this.selectedNodes.clear();
    }

    public void unSelectNode(String nodeId, boolean includeChildren) {
        this.unSelectNodes(Collections.singletonList(nodeId), includeChildren);
    }

    public void unSelectNodes(List<String> nodeIds, boolean includeChildren) {
        if (this.rootNode == null || CollectionUtils.isEmpty(nodeIds)) {
            return;
        }
        if (includeChildren && nodeIds.contains(this.rootNode.getId())) {
            this.unSelectAll();
            return;
        }
        this.selectedNodes = this.getSelectedNodes();
        ArrayList<String> currentSelectNodes = new ArrayList<String>(nodeIds);
        if (includeChildren) {
            for (String nodeId : nodeIds) {
                TreeNode node = OrgTreeUtils.getNode((TreeNode)this.rootNode, (Object)nodeId);
                this.querySelectedChildren(node, currentSelectNodes, null);
            }
        }
        this.selectedNodes.removeAll(currentSelectNodes);
        this.treeView.uncheckNodes(currentSelectNodes);
        if (this.selectedNodes.isEmpty()) {
            this.selectedNodes = null;
        }
        this.updateSelectedNodeCache(this.selectedNodes);
    }

    protected TreeNode shallowCloneTreeNode(TreeNode srcNode) {
        TreeNode targetNode = new TreeNode(srcNode.getParentid(), srcNode.getId(), srcNode.getText());
        targetNode.setLongNumber(srcNode.getLongNumber());
        targetNode.setLeaf(srcNode.isLeaf());
        targetNode.setChildren((List)(srcNode.getChildren() == null ? null : new ArrayList()));
        targetNode.setIsOpened(srcNode.getIsOpened());
        if (StringUtils.isNotBlank((CharSequence)targetNode.getParentid())) {
            targetNode.setDisabled(srcNode.isDisabled());
        }
        targetNode.setExpend(srcNode.isExpend());
        targetNode.setIcon(srcNode.getIcon());
        targetNode.setColor(srcNode.getColor());
        targetNode.setCheckable(srcNode.isCheckable());
        targetNode.setData(srcNode.getData());
        targetNode.setType(srcNode.getType());
        targetNode.setLongText(srcNode.getLongText());
        if (srcNode.getLabelPara() != null) {
            targetNode.getLabelPara().addAll(srcNode.getLabelPara());
        }
        targetNode.setLabelShowType(srcNode.getLabelShowType());
        return targetNode;
    }

    public void updateRootNodeCache() {
        this.updateRootNodeCache(this.rootNode);
    }

    private void updateRootNodeCache(Object cache) {
        this.cache.put(this.getRootNodeCacheKey(), cache);
    }

    protected void updateSelectedNodeCache(Object cache) {
        this.cache.put(this.getSelectedNodeCacheKey(), cache);
    }

    protected boolean isIncludeDisabled() {
        return (Boolean)this.view.getModel().getValue("isshowdisablednode");
    }

    private void updateAllInitialNodesCache(Object cache) {
        this.cache.put(this.getAllInitialNodesCacheKey(), cache);
    }

    private String getRootNodeCacheKey() {
        return CACHE_ROOT_NODE + this.treeView.getKey();
    }

    private String getRootNodeIdCacheKey() {
        return CACHE_ROOT_NODE_ID + this.treeView.getKey();
    }

    private String getAllInitialNodesCacheKey() {
        return CACHE_ALL_INITIAL_NODES + this.treeView.getKey();
    }

    private String getSelectedNodeCacheKey() {
        return CACHE_SELECTED_NODE + this.treeView.getKey();
    }
}

