/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.biz.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.org.biz.view.OrgSourceTreeView;
import kd.bos.org.biz.view.OrgTargetTreeEditParam;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.org.utils.OrgTreeUtils;
import kd.bos.orm.util.CollectionUtils;

public class OrgTargetTreeView
extends OrgSourceTreeView {
    public OrgTargetTreeView(long viewId, TreeView treeView, boolean isInitTree) {
        super(viewId, treeView, isInitTree);
    }

    public void addNodes(OrgSourceTreeView srcTreeView, String parentId, boolean addByLevel) {
        if (srcTreeView == null) {
            return;
        }
        ArrayList<String> srcSelectedNodes = new ArrayList<String>(srcTreeView.getSelectedNodes());
        srcSelectedNodes.remove(parentId);
        if (CollectionUtils.isEmpty(srcSelectedNodes)) {
            return;
        }
        OrgTargetTreeEditParam editParam = new OrgTargetTreeEditParam();
        editParam.setSrcTreeView(srcTreeView);
        editParam.setParentId(parentId);
        this.getAllNodesMap(editParam.getAllSourceNodes(), srcTreeView.getRootNode());
        this.getAllNodesMap(editParam.getAllTargetNodes(), this.rootNode);
        this.removeAddedParentNode(editParam, srcSelectedNodes);
        if (CollectionUtils.isEmpty(srcSelectedNodes)) {
            return;
        }
        if (addByLevel) {
            this.findNodesToAddByLevel(editParam, srcSelectedNodes);
        } else {
            this.findNodesToAdd(editParam, srcSelectedNodes);
        }
        boolean deleted = this.deleteExistsNodeBeforeAdd(editParam);
        boolean added = this.addNodes(editParam);
        if (deleted || added) {
            this.updateRootNodeCache();
        }
    }

    private void removeAddedParentNode(OrgTargetTreeEditParam editParam, List<String> srcSelectedNodes) {
        ArrayList<String> parentNodeIds = new ArrayList<String>(srcSelectedNodes.size());
        Map<String, TreeNode> allTargetNodes = editParam.getAllTargetNodes();
        this.findAllParentNodeIds(allTargetNodes, editParam.getParentId(), parentNodeIds);
        srcSelectedNodes.removeAll(parentNodeIds);
    }

    private void findAllParentNodeIds(Map<String, TreeNode> allTargetNodes, String parentId, List<String> parentNodeIds) {
        TreeNode treeNode = allTargetNodes.get(parentId);
        if (treeNode == null) {
            return;
        }
        parentNodeIds.add(treeNode.getId());
        this.findAllParentNodeIds(allTargetNodes, treeNode.getParentid(), parentNodeIds);
    }

    public void findNodesToAddByLevel(OrgTargetTreeEditParam editParam, List<String> srcSelectedNodes) {
        HashMap<String, TreeNode> selectedNodeMap = new HashMap<String, TreeNode>(srcSelectedNodes.size());
        for (String nodeId : srcSelectedNodes) {
            TreeNode srcNode = editParam.getAllSourceNodes().get(nodeId);
            if (srcNode == null) continue;
            TreeNode targetNode = this.shallowCloneTreeNode(srcNode);
            targetNode.setLeaf(true);
            targetNode.setChildren(null);
            TreeNode parentNode = (TreeNode)selectedNodeMap.get(targetNode.getParentid());
            if (parentNode == null) {
                this.acceptSkipLevelNode(editParam, targetNode);
            } else {
                parentNode.addChild(targetNode);
            }
            selectedNodeMap.put(targetNode.getId(), targetNode);
        }
        ArrayList<TreeNode> addChildren = new ArrayList<TreeNode>();
        for (TreeNode node : editParam.getAddNodes()) {
            ArrayList<String> nodeIds = new ArrayList<String>();
            OrgTreeUtils.getAllNodeId((TreeNode)node, (boolean)true, nodeIds);
            this.acceptChildren(editParam, selectedNodeMap, node, nodeIds, addChildren);
        }
        editParam.getAddNodes().addAll(addChildren);
    }

    private void acceptSkipLevelNode(OrgTargetTreeEditParam editParam, TreeNode targetNode) {
        boolean isAddDirectOrg;
        List<TreeNode> addNodeList;
        block4: {
            block3: {
                addNodeList = editParam.getAddNodes();
                isAddDirectOrg = true;
                if (!editParam.getParentId().equals(targetNode.getParentid())) break block3;
                TreeNode exitsTargetNode = editParam.getAllTargetNodes().get(targetNode.getId());
                if (exitsTargetNode == null) break block4;
                editParam.getDeleteNodeIds().add(targetNode.getId());
                break block4;
            }
            if (StringUtils.isNotBlank((CharSequence)targetNode.getLongNumber())) {
                for (int i = addNodeList.size() - 1; i >= 0; --i) {
                    TreeNode node = addNodeList.get(i);
                    String parentLongNumberPre = node.getLongNumber() + "!";
                    if (!targetNode.getLongNumber().startsWith(parentLongNumberPre)) continue;
                    targetNode.setParentid(node.getId());
                    node.addChild(targetNode);
                    isAddDirectOrg = false;
                    break;
                }
            }
        }
        if (isAddDirectOrg) {
            targetNode.setParentid(editParam.getParentId());
            addNodeList.add(targetNode);
        }
    }

    private void acceptChildren(OrgTargetTreeEditParam editParam, Map<String, TreeNode> selectedNodeMap, TreeNode node, List<String> nodeIds, List<TreeNode> addChildren) {
        List children;
        TreeNode child;
        if (node == null) {
            return;
        }
        boolean addNew = false;
        TreeNode targetNode = editParam.getAllTargetNodes().get(node.getId());
        List targetChildren = null;
        if (targetNode == null) {
            addNew = true;
        } else {
            targetChildren = targetNode.getChildren();
            TreeNode srcNode = selectedNodeMap.get(node.getId());
            if (srcNode != null && this.isNodeChanged(srcNode.getParentid(), srcNode, targetNode, false)) {
                editParam.getDeleteNodeIds().add(node.getId());
                addNew = true;
            }
        }
        if (addNew && !nodeIds.contains(node.getId())) {
            addChildren.add(node);
        }
        if (targetChildren != null) {
            for (int i = 0; i < targetChildren.size(); ++i) {
                TreeNode targetChild = (TreeNode)targetChildren.get(i);
                if (editParam.getDeleteNodeIds().contains(targetChild.getId()) || nodeIds.contains(targetChild.getId()) || !selectedNodeMap.containsKey(targetChild.getId())) continue;
                child = this.shallowCloneTreeNode(targetChild);
                this.setTreeNodeLeaf(child);
                node.addChild(child);
            }
        }
        if ((children = node.getChildren()) != null) {
            for (int i = 0; i < children.size(); ++i) {
                child = (TreeNode)children.get(i);
                this.acceptChildren(editParam, selectedNodeMap, child, nodeIds, addChildren);
            }
        }
    }

    private void findNodesToAdd(OrgTargetTreeEditParam editParam, List<String> srcSelectedNodes) {
        String parentId = editParam.getParentId();
        for (String nodeId : srcSelectedNodes) {
            List targetNodeChildren;
            TreeNode srcNode = editParam.getAllSourceNodes().get(nodeId);
            if (srcNode == null) continue;
            TreeNode targetNode = editParam.getAllTargetNodes().get(nodeId);
            if (targetNode != null && (targetNodeChildren = targetNode.getChildren()) != null) {
                Iterator iterator = targetNodeChildren.iterator();
                while (iterator.hasNext()) {
                    TreeNode child = (TreeNode)iterator.next();
                    if (!srcSelectedNodes.contains(child.getId())) continue;
                    iterator.remove();
                }
                this.setTreeNodeLeaf(targetNode);
            }
            if (!this.isNodeChanged(editParam.getParentId(), srcNode, targetNode, true)) continue;
            targetNode = this.shallowCloneTreeNode(srcNode);
            targetNode.setParentid(parentId);
            targetNode.setLeaf(true);
            targetNode.setChildren(null);
            editParam.getAddNodes().add(targetNode);
            editParam.getDeleteNodeIds().add(nodeId);
        }
    }

    private boolean isNodeChanged(String parentId, TreeNode srcNode, TreeNode targetNode, boolean checkChildrenSize) {
        if (targetNode == null) {
            return true;
        }
        if (!parentId.equals(targetNode.getParentid())) {
            return true;
        }
        if (srcNode.getChildren() == null && targetNode.getChildren() == null) {
            return false;
        }
        boolean isChildrenChanged = srcNode.getChildren() == null && targetNode.getChildren() != null || srcNode.getChildren() != null && targetNode.getChildren() == null || checkChildrenSize && srcNode.getChildren().size() != targetNode.getChildren().size();
        return isChildrenChanged;
    }

    private boolean deleteExistsNodeBeforeAdd(OrgTargetTreeEditParam editParam) {
        List<String> deleteNodeIds = editParam.getDeleteNodeIds();
        if (CollectionUtils.isEmpty(deleteNodeIds)) {
            return false;
        }
        ArrayList<String> deleteCacheIds = new ArrayList<String>(deleteNodeIds);
        ArrayList<TreeNode> updateLeafNodes = new ArrayList<TreeNode>(deleteNodeIds.size());
        this.deleteChildNode(this.rootNode, deleteCacheIds, updateLeafNodes);
        this.treeView.deleteNodes(deleteNodeIds);
        ArrayList<String> originalSelectNodeIds = new ArrayList<String>(1);
        originalSelectNodeIds.add(editParam.getParentId());
        this.updateNodes(originalSelectNodeIds, updateLeafNodes);
        List<String> selectedNodes = this.getSelectedNodes();
        selectedNodes.removeAll(deleteCacheIds);
        this.updateSelectedNodeCache(selectedNodes);
        return true;
    }

    public void updateNodes(List<String> originalSelectNodeIds, List<TreeNode> updateNodes) {
        this.treeView.updateNodes(updateNodes);
        this.reselectUpdateNode(originalSelectNodeIds, updateNodes);
    }

    private void reselectUpdateNode(List<String> nodeIds, List<TreeNode> updateNodes) {
        if (CollectionUtils.isEmpty(nodeIds) || CollectionUtils.isEmpty(updateNodes)) {
            return;
        }
        ArrayList<TreeNode> targetParentNodes = new ArrayList<TreeNode>(nodeIds.size());
        ArrayList<String> targetNodeIds = new ArrayList<String>(nodeIds);
        List<String> selectedNodes = this.getSelectedNodes();
        block0: for (String nodeId : targetNodeIds) {
            for (TreeNode node : updateNodes) {
                if (!nodeId.equals(node.getId()) || !selectedNodes.contains(nodeId)) continue;
                targetParentNodes.add(node);
                continue block0;
            }
        }
        this.treeView.checkNodes(targetParentNodes);
    }

    private void deleteChildNode(TreeNode node, List<String> deleteCacheIds, List<TreeNode> updateLeafNodes) {
        if (node == null || node.getChildren() == null || CollectionUtils.isEmpty(deleteCacheIds)) {
            return;
        }
        Iterator iterator = node.getChildren().iterator();
        while (iterator.hasNext()) {
            TreeNode child = (TreeNode)iterator.next();
            if (deleteCacheIds.contains(child.getId())) {
                iterator.remove();
                deleteCacheIds.remove(child.getId());
                this.setTreeNodeLeaf(node);
                if (node.getChildren() == null) {
                    updateLeafNodes.add(node);
                }
                if (!deleteCacheIds.isEmpty()) continue;
                break;
            }
            this.deleteChildNode(child, deleteCacheIds, updateLeafNodes);
        }
    }

    private boolean addNodes(OrgTargetTreeEditParam editParam) {
        ArrayList<Object> addToViewNodes;
        List<TreeNode> addNodes = editParam.getAddNodes();
        if (CollectionUtils.isEmpty(addNodes)) {
            return false;
        }
        Map<String, TreeNode> allTargetNodes = editParam.getAllTargetNodes();
        ArrayList<Object> addNewNodes = new ArrayList<Object>(addNodes.size());
        HashMap<String, TreeNode> existsChildren = new HashMap<String, TreeNode>(addNodes.size());
        for (TreeNode treeNode : addNodes) {
            addNewNodes.add(this.shallowCloneTreeNode(treeNode));
            TreeNode treeNode2 = allTargetNodes.get(treeNode.getParentid());
            if (treeNode2 == null) continue;
            if (!treeNode2.getIsOpened() && treeNode2.getChildren() != null) {
                for (TreeNode child : treeNode2.getChildren()) {
                    existsChildren.put(child.getId(), child);
                }
            }
            treeNode2.addChild(treeNode);
        }
        if (existsChildren.isEmpty()) {
            addToViewNodes = addNewNodes;
        } else {
            addToViewNodes = new ArrayList(addNodes.size() + existsChildren.size());
            for (TreeNode treeNode : addNewNodes) {
                existsChildren.remove(treeNode.getId());
            }
            addToViewNodes.addAll(existsChildren.values());
            addToViewNodes.addAll(addNewNodes);
        }
        this.treeView.addNodes(addToViewNodes);
        if (this.rootNode == null) {
            this.rootNode = addNodes.get(0);
        } else {
            this.treeView.expand(editParam.getParentId());
            TreeNode treeNode = allTargetNodes.get(editParam.getParentId());
            if (treeNode != null) {
                treeNode.setExpend(true);
                treeNode.setIsOpened(true);
            }
        }
        return true;
    }

    public void deleteNodes(List<String> selectedNodes) {
        if (CollectionUtils.isEmpty(selectedNodes)) {
            return;
        }
        int count = selectedNodes.size();
        ArrayList<String> nodeIds = new ArrayList<String>(count);
        ArrayList<TreeNode> updateLeafNodes = new ArrayList<TreeNode>(count);
        for (String nodeId : selectedNodes) {
            if (nodeId.equals(this.rootNode.getId())) {
                this.rootNode = null;
                nodeIds = new ArrayList(1);
                nodeIds.add(nodeId);
                break;
            }
            nodeIds.add(nodeId);
            TreeNode node = OrgTreeUtils.getNode((TreeNode)this.rootNode, (Object)nodeId);
            if (node == null) continue;
            TreeNode parentNode = OrgTreeUtils.getNode((TreeNode)this.rootNode, (Object)node.getParentid());
            if (parentNode == null) {
                this.rootNode.deleteChildNode(nodeId);
                continue;
            }
            parentNode.deleteChildNode(nodeId);
            if (!this.setTreeNodeLeaf(parentNode)) continue;
            updateLeafNodes.add(parentNode);
        }
        this.updateRootNodeCache();
        this.updateSelectedNodeCache(null);
        this.treeView.deleteNodes(nodeIds);
        this.treeView.updateNodes(updateLeafNodes);
    }

    @Override
    protected OrgTreeParam getOrgTreeParam() {
        OrgTreeParam orgTreeParam = super.getOrgTreeParam();
        boolean includeDisabled = this.isIncludeDisabled();
        orgTreeParam.setIncludeDisable(includeDisabled);
        orgTreeParam.setIncludeFreeze(includeDisabled);
        return orgTreeParam;
    }
}

