/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.biz.view;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.org.biz.view.OrgSourceTreeView;
import kd.bos.org.biz.view.OrgViewSchemaFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;

public class OrgUnitViewSchemaFormPlugin
extends OrgViewSchemaFormPlugin {
    private static final String OPEN_TIPS = "opentips";
    private static final String CLOSE_TIPS = "closetips";
    private static final String IS_OPEN = "isopen";
    private static final String TIPS = "tips";
    private static final String ORG_UNIT_RAPID_ADD = "OrgUnitRapidAdd";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{OPEN_TIPS, CLOSE_TIPS});
    }

    @Override
    public QFilter getTreeTypeFilter() {
        QFilter numberFilter = new QFilter("fnumber", "=", (Object)"15");
        return numberFilter;
    }

    @Override
    public void initAfterCreateNewData() {
        super.initAfterCreateNewData();
        this.initOrgPatternMulCombo();
        this.setButtonVisibleByTabKey("edittab", false);
        long userId = RequestContext.get().getCurrUserId();
        String isOpen = UserConfigServiceHelper.getSetting((long)userId, (String)ORG_UNIT_RAPID_ADD);
        if (StringUtils.isEmpty((CharSequence)isOpen) || "1".equals(isOpen)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{TIPS, CLOSE_TIPS});
            this.getView().setVisible(Boolean.FALSE, new String[]{OPEN_TIPS});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{OPEN_TIPS});
            this.getView().setVisible(Boolean.FALSE, new String[]{TIPS, CLOSE_TIPS});
        }
    }

    @Override
    public String getSchemaId(TreeView schemaTree) {
        return Long.toString(15L);
    }

    private void initOrgPatternMulCombo() {
        QFilter idFilter = new QFilter("id", "in", (Object)new Object[]{7L, 1L, 2L, 6L, 8L});
        QFilter[] filters = new QFilter[]{idFilter};
        Map orgPatterMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_pattern", (String)"id,name", (QFilter[])filters, (String)"number");
        if (orgPatterMap == null || orgPatterMap.isEmpty()) {
            return;
        }
        ComboEdit orgPatternField = (ComboEdit)this.getControl("orgpattern");
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(3);
        for (Map.Entry entry : orgPatterMap.entrySet()) {
            DynamicObject patternObj = (DynamicObject)entry.getValue();
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(patternObj.getString("id"));
            comboItem.setCaption(new LocaleString(patternObj.getString("name")));
            propertyItems.add(comboItem);
        }
        orgPatternField.setComboItems(propertyItems);
    }

    @Override
    public String getLeftTreeViewSchemaId() {
        return Long.toString(1L);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        if ("orgpattern".equals(proName)) {
            this.checkNodeByOrgPattern(e.getChangeSet()[0]);
        }
    }

    private void checkNodeByOrgPattern(ChangeData cd) {
        OrgSourceTreeView adminTreeView = this.getOrgSourceTreeView();
        adminTreeView.unSelectAll();
        if (cd == null) {
            return;
        }
        Object newValue = cd.getNewValue();
        if (newValue == null) {
            return;
        }
        String[] patternArr = newValue.toString().split(",");
        ArrayList<Long> patternList = new ArrayList<Long>(patternArr.length);
        for (String orgPattern : patternArr) {
            if (!StringUtils.isNotBlank((CharSequence)orgPattern)) continue;
            patternList.add(Long.valueOf(orgPattern));
        }
        if (patternList.isEmpty()) {
            return;
        }
        QFilter orgpatternFilter = new QFilter("orgpattern", "in", patternList);
        QFilter viewFilter = new QFilter("fisadministrative", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{orgpatternFilter, viewFilter};
        Map orgObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id", (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)orgObjMap)) {
            return;
        }
        ArrayList<String> checkNodes = new ArrayList<String>(orgObjMap.size());
        for (Map.Entry orgEntry : orgObjMap.entrySet()) {
            checkNodes.add(orgEntry.getKey().toString());
        }
        adminTreeView.selectNodes(checkNodes, false);
    }

    @Override
    public boolean isViewDeleteAble(List<String> allDeleteNodeIds) {
        if (CollectionUtils.isEmpty(allDeleteNodeIds)) {
            return true;
        }
        ArrayList<Long> nodeIds = new ArrayList<Long>(allDeleteNodeIds.size());
        for (String nodeId : allDeleteNodeIds) {
            if (!StringUtils.isNotBlank((CharSequence)nodeId)) continue;
            nodeIds.add(Long.valueOf(nodeId));
        }
        if (this.isExistsNotAdminOrg(nodeIds)) {
            return false;
        }
        return !this.isExistsOtherView(nodeIds);
    }

    private boolean isExistsNotAdminOrg(List<Long> allDeleteNodeIds) {
        QFilter viewFilter = new QFilter("fisadministrative", "=", (Object)Boolean.FALSE);
        QFilter orgFilter = new QFilter("id", "in", allDeleteNodeIds);
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter};
        String selectFields = "number,name";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.bos.org.biz.view.OrgUnitViewSchemaFormPlugin.isExistsNotAdminOrg", (String)"bos_org", (String)selectFields, (QFilter[])filters, (String)"number", (int)1);){
            if (ds.hasNext()) {
                this.getView().showTipNotification(OrgMessage.getMessage((String)"M00043", (Object[])new Object[]{ds.next().getString("name")}));
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private boolean isExistsOtherView(List<Long> allDeleteNodeIds) {
        QFilter viewFilter = new QFilter("view", "not in", (Object)new Long[]{1L, 15L, 16L});
        QFilter orgFilter = new QFilter("org", "in", allDeleteNodeIds);
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter};
        String selectFields = "org.name org,view.name view";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.bos.org.biz.view.OrgUnitViewSchemaFormPlugin.isExistsOtherView", (String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"level", (int)1);){
            if (ds.hasNext()) {
                Row row = ds.next();
                this.getView().showTipNotification(OrgMessage.getMessage((String)"M00044", (Object[])new Object[]{row.getString("org"), row.getString("view")}));
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
        if (OPEN_TIPS.equals(key)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{TIPS, CLOSE_TIPS});
            this.getView().setVisible(Boolean.FALSE, new String[]{OPEN_TIPS});
            if (parentView != null) {
                parentView.getPageCache().put(IS_OPEN, "1");
            }
            return;
        }
        if (CLOSE_TIPS.equals(key)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TIPS, CLOSE_TIPS});
            this.getView().setVisible(Boolean.TRUE, new String[]{OPEN_TIPS});
            if (parentView != null) {
                parentView.getPageCache().put(IS_OPEN, "0");
            }
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        long userId = RequestContext.get().getCurrUserId();
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
        if (parentView == null) {
            return;
        }
        if ("0".equals(parentView.getPageCache().get(IS_OPEN))) {
            UserConfigServiceHelper.setSetting((long)userId, (String)ORG_UNIT_RAPID_ADD, (String)"0");
        } else {
            UserConfigServiceHelper.setSetting((long)userId, (String)ORG_UNIT_RAPID_ADD, (String)"1");
        }
    }
}

