/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.biz.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.msg.BaseMessageUtils;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.Search;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.base.BaseView;
import kd.bos.org.biz.view.OrgSourceTreeView;
import kd.bos.org.biz.view.OrgTargetTreeView;
import kd.bos.org.biz.view.OrgViewSchemaRefrenceChecker;
import kd.bos.org.model.OrgDutyView;
import kd.bos.org.model.OrgParam;
import kd.bos.org.model.OrgTreeSearchParam;
import kd.bos.org.utils.OrgTreeUtils;
import kd.bos.org.utils.OrgUtils;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.org.utils.Utils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public abstract class OrgViewSchemaBaseFormPlugin
extends AbstractFormPlugin
implements TreeNodeQueryListener,
TreeNodeClickListener,
TreeNodeCheckListener,
SearchEnterListener,
TabSelectListener {
    private static final Log log = LogFactory.getLog(OrgViewSchemaBaseFormPlugin.class);
    public static final String AP_SCHEMA_TREE = "schematree";
    public static final String CACHE_SCHEMA_TREE_ROOTNODE = "CACHE_SCHEMA_TREE_ROOTNODE";
    public static final String AP_BIZ_UNIT_TREE = "bizunittree";
    public static final String AP_BIZ_VIEW_TREE = "bizviewtree";
    protected String SCHEMA_ROOT_NAME = ResManager.loadKDString((String)"\u89c6\u56fe\u65b9\u6848", (String)"OrgViewSchemaBaseFormPlugin_0", (String)"bos-org-formplugin", (Object[])new Object[0]);
    public static final String CACHE_NEW_SCHEMA_ID = "newSchemaId";
    protected String NEW_SCHEMA_DEFAULT_NAME = ResManager.loadKDString((String)"\u65b0\u5efa\u65b9\u6848", (String)"OrgViewSchemaBaseFormPlugin_1", (String)"bos-org-formplugin", (Object[])new Object[0]);
    public static final String IS_DATA_CHANGED_FLAG = "isdatachangedflag";
    public static final String LASTTIME_CLICK_NODE = "lasttime_click_node";
    protected static final String AFTER_DELETE_CLICK_NODE = "after_delete_click_node";
    public static final String CACHE_ORG_UNIT_TREE_ROOTNODE = "CACHE_ORG_UNIT_TREE_ROOTNODE";
    public static final String CACHE_ORG_UNIT_TREE_ROOTNODE_CHECKED = "CACHE_ORG_UNIT_TREE_ROOTNODE_CHECKED";
    public static final String CACHE_ORG_VIEW_TREE_ROOTNODE = "CACHE_ORG_VIEW_TREE_ROOTNODE";
    public static final String CACHE_ORG_VIEW_TREE_ROOTNODE_CHECKED = "CACHE_ORG_VIEW_TREE_ROOTNODE_CHECKED";
    public static final String KEY_ORG_OPTION_PARAMS = "_org_option_params_";
    public static final String KEY_RESETROOT = "_resetroot_";
    public static final String KEY_ADDNODE = "_addNode_";
    public static final String KEY_UPDATENODE = "_updateNode_";
    public static final String KEY_DELETENODE = "_deleteNode_";
    public static final String IS_CHECK_UNIT_CHILD = "ischeckunitchild";
    public static final String IS_CHECK_VIEW_CHILD = "ischeckviewchild";
    public static final String LABEL_CU = "\uff08CU\uff09";
    private static final String BTN_SETCTRLUNIT = "btn_setctrlunit";
    private static final String BTN_DELCTRLUNIT = "btn_delctrlunit";
    private static final String ORG_SEARCHAP = "orgsearchap";
    private static final String SAVE_WHEN_CLICK_NODE = "saveWhenClickNode";
    private static final String TREE_TYPE_ID = "treetypeid";
    private static final String ORIGINAL_VIEWSCHEMA = "originalviewschema";
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"OrgViewSchemaBaseFormPlugin.ThreadPools", (int)2);
    private static final String ORG_TREEE_NTRYENTITY = "orgtreeentryentity";
    private static final String BTN_VIEW = "btn_view";
    private static final String VIEW_TAB = "viewtab";
    private static final String BTN_EDIT = "btn_edit";
    protected static final String EDIT_TAB = "edittab";
    private static final String VIEW_TAB_ACTIVE = "viewTabActive";
    private static final String[] TOOLBAR_BUTTONS = new String[]{"bar_new", "bar_save", "bar_delete"};

    protected String getLeftTreeViewSchemaId() {
        return Long.toString(15L);
    }

    public abstract QFilter getTreeTypeFilter();

    public QFilter getViewSchemaFilter() {
        return null;
    }

    public void registerListener(EventObject e) {
        TreeEntryGrid orgTreeEntryGrid;
        Tab tab;
        Search searchap;
        Search viewsearchap;
        this.registerTreeListener((TreeView)this.getControl(AP_SCHEMA_TREE));
        this.registerTreeListener((TreeView)this.getControl(AP_BIZ_UNIT_TREE));
        this.registerTreeListener((TreeView)this.getControl(AP_BIZ_VIEW_TREE));
        this.addClickListeners(new String[]{"btn_leveladd", "btn_orderadd", "btn_deletenode", "btn_uncheckunit", "btn_uncheckview", BTN_SETCTRLUNIT, BTN_DELCTRLUNIT});
        this.addItemClickListeners(new String[]{"tbmain", "toolbarap"});
        Search orgsearchap = (Search)this.getView().getControl(ORG_SEARCHAP);
        if (orgsearchap != null) {
            orgsearchap.addEnterListener((SearchEnterListener)this);
        }
        if ((viewsearchap = (Search)this.getView().getControl("viewsearchap")) != null) {
            viewsearchap.addEnterListener((SearchEnterListener)this);
        }
        if ((searchap = (Search)this.getView().getControl("searchap")) != null) {
            searchap.addEnterListener((SearchEnterListener)this);
        }
        if ((tab = (Tab)this.getControl("tabap")) != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
        if ((orgTreeEntryGrid = (TreeEntryGrid)this.getControl(ORG_TREEE_NTRYENTITY)) != null) {
            orgTreeEntryGrid.addRowClickListener(new RowClickEventListener(){

                public void entryRowClick(RowClickEvent evt) {
                    if (evt.getRow() == -1) {
                        DynamicObjectCollection treeEntryEntity = OrgViewSchemaBaseFormPlugin.this.getModel().getEntryEntity(OrgViewSchemaBaseFormPlugin.ORG_TREEE_NTRYENTITY);
                        if (CollectionUtils.isEmpty((Collection)treeEntryEntity)) {
                            return;
                        }
                        int[] indexs = new int[treeEntryEntity.size()];
                        for (int i = 0; i < treeEntryEntity.size(); ++i) {
                            indexs[i] = i;
                        }
                        orgTreeEntryGrid.expand(indexs);
                    }
                }
            });
        }
    }

    private void registerTreeListener(TreeView treeView) {
        if (treeView == null) {
            return;
        }
        if (AP_SCHEMA_TREE.equals(treeView.getKey())) {
            treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        }
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        if (this.getRootNodeFromCache(CACHE_SCHEMA_TREE_ROOTNODE) == null) {
            this.initAfterCreateNewData();
        } else {
            this.choseChildNode(AP_BIZ_UNIT_TREE, Boolean.FALSE);
            this.choseChildNode(AP_BIZ_VIEW_TREE, Boolean.FALSE);
            this.clearSearchText();
            String nodeId = this.getPageCache().get(AFTER_DELETE_CLICK_NODE);
            if (StringUtils.isNotBlank((CharSequence)nodeId)) {
                TreeView schemaTree = (TreeView)this.getControl(AP_SCHEMA_TREE);
                Map focusNode = schemaTree.getTreeState().getFocusNode();
                if (focusNode != null) {
                    this.fireClickSchemaTree(schemaTree, focusNode.get("parentid").toString(), focusNode.get("id").toString());
                }
                this.getPageCache().remove(AFTER_DELETE_CLICK_NODE);
            }
        }
    }

    public void afterBindData(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof BaseView) {
            BaseView baseView = (BaseView)source;
            BillShowParameter formShowParameter = (BillShowParameter)baseView.getFormShowParameter();
            if (OperationStatus.VIEW == formShowParameter.getStatus()) {
                SplitContainer sc = (SplitContainer)this.getControl("splitcontainerap");
                sc.hidePanel(SplitDirection.left, true);
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_EDIT});
                this.viewDetail();
            }
            boolean isComeFromDataBase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
            this.getView().setEnable(Boolean.valueOf(!isComeFromDataBase), new String[]{"number"});
        }
    }

    private void viewDetail() {
        if (this.getModel().getProperty(ORG_TREEE_NTRYENTITY) == null) {
            return;
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"fieldsetpanelap"});
        TreeEntryGrid orgTreeEntryGrid = (TreeEntryGrid)this.getControl(ORG_TREEE_NTRYENTITY);
        orgTreeEntryGrid.collapse(0);
        QFilter viewFilter = new QFilter("structure.view", "=", (Object)Long.parseLong(this.getPkValue().toString()));
        if (!((Boolean)this.getModel().getValue("isshowdisabled")).booleanValue()) {
            viewFilter = viewFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
            viewFilter = viewFilter.and(new QFilter("structure.isfreeze", "=", (Object)Boolean.FALSE));
        }
        QFilter[] filters = new QFilter[]{viewFilter};
        String selectFields = "id,structure.viewparent parent,number,name,orgpattern.name orgpattern,orgpattern.patterntype orgpatterntype,enable,structure.isfreeze isfreeze";
        String orderBy = OrgUtils.getOrgTreeOrderByFields((String)"");
        selectFields = OrgUtils.getOrgSelectFields((String)selectFields, (String)orderBy);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgViewSchemaBaseFormPlugin.viewDetail.count", (String)"bos_org", (String)selectFields, (QFilter[])filters, (String)"");
             DataSet orderDataSet = dataSet.orderBy(orderBy.split(","));){
            this.getModel().beginInit();
            this.getModel().deleteEntryData(ORG_TREEE_NTRYENTITY);
            TableValueSetter vs = new TableValueSetter(new String[]{"id", "pid", "orgname", "orgnumber", "orgpatternname", "orgpatterntype", "orgenable", "isfreeze"});
            for (Row orgStructObj : orderDataSet) {
                vs.addRow(new Object[]{orgStructObj.get("id"), orgStructObj.get("parent"), orgStructObj.get("name"), orgStructObj.get("number"), orgStructObj.get("orgpattern"), orgStructObj.get("orgpatterntype"), orgStructObj.get("enable"), orgStructObj.getBoolean("isfreeze") != false ? "1" : "0"});
            }
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(ORG_TREEE_NTRYENTITY, vs);
            this.getModel().endInit();
        }
        this.getView().updateView(ORG_TREEE_NTRYENTITY);
        orgTreeEntryGrid.expandOne(0);
        this.getPageCache().remove(IS_DATA_CHANGED_FLAG);
        this.getModel().setDataChanged(false);
    }

    public void initAfterCreateNewData() {
        this.initSchemaTree();
    }

    public void search(SearchEnterEvent evt) {
        String checkChildKey;
        TreeNode rootNode;
        String viewId;
        TreeView treeView;
        OrgSourceTreeView orgTreeView;
        String searchText = evt.getText();
        Search search = (Search)evt.getSource();
        if (ORG_SEARCHAP.equals(search.getKey())) {
            orgTreeView = this.getOrgSourceTreeView();
            treeView = (TreeView)this.getControl(AP_BIZ_UNIT_TREE);
            viewId = this.getLeftOriginalViewSchemaId();
            rootNode = orgTreeView.getRootNode();
            checkChildKey = IS_CHECK_UNIT_CHILD;
        } else {
            orgTreeView = this.getOrgTargetTreeView();
            treeView = (TreeView)this.getControl(AP_BIZ_VIEW_TREE);
            viewId = this.getPkValue().toString();
            rootNode = orgTreeView.getRootNode();
            checkChildKey = IS_CHECK_VIEW_CHILD;
        }
        OrgTreeSearchParam searchParam = new OrgTreeSearchParam(searchText, this.getView(), treeView, rootNode, Long.parseLong(viewId));
        searchParam.setQueryBeforeExpend(true);
        OrgTreeUtils.searchFromLazyOrgTree((OrgTreeSearchParam)searchParam);
        orgTreeView.unSelectAll();
        orgTreeView.cacheSelectNodes(searchParam.getCheckNodeIds(), (boolean)((Boolean)this.getModel().getValue(checkChildKey)));
    }

    private String getLeftOriginalViewSchemaId() {
        DynamicObject originalViewObj = (DynamicObject)this.getModel().getValue(ORIGINAL_VIEWSCHEMA);
        return originalViewObj == null ? this.getLeftTreeViewSchemaId() : originalViewObj.getString("id");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        boolean cacheDataChanged = this.isCacheDataChanged();
        if (IS_CHECK_UNIT_CHILD.equals(proName)) {
            this.choseChildNode(AP_BIZ_UNIT_TREE, (Boolean)e.getChangeSet()[0].getNewValue(), this.getOrgSourceTreeView());
        } else if (IS_CHECK_VIEW_CHILD.equals(proName)) {
            this.choseChildNode(AP_BIZ_VIEW_TREE, (Boolean)e.getChangeSet()[0].getNewValue(), this.getOrgTargetTreeView());
        } else if ("isshowdisabled".equals(proName)) {
            this.viewDetail();
        } else if ("isshowdisablednode".equals(proName)) {
            if (cacheDataChanged) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5237\u65b0\u5f53\u524d\u89c6\u56fe\u5c06\u4e0d\u4fdd\u5b58\u4fee\u6539\u7684\u5185\u5bb9\u3002\u786e\u5b9a\u5237\u65b0\u5417\uff1f", (String)"OrgViewSchemaBaseFormPlugin_13", (String)"bos-org-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("isshowdisablednode"));
            } else {
                this.getOrgTargetTreeView().initTree();
            }
        }
        this.updateDataChanged(cacheDataChanged);
    }

    private boolean isCacheDataChanged() {
        return "1".equals(this.getPageCache().get(IS_DATA_CHANGED_FLAG));
    }

    private void updateDataChanged(boolean cacheDataChanged) {
        if (cacheDataChanged) {
            return;
        }
        Iterable bizChangedProperties = this.getModel().getDataEntity().getDataEntityState().getBizChangedProperties();
        Iterator iterator = bizChangedProperties.iterator();
        while (iterator.hasNext()) {
            IDataEntityProperty prop = (IDataEntityProperty)iterator.next();
            String propName = prop.getName();
            if (!Objects.equals(IS_CHECK_UNIT_CHILD, propName) && !Objects.equals(IS_CHECK_VIEW_CHILD, propName) && !Objects.equals("isshowdisabled", propName) && !Objects.equals("isshowdisablednode", propName) && !Objects.equals(ORIGINAL_VIEWSCHEMA, propName) && !Objects.equals(TREE_TYPE_ID, propName)) continue;
            iterator.remove();
        }
        this.getModel().setDataChanged(bizChangedProperties.iterator().hasNext());
    }

    private void choseChildNode(String treeViewKey, Boolean chose) {
        this.choseChildNode(treeViewKey, chose, null);
    }

    private void choseChildNode(String treeViewKey, Boolean chose, OrgSourceTreeView treeView) {
        HashMap<String, Boolean> treeProMap = new HashMap<String, Boolean>(1);
        treeProMap.put("ccn", chose);
        treeProMap.put("cpn", Boolean.FALSE);
        this.getView().updateControlMetadata(treeViewKey, treeProMap);
        if (chose.booleanValue() && treeView != null) {
            BaseMessageUtils.showLoading((IFormView)this.getView(), () -> {
                List<String> selectedNodes = treeView.getSelectedNodes();
                treeView.selectNodes(selectedNodes, true);
            });
        }
    }

    protected void initDataModel() {
        this.load("0");
    }

    protected void load(String schemaId) {
        DynamicObject viewObj = null;
        if (!"0".equals(schemaId) && schemaId.indexOf("\\") == -1) {
            viewObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(schemaId), (String)"bos_org_viewschema");
        }
        if (viewObj == null) {
            viewObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_org_viewschema");
        }
        this.getModel().setValue("id", viewObj.getPkValue());
        this.getModel().setValue("number", viewObj.get("number"));
        this.getModel().setValue("name", viewObj.get("name"));
        this.getModel().setValue("treetype", viewObj.get("treetype"));
        this.getModel().setValue("enable", viewObj.get("enable"));
        this.getModel().setValue("isdefault", viewObj.get("isdefault"));
        if (schemaId.indexOf("\\") == -1) {
            this.getModel().setValue(TREE_TYPE_ID, viewObj.get(TREE_TYPE_ID));
        } else {
            this.getModel().setValue(TREE_TYPE_ID, (Object)StringUtils.substringAfterLast((String)schemaId, (String)"\\"));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "bar_new": {
                this.clickAddButton(evt);
                break;
            }
            case "bar_save": {
                this.clickSaveButton(evt);
                break;
            }
            case "bar_delete": {
                this.clickDeleteButton(evt);
                break;
            }
            case "btn_view": {
                this.clickViewButton(evt);
                break;
            }
        }
    }

    private void clickAddButton(BeforeItemClickEvent evt) {
        if (this.getPageCache().get(CACHE_NEW_SCHEMA_ID) != null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5f53\u524d\u7684\u65b0\u5efa\u65b9\u6848\u3002", (String)"OrgViewSchemaBaseFormPlugin_2", (String)"bos-org-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (this.isViewSchemaChanged()) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("saveWhenNew", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u4fdd\u5b58", (String)"OrgViewSchemaBaseFormPlugin_3", (String)"bos-org-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u65b0\u5efa", (String)"OrgViewSchemaBaseFormPlugin_4", (String)"bos-org-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u65b0\u5efa\u65b9\u6848\uff1f\r\n \u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"OrgViewSchemaBaseFormPlugin_5", (String)"bos-org-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
            evt.setCancel(true);
            return;
        }
    }

    private void clickSaveButton(BeforeItemClickEvent evt) {
        LinkedHashMap<String, String> initialNodes;
        TreeView schemaTree = (TreeView)this.getControl(AP_SCHEMA_TREE);
        String schemaId = this.getSchemaId(schemaTree);
        if ("0".equals(schemaId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u804c\u80fd\u7c7b\u578b\u3002", (String)"OrgViewSchemaBaseFormPlugin_6", (String)"bos-org-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        OrgTargetTreeView orgTargetTreeView = this.getOrgTargetTreeView();
        if (orgTargetTreeView.getRootNode() == null && !CollectionUtils.isEmpty(initialNodes = orgTargetTreeView.getAllInitialNodes())) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u79fb\u9664\u5168\u90e8\u7ec4\u7ec7\u5417\uff1f", (String)"OrgViewSchemaBaseFormPlugin_15", (String)"bos-org-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("clickSaveButton"));
            evt.setCancel(true);
        }
    }

    private void clickDeleteButton(BeforeItemClickEvent evt) {
        TreeView schemaTree = (TreeView)this.getControl(AP_SCHEMA_TREE);
        String curSchemaId = this.getSchemaId(schemaTree);
        String newSchemaId = this.getPageCache().get(CACHE_NEW_SCHEMA_ID);
        if (StringUtils.isNotBlank((CharSequence)newSchemaId) && newSchemaId.equals(curSchemaId)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\u5f53\u524d\u65b0\u5efa\u65b9\u6848\u5417\uff1f", (String)"OrgViewSchemaBaseFormPlugin_8", (String)"bos-org-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteNewSchema", (IFormPlugin)this));
            evt.setCancel(true);
            return;
        }
        String msg = OrgViewSchemaRefrenceChecker.isRefrenced(Collections.singletonList(Long.valueOf(curSchemaId)), true);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            this.getView().showTipNotification(msg);
            evt.setCancel(true);
            return;
        }
    }

    private void clickViewButton(BeforeItemClickEvent evt) {
        boolean isDataChanged;
        boolean bl = isDataChanged = this.isViewSchemaChanged() || StringUtils.isNotBlank((CharSequence)this.getPageCache().get(CACHE_NEW_SCHEMA_ID));
        if (isDataChanged) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(VIEW_TAB_ACTIVE, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u4fdd\u5b58", (String)"OrgViewSchemaBaseFormPlugin_3", (String)"bos-org-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u5207\u6362", (String)"OrgViewSchemaBaseFormPlugin_22", (String)"bos-org-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u5207\u6362\u9875\u9762\uff1f\r\n \u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"OrgViewSchemaBaseFormPlugin_24", (String)"bos-org-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
            evt.setCancel(true);
        }
    }

    public String getSchemaId(TreeView schemaTree) {
        TreeNode bizNode;
        List viewChildren;
        List bizChildren;
        String schemaId = schemaTree.getTreeState().getFocusNodeId();
        if (StringUtils.isNotBlank((CharSequence)schemaId)) {
            return schemaId;
        }
        TreeNode rootNode = this.getRootNodeFromCache(CACHE_SCHEMA_TREE_ROOTNODE);
        if (rootNode != null && Utils.isListNotEmpty((List)(bizChildren = rootNode.getChildren())) && Utils.isListNotEmpty((List)(viewChildren = (bizNode = (TreeNode)bizChildren.get(0)).getChildren()))) {
            TreeNode viewNode = (TreeNode)viewChildren.get(0);
            schemaId = viewNode.getId();
            schemaTree.focusNode(viewNode);
        }
        if (StringUtils.isBlank((CharSequence)schemaId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u89c6\u56fe\u65b9\u6848\u3002", (String)"OrgViewSchemaBaseFormPlugin_9", (String)"bos-org-formplugin", (Object[])new Object[0]));
        }
        return schemaId;
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "bar_new": {
                this.addNewViewSchema();
                break;
            }
        }
    }

    private void addNewViewSchema() {
        String parentId;
        String lastClickNodeId = this.getPageCache().get(LASTTIME_CLICK_NODE);
        if (StringUtils.isBlank((CharSequence)lastClickNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u89c6\u56fe\u65b9\u6848\u3002", (String)"OrgViewSchemaBaseFormPlugin_9", (String)"bos-org-formplugin", (Object[])new Object[0]));
            return;
        }
        Object originalView = this.getModel().getValue(ORIGINAL_VIEWSCHEMA);
        this.initDataModel();
        this.getModel().setValue(ORIGINAL_VIEWSCHEMA, originalView);
        String newSchemaId = Long.toString(ORM.create().genLongId("bos_org_viewschema"));
        this.getModel().setValue("id", (Object)newSchemaId);
        this.getPageCache().put(CACHE_NEW_SCHEMA_ID, newSchemaId);
        TreeView schemaTree = (TreeView)this.getControl(AP_SCHEMA_TREE);
        TreeNode schemaRootNode = this.getRootNodeFromCache(CACHE_SCHEMA_TREE_ROOTNODE);
        if (lastClickNodeId.indexOf("\\") == -1) {
            TreeNode focusNode = OrgTreeUtils.getNode((TreeNode)schemaRootNode, (Object)lastClickNodeId);
            if (focusNode == null) {
                return;
            }
            parentId = focusNode.getParentid();
        } else {
            parentId = lastClickNodeId;
        }
        String treetype = StringUtils.substringBeforeLast((String)parentId, (String)"\\");
        this.getModel().setValue("treetype", (Object)treetype);
        String treetypeid = StringUtils.substringAfterLast((String)parentId, (String)"\\");
        this.getModel().setValue(TREE_TYPE_ID, (Object)treetypeid);
        TreeNode newSchemaNode = new TreeNode(parentId, newSchemaId, this.NEW_SCHEMA_DEFAULT_NAME);
        schemaTree.addNode(newSchemaNode);
        this.schemaTreeNodeClick(parentId, newSchemaId, true, false);
    }

    public void beforeClick(BeforeClickEvent evt) {
        String itemKey;
        Object src = evt.getSource();
        if (!(src instanceof Button)) {
            return;
        }
        switch (itemKey = ((Button)src).getKey()) {
            case "btn_leveladd": {
                if (this.isAddAble(false)) break;
                evt.setCancel(true);
                break;
            }
            case "btn_orderadd": {
                if (this.isAddAble(true)) break;
                evt.setCancel(true);
                break;
            }
            case "btn_deletenode": {
                if (this.isDeleteAble()) break;
                evt.setCancel(true);
                break;
            }
            case "btn_setctrlunit": 
            case "btn_delctrlunit": {
                if (this.isCtrlUnitModifyAble()) break;
                evt.setCancel(true);
                break;
            }
        }
    }

    private boolean isAddAble(boolean isAddByOrder) {
        int targetSelectedCount;
        OrgSourceTreeView srcTreeView = this.getOrgSourceTreeView();
        List<String> selectedNodes = srcTreeView.getSelectedNodes();
        if (CollectionUtils.isEmpty(selectedNodes)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ece\u5de6\u6811\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u7ec4\u7ec7\u3002", (String)"OrgViewSchemaBaseFormPlugin_10", (String)"bos-org-formplugin", (Object[])new Object[0]));
            return false;
        }
        String parentId = "";
        OrgTargetTreeView targetTreeView = this.getOrgTargetTreeView();
        boolean hasTargetRootNode = targetTreeView.getRootNode() != null;
        List<String> targetSelectedNodes = targetTreeView.getSelectedNodes();
        int n = targetSelectedCount = CollectionUtils.isEmpty(targetSelectedNodes) ? 0 : targetSelectedNodes.size();
        if (hasTargetRootNode) {
            if (targetSelectedCount == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ece\u53f3\u6811\u9009\u62e9\u4e00\u4e2a\u7ec4\u7ec7\u4f5c\u4e3a\u4e0a\u7ea7\u3002", (String)"OrgViewSchemaBaseFormPlugin_11", (String)"bos-org-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (targetSelectedCount > 1) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u4ece\u53f3\u6811\u9009\u62e9\u4e00\u4e2a\u7ec4\u7ec7\u4f5c\u4e3a\u4e0a\u7ea7\uff0c\u5f53\u524d\u5df2\u9009\u6570\u91cf\uff1a%s", (String)"OrgViewSchemaBaseFormPlugin_12", (String)"bos-org-formplugin", (Object[])new Object[0]), targetSelectedCount));
                return false;
            }
            parentId = targetSelectedNodes.get(0);
        } else {
            int srcSelectedCount = selectedNodes.size();
            if (srcSelectedCount != 1) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u4ece\u5de6\u6811\u9009\u62e9\u4e00\u4e2a\u7ec4\u7ec7\u6dfb\u52a0\u4e3a\u6839\u7ec4\u7ec7\uff0c\u5f53\u524d\u5df2\u9009\u6570\u91cf\uff1a%s", (String)"OrgViewSchemaBaseFormPlugin_25", (String)"bos-org-formplugin", (Object[])new Object[0]), srcSelectedCount));
                return false;
            }
        }
        targetTreeView.addNodes(srcTreeView, parentId, isAddByOrder);
        srcTreeView.unSelectAll();
        this.setViewSchemaChangedFlag(true);
        return true;
    }

    private boolean isDeleteAble() {
        OrgTargetTreeView targetTreeView = this.getOrgTargetTreeView();
        ArrayList<String> selectedNodes = new ArrayList<String>(targetTreeView.getSelectedNodes());
        if (CollectionUtils.isEmpty(selectedNodes)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ece\u53f3\u6811\u9009\u62e9\u9700\u8981\u79fb\u9664\u7684\u7ec4\u7ec7\u3002", (String)"OrgViewSchemaBaseFormPlugin_14", (String)"bos-org-formplugin", (Object[])new Object[0]));
            return false;
        }
        TreeView schemaTree = (TreeView)this.getControl(AP_SCHEMA_TREE);
        String schemaId = this.getSchemaId(schemaTree);
        TreeNode rootNode = targetTreeView.getRootNode();
        if (!this.isRootNodeDeleteAble(rootNode, selectedNodes, schemaId)) {
            return false;
        }
        int count = selectedNodes.size();
        ArrayList<String> allDeleteNodeIds = new ArrayList<String>(count);
        this.getAllDeleteNode(rootNode, selectedNodes, allDeleteNodeIds);
        if (!this.isViewDeleteAble(allDeleteNodeIds)) {
            return false;
        }
        targetTreeView.deleteNodes(allDeleteNodeIds);
        this.setViewSchemaChangedFlag(true);
        return true;
    }

    private boolean isRootNodeDeleteAble(TreeNode rootNode, List<String> selectedNodes, String schemaId) {
        boolean deleteAble = true;
        if ("15".equals(schemaId) && selectedNodes.contains(rootNode.getId())) {
            deleteAble = false;
        }
        if (!deleteAble) {
            this.getView().showTipNotification(OrgMessage.getMessage((String)"M00154"));
        }
        return deleteAble;
    }

    private void getAllDeleteNode(TreeNode rootNode, List<String> selectedNodes, List<String> allDeleteNodeIds) {
        if (CollectionUtils.isEmpty(selectedNodes)) {
            return;
        }
        String nodeId = selectedNodes.remove(0);
        TreeNode node = OrgTreeUtils.getNode((TreeNode)rootNode, (Object)nodeId);
        if (node == null) {
            return;
        }
        OrgTreeUtils.getAllNodeId((TreeNode)node, (boolean)true, allDeleteNodeIds);
        selectedNodes.removeAll(allDeleteNodeIds);
        this.getAllDeleteNode(rootNode, selectedNodes, allDeleteNodeIds);
    }

    private boolean isCtrlUnitModifyAble() {
        if (CollectionUtils.isEmpty(this.getOrgTargetTreeView().getSelectedNodes())) {
            this.getView().showTipNotification(OrgMessage.getMessage((String)"M00182"));
            return false;
        }
        boolean isDataChanged = true;
        IPageCache pageCache = this.getPageCache();
        if (StringUtils.isBlank((CharSequence)pageCache.get(CACHE_NEW_SCHEMA_ID)) && (!this.isViewSchemaChanged() || "0".equals(pageCache.get(LASTTIME_CLICK_NODE)))) {
            isDataChanged = false;
        }
        if (isDataChanged) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u89c6\u56fe\u65b9\u6848\u5b58\u5728\u66f4\u65b0\u5185\u5bb9\uff0c\u8bf7\u5148\u4fdd\u5b58\u3002", (String)"OrgViewSchemaBaseFormPlugin_16", (String)"bos-org-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public boolean isViewDeleteAble(List<String> allDeleteNodeIds) {
        return true;
    }

    public void click(EventObject evt) {
        String itemKey;
        Object src = evt.getSource();
        if (!(src instanceof Button)) {
            return;
        }
        switch (itemKey = ((Button)src).getKey()) {
            case "btn_uncheckunit": {
                this.getOrgSourceTreeView().unSelectAll();
                break;
            }
            case "btn_uncheckview": {
                this.getOrgTargetTreeView().unSelectAll();
                break;
            }
            case "btn_setctrlunit": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u8bbe\u7f6e\u4e3a\u7ba1\u63a7\u5355\u5143\u540e\uff0c\u5b83\u539f\u5148\u4f7f\u7528\u7684\u5206\u914d\u578b\u6570\u636e\u5c06\u4e0d\u53ef\u518d\u4f7f\u7528\uff0c\u5982\u9700\u4f7f\u7528\u9700\u8981\u624b\u5de5\u4ece\u521b\u5efa\u7ec4\u7ec7\u91cd\u65b0\u5206\u914d\u3002\u6d89\u53ca\u6240\u6709\u4f7f\u7528\u8be5\u63a7\u5236\u89c6\u56fe\u7684\u57fa\u7840\u8d44\u6599\uff0c\u5386\u53f2\u5355\u636e\u4e0d\u53d7\u5f71\u54cd\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OrgViewSchemaBaseFormPlugin_26", (String)"bos-org-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BTN_SETCTRLUNIT, (IFormPlugin)this));
                break;
            }
            case "btn_delctrlunit": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u53d6\u6d88\u7ba1\u63a7\u5355\u5143\u540e\uff0c\u5b83\u4f7f\u7528\u7684\u57fa\u7840\u8d44\u6599\u5c06\u548c\u76f4\u63a5\u4e0a\u7ea7\u7ba1\u63a7\u5355\u5143\u4fdd\u6301\u4e00\u81f4\uff0c\u65b0\u589e\u5355\u636e\u4e0d\u53ef\u4f7f\u7528\u8be5\u7ec4\u7ec7\u521b\u5efa\u7684\u57fa\u7840\u8d44\u6599\u3002\u6d89\u53ca\u6240\u6709\u4f7f\u7528\u8be5\u63a7\u5236\u89c6\u56fe\u7684\u57fa\u7840\u8d44\u6599\uff0c\u5386\u53f2\u5355\u636e\u4e0d\u53d7\u5f71\u54cd\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OrgViewSchemaBaseFormPlugin_27", (String)"bos-org-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BTN_DELCTRLUNIT, (IFormPlugin)this));
                break;
            }
        }
    }

    private void updateCtrlUnit(boolean isAddCtrlUnit) {
        OrgTargetTreeView orgTargetTreeView = this.getOrgTargetTreeView();
        TreeNode rootNode = orgTargetTreeView.getRootNode();
        if (rootNode == null) {
            return;
        }
        List<String> selectedIds = orgTargetTreeView.getSelectedNodes();
        Map<Long, OperateErrorInfo> ctrlUnitOperateErrorInfo = this.getCtrlUnitOperateErrorInfo(isAddCtrlUnit, selectedIds);
        ArrayList<TreeNode> selectedNodes = new ArrayList<TreeNode>(selectedIds.size());
        for (String string : selectedIds) {
            TreeNode treeNode;
            if (ctrlUnitOperateErrorInfo.containsKey(Long.valueOf(string)) || (treeNode = orgTargetTreeView.getRootNode().getTreeNode(string)) == null) continue;
            selectedNodes.add(treeNode);
        }
        ArrayList<OrgParam> orgParamList = new ArrayList<OrgParam>(selectedNodes.size());
        for (TreeNode node : selectedNodes) {
            OrgParam orgParam = new OrgParam();
            orgParamList.add(orgParam);
            orgParam.setId(Long.parseLong(node.getId()));
            long parentId = 0L;
            if (StringUtils.isNotBlank((CharSequence)node.getParentid())) {
                parentId = Long.parseLong(node.getParentid());
            }
            TreeMap<String, OrgDutyView> multiViewMap = new TreeMap<String, OrgDutyView>();
            orgParam.setMultiViewMap(multiViewMap);
            OrgDutyView orgDutyView = new OrgDutyView(parentId);
            HashMap<String, Boolean> propertyMap = new HashMap<String, Boolean>(1);
            propertyMap.put("isctrlunit", isAddCtrlUnit);
            orgDutyView.setPropertyMap(propertyMap);
            multiViewMap.put((String)this.getModel().getValue("number"), orgDutyView);
        }
        OrgUnitServiceHelper.addOrUpdate(orgParamList);
        OperationResult operationResult = new OperationResult();
        operationResult.setBillCount(selectedIds.size());
        operationResult.setMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"OrgViewSchemaBaseFormPlugin_21", (String)"bos-org-formplugin", (Object[])new Object[0]));
        for (Map.Entry<Long, OperateErrorInfo> errorInfoEntry : ctrlUnitOperateErrorInfo.entrySet()) {
            operationResult.addErrorInfo(errorInfoEntry.getValue());
        }
        for (OrgParam orgParam : orgParamList) {
            if (orgParam.isSuccess()) {
                operationResult.getSuccessPkIds().add(orgParam.getId());
                continue;
            }
            OperateErrorInfo errorInfo = new OperateErrorInfo(null, ErrorLevel.Error, (Object)orgParam.getId());
            errorInfo.setMessage(orgParam.getMsg());
            operationResult.addErrorInfo(errorInfo);
        }
        if (operationResult.isSuccess() && CollectionUtils.isEmpty((Collection)operationResult.getAllErrorOrValidateInfo())) {
            this.getView().showSuccessNotification(operationResult.getMessage());
        } else {
            this.getView().showOperationResult(operationResult);
        }
        if (!operationResult.getSuccessPkIds().isEmpty()) {
            orgTargetTreeView.initTree();
        }
    }

    private Map<Long, OperateErrorInfo> getCtrlUnitOperateErrorInfo(boolean isAddCtrlUnit, List<String> selectedIds) {
        ArrayList<Long> orgIds = new ArrayList<Long>(selectedIds.size());
        for (String nodeId : selectedIds) {
            orgIds.add(Long.valueOf(nodeId));
        }
        HashMap<Long, OperateErrorInfo> errorInfoMap = new HashMap<Long, OperateErrorInfo>(orgIds.size());
        QFilter viewFilter = new QFilter("view", "=", this.getPkValue());
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter ctrlUnitFilter = new QFilter("isctrlunit", "=", (Object)isAddCtrlUnit);
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter, ctrlUnitFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgViewSchemaBaseFormPlugin.getCtrlUnitOperateErrorInfo", (String)"bos_org_structure", (String)"org,org.name name", (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                Long orgId = row.getLong("org");
                OperateErrorInfo errorInfo = new OperateErrorInfo(null, ErrorLevel.Error, (Object)orgId);
                if (isAddCtrlUnit) {
                    errorInfo.setMessage(OrgMessage.getMessage((String)"M00186", (Object[])new Object[]{row.getString("name")}));
                } else {
                    errorInfo.setMessage(OrgMessage.getMessage((String)"M00187", (Object[])new Object[]{row.getString("name")}));
                }
                errorInfoMap.put(orgId, errorInfo);
            }
        }
        return errorInfoMap;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.clearSearchText();
            switch (callBackId) {
                case "saveWhenNew": {
                    this.addNewViewSchema();
                    break;
                }
                case "saveWhenClickNode": {
                    this.deleteNewSchemaNode(true);
                    break;
                }
                case "deleteNewSchema": {
                    this.deleteNewSchemaNode(true);
                    break;
                }
                case "viewTabActive": {
                    this.deleteNewSchemaNode(false);
                    this.activeSchemaTab(VIEW_TAB);
                    break;
                }
                case "btn_setctrlunit": {
                    this.updateCtrlUnit(true);
                    break;
                }
                case "btn_delctrlunit": {
                    this.updateCtrlUnit(false);
                    break;
                }
                case "isshowdisablednode": {
                    this.getOrgTargetTreeView().initTree();
                    break;
                }
                case "clickSaveButton": {
                    this.getView().invokeOperation("save");
                    break;
                }
            }
        } else {
            switch (callBackId) {
                case "saveWhenClickNode": {
                    String lastClickNodeId = this.getPageCache().get(LASTTIME_CLICK_NODE);
                    if (!StringUtils.isNotBlank((CharSequence)lastClickNodeId)) break;
                    TreeView schemaTree = (TreeView)this.getControl(AP_SCHEMA_TREE);
                    TreeNode lastClickNode = new TreeNode("0", lastClickNodeId, "");
                    schemaTree.focusNode(lastClickNode);
                    break;
                }
                case "isshowdisablednode": {
                    this.setValueInInit("isshowdisablednode", (Boolean)this.getModel().getValue("isshowdisablednode") == false);
                    break;
                }
            }
        }
    }

    private void deleteNewSchemaNode(boolean fireTreeNodeClick) {
        String nodeId;
        String parentId;
        Map focusNode;
        IPageCache pageCache = this.getPageCache();
        String newSchemaId = pageCache.get(CACHE_NEW_SCHEMA_ID);
        TreeView schemaTree = (TreeView)this.getControl(AP_SCHEMA_TREE);
        TreeNode rootNodeFromCache = this.getRootNodeFromCache(CACHE_SCHEMA_TREE_ROOTNODE);
        if (StringUtils.isNotBlank((CharSequence)newSchemaId)) {
            rootNodeFromCache.deleteChildNode(newSchemaId);
            schemaTree.deleteNode(newSchemaId);
            pageCache.remove(CACHE_NEW_SCHEMA_ID);
        }
        if ((focusNode = schemaTree.getTreeState().getFocusNode()) == null) {
            TreeNode bizNode = null;
            DynamicObject bizObj = (DynamicObject)this.getModel().getValue(TREE_TYPE_ID);
            if (bizObj != null) {
                bizNode = OrgTreeUtils.getNode((TreeNode)rootNodeFromCache, (Object)this.getBizNodeId(bizObj));
            }
            if (bizNode == null) {
                List children = rootNodeFromCache.getChildren();
                if (CollectionUtils.isEmpty((Collection)children)) {
                    bizNode = rootNodeFromCache;
                } else {
                    bizNode = (TreeNode)children.get(children.size() - 1);
                    List viewChildren = bizNode.getChildren();
                    if (!CollectionUtils.isEmpty((Collection)viewChildren)) {
                        bizNode = (TreeNode)viewChildren.get(viewChildren.size() - 1);
                    }
                }
            }
            parentId = bizNode.getParentid();
            nodeId = bizNode.getId();
        } else {
            parentId = focusNode.get("parentid").toString();
            nodeId = focusNode.get("id").toString();
        }
        if (fireTreeNodeClick) {
            this.fireClickSchemaTree(schemaTree, parentId, nodeId);
        } else {
            schemaTree.focusNode(new TreeNode(parentId, nodeId, ""));
        }
    }

    private void fireClickSchemaTree(TreeView schemaTree, String parentId, String nodeId) {
        this.setViewSchemaChangedFlag(false);
        this.registerTreeListener(schemaTree);
        schemaTree.treeNodeClick(parentId, nodeId);
    }

    private void clearSearchText() {
        Search viewsearchap;
        Search orgsearchap = (Search)this.getView().getControl(ORG_SEARCHAP);
        if (orgsearchap != null) {
            orgsearchap.setSearchKey("");
        }
        if ((viewsearchap = (Search)this.getView().getControl("viewsearchap")) != null) {
            viewsearchap.setSearchKey("");
        }
        OrgTreeUtils.removeAllSearchTreeNodeCache((IPageCache)this.getPageCache());
    }

    public Object getPkValue() {
        return this.getModel().getValue("id");
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        boolean viewTabActive = this.isViewTabActive();
        if (this.isReloadAfterTreeNodeClick(evt, viewTabActive)) {
            this.schemaTreeNodeClick(evt.getParentNodeId().toString(), evt.getNodeId().toString(), false, viewTabActive);
        } else {
            TreeView schemaTree = (TreeView)this.getControl(AP_SCHEMA_TREE);
            Object[] treeTypeAndFocusNode = this.getTreeTypeAndFocusNode(schemaTree, evt.getParentNodeId().toString(), evt.getNodeId().toString());
            schemaTree.focusNode((TreeNode)treeTypeAndFocusNode[1]);
        }
    }

    private Object[] getTreeTypeAndFocusNode(TreeView schemaTree, String parentId, String nodeId) {
        TreeNode focusNode;
        String treetype;
        if (nodeId.indexOf("\\") == -1) {
            treetype = StringUtils.substringBefore((String)parentId, (String)"\\");
            focusNode = new TreeNode(parentId, nodeId, "");
        } else {
            treetype = StringUtils.substringBefore((String)nodeId, (String)"\\");
            schemaTree.expand(nodeId);
            focusNode = new TreeNode(nodeId, this.getDefaultViewId(null, treetype, false), "");
        }
        return new Object[]{treetype, focusNode};
    }

    private boolean isViewTabActive() {
        Tab tab = (Tab)this.getControl("tabap");
        return tab != null && VIEW_TAB.equals(tab.getCurrentTab());
    }

    private boolean isReloadAfterTreeNodeClick(TreeNodeEvent evt, boolean viewTabActive) {
        boolean isDataChanged;
        IPageCache pageCache = this.getPageCache();
        String nodeId = evt.getNodeId().toString();
        if (nodeId.equals(pageCache.get(LASTTIME_CLICK_NODE))) {
            return false;
        }
        if (viewTabActive) {
            return true;
        }
        boolean bl = isDataChanged = this.isViewSchemaChanged() || StringUtils.isNotBlank((CharSequence)pageCache.get(CACHE_NEW_SCHEMA_ID));
        if (isDataChanged) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(SAVE_WHEN_CLICK_NODE, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u4fdd\u5b58", (String)"OrgViewSchemaBaseFormPlugin_3", (String)"bos-org-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u5207\u6362", (String)"OrgViewSchemaBaseFormPlugin_22", (String)"bos-org-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u5207\u6362\u65b9\u6848\uff1f\r\n \u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"OrgViewSchemaBaseFormPlugin_23", (String)"bos-org-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
            return false;
        }
        return true;
    }

    private boolean isViewSchemaChanged() {
        return this.getModel().getDataChanged() || this.isCacheDataChanged();
    }

    private void setViewSchemaChangedFlag(boolean changed) {
        this.getModel().setDataChanged(changed);
        if (changed) {
            this.getPageCache().put(IS_DATA_CHANGED_FLAG, "1");
        } else {
            this.getPageCache().remove(IS_DATA_CHANGED_FLAG);
        }
    }

    private void schemaTreeNodeClick(String parentId, String nodeId, boolean createNewSchema, boolean viewTabActive) {
        this.clearSearchText();
        TreeView schemaTree = (TreeView)this.getControl(AP_SCHEMA_TREE);
        Object[] treeTypeAndFocusNode = this.getTreeTypeAndFocusNode(schemaTree, parentId, nodeId);
        String treetype = (String)treeTypeAndFocusNode[0];
        TreeNode focusNode = (TreeNode)treeTypeAndFocusNode[1];
        String schemeId = focusNode.getId();
        if (!createNewSchema) {
            this.load(schemeId);
        }
        this.setOriginalViewScheme(schemeId, treetype);
        if (viewTabActive) {
            this.viewDetail();
        } else {
            this.loadOrgTree(nodeId);
        }
        schemaTree.focusNode(focusNode);
    }

    private void loadOrgTree(String nodeId) {
        this.getView().setEnable(Boolean.TRUE, new String[]{"fieldsetpanelap"});
        Future originalFuture = threadPool.submit(() -> {
            OrgSourceTreeView srcTreeView = new OrgSourceTreeView(Long.parseLong(this.getLeftOriginalViewSchemaId()), (TreeView)this.getControl(AP_BIZ_UNIT_TREE), true);
            srcTreeView.initTree();
            return Boolean.TRUE;
        });
        Future targetFuture = threadPool.submit(() -> {
            OrgTargetTreeView targetTreeView = new OrgTargetTreeView(Long.parseLong(this.getPkValue().toString()), (TreeView)this.getControl(AP_BIZ_VIEW_TREE), true);
            targetTreeView.initTree();
            return Boolean.TRUE;
        });
        try {
            if (((Boolean)originalFuture.get()).booleanValue() && ((Boolean)targetFuture.get()).booleanValue()) {
                this.getPageCache().put(LASTTIME_CLICK_NODE, nodeId);
                this.getModel().setValue(IS_CHECK_UNIT_CHILD, (Object)Boolean.FALSE);
                this.getModel().setValue(IS_CHECK_VIEW_CHILD, (Object)Boolean.FALSE);
                this.choseChildNode(AP_BIZ_UNIT_TREE, Boolean.FALSE);
                this.choseChildNode(AP_BIZ_VIEW_TREE, Boolean.FALSE);
                this.getModel().setDataChanged(false);
            }
        }
        catch (InterruptedException e) {
            log.error("\u521d\u59cb\u5316\u7ec4\u7ec7\u6811\u5931\u8d25\u3002", (Throwable)e);
        }
        catch (ExecutionException e) {
            log.error("\u521d\u59cb\u5316\u7ec4\u7ec7\u6811\u5931\u8d25\u3002", (Throwable)e);
        }
    }

    protected OrgSourceTreeView getOrgSourceTreeView() {
        return new OrgSourceTreeView(Long.parseLong(this.getLeftOriginalViewSchemaId()), (TreeView)this.getControl(AP_BIZ_UNIT_TREE), false);
    }

    protected OrgTargetTreeView getOrgTargetTreeView() {
        return new OrgTargetTreeView(Long.parseLong(this.getPkValue().toString()), (TreeView)this.getControl(AP_BIZ_VIEW_TREE), false);
    }

    private void setOriginalViewScheme(String schemeId, String treetype) {
        this.getModel().setValue(ORIGINAL_VIEWSCHEMA, (Object)this.getDefaultViewId(schemeId, treetype, true));
    }

    private String getDefaultViewId(String viewId, String treetype, boolean isGetOriginalView) {
        if (isGetOriginalView && "16".equals(treetype)) {
            return this.getLeftTreeViewSchemaId();
        }
        QFilter defaultFilter = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        QFilter treeTypeFilter = new QFilter("treetype", "=", (Object)treetype);
        QFilter[] filters = new QFilter[]{defaultFilter, treeTypeFilter};
        DynamicObject viewObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_viewschema", (String)"id", (QFilter[])filters);
        if (viewObj == null) {
            return this.getLeftTreeViewSchemaId();
        }
        String defaultViewId = viewObj.getString("id");
        if (isGetOriginalView && defaultViewId.equals(viewId)) {
            return this.getLeftTreeViewSchemaId();
        }
        return defaultViewId;
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        TreeView treeView = (TreeView)evt.getSource();
        String treeKey = treeView.getKey();
        if (AP_BIZ_UNIT_TREE.equals(treeKey)) {
            this.orgUnitTreeNodeCheck(evt);
        } else {
            this.orgViewTreeNodeCheck(evt);
        }
    }

    public void orgUnitTreeNodeCheck(TreeNodeCheckEvent evt) {
        boolean isCheckChild = (Boolean)this.getModel().getValue(IS_CHECK_UNIT_CHILD);
        OrgSourceTreeView srcTreeView = this.getOrgSourceTreeView();
        if (evt.getChecked().booleanValue()) {
            srcTreeView.cacheSelectNodes(evt.getNodeId().toString(), isCheckChild);
        } else {
            srcTreeView.unSelectNode(evt.getNodeId().toString(), isCheckChild);
        }
    }

    public void orgViewTreeNodeCheck(TreeNodeCheckEvent evt) {
        OrgTargetTreeView targetTreeView = this.getOrgTargetTreeView();
        if (evt.getChecked().booleanValue()) {
            targetTreeView.cacheSelectNodes(evt.getNodeId().toString(), (boolean)((Boolean)this.getModel().getValue(IS_CHECK_VIEW_CHILD)));
        } else {
            targetTreeView.unSelectNode(evt.getNodeId().toString(), (Boolean)this.getModel().getValue(IS_CHECK_VIEW_CHILD));
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        TreeView treeView = (TreeView)evt.getSource();
        String treeKey = treeView.getKey();
        String nodeId = evt.getNodeId().toString();
        switch (treeKey) {
            case "bizunittree": {
                this.getOrgSourceTreeView().addChildren(nodeId, (Boolean)this.getModel().getValue(IS_CHECK_VIEW_CHILD));
                break;
            }
            case "bizviewtree": {
                this.getOrgTargetTreeView().addChildren(nodeId, (Boolean)this.getModel().getValue(IS_CHECK_VIEW_CHILD));
                break;
            }
        }
    }

    private void initSchemaTree() {
        String orderBy;
        QFilter[] filters;
        String selectFields;
        Map bizMap;
        TreeView schemaTree = (TreeView)this.getControl(AP_SCHEMA_TREE);
        TreeNode rootNode = new TreeNode("", "0", this.SCHEMA_ROOT_NAME);
        rootNode.setIsOpened(true);
        QFilter schemaFilter = this.getSchemaFixedFilter();
        QFilter treetypeFilter = this.getTreeTypeFilter();
        if (treetypeFilter != null) {
            schemaFilter = schemaFilter.and(treetypeFilter);
        }
        if ((bizMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_biz", (String)(selectFields = "id,fnumber,fname,basemaintain"), (QFilter[])(filters = new QFilter[]{schemaFilter}), (String)(orderBy = "basemaintain desc, fnumber"))) == null || bizMap.isEmpty()) {
            return;
        }
        String parentId = "0";
        int count = bizMap.size();
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(count);
        HashMap<String, TreeNode> bizNodeMap = new HashMap<String, TreeNode>(count);
        for (DynamicObject bizObj : bizMap.values()) {
            String treetype = bizObj.getString("fnumber");
            String nodeId = this.getBizNodeId(bizObj);
            TreeNode node = new TreeNode(parentId, nodeId, bizObj.getString("fname"));
            node.setIsOpened(bizObj.getBoolean("basemaintain"));
            node.setColor("#7f00ff");
            nodeList.add(node);
            bizNodeMap.put(treetype, node);
        }
        TreeNode firstViewNode = this.getFirstViewNodeForInitSchemaTree(bizNodeMap);
        rootNode.setChildren(nodeList);
        schemaTree.addNode(rootNode);
        this.getPageCache().put(CACHE_SCHEMA_TREE_ROOTNODE, SerializationUtils.toJsonString((Object)rootNode));
        if (firstViewNode != null) {
            this.fireClickSchemaTree(schemaTree, firstViewNode.getParentid(), firstViewNode.getId());
        }
    }

    private String getBizNodeId(DynamicObject bizObj) {
        return bizObj.getString("fnumber") + "\\" + bizObj.getString("id");
    }

    private TreeNode getFirstViewNodeForInitSchemaTree(Map<String, TreeNode> bizNodeMap) {
        Map viewSchemaMap;
        String selectFields = "id,number,name,treetype,treetypeid";
        QFilter viewSchemailter = this.getViewSchemaFilter();
        QFilter[] filters = null;
        if (viewSchemailter != null) {
            filters = new QFilter[]{viewSchemailter};
        }
        if ((viewSchemaMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_viewschema", (String)selectFields, filters, (String)"isdefault desc,number")) == null || viewSchemaMap.isEmpty()) {
            return null;
        }
        TreeNode firstViewNode = null;
        ArrayList<TreeNode> children = null;
        for (DynamicObject viewObj : viewSchemaMap.values()) {
            TreeNode bizNode = bizNodeMap.get(viewObj.getString("treetype"));
            if (bizNode == null) continue;
            children = bizNode.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>();
                bizNode.setChildren(children);
            }
            String viewParentId = bizNode.getId();
            String id = viewObj.getString("id");
            String name = viewObj.getString("name");
            TreeNode node = new TreeNode(viewParentId, id, name);
            node.setData((Object)viewObj.getDynamicObject(TREE_TYPE_ID));
            children.add(node);
            if (firstViewNode != null) continue;
            firstViewNode = node;
        }
        return firstViewNode;
    }

    private QFilter getSchemaFixedFilter() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter visiableFilter = new QFilter("visiable", "=", (Object)Boolean.TRUE);
        enableFilter = enableFilter.and(visiableFilter);
        QFilter adminFilter = new QFilter("id", "!=", (Object)1L);
        enableFilter = enableFilter.and(adminFilter);
        return enableFilter;
    }

    @Deprecated
    public void initViewTree(String treeKey, String parentId, String schemaId) {
        if (AP_BIZ_UNIT_TREE.equals(treeKey)) {
            OrgSourceTreeView treeView = new OrgSourceTreeView(Long.parseLong(schemaId), (TreeView)this.getControl(treeKey), true);
            treeView.initTree();
        } else {
            OrgTargetTreeView treeView = new OrgTargetTreeView(Long.parseLong(schemaId), (TreeView)this.getControl(treeKey), true);
            treeView.initTree();
        }
    }

    public List<TreeNode> queryViewTreeNodeChildren(String treeKey, String parentId, String schemaId) {
        return this.queryViewTreeNodeChildren(treeKey, parentId, schemaId, false);
    }

    public List<TreeNode> queryViewTreeNodeChildren(String treeKey, String parentId, String schemaId, boolean isCheckChildren) {
        List<TreeNode> children;
        if ("0".equals(schemaId) || schemaId.indexOf("\\") != -1) {
            return new ArrayList<TreeNode>(0);
        }
        if (AP_BIZ_UNIT_TREE.equals(treeKey)) {
            OrgSourceTreeView srcTreeView = this.getOrgSourceTreeView();
            children = srcTreeView.queryChildren(parentId);
        } else {
            OrgTargetTreeView targetTreeView = this.getOrgTargetTreeView();
            children = targetTreeView.queryChildren(parentId);
        }
        return children;
    }

    protected String formatOrgTreeNodeName(DynamicObject strucObj, String orgTreeNodeFormat) {
        boolean addCuLabel = false;
        if ("16".equals(strucObj.getString("treetype")) && strucObj.getBoolean("isctrlunit")) {
            addCuLabel = true;
        }
        return this.formatOrgTreeNodeName(strucObj.getString("number"), strucObj.getString("name"), orgTreeNodeFormat, addCuLabel);
    }

    protected String formatOrgTreeNodeName(String number, String name, String orgTreeNodeFormat, boolean addCuLabel) {
        name = OrgTreeUtils.formatOrgTreeNodeName((String)number, (String)name, (String)orgTreeNodeFormat);
        if (addCuLabel) {
            name = name + LABEL_CU;
        }
        return name;
    }

    public TreeNode getRootNodeFromCache(String rootNodeCacheKey) {
        String rootNodeCache = this.getPageCache().get(rootNodeCacheKey);
        TreeNode rootNode = null;
        if (StringUtils.isNotBlank((CharSequence)rootNodeCache)) {
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeCache, TreeNode.class);
        }
        return rootNode;
    }

    public void updateRootNodeCache(String rootNodeCacheKey, TreeNode rootNode) {
        if (rootNode == null) {
            this.getPageCache().remove(rootNodeCacheKey);
        } else {
            this.getPageCache().put(rootNodeCacheKey, SerializationUtils.toJsonString((Object)rootNode));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (!(source instanceof DefaultEntityOperate)) {
            return;
        }
        DefaultEntityOperate operate = (DefaultEntityOperate)source;
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey) && !this.beforeDoSaveOperation(operate.getOption())) {
            args.setCancel(true);
        }
    }

    private boolean beforeDoSaveOperation(OperateOption operateOption) {
        DynamicObject viewObj = this.getModel().getDataEntity();
        if (OrgViewUtils.isNumberUnSupport((IFormView)this.getView(), (String)viewObj.getString("number"), (!viewObj.getBoolean("isdefault") ? 1 : 0) != 0)) {
            return false;
        }
        HashMap<String, Cloneable> cacheMap = new HashMap<String, Cloneable>(4);
        OrgTargetTreeView orgTargetTreeView = this.getOrgTargetTreeView();
        List<TreeNode> allNodes = orgTargetTreeView.getAllNodes();
        boolean isDeleteAll = allNodes.isEmpty();
        LinkedHashMap<String, Map<String, Object>> allOrgsMap = orgTargetTreeView.getAllOrgs(isDeleteAll);
        int count = allOrgsMap.size();
        HashMap<String, String> resetRootNodes = new HashMap<String, String>(2);
        ArrayList<Map<String, Object>> addNodes = new ArrayList<Map<String, Object>>(count);
        ArrayList<Map<String, Object>> updateNodes = new ArrayList<Map<String, Object>>(count);
        ArrayList<Map<String, Object>> deleteNodes = new ArrayList<Map<String, Object>>(count);
        this.filterResetRootNode(orgTargetTreeView, resetRootNodes, isDeleteAll);
        this.filterUpdateNode(allOrgsMap, allNodes, addNodes, updateNodes);
        this.filterDeleteNode(allOrgsMap, deleteNodes, isDeleteAll);
        cacheMap.put(KEY_RESETROOT, resetRootNodes);
        cacheMap.put(KEY_DELETENODE, deleteNodes);
        cacheMap.put(KEY_UPDATENODE, updateNodes);
        cacheMap.put(KEY_ADDNODE, addNodes);
        operateOption.setVariableValue(KEY_ORG_OPTION_PARAMS, SerializationUtils.toJsonString(cacheMap));
        return true;
    }

    private void filterResetRootNode(OrgTargetTreeView orgTargetTreeView, Map<String, String> resetRootNodes, boolean isDeleteAll) {
        if (isDeleteAll) {
            return;
        }
        String initRootNodeId = orgTargetTreeView.getInitRootNodeId();
        if (initRootNodeId == null) {
            return;
        }
        String rootNodeId = orgTargetTreeView.getRootNode().getId();
        if (!Objects.equals(rootNodeId, initRootNodeId)) {
            resetRootNodes.put("addnew", rootNodeId);
            resetRootNodes.put("update", initRootNodeId);
        }
    }

    private void filterUpdateNode(LinkedHashMap<String, Map<String, Object>> allOrgsMap, List<TreeNode> allNodes, List<Map<String, Object>> addNodes, List<Map<String, Object>> updateNodes) {
        if (allNodes.isEmpty()) {
            return;
        }
        Iterator<TreeNode> nodeIterator = allNodes.iterator();
        while (nodeIterator.hasNext()) {
            Object orgParentId;
            TreeNode node = nodeIterator.next();
            nodeIterator.remove();
            Map dataMap = (Map)allOrgsMap.remove(node.getId());
            if (node.isDisabled()) continue;
            if (dataMap == null) {
                addNodes.add(this.genOperationNodeMap(node));
                continue;
            }
            String nodeParentId = node.getParentid();
            if (Objects.equals(nodeParentId, orgParentId = dataMap.get("parent")) || StringUtils.isBlank((CharSequence)nodeParentId) && "0".equals(orgParentId)) continue;
            updateNodes.add(this.genOperationNodeMap(node));
        }
    }

    private void filterDeleteNode(LinkedHashMap<String, Map<String, Object>> allOrgsMap, List<Map<String, Object>> deleteNodes, boolean isDeleteAll) {
        if (allOrgsMap.isEmpty()) {
            return;
        }
        ListIterator<Map.Entry<String, Map<String, Object>>> deleteNodesMap = new ArrayList<Map.Entry<String, Map<String, Object>>>(allOrgsMap.entrySet()).listIterator(allOrgsMap.size());
        while (deleteNodesMap.hasPrevious()) {
            Map.Entry<String, Map<String, Object>> nodeEntry = deleteNodesMap.previous();
            Map<String, Object> dataMap = nodeEntry.getValue();
            if (!isDeleteAll && (!((Boolean)dataMap.get("enable")).booleanValue() || ((Boolean)dataMap.get("isfreeze")).booleanValue())) continue;
            HashMap<String, Object> nodeInfo = new HashMap<String, Object>(2);
            nodeInfo.put("id", nodeEntry.getKey());
            nodeInfo.put("parentid", dataMap.get("parent"));
            deleteNodes.add(nodeInfo);
        }
    }

    private Map<String, Object> genOperationNodeMap(TreeNode node) {
        HashMap<String, Object> nodeInfo = new HashMap<String, Object>(2);
        nodeInfo.put("id", node.getId());
        nodeInfo.put("parentid", node.getParentid());
        return nodeInfo;
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey = evt.getOperateKey();
        if ("doview".equals(operateKey)) {
            this.activeSchemaTab(VIEW_TAB);
            return;
        }
        if ("doedit".equals(operateKey)) {
            this.activeSchemaTab(EDIT_TAB);
            return;
        }
        if ("new".equals(operateKey)) {
            return;
        }
        OperationResult opResult = evt.getOperationResult();
        if (opResult == null) {
            return;
        }
        TreeNode schemaRootNode = this.getRootNodeFromCache(CACHE_SCHEMA_TREE_ROOTNODE);
        if ("delete".equals(operateKey)) {
            this.afterDeleteOperation(opResult, schemaRootNode);
        } else if ("save".equals(operateKey)) {
            this.afterSaveOperation(opResult, schemaRootNode);
        }
        this.updateRootNodeCache(CACHE_SCHEMA_TREE_ROOTNODE, schemaRootNode);
        this.updateTargetTreeAfterSave(evt);
        this.setViewSchemaChangedFlag(false);
    }

    private void activeSchemaTab(String tabKey) {
        Tab tab = (Tab)this.getControl("tabap");
        if (tab == null) {
            return;
        }
        tab.activeTab(tabKey);
    }

    private void updateTargetTreeAfterSave(AfterDoOperationEventArgs evt) {
        if (!(evt.getSource() instanceof Save)) {
            return;
        }
        ArrayList successPkIds = new ArrayList(evt.getOperationResult().getSuccessPkIds());
        long viewId = Long.parseLong(this.getPkValue().toString());
        successPkIds.remove(viewId);
        if (successPkIds.isEmpty()) {
            return;
        }
        OrgTargetTreeView targetTreeView = new OrgTargetTreeView(viewId, (TreeView)this.getControl(AP_BIZ_VIEW_TREE), true);
        targetTreeView.initTree();
    }

    private void afterDeleteOperation(OperationResult opResult, TreeNode schemaRootNode) {
        List idList = opResult.getSuccessPkIds();
        if (Utils.isListEmpty((List)idList)) {
            return;
        }
        TreeView schemaTree = (TreeView)this.getControl(AP_SCHEMA_TREE);
        Map curFocusNode = schemaTree.getTreeState().getFocusNode();
        String parentId = "0";
        if (curFocusNode != null) {
            parentId = curFocusNode.get("parentid").toString();
        }
        ArrayList<String> nodes = new ArrayList<String>(idList.size());
        for (Object id : idList) {
            if (id == null && curFocusNode != null) {
                id = curFocusNode.get("id");
            }
            if (id == null) continue;
            String idStr = id.toString();
            nodes.add(idStr);
            schemaRootNode.deleteChildNode(idStr);
        }
        schemaTree.deleteNodes(nodes);
        this.getPageCache().remove(LASTTIME_CLICK_NODE);
        TreeNode parentNode = OrgTreeUtils.getNode((TreeNode)schemaRootNode, (Object)parentId);
        if (parentNode != null) {
            List children = parentNode.getChildren();
            if (Utils.isListEmpty((List)children)) {
                schemaTree.focusNode(parentNode);
                parentNode.setChildren(null);
                schemaTree.updateNode(parentNode);
            } else {
                TreeNode defaultViewNode = (TreeNode)children.get(children.size() - 1);
                schemaTree.focusNode(defaultViewNode);
            }
            this.getPageCache().put(AFTER_DELETE_CLICK_NODE, schemaTree.getTreeState().getFocusNodeId());
            this.afterDeleteViewSchema();
        }
    }

    private void afterSaveOperation(OperationResult opResult, TreeNode schemaRootNode) {
        List idList = opResult.getSuccessPkIds();
        if (Utils.isListEmpty((List)idList)) {
            return;
        }
        TreeView schemaTree = (TreeView)this.getControl(AP_SCHEMA_TREE);
        Map curFocusNode = schemaTree.getTreeState().getFocusNode();
        String parentId = "0";
        Object pk = idList.get(0);
        if (curFocusNode != null) {
            parentId = curFocusNode.get("parentid").toString();
            if (pk == null) {
                pk = curFocusNode.get("id");
            }
        }
        if (pk == null) {
            return;
        }
        this.getModel().setValue("id", pk);
        String schemaId = pk.toString();
        DynamicObject schemaObj = this.getModel().getDataEntity();
        TreeNode node = new TreeNode(parentId, schemaId, schemaObj.getString("name"));
        schemaTree.updateNode(node);
        schemaTree.focusNode(node);
        TreeNode parentNode = OrgTreeUtils.getNode((TreeNode)schemaRootNode, (Object)parentId);
        if (parentNode != null && OrgTreeUtils.getNode((TreeNode)schemaRootNode, (Object)node.getId()) == null) {
            parentNode.addChild(node);
        }
        this.getPageCache().put("ischanged", Boolean.TRUE.toString());
        this.getPageCache().remove(CACHE_NEW_SCHEMA_ID);
    }

    protected void afterDeleteViewSchema() {
    }

    public void updateRightTreeView() {
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String isChangedCache = this.getPageCache().get("ischanged");
        if (StringUtils.isBlank((CharSequence)isChangedCache)) {
            this.getView().returnDataToParent(null);
        } else {
            HashMap<String, Object> returnData = new HashMap<String, Object>(1);
            returnData.put("ischanged", Boolean.TRUE);
            returnData.put("view", this.getView().getEntityId());
            this.getView().returnDataToParent(returnData);
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        this.setButtonVisibleByTabKey(tabSelectEvent.getTabKey(), true);
        TreeView schemaTree = (TreeView)this.getControl(AP_SCHEMA_TREE);
        Map focusNode = schemaTree.getTreeState().getFocusNode();
        String parentId = "";
        String nodeId = "";
        if (focusNode == null) {
            TreeNode viewTreeNode = this.getFirstViewNode();
            if (viewTreeNode != null) {
                parentId = viewTreeNode.getParentid();
                nodeId = viewTreeNode.getId();
                schemaTree.focusNode(viewTreeNode);
            }
        } else {
            parentId = String.valueOf(focusNode.get("parentId"));
            nodeId = String.valueOf(focusNode.get("id"));
        }
        if (StringUtils.isNotBlank((CharSequence)nodeId)) {
            this.getPageCache().remove(LASTTIME_CLICK_NODE);
            boolean viewTabActive = VIEW_TAB.equals(tabSelectEvent.getTabKey());
            this.schemaTreeNodeClick(parentId, nodeId, false, viewTabActive);
        }
    }

    private TreeNode getFirstViewNode() {
        TreeNode schemaRootNode = this.getRootNodeFromCache(CACHE_SCHEMA_TREE_ROOTNODE);
        if (schemaRootNode == null) {
            return null;
        }
        List bizChildren = schemaRootNode.getChildren();
        if (CollectionUtils.isEmpty((Collection)bizChildren)) {
            return null;
        }
        TreeNode bizTreeNode = (TreeNode)bizChildren.get(0);
        List viewChildren = bizTreeNode.getChildren();
        if (CollectionUtils.isEmpty((Collection)viewChildren)) {
            return null;
        }
        return (TreeNode)viewChildren.get(0);
    }

    protected void setButtonVisibleByTabKey(String tabKey, boolean hasViewTab) {
        if (VIEW_TAB.equals(tabKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_VIEW});
            this.getView().setVisible(Boolean.FALSE, TOOLBAR_BUTTONS);
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_EDIT});
        } else {
            if (hasViewTab) {
                this.getView().setVisible(Boolean.TRUE, new String[]{BTN_VIEW});
            }
            this.getView().setVisible(Boolean.TRUE, TOOLBAR_BUTTONS);
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_EDIT});
        }
    }

    private void setValueInInit(String key, Object value) {
        this.getModel().beginInit();
        this.getModel().setValue(key, value);
        this.getModel().endInit();
        this.getView().updateView(key);
    }
}

