/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.biz.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgDutyView;
import kd.bos.org.model.OrgParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrgViewSchemaBaseServicePlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(OrgViewSchemaBaseServicePlugin.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        String pages = "bos_org_structure_history,bos_adminorg_structure,bos_maindataorg,bos_org_structure";
        this.getOption().setVariableValue("ignorerefentityids", pages);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if ("delete".equals(operationKey)) {
            this.doDeleteOperation(e);
        } else if ("save".equals(operationKey)) {
            this.doSaveOperation(e.getDataEntities());
        }
    }

    private void doDeleteOperation(BeginOperationTransactionArgs event) {
        DynamicObject[] schemaObjArr = event.getDataEntities();
        ArrayList<Long> viewIds = new ArrayList<Long>(schemaObjArr.length);
        HashMap<Long, String> viewIdNumberMap = new HashMap<Long, String>(schemaObjArr.length);
        for (DynamicObject schemaObj : schemaObjArr) {
            long viewId = schemaObj.getLong("id");
            viewIds.add(viewId);
            viewIdNumberMap.put(viewId, schemaObj.getString("number"));
        }
        try {
            this.deleteOrgDuty(viewIdNumberMap);
            this.deleteViewSchema(viewIds);
        }
        catch (KDBizException e) {
            event.setCancelOperation(true);
            this.getOperationResult().setSuccess(false);
            this.getOperationResult().getSuccessPkIds().clear();
            throw new KDBizException(e.getMessage());
        }
    }

    private void doSaveOperation(DynamicObject[] schemaObjArr) {
        HashMap<String, DynamicObject> bizMap = new HashMap<String, DynamicObject>(schemaObjArr.length);
        for (DynamicObject schemaObj : schemaObjArr) {
            if (schemaObj.get("treetypeid") == null) {
                String treetype = schemaObj.getString("treetype");
                DynamicObject bizObj = (DynamicObject)bizMap.get(treetype);
                if (bizObj == null) {
                    bizObj = this.getOrgBizByTreetype(treetype);
                    bizMap.put(treetype, bizObj);
                }
                schemaObj.set("treetypeid", (Object)bizObj);
            }
            this.saveViewSchema(schemaObj);
        }
    }

    protected void deleteViewSchema(List<Long> schemaIds) {
        if (schemaIds == null) {
            throw new KDBizException(BaseMessage.getMessage((String)"M00014"));
        }
    }

    protected void saveViewSchema(DynamicObject schemaObj) {
        if (schemaObj == null) {
            throw new KDBizException(BaseMessage.getMessage((String)"M00014"));
        }
    }

    private DynamicObject getOrgBizByTreetype(String treetype) {
        QFilter filter = new QFilter("fnumber", "=", (Object)treetype);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject bizObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_biz", (String)"id", (QFilter[])filters);
        return bizObject;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        this.removeNullSuccessPkIds();
        if ("save".equals(operationKey)) {
            DynamicObject[] schemaObjArr = e.getDataEntities();
            if (schemaObjArr == null || schemaObjArr.length == 0) {
                return;
            }
            for (DynamicObject schemaObj : schemaObjArr) {
                this.saveOrgStructure(schemaObj);
            }
        }
    }

    private void removeNullSuccessPkIds() {
        List successPkIds = this.getOperationResult().getSuccessPkIds();
        Iterator iterator = successPkIds.iterator();
        while (iterator.hasNext()) {
            Object pk = iterator.next();
            if (pk != null) continue;
            iterator.remove();
        }
    }

    private void deleteOrgDuty(Map<Long, String> viewIdNumberMap) {
        if (viewIdNumberMap.containsKey(15L)) {
            viewIdNumberMap.put(16L, "16");
        }
        QFilter viewFilter = new QFilter("view", "in", viewIdNumberMap.keySet());
        QFilter[] delFilters = new QFilter[]{viewFilter};
        ArrayList<OrgParam> paramList = new ArrayList<OrgParam>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgViewSchemaBaseServicePlugin.deleteOrgDuty", (String)"bos_org_structure", (String)"org,view", (QFilter[])delFilters, (String)"");){
            HashMap<Long, List> orgViewMap = new HashMap<Long, List>(64);
            for (Row row : dataSet) {
                orgViewMap.computeIfAbsent(row.getLong("org"), v -> new ArrayList(64)).add(row.getLong("view"));
            }
            for (Map.Entry orgViewEntry : orgViewMap.entrySet()) {
                OrgParam orgParam = new OrgParam();
                paramList.add(orgParam);
                orgParam.setId(((Long)orgViewEntry.getKey()).longValue());
                TreeMap<String, OrgDutyView> multiViewMap = new TreeMap<String, OrgDutyView>();
                orgParam.setMultiViewMap(multiViewMap);
                for (Long viewId : (List)orgViewEntry.getValue()) {
                    OrgDutyView orgDutyView = new OrgDutyView();
                    multiViewMap.put(viewIdNumberMap.get(viewId), orgDutyView);
                }
            }
            OrgUnitServiceHelper.deleteDuty(paramList);
            for (OrgParam orgParam : paramList) {
                if (orgParam.isSuccess()) continue;
                throw new KDBizException(orgParam.getMsg());
            }
        }
    }

    private void saveOrgStructure(DynamicObject schemaObj) {
        Map optionMap = this.getOption().getVariables();
        if (optionMap == null || optionMap.isEmpty()) {
            return;
        }
        String orgStructureCache = (String)optionMap.get("_org_option_params_");
        if (StringUtils.isBlank((CharSequence)orgStructureCache)) {
            return;
        }
        Map cacheMap = (Map)SerializationUtils.fromJsonString((String)orgStructureCache, Map.class);
        if (this.resetRoot(schemaObj, cacheMap)) {
            this.deleteOrgStructure(schemaObj, cacheMap);
            this.addOrUpdateOrgStructure(schemaObj, cacheMap);
        }
    }

    private boolean resetRoot(DynamicObject schemaObj, Map<String, Object> cacheMap) {
        Map resetRootNodes = (Map)cacheMap.get("_resetroot_");
        if (CollectionUtils.isEmpty((Map)resetRootNodes)) {
            return true;
        }
        logger.info("\u5f00\u59cb\u6267\u884c\u66ff\u6362\u6839\u7ec4\u7ec7\u64cd\u4f5c\uff1a" + resetRootNodes);
        String schemaNumber = schemaObj.getString("number");
        ArrayList<OrgParam> paramList = new ArrayList<OrgParam>(resetRootNodes.size());
        OrgParam newRootParam = new OrgParam();
        paramList.add(newRootParam);
        long newRootId = Long.parseLong((String)resetRootNodes.get("addnew"));
        newRootParam.setId(newRootId);
        newRootParam.setDuty(schemaNumber);
        OrgParam oldRootParam = new OrgParam();
        paramList.add(oldRootParam);
        long oldRootId = Long.parseLong((String)resetRootNodes.get("update"));
        oldRootParam.setId(oldRootId);
        oldRootParam.setParentId(newRootId);
        oldRootParam.setDuty(schemaNumber);
        OrgUnitServiceHelper.addOrUpdate(paramList);
        boolean success = this.updateOperationResult(paramList);
        logger.info("\u5b8c\u6210\u6267\u884c\u66ff\u6362\u6839\u7ec4\u7ec7\u64cd\u4f5c\u3002");
        return success;
    }

    private void deleteOrgStructure(DynamicObject schemaObj, Map<String, Object> cacheMap) {
        List nodeList = (List)cacheMap.get("_deleteNode_");
        if (CollectionUtils.isEmpty((Collection)nodeList)) {
            return;
        }
        logger.info("\u5f00\u59cb\u6267\u884c\u79fb\u9664\u7ec4\u7ec7\u804c\u80fd\u7c7b\u578b\u64cd\u4f5c\uff1a" + nodeList);
        String schemaNumber = schemaObj.getString("number");
        ArrayList<OrgParam> paramList = new ArrayList<OrgParam>(nodeList.size());
        for (Map nodeMap : nodeList) {
            Long orgId = Long.valueOf(String.valueOf(nodeMap.get("id")));
            OrgParam orgParam = new OrgParam();
            orgParam.setId(orgId.longValue());
            TreeMap<String, OrgDutyView> multiViewMap = new TreeMap<String, OrgDutyView>();
            OrgDutyView orgDutyView = new OrgDutyView();
            multiViewMap.put(schemaNumber, orgDutyView);
            if ("15".equals(schemaNumber)) {
                orgDutyView = new OrgDutyView();
                multiViewMap.put("16", orgDutyView);
            }
            orgParam.setMultiViewMap(multiViewMap);
            paramList.add(orgParam);
        }
        OrgUnitServiceHelper.deleteDuty(paramList);
        this.updateOperationResult(paramList);
        logger.info("\u5b8c\u6210\u6267\u884c\u79fb\u9664\u7ec4\u7ec7\u804c\u80fd\u7c7b\u578b\u64cd\u4f5c\u3002");
    }

    private void addOrUpdateOrgStructure(DynamicObject schemaObj, Map<String, Object> cacheMap) {
        ArrayList updateNodeList;
        ArrayList nodeList = (ArrayList)cacheMap.get("_addNode_");
        if (nodeList == null) {
            nodeList = new ArrayList(0);
        }
        if ((updateNodeList = (ArrayList)cacheMap.get("_updateNode_")) == null) {
            updateNodeList = new ArrayList(0);
        }
        nodeList.addAll(updateNodeList);
        if (CollectionUtils.isEmpty(nodeList)) {
            return;
        }
        logger.info("\u5f00\u59cb\u6267\u884c\u6dfb\u52a0\u7ec4\u7ec7\u6216\u8005\u4fee\u6539\u7ec4\u7ec7\u4e0a\u7ea7\u64cd\u4f5c\uff1a" + nodeList);
        String schemaNumber = schemaObj.getString("number");
        ArrayList<OrgParam> paramList = new ArrayList<OrgParam>(nodeList.size());
        for (Map nodeMap : nodeList) {
            long orgId = Long.parseLong(nodeMap.get("id").toString());
            OrgParam orgParam = new OrgParam();
            orgParam.setDuty(schemaNumber);
            orgParam.setId(orgId);
            orgParam.setAutoMoveSubOrg(false);
            Object parentIdObj = nodeMap.get("parentid");
            if (parentIdObj == null) continue;
            long parentId = 0L;
            if (StringUtils.isNotBlank(parentIdObj)) {
                parentId = Long.parseLong(parentIdObj.toString());
            }
            orgParam.setParentId(parentId);
            paramList.add(orgParam);
        }
        OrgUnitServiceHelper.addOrUpdate(paramList);
        this.updateOperationResult(paramList);
        logger.info("\u5b8c\u6210\u6267\u884c\u6dfb\u52a0\u7ec4\u7ec7\u6216\u8005\u4fee\u6539\u7ec4\u7ec7\u4e0a\u7ea7\u64cd\u4f5c\u3002");
    }

    private boolean updateOperationResult(List<OrgParam> paramList) {
        boolean success = true;
        OperationResult operationResult = this.getOperationResult();
        operationResult.setBillCount(operationResult.getBillCount() + paramList.size());
        for (OrgParam orgParam : paramList) {
            if (orgParam.isSuccess()) {
                operationResult.getSuccessPkIds().add(orgParam.getId());
                continue;
            }
            success = false;
            OperateErrorInfo errorInfo = new OperateErrorInfo(null, ErrorLevel.Error, (Object)orgParam.getId());
            errorInfo.setMessage(orgParam.getMsg());
            operationResult.addErrorInfo(errorInfo);
        }
        return success;
    }
}

