/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.biz.view;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class OrgViewSchemaRefrenceChecker {
    public static String isRefrenced(List<Long> pkList, Set<String> ignoreEntitySet, String entryEntityId) {
        Map checkResultMap;
        if (StringUtils.isBlank((CharSequence)entryEntityId)) {
            return "";
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entryEntityId);
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        if (ignoreEntitySet != null && !ignoreEntitySet.isEmpty()) {
            checker.getIgnoreRefEntityIds().addAll(ignoreEntitySet);
        }
        if ((checkResultMap = checker.checkRef((BasedataEntityType)entityType, (Object[])pkList.toArray(new Long[pkList.size()]))) == null || checkResultMap.isEmpty()) {
            return "";
        }
        for (Map.Entry entry : checkResultMap.entrySet()) {
            BaseDataCheckRefrenceResult refrenceResult = (BaseDataCheckRefrenceResult)entry.getValue();
            if (refrenceResult == null || !refrenceResult.isRefence() || !((BaseDataCheckRefrenceResult)entry.getValue()).isRefence()) continue;
            return OrgViewSchemaRefrenceChecker.getRefenceMessage(refrenceResult);
        }
        return "";
    }

    private static String getRefenceMessage(BaseDataCheckRefrenceResult refrenceResult) {
        MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refrenceResult.getRefenceKey().getRefEntityKey());
        String billName = refMainType.getDisplayName().toString();
        String fieldName = refrenceResult.getRefenceKey().getRefCol();
        for (IDataEntityProperty property : refMainType.getAllFields().values()) {
            if (property instanceof IFieldHandle && StringUtils.equalsIgnoreCase((CharSequence)property.getAlias(), (CharSequence)refrenceResult.getRefenceKey().getRefCol())) {
                fieldName = ((IFieldHandle)property).getDisplayName().toString();
                break;
            }
            if (!(property instanceof MulBasedataProp) || !StringUtils.equalsIgnoreCase((CharSequence)refrenceResult.getRefenceKey().getRefCol(), (CharSequence)"fbasedataid") || !StringUtils.equalsIgnoreCase((CharSequence)refrenceResult.getRefenceKey().getRefTable(), (CharSequence)property.getAlias())) continue;
            fieldName = property.getDisplayName().toString();
            break;
        }
        return BaseMessage.getMessage((String)"M00025", (Object[])new Object[]{billName, fieldName});
    }

    public static String isRefrenced(List<Long> pkList, Set<String> ignoreEntitySet) {
        return OrgViewSchemaRefrenceChecker.isRefrenced(pkList, ignoreEntitySet, "bos_org_viewschema");
    }

    public static String isRefrenced(List<Long> pkList, boolean ignoreStructure) {
        Set<String> ignoreEntitySet = OrgViewSchemaRefrenceChecker.getIgnoreRefEntity(ignoreStructure);
        return OrgViewSchemaRefrenceChecker.isRefrenced(pkList, ignoreEntitySet);
    }

    public static Set<String> getIgnoreRefEntity(boolean ignoreStructure) {
        HashSet<String> entitySet = new HashSet<String>(16);
        if (!ignoreStructure) {
            return entitySet;
        }
        entitySet.add("bos_org");
        entitySet.add("bos_org_history");
        entitySet.add("bos_adminorg");
        entitySet.add("bos_org_structure");
        QFilter numberFilter = new QFilter("number", "in", (Object)new String[]{"bos_org", "bos_org_structure"});
        QFilter[] filters = new QFilter[]{numberFilter};
        Map entityMap = BusinessDataServiceHelper.loadFromCache((String)"bos_entitymeta", (QFilter[])filters);
        if (entityMap == null || entityMap.isEmpty()) {
            return entitySet;
        }
        QFilter inheritpathFilter = null;
        for (Map.Entry entry : entityMap.entrySet()) {
            QFilter filter = new QFilter("inheritpath", "like", (Object)("%" + ((DynamicObject)entry.getValue()).getString("id") + "%"));
            if (inheritpathFilter == null) {
                inheritpathFilter = filter;
                continue;
            }
            inheritpathFilter = inheritpathFilter.or(filter);
        }
        filters = new QFilter[]{inheritpathFilter};
        entityMap = BusinessDataServiceHelper.loadFromCache((String)"bos_entitymeta", (QFilter[])filters);
        if (entityMap == null || entityMap.isEmpty()) {
            return entitySet;
        }
        for (Map.Entry entry : entityMap.entrySet()) {
            DynamicObject entityObj = (DynamicObject)entry.getValue();
            entitySet.add(entityObj.getString("number"));
        }
        return entitySet;
    }
}

