/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.change;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.org.model.BizViewQueryParam;
import kd.bos.org.utils.TaskStatus;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrgChangeConfigFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String BIZ_LIST_CACHE = "biz_list_cache";
    private static final String BIZ_BASEDATA = "bizbasedata";
    private static final String OLD_BIZ_BASEDATA_ID = "oldBizBaseDataId";

    public void initialize() {
        BasedataEdit bizBaseDataEdit = (BasedataEdit)this.getControl(BIZ_BASEDATA);
        bizBaseDataEdit.setMustInput(true);
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"entryentitytoolbarap"});
        this.addClickListeners(new String[]{"btnsave"});
        OrgEdit orgEdit = (OrgEdit)this.getControl("handoverorg");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        orgEdit = (OrgEdit)this.getControl("parent");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        orgEdit = (OrgEdit)this.getControl("oldParent");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("biz");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        basedataEdit = (BasedataEdit)this.getControl("view");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        basedataEdit = (BasedataEdit)this.getControl(BIZ_BASEDATA);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        if (this.getExistsIdByExecutionDate() > 0L) {
            this.getModel().setValue("executiondate", null);
        }
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        this.initBizBaseData();
        this.updateViewStatusControlMetadata();
        this.getModel().setDataChanged(false);
    }

    private void initBizBaseData() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (this.getModel().getValue(BIZ_BASEDATA) != null) {
            return;
        }
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        ArrayList<Object> bizPkList = new ArrayList<Object>(entryEntity.size());
        for (DynamicObject rowObj : entryEntity) {
            Object bizObjPkValue;
            DynamicObject bizObj = rowObj.getDynamicObject("biz");
            if (bizObj == null || bizPkList.contains(bizObjPkValue = bizObj.getPkValue())) continue;
            bizPkList.add(bizObjPkValue);
        }
        if (bizPkList.size() == 1) {
            Object bizObjPkValue = bizPkList.get(0);
            this.getPageCache().put(OLD_BIZ_BASEDATA_ID, bizObjPkValue.toString());
            this.getModel().setValue(BIZ_BASEDATA, bizObjPkValue);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        long existsId;
        String propName = e.getProperty().getName();
        boolean loadExistsChangeRecord = false;
        if (BIZ_BASEDATA.equals(propName)) {
            if (this.getPageCache().get(OLD_BIZ_BASEDATA_ID) != null) {
                this.getPageCache().remove(OLD_BIZ_BASEDATA_ID);
                return;
            }
            ChangeData changeData = e.getChangeSet()[0];
            if (this.changeBizAble(changeData)) {
                loadExistsChangeRecord = true;
            } else {
                DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
                this.getPageCache().put(OLD_BIZ_BASEDATA_ID, oldValue.getPkValue().toString());
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u804c\u80fd\u7c7b\u578b\u5c06\u5220\u9664\u5168\u90e8\u5df2\u9009\u7684\u7ec4\u7ec7\u3002\u786e\u8ba4\u5207\u6362\u5417\uff1f", (String)"OrgChangeConfigFormPlugin_0", (String)"bos-org-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("changeBizBaseData"));
            }
        } else if ("executiondate".equals(propName)) {
            loadExistsChangeRecord = true;
        }
        if (loadExistsChangeRecord && (existsId = this.getExistsIdByExecutionDate()) > 0L) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u5929\u5df2\u5b58\u5728\u76f8\u540c\u7c7b\u578b\u7684\u7ec4\u7ec7\u53d8\u66f4\u65b9\u6848\uff0c\u662f\u5426\u6253\u5f00\u7f16\u8f91\uff1f", (String)"OrgChangeConfigFormPlugin_1", (String)"bos-org-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener("loadExistsChangeRecord"), null, Long.toString(existsId));
        }
    }

    private boolean changeBizAble(ChangeData changeData) {
        if (this.getModel().getEntryEntity("entryentity").isEmpty()) {
            return true;
        }
        DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
        if (oldValue == null) {
            return true;
        }
        DynamicObject newValue = (DynamicObject)changeData.getNewValue();
        return newValue != null && Objects.equals(oldValue.getPkValue(), newValue.getPkValue());
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if ("loadExistsChangeRecord".equals(callBackId)) {
            if (MessageBoxResult.Yes == event.getResult()) {
                long existsId = Long.parseLong(event.getCustomVaule());
                ((IBillView)this.getView()).load((Object)existsId);
            } else {
                this.getModel().setValue("executiondate", null);
            }
        } else if ("changeBizBaseData".equals(callBackId)) {
            if (MessageBoxResult.Yes == event.getResult()) {
                this.getPageCache().remove(OLD_BIZ_BASEDATA_ID);
                this.getModel().deleteEntryData("entryentity");
            } else {
                this.getModel().setValue(BIZ_BASEDATA, (Object)this.getPageCache().get(OLD_BIZ_BASEDATA_ID));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (source instanceof Save) {
            DynamicObject bizObj = (DynamicObject)this.getModel().getValue(BIZ_BASEDATA);
            this.getModel().setValue("name", bizObj.get("fname"));
            ((Save)args.getSource()).getParameter().put("afterOperation", "close");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("addchange".equals(itemKey)) {
            this.showOrgF7();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        if ("orgF7CloseCallBack".equals(event.getActionId())) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)event.getReturnData();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                return;
            }
            DynamicObject bizObj = (DynamicObject)this.getModel().getValue(BIZ_BASEDATA);
            TableValueSetter tableValueSetter = new TableValueSetter(new String[]{"biz", "org"});
            for (ListSelectedRow row : selectedRows) {
                tableValueSetter.addRow(new Object[]{bizObj.getPkValue(), row.getPrimaryKeyValue()});
            }
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", tableValueSetter);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        Button button = (Button)evt.getSource();
        if ("save".equals(button.getOperationKey()) && this.cancelClickSaveButton()) {
            evt.setCancel(true);
            return;
        }
    }

    private boolean cancelClickSaveButton() {
        if (this.getModel().getEntryEntity("entryentity").isEmpty()) {
            String changeTypeName = this.getChangeTypeName();
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c%s\u7684\u7ec4\u7ec7\u3002", (String)"OrgChangeConfigFormPlugin_4", (String)"bos-org-formplugin", (Object[])new Object[0]), changeTypeName));
            return true;
        }
        return false;
    }

    private String getChangeTypeName() {
        ComboProp changeTypeProp = (ComboProp)this.getModel().getProperty("changetype");
        Object changeType = this.getModel().getValue("changetype");
        return changeTypeProp.getItemByName((String)changeType);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        IDataEntityProperty property = event.getProperty();
        String propertyName = property.getName();
        ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
        if (property instanceof OrgProp) {
            listShowParameter.setMultiSelect(false);
            if (this.setOrgF7BizParameter(listShowParameter)) {
                this.setOrgF7FilterParameter(listShowParameter);
            }
        } else if (BIZ_BASEDATA.equals(propertyName)) {
            listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", this.getBizList()));
        }
    }

    private void showOrgF7() {
        if (this.getModel().getValue("executiondate") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6267\u884c\u65e5\u671f\u201d\u3002", (String)"OrgChangeConfigFormPlugin_2", (String)"bos-org-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"bos_org", (boolean)true);
        if (this.setOrgF7BizParameter(listShowParameter)) {
            listShowParameter.setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
            listShowParameter.setCustomParam("showAdminOrgViewType", (Object)Boolean.FALSE);
            this.setOrgF7FilterParameter(listShowParameter);
            Object isOnlyShowDisabledOrg = this.getView().getFormShowParameter().getCustomParam("isOnlyShowDisabledOrg");
            if (isOnlyShowDisabledOrg != null) {
                listShowParameter.setCustomParam("isOnlyShowDisabledOrg", isOnlyShowDisabledOrg);
            } else {
                QFilter freezeFilter = new QFilter("structure.isfreeze", "=", (Object)false);
                listShowParameter.getListFilterParameter().getQFilters().add(freezeFilter);
            }
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "orgF7CloseCallBack"));
            listShowParameter.setF7ClickByFilter(true);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    private boolean setOrgF7BizParameter(ListShowParameter listShowParameter) {
        DynamicObject bizObj = (DynamicObject)this.getModel().getValue(BIZ_BASEDATA);
        if (bizObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u804c\u80fd\u7c7b\u578b\u201d\u3002", (String)"OrgChangeConfigFormPlugin_3", (String)"bos-org-formplugin", (Object[])new Object[0]));
            return false;
        }
        listShowParameter.setCustomParam("orgFuncId", (Object)bizObj.getString("fnumber"));
        return true;
    }

    private void setOrgF7FilterParameter(ListShowParameter listShowParameter) {
        HashSet<Long> selectedOrgIds = new HashSet<Long>();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject rowObj : entryEntity) {
            DynamicObject orgObj = rowObj.getDynamicObject("org");
            if (orgObj == null) continue;
            selectedOrgIds.add(orgObj.getLong("id"));
        }
        if (!selectedOrgIds.isEmpty()) {
            listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", selectedOrgIds));
        }
    }

    private Set<Object> getBizList() {
        String bizListCache = this.getPageCache().get(BIZ_LIST_CACHE);
        if (StringUtils.isNotBlank((CharSequence)bizListCache)) {
            return (Set)SerializationUtils.fromJsonString((String)bizListCache, Set.class);
        }
        BizViewQueryParam bizViewQueryParam = new BizViewQueryParam();
        bizViewQueryParam.setOnlyBaseMaintain(true);
        bizViewQueryParam.setOnlyBaseType(true);
        Map bizObjMap = OrgUnitServiceHelper.getBiz((BizViewQueryParam)bizViewQueryParam);
        Set<Object> ids = bizObjMap.keySet();
        ids.remove(1L);
        this.getPageCache().put(BIZ_LIST_CACHE, SerializationUtils.toJsonString(ids));
        return ids;
    }

    private long getExistsIdByExecutionDate() {
        DynamicObject bizObj = (DynamicObject)this.getModel().getValue(BIZ_BASEDATA);
        if (bizObj == null) {
            return -1L;
        }
        Date executionDate = (Date)this.getModel().getValue("executiondate");
        if (executionDate == null) {
            return -1L;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("executionstatus", "=", (Object)TaskStatus.A);
        QFilter dateFilter = new QFilter("executiondate", "=", (Object)executionDate);
        QFilter typeFilter = new QFilter("changetype", "=", dataEntity.get("changetype"));
        QFilter bizFilter = new QFilter("entryentity.biz", "=", bizObj.getPkValue());
        QFilter[] filters = new QFilter[]{enableFilter, statusFilter, dateFilter, typeFilter, bizFilter};
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_org_changerecord", (String)"id", (QFilter[])filters);
        if (dynamicObject == null) {
            return -1L;
        }
        return dynamicObject.getLong("id");
    }

    private boolean isViewStatus() {
        return OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus());
    }

    private void updateViewStatusControlMetadata() {
        if (!this.isViewStatus()) {
            return;
        }
        HashMap<String, Boolean> propMap = new HashMap<String, Boolean>(1);
        propMap.put("selchexkbox", false);
        this.getView().updateControlMetadata("entryentity", propMap);
    }
}

