/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.change;

import java.util.EventObject;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.org.utils.OrgChangeType;
import kd.bos.org.utils.TaskStatus;
import kd.bos.permission.model.AdminType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.yzj.config.YzjConfigServiceHelper;
import kd.bos.yzj.model.YzjConfig;

public class OrgChangeRecordListPlugin
extends AbstractListPlugin {
    private String changeType;
    private String executionStatus;
    private boolean showFormViewStatus;

    public void beforeBindData(EventObject e) {
        long currUserId = RequestContext.get().getCurrUserId();
        boolean visible = this.buttonVisible(currUserId);
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"resetroot"});
    }

    private boolean buttonVisible(long currUserId) {
        boolean cosmicUser = PermissionServiceHelper.isAdminUser((long)currUserId, (String)"10");
        if (!cosmicUser) {
            return false;
        }
        boolean adminUser = PermissionServiceHelper.isAdminUser((long)currUserId, (AdminType)AdminType.Administrator);
        if (!adminUser) {
            return false;
        }
        boolean hasPermission = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"base", (String)"bos_org", (String)"4715a0df000000ac");
        return hasPermission;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        OrgChangeType orgChangeType;
        if (this.changeType == null) {
            this.getChangeTypeObject(e.getParameter().getPkId());
        }
        if (this.changeType != null && (orgChangeType = OrgChangeType.valueOf((String)this.changeType.toUpperCase())) != null) {
            e.getParameter().setFormId(orgChangeType.getFormId());
            e.getParameter().setCustomParam("changetype", (Object)this.changeType);
        }
        if (this.showFormViewStatus) {
            e.getParameter().setStatus(OperationStatus.VIEW);
            e.getParameter().setBillStatus(BillOperationStatus.VIEW);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        YzjConfig parameterConfig;
        this.changeType = evt.getOperationKey();
        if (OrgChangeType.RESETROOT.getChangeType().equalsIgnoreCase(evt.getOperationKey()) && 1 != (parameterConfig = YzjConfigServiceHelper.getParameterConfig()).getSyncMode()) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u91cd\u7f6e\u6839\u7ec4\u7ec7\u3002\u539f\u56e0\uff1a\u542f\u52a8\u4e86\u4e91\u4e4b\u5bb6\u540c\u6b65\uff0c\u4e14\u4e91\u4e4b\u5bb6\u4e0d\u652f\u6301\u4fee\u6539\u6839\u7ec4\u7ec7\u3002", (String)"OrgChangeRecordListPlugin_0", (String)"bos-org-formplugin", (Object[])new Object[0]));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (!"number".equals(args.getFieldName())) {
            return;
        }
        ListSelectedRow currentSelectedRowInfo = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo();
        if (currentSelectedRowInfo == null) {
            return;
        }
        this.getChangeTypeObject(currentSelectedRowInfo.getPrimaryKeyValue());
        if (TaskStatus.B.name().equals(this.executionStatus)) {
            this.getView().showTipNotification(BaseMessage.getMessage((String)"M00076"));
            args.setCancel(true);
            return;
        }
    }

    private void getChangeTypeObject(Object pk) {
        if (pk == null) {
            return;
        }
        String selectFields = "changetype,executionstatus";
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)"bos_org_changerecord", (String)selectFields);
        if (dynamicObject == null) {
            return;
        }
        this.changeType = dynamicObject.getString("changetype");
        this.executionStatus = dynamicObject.getString("executionstatus");
        if (!TaskStatus.A.name().equals(dynamicObject.getString("executionstatus"))) {
            this.showFormViewStatus = true;
        }
    }
}

