/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.change;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.utils.BaseUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.org.change.OrgChangeRecordSaveValidator;
import kd.bos.org.task.change.OrgChangeTask;
import kd.bos.org.utils.OrgChangeType;
import kd.bos.org.utils.TaskStatus;
import kd.bos.org.utils.Utils;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPools;

public class OrgChangeRecordSavePlugin
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        this.initDefaultValue(e.getDataEntities());
        e.addValidator((AbstractValidator)new OrgChangeRecordSaveValidator());
    }

    private void initDefaultValue(DynamicObject[] dataEntities) {
        long currUserId = RequestContext.get().getCurrUserId();
        Date modifyTime = Calendar.getInstance().getTime();
        Date today = Utils.getDate((int)0);
        String todayString = Utils.formatDate((Date)today, (String)"yyyy-MM-dd");
        for (DynamicObject dataEntity : dataEntities) {
            String number = dataEntity.getString("number");
            if (StringUtils.isBlank((CharSequence)number)) {
                number = this.generateNumber(todayString, dataEntity.getString("changetype"));
                dataEntity.set("number", (Object)number);
            }
            this.initDefaultValue(dataEntity, currUserId, today, modifyTime);
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
            dataEntity.set("totalcount", (Object)entryEntity.size());
            HashMap<Long, DynamicObject> entryBizMap = new HashMap<Long, DynamicObject>(entryEntity.size());
            int seq = 1;
            for (DynamicObject entryObj : entryEntity) {
                entryObj.set("seq", (Object)seq++);
                this.getAllBizObj(entryObj, entryBizMap);
            }
            ILocaleString localeString = dataEntity.getLocaleString("name");
            if (!CollectionUtils.isEmpty((Map)localeString) && !StringUtils.isBlank((CharSequence)localeString.getLocaleValue()) || entryBizMap.size() != 1) continue;
            DynamicObject bizObj = (DynamicObject)entryBizMap.entrySet().iterator().next().getValue();
            dataEntity.set("name", bizObj.get("fname"));
        }
    }

    private void initDefaultValue(DynamicObject dataEntity, long currUserId, Date today, Date modifyTime) {
        if (StringUtils.isBlank((Object)dataEntity.get("executionstatus"))) {
            dataEntity.set("executionstatus", (Object)TaskStatus.A);
        }
        if (dataEntity.get("executiondate") == null) {
            dataEntity.set("executiondate", (Object)today);
        }
        if (StringUtils.isBlank((Object)dataEntity.get("status"))) {
            dataEntity.set("status", (Object)"C");
        }
        if (StringUtils.isBlank((Object)dataEntity.get("enable"))) {
            dataEntity.set("enable", (Object)"1");
        }
        if (dataEntity.get("creator") == null) {
            dataEntity.set("creator", (Object)currUserId);
        }
        if (dataEntity.get("createtime") == null) {
            dataEntity.set("createtime", (Object)modifyTime);
        }
        if (dataEntity.get("modifier") == null) {
            dataEntity.set("modifier", (Object)currUserId);
        }
        if (dataEntity.get("modifytime") == null) {
            dataEntity.set("modifytime", (Object)modifyTime);
        }
    }

    private void getAllBizObj(DynamicObject entryObj, Map<Long, DynamicObject> entryBizMap) {
        DynamicObject entryBizObj = entryObj.getDynamicObject("biz");
        if (entryBizObj != null) {
            entryBizMap.put(entryBizObj.getLong("id"), entryBizObj);
        }
    }

    private String generateNumber(String todayString, String changeType) {
        StringBuilder number = new StringBuilder();
        number.append(todayString);
        number.append("_");
        number.append(changeType);
        number.append("_");
        number.append(BaseUtils.generateShortUUID());
        return number.toString();
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        ThreadPools.executeOnceIncludeRequestContext((String)"OrgChangeRecordSavePlugin.executeOrgChangeTask", () -> this.executeOrgChangeTask(dataEntities));
    }

    private <T> T executeOrgChangeTask(DynamicObject[] dataEntities) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        for (DynamicObject obj : dataEntities) {
            String changeType = obj.getString("changetype");
            if (OrgChangeType.RESETROOT.getChangeType().equals(changeType)) {
                params.put("newrootorgnumber", obj.get("newrootorgnumber"));
                params.put("newrootorgname", obj.get("newrootorgname"));
            } else {
                params.clear();
            }
            OrgChangeTask orgChangeTask = new OrgChangeTask();
            orgChangeTask.execute(RequestContext.get(), params);
        }
        return null;
    }
}

