/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.change;

import java.util.Date;
import java.util.HashSet;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.org.utils.OrgChangeType;
import kd.bos.org.utils.TaskStatus;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.yzj.config.YzjConfigServiceHelper;
import kd.bos.yzj.model.YzjConfig;

public class OrgChangeRecordSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            this.validateUnique(dataEntity);
            this.validateFreeze(dataEntity);
            this.validateYzjEnable(dataEntity);
        }
    }

    private void validateYzjEnable(ExtendedDataEntity dataEntity) {
        if (!OrgChangeType.RESETROOT.getChangeType().equals(dataEntity.getDataEntity().get("changetype"))) {
            return;
        }
        YzjConfig parameterConfig = YzjConfigServiceHelper.getParameterConfig();
        if (1 != parameterConfig.getSyncMode()) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u91cd\u7f6e\u6839\u7ec4\u7ec7\u3002\u539f\u56e0\uff1a\u542f\u52a8\u4e86\u4e91\u4e4b\u5bb6\u540c\u6b65\uff0c\u4e14\u4e91\u4e4b\u5bb6\u4e0d\u652f\u6301\u4fee\u6539\u6839\u7ec4\u7ec7\u3002", (String)"OrgChangeRecordSaveValidator_2", (String)"bos-org-formplugin", (Object[])new Object[0]));
        }
    }

    private void validateUnique(ExtendedDataEntity dataEntity) {
        QFilter[] filters;
        DynamicObject obj = dataEntity.getDataEntity();
        String changeType = obj.getString("changetype");
        Date executionDate = obj.getDate("executiondate");
        if (changeType == null || executionDate == null) {
            return;
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("executionstatus", "=", (Object)TaskStatus.A);
        QFilter changeTypeFilter = new QFilter("changetype", "=", (Object)changeType);
        QFilter executionDateFilter = new QFilter("executiondate", "=", (Object)executionDate);
        QFilter bizFilter = this.getBizFilter(obj);
        if (bizFilter != null) {
            executionDateFilter = executionDateFilter.and(bizFilter);
        }
        if (obj.getDataEntityState().getFromDatabase()) {
            QFilter idFilter = new QFilter("id", "!=", obj.getPkValue());
            executionDateFilter = executionDateFilter.and(idFilter);
        }
        if (QueryServiceHelper.exists((String)"bos_org_changerecord", (QFilter[])(filters = new QFilter[]{enableFilter, statusFilter, changeTypeFilter, executionDateFilter}))) {
            String error = ResManager.loadKDString((String)"%s\u5df2\u5b58\u5728\u76f8\u540c\u7684\u53d8\u66f4\u65b9\u6848\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6dfb\u52a0\u3002", (String)"OrgChangeRecordSaveValidator_1", (String)"bos-org-formplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, String.format(error, KDDateFormatUtils.getDateFormat().format(executionDate)));
        }
    }

    private QFilter getBizFilter(DynamicObject obj) {
        String changeType = obj.getString("changetype");
        if (OrgChangeType.RESETROOT.getChangeType().equals(changeType)) {
            return null;
        }
        DynamicObjectCollection entryEntity = obj.getDynamicObjectCollection("entryentity");
        HashSet<Object> bizPks = new HashSet<Object>(entryEntity.size());
        for (DynamicObject rowObj : entryEntity) {
            DynamicObject bizObj = rowObj.getDynamicObject("biz");
            if (bizObj == null) continue;
            bizPks.add(bizObj.getPkValue());
        }
        if (bizPks.isEmpty() || bizPks.size() > 1) {
            return null;
        }
        return new QFilter("entryentity.biz", "in", bizPks);
    }

    private void validateFreeze(ExtendedDataEntity dataEntity) {
        DynamicObject obj = dataEntity.getDataEntity();
        String changeType = obj.getString("changetype");
        if (!OrgChangeType.BIZFREEZE.getChangeType().equals(changeType) && !OrgChangeType.BIZUNFREEZE.getChangeType().equals(changeType)) {
            return;
        }
        DynamicObjectCollection entryEntity = obj.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryObj : entryEntity) {
            DynamicObject orgObj = entryObj.getDynamicObject("org");
            DynamicObject bizObj = entryObj.getDynamicObject("biz");
            if (orgObj == null) {
                this.addErrorMessage(dataEntity, OrgMessage.getMessage((String)"M00199"));
                continue;
            }
            if (bizObj != null) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u672a\u9009\u62e9\u7ec4\u7ec7\u7684\u804c\u80fd\u7c7b\u578b\u3002", (String)"OrgChangeRecordSaveValidator_0", (String)"bos-org-formplugin", (Object[])new Object[0]), orgObj.getString("name")));
        }
    }
}

