/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.change;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.base.utils.BaseUtils;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.lang.Lang;
import kd.bos.org.model.OrgSeparation;
import kd.bos.org.utils.CommonUtils;
import kd.bos.org.utils.OrgChangeType;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.org.utils.TaskStatus;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.CollectionUtils;

public class OrgResetRootFormPlugin
extends AbstractBillPlugIn
implements ProgresssListener,
TabSelectListener,
ItemClickListener {
    private static final String CACHEKEY_STARTPROGRESS = "startprogress";
    private static final String FIELD_ISSYN = "issyn";
    private static final String FIELD_SYNVIEW = "synview";
    private static final String FIELD_BIZ = "biz";
    private static final String FIELD_NEWROOTORGNUMBER = "newrootorgnumber";
    private static final String FIELD_NEWROOTORGNAME = "newrootorgname";
    private static final String TAB_KEY = "guidecontent";
    private static final String TAB_PAGE_TIPS = "tabpageap";
    private static final String TAB_PAGE_NEWROOT = "tabpageap1";
    private static final String TAB_PAGE_SYN = "savestep";
    private static final String TAB_PAGE_CHECK = "tabpageap3";
    private static final String BUTTON_NEXT = "btnnext";
    private static final String BUTTON_PREV = "btnprev";
    private static final String BUTTON_CLOSE = "btnclose";
    private static final String BUTTON_EXPORTLIST_EXPT = "exportlist_expt";
    private static final String BUTTON_BACKCHECK = "backcheck";
    private static final String FLEX_CHECKPROGRESS = "flexcheckprogress";
    private static final String FLEX_CHECKRESULT = "flexcheckresult";
    private static final String ENTRY_VIEW = "viewentry";
    private static final String LABEL_SHOWTIPS = "showtips";
    private static final String LABEL_CLOSETIPS = "closetips";
    private static final String HTML_TIPS = "htmltips";
    private static final String CONTROL_PROGRESSBARAP = "progressbarap";
    private static final String ENTRY_CHECKRPT = "checkrptentry";
    private static final String FIELD_EVENT = "event";
    private static final String FIELD_CHECKSTATUS = "checkstatus";
    private static final String CACHEKEY_ISFINISHED = "isfinished";
    private static List<Object> viewIds = new ArrayList<Object>();
    private Set<Object> baseViewIds = new HashSet<Object>(16);
    private Map<Object, DynamicObject> viewIdRootOrgObjMap = new HashMap<Object, DynamicObject>(16);

    private Set<Object> getBaseViewIds() {
        if (this.baseViewIds.size() <= 0) {
            this.baseViewIds = CommonUtils.queryBaseViewIds();
        }
        return this.baseViewIds;
    }

    private Map<Object, DynamicObject> getViewIdRootOrgObjMap() {
        if (this.viewIdRootOrgObjMap.size() <= 0) {
            this.viewIdRootOrgObjMap = CommonUtils.loadViewIdRootOrgObjMap(this.getBaseViewIds());
        }
        return this.viewIdRootOrgObjMap;
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BUTTON_NEXT, BUTTON_PREV, LABEL_SHOWTIPS, LABEL_CLOSETIPS, BUTTON_EXPORTLIST_EXPT});
        ProgressBar progressbar = (ProgressBar)this.getControl(CONTROL_PROGRESSBARAP);
        progressbar.addProgressListener((ProgresssListener)this);
        Tab tab = (Tab)this.getView().getControl(TAB_KEY);
        tab.addTabSelectListener((TabSelectListener)this);
        tab.addItemClickListener((ItemClickListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        BaseShowParameter bsp;
        Object pkId;
        DynamicObject object;
        super.preOpenForm(e);
        FormShowParameter fsp = e.getFormShowParameter();
        if (fsp instanceof BaseShowParameter && (object = QueryServiceHelper.queryOne((String)"bos_org_changerecord", (String)"executionstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId = (bsp = (BaseShowParameter)fsp).getPkId())})) != null && TaskStatus.B.name().equals(object.getString("executionstatus"))) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"OrgResetRootFormPlugin_9", (String)"bos-org-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initViewEntryValue();
        this.initEventsValue();
        this.initOldOrgValue(false);
    }

    private void initOldOrgValue(boolean hasResetRoot) {
        DynamicObject oldOrgObj = this.getOldOrgObj(hasResetRoot);
        if (oldOrgObj == null) {
            return;
        }
        this.getModel().setValue("oldorgnumber", oldOrgObj.get("number"));
        this.getModel().setValue("oldorgname", oldOrgObj.get("name"));
    }

    private DynamicObject getOldOrgObj(boolean hasResetRoot) {
        DynamicObject res = null;
        if (hasResetRoot) {
            DynamicObjectCollection changeDoc = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
            for (DynamicObject changeObj : changeDoc) {
                if (ObjectUtils.isEmpty((Object)changeObj.getDynamicObject("org")) || ObjectUtils.isEmpty((Object)changeObj.getDynamicObject("view"))) continue;
                res = changeObj.getDynamicObject("org");
                break;
            }
        } else {
            Map<Object, DynamicObject> viewIdRootOrgObjMap = this.getViewIdRootOrgObjMap();
            res = viewIdRootOrgObjMap.get(15L);
        }
        return res;
    }

    public void afterLoadData(EventObject e) {
        Object status = this.getView().getFormShowParameter().getCustomParam("status");
        if (!ObjectUtils.isEmpty((Object)status) && "view".equals(status.toString())) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
        }
        this.setViewEntryValue();
        this.setNewRootOrgValue();
        this.initOldOrgValue(true);
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
    }

    private void setNewRootOrgValue() {
        DynamicObjectCollection changeDoc = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        Optional<DynamicObject> newRootRow = changeDoc.stream().filter(obj -> ObjectUtils.isEmpty((Object)obj.getDynamicObject("view"))).findFirst();
        if (newRootRow.isPresent()) {
            if (newRootRow.get().getDynamicObject("org") == null) {
                return;
            }
            this.getModel().setValue(FIELD_NEWROOTORGNUMBER, newRootRow.get().getDynamicObject("org").get("number"));
            this.getModel().setValue(FIELD_NEWROOTORGNAME, newRootRow.get().getDynamicObject("org").get("name"));
        } else {
            String message = ResManager.loadKDString((String)"\u91cd\u7f6e\u6839\u7ec4\u7ec7\u5931\u8d25\uff0c\u672a\u751f\u6210\u65b0\u6839\u7ec4\u7ec7\u3002", (String)"OrgResetRootFormPlugin_0", (String)"bos-org-formplugin", (Object[])new Object[0]);
            this.getModel().setValue(FIELD_NEWROOTORGNUMBER, (Object)message);
            this.getModel().setValue(FIELD_NEWROOTORGNAME, (Object)message);
        }
    }

    public void afterBindData(EventObject e) {
        this.setCheckResultVisible(OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus()));
        this.setViewEntryEnable(viewIds);
        this.setTipsVisible(Boolean.TRUE);
        this.getView().setVisible(this.isShowButtonExportClose(), new String[]{BUTTON_EXPORTLIST_EXPT, BUTTON_CLOSE});
        this.setMustInput(Boolean.TRUE, FIELD_NEWROOTORGNUMBER, FIELD_NEWROOTORGNAME);
    }

    private void setMustInput(Boolean value, String ... fields) {
        for (String field : fields) {
            Control control = this.getControl(field);
            if (!(control instanceof FieldEdit)) continue;
            ((FieldEdit)control).setMustInput(value.booleanValue());
        }
    }

    private void setViewEntryValue() {
        DynamicObject changeRecordObj = this.getModel().getDataEntity();
        DynamicObjectCollection changeEntryDoc = changeRecordObj.getDynamicObjectCollection("entryentity");
        HashMap<Object, String> viewIdSynMap = new HashMap<Object, String>(changeEntryDoc.size());
        for (DynamicObject changeEntryObj : changeEntryDoc) {
            if (ObjectUtils.isEmpty((Object)changeEntryObj.get("view"))) continue;
            viewIdSynMap.put(changeEntryObj.getDynamicObject("view").getPkValue(), ObjectUtils.isEmpty((Object)changeEntryObj.get(FIELD_BIZ)) ? "0" : "1");
        }
        this.batchCreateViewEntry(viewIdSynMap);
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnnext": {
                this.switchCurrentTab(evt);
                break;
            }
            case "btnprev": {
                break;
            }
            case "showtips": {
                break;
            }
            case "closetips": {
                break;
            }
            case "exportlist_expt": {
                this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
            }
        }
    }

    private void switchCurrentTab(BeforeClickEvent evt) {
        String currentTab;
        if (this.isExecuted(this.getModel().getDataEntity()).booleanValue()) {
            return;
        }
        Tab tab = (Tab)this.getView().getControl(TAB_KEY);
        switch (currentTab = tab.getCurrentTab()) {
            case "tabpageap": {
                break;
            }
            case "tabpageap1": {
                String checkRes = this.checkNewRootNumberName(this.getModel().getDataEntity());
                if (StringUtils.isEmpty((CharSequence)checkRes)) break;
                evt.setCancel(Boolean.TRUE.booleanValue());
                this.getView().showTipNotification(checkRes);
                return;
            }
            case "savestep": {
                String checkRes = this.checkNewRootNumberName(this.getModel().getDataEntity());
                if (StringUtils.isEmpty((CharSequence)checkRes)) break;
                evt.setCancel(Boolean.TRUE.booleanValue());
                this.getView().showTipNotification(checkRes);
                return;
            }
            case "tabpageap3": {
                break;
            }
        }
    }

    private String checkNewRootEmpty(DynamicObject obj) {
        if (ObjectUtils.isEmpty((Object)obj.get(FIELD_NEWROOTORGNUMBER)) || ObjectUtils.isEmpty((Object)obj.getLocaleString(FIELD_NEWROOTORGNAME).getLocaleValue())) {
            return ResManager.loadKDString((String)"\u7f16\u7801\u6216\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u3002", (String)"OrgResetRootFormPlugin_3", (String)"bos-org-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private String checkNewRootNumberName(DynamicObject obj) {
        String checkRes = this.checkNewRootEmpty(obj);
        if (StringUtils.isNotBlank((CharSequence)checkRes)) {
            return checkRes;
        }
        boolean exists = QueryServiceHelper.exists((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("number", "=", obj.get(FIELD_NEWROOTORGNUMBER))});
        if (exists) {
            return ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"OrgResetRootFormPlugin_4", (String)"bos-org-formplugin", (Object[])new Object[0]);
        }
        OrgSeparation orgSeparation = OrgUnitServiceHelper.getOrgSeparation();
        String longNumberSep = orgSeparation.getLongNumberSep();
        String fullNameSep = orgSeparation.getFullNameSep();
        String newRootOrgNumber = obj.getString(FIELD_NEWROOTORGNUMBER);
        checkRes = OrgViewUtils.isOrgNumberValid((String)newRootOrgNumber, (String)longNumberSep);
        if (StringUtils.isNotBlank((CharSequence)checkRes)) {
            return checkRes;
        }
        Map enableLangMap = BaseUtils.getEnableLangMap();
        Lang currentLang = RequestContext.get().getLang();
        ILocaleString nameLocaleString = obj.getLocaleString(FIELD_NEWROOTORGNAME);
        checkRes = OrgViewUtils.isOrgNameValid((ILocaleString)nameLocaleString, (String)fullNameSep, (Map)enableLangMap, (Lang)currentLang);
        return checkRes;
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnnext": {
                break;
            }
            case "btnprev": {
                this.setVisibleMutual(BUTTON_NEXT, BUTTON_CLOSE, BUTTON_EXPORTLIST_EXPT);
                break;
            }
            case "showtips": {
                this.setTipsVisible(Boolean.TRUE);
                break;
            }
            case "closetips": {
                this.setTipsVisible(Boolean.FALSE);
                break;
            }
            case "backcheck": {
                break;
            }
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey;
        switch (tabKey = tabSelectEvent.getTabKey()) {
            case "tabpageap": {
                break;
            }
            case "tabpageap1": {
                break;
            }
            case "savestep": {
                break;
            }
            case "tabpageap3": {
                this.showCheckTab();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate source = (AbstractOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("save".equals(operateKey)) {
            Set<Object> baseViewIds = CommonUtils.queryBaseViewIds();
            Map<Object, DynamicObject> viewIdRootOrgObjMap = CommonUtils.loadViewIdRootOrgObjMap(baseViewIds);
            DynamicObjectCollection synViewDoc = this.getModel().getDataEntity().getDynamicObjectCollection(ENTRY_VIEW);
            DynamicObjectCollection changeDetailDoc = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
            DynamicObjectType changeDetailType = changeDetailDoc.getDynamicObjectType();
            for (DynamicObject synViewObj : synViewDoc) {
                DynamicObject newChangeDetailObj = new DynamicObject(changeDetailType);
                DynamicObject viewObj = synViewObj.getDynamicObject(FIELD_SYNVIEW);
                newChangeDetailObj.set("view", (Object)viewObj);
                newChangeDetailObj.set("org", (Object)viewIdRootOrgObjMap.get(viewObj.getPkValue()));
                if (synViewObj.getBoolean(FIELD_ISSYN) && viewIdRootOrgObjMap.get(synViewObj.getDynamicObject(FIELD_SYNVIEW).getPkValue()) != null) {
                    newChangeDetailObj.set(FIELD_BIZ, (Object)viewObj.getDynamicObject("treetypeid"));
                }
                changeDetailDoc.add((Object)newChangeDetailObj);
            }
            Map<Object, DynamicObject> eventsMap = CommonUtils.loadSubscriptionEvents("bos_org", OrgChangeType.RESETROOT.getChangeType());
            if (eventsMap.size() <= 0) {
                return;
            }
            DynamicObjectCollection checkDoc = this.getModel().getDataEntity().getDynamicObjectCollection(ENTRY_CHECKRPT);
            DynamicObjectType checkType = checkDoc.getDynamicObjectType();
            for (Map.Entry<Object, DynamicObject> next : eventsMap.entrySet()) {
                DynamicObject checkObj = new DynamicObject(checkType);
                checkObj.set(FIELD_EVENT, (Object)next.getValue());
                checkDoc.add((Object)checkObj);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey)) {
            // empty if block
        }
    }

    public void onProgress(ProgressEvent event) {
        String startProgress = this.getPageCache().get(CACHEKEY_STARTPROGRESS);
        if (StringUtils.isBlank((CharSequence)startProgress)) {
            event.setProgress(0);
            event.setText(ResManager.loadKDString((String)"\u5373\u5c06\u5f00\u59cb\u8fdb\u884c\u6570\u636e\u68c0\u67e5\u3002", (String)"OrgResetRootFormPlugin_6", (String)"bos-org-formplugin", (Object[])new Object[0]));
            return;
        }
        String text = ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u6570\u636e\u68c0\u67e5\u3002", (String)"OrgResetRootFormPlugin_7", (String)"bos-org-formplugin", (Object[])new Object[0]);
        int progress = this.calProgress();
        int n = progress = progress <= 0 ? 1 : progress;
        if (progress >= 100) {
            boolean finished = this.isFinished();
            this.setFinished(true);
            if (!finished) {
                event.setProgress(99);
                event.setText(text);
                return;
            }
        }
        if (progress >= 100) {
            progress = 100;
            text = ResManager.loadKDString((String)"\u5b8c\u6210\u3002", (String)"OrgResetRootFormPlugin_8", (String)"bos-org-formplugin", (Object[])new Object[0]);
        }
        event.setProgress(progress);
        event.setText(text);
        if (progress >= 100) {
            this.setCheckResultVisible(true);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BUTTON_EXPORTLIST_EXPT});
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
        }
    }

    private int calProgress() {
        int oldProgress = this.getPageCache().get("progress") != null ? Integer.parseInt(this.getPageCache().get("progress")) : 0;
        DynamicObject changeRecordObj = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getDataEntity().getPkValue(), (String)"bos_org_changerecord", (String)"checkrptentry,checkstatus");
        if (changeRecordObj == null) {
            return 100;
        }
        DynamicObjectCollection checkRptEntry = changeRecordObj.getDynamicObjectCollection(ENTRY_CHECKRPT);
        if (CollectionUtils.isEmpty((Collection)checkRptEntry)) {
            return 100;
        }
        int count = 0;
        for (DynamicObject entry : checkRptEntry) {
            if (StringUtils.isBlank((CharSequence)entry.getString(FIELD_CHECKSTATUS))) continue;
            ++count;
        }
        Label currRow = (Label)this.getControl("currentrow");
        Label totalRow = (Label)this.getControl("totalrow");
        currRow.setText(count + "");
        totalRow.setText(checkRptEntry.size() + "");
        if (count == checkRptEntry.size()) {
            return 100;
        }
        int realProgress = new BigDecimal(count).divide(new BigDecimal(checkRptEntry.size()), 3, 3).multiply(new BigDecimal(100)).intValue();
        int maxProgress = new BigDecimal(count + 1).divide(new BigDecimal(checkRptEntry.size()), 3, 3).multiply(new BigDecimal(100)).intValue() - 1;
        int progress = realProgress <= oldProgress ? (oldProgress + 1 < maxProgress ? oldProgress + 1 : maxProgress) : realProgress;
        this.getPageCache().put("progress", String.valueOf(progress));
        return progress;
    }

    private void setCheckResultVisible(Boolean isShow) {
        this.getView().setVisible(isShow, new String[]{FLEX_CHECKRESULT});
        this.getView().setVisible(Boolean.valueOf(isShow == false), new String[]{FLEX_CHECKPROGRESS});
    }

    private void showCheckTab() {
        boolean executed = this.isExecuted(this.getModel().getDataEntity());
        boolean needExecute = this.needExecute();
        this.getView().setEnable(Boolean.valueOf(OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())), new String[]{BUTTON_PREV});
        this.setVisibleMutualRe(BUTTON_NEXT, BUTTON_CLOSE);
        if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BUTTON_EXPORTLIST_EXPT});
        }
        if (!executed && needExecute) {
            this.startProgress();
        }
        if (!executed && !needExecute) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u68c0\u67e5\u9879\u3002", (String)"OrgResetRootFormPlugin_5", (String)"bos-org-formplugin", (Object[])new Object[0]));
            this.setCheckResultVisible(Boolean.TRUE);
        }
    }

    private void setVisibleMutual(String visibleKey, String ... notVisibleKey) {
        this.getView().setVisible(Boolean.TRUE, new String[]{visibleKey});
        this.getView().setVisible(Boolean.FALSE, notVisibleKey);
    }

    private void setVisibleMutualRe(String notVisibleKey, String ... visibleKey) {
        this.getView().setVisible(Boolean.FALSE, new String[]{notVisibleKey});
        this.getView().setVisible(Boolean.TRUE, visibleKey);
    }

    private boolean needExecute() {
        return !ObjectUtils.isEmpty((Object)this.getModel().getValue("events"));
    }

    private Boolean isExecuted(DynamicObject object) {
        if (object.getDataEntityState().getFromDatabase()) {
            if ("A".equals(object.getString("executionstatus"))) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (object.getLong("id") == 0L) {
            return Boolean.FALSE;
        }
        DynamicObject changeRecordObjFromDB = QueryServiceHelper.queryOne((String)object.getDynamicObjectType().getName(), (String)"executionstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", object.getPkValue())});
        if ("A".equals(changeRecordObjFromDB.getString("executionstatus"))) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void initEventsValue() {
        Map<Object, DynamicObject> events = CommonUtils.loadSubscriptionEvents("bos_org", "resetroot");
        if (events == null || events.size() == 0) {
            return;
        }
        String separator = System.getProperty("line.separator");
        StringJoiner sj = new StringJoiner(separator);
        for (Map.Entry<Object, DynamicObject> next : events.entrySet()) {
            DynamicObject subscriptionObj = next.getValue();
            if (subscriptionObj == null || subscriptionObj.getLocaleString("name") == null) continue;
            sj.add(subscriptionObj.getLocaleString("name").getLocaleValue());
        }
        this.getModel().setValue("events", (Object)sj.toString());
    }

    private void startProgress() {
        ProgressBar progress = (ProgressBar)this.getControl(CONTROL_PROGRESSBARAP);
        progress.start();
        this.getPageCache().put(CACHEKEY_STARTPROGRESS, "true");
    }

    private void setViewEntryEnable(List<Object> ids) {
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRY_VIEW);
        List fieldEdits = cardEntry.getFieldEdits();
        DynamicObjectCollection viewDoc = this.getModel().getDataEntity().getDynamicObjectCollection(ENTRY_VIEW);
        for (int i = 0; i < viewDoc.size(); ++i) {
            DynamicObject viewEntry = (DynamicObject)viewDoc.get(i);
            DynamicObject viewObj = viewEntry.getDynamicObject(FIELD_SYNVIEW);
            if (!ids.contains(viewObj.getPkValue())) continue;
            for (FieldEdit fieldEdit : fieldEdits) {
                if (!FIELD_ISSYN.equalsIgnoreCase(fieldEdit.getFieldKey())) continue;
                fieldEdit.setEnable("", Boolean.FALSE.booleanValue(), i);
            }
        }
    }

    public void setTipsVisible(Boolean isShow) {
        this.getView().setVisible(isShow, new String[]{HTML_TIPS, LABEL_CLOSETIPS});
        this.getView().setVisible(Boolean.valueOf(isShow == false), new String[]{LABEL_SHOWTIPS});
    }

    private void initViewEntryValue() {
        Set<Object> showViewIds = CommonUtils.queryBaseViewIds();
        Map<Object, DynamicObject> viewIdRootOrgObjMap = CommonUtils.loadViewIdRootOrgObjMap(showViewIds);
        DynamicObject orgUnitRootObj = viewIdRootOrgObjMap.get(15L);
        Set<Object> rootOrgViewIds = this.getOrgViewIds(orgUnitRootObj);
        HashMap<Object, String> viewIdSynMap = new HashMap<Object, String>(showViewIds.size());
        for (Object viewId : showViewIds) {
            if (viewIdRootOrgObjMap.get(viewId) == null || !viewIdRootOrgObjMap.get(viewId).getPkValue().equals(orgUnitRootObj.getPkValue())) continue;
            if (rootOrgViewIds.contains(viewId)) {
                viewIdSynMap.put(viewId, "1");
                continue;
            }
            viewIdSynMap.put(viewId, "0");
        }
        this.batchCreateViewEntry(viewIdSynMap);
    }

    private void batchCreateViewEntry(Map<Object, String> viewIdSynMap) {
        List<Object> sortedViewIds = viewIdSynMap.keySet().stream().sorted(Comparator.comparing(k1 -> Long.valueOf(k1.toString()))).collect(Collectors.toList());
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(FIELD_SYNVIEW, new Object[0]);
        vs.addField(FIELD_ISSYN, new Object[0]);
        sortedViewIds.forEach(id -> vs.addRow(new Object[]{Long.valueOf(id.toString()), viewIdSynMap.get(id)}));
        model.batchCreateNewEntryRow(ENTRY_VIEW, vs);
        model.endInit();
        this.getView().updateView(ENTRY_VIEW);
    }

    private Set<Object> getOrgViewIds(DynamicObject orgObj) {
        if (orgObj == null) {
            long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
            orgObj = BusinessDataServiceHelper.loadSingle((Object)rootOrgId, (String)"bos_org");
        }
        HashSet<Object> rootViewIds = new HashSet<Object>();
        for (DynamicObject structureObj : orgObj.getDynamicObjectCollection("structure")) {
            DynamicObject viewObj = structureObj.getDynamicObject("view");
            if (viewObj == null) continue;
            rootViewIds.add(viewObj.getPkValue());
        }
        return rootViewIds;
    }

    private Boolean isShowButtonExportClose() {
        boolean isViewStatus = OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus());
        Tab tab = (Tab)this.getControl(TAB_KEY);
        String currentTab = tab.getCurrentTab();
        boolean isPageCheck = TAB_PAGE_CHECK.equals(currentTab);
        return isViewStatus && isPageCheck;
    }

    private boolean isFinished() {
        String finished = this.getPageCache().get(CACHEKEY_ISFINISHED);
        if (StringUtils.isBlank((CharSequence)finished)) {
            return false;
        }
        return Boolean.parseBoolean(finished);
    }

    private void setFinished(boolean finished) {
        this.getPageCache().put(CACHEKEY_ISFINISHED, String.valueOf(finished));
    }

    static {
        viewIds.add(1L);
        viewIds.add(15L);
    }
}

