/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.AbstractBasedataController;
import kd.bos.base.utils.BaseUtils;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.events.BaseDataCustomControllerEvent;
import kd.bos.form.field.events.BasedataControllerSourceEnum;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.controller.filter.OrgControllerFilter;
import kd.bos.org.model.BizViewQueryParam;
import kd.bos.org.utils.OrgBillListCommon;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public abstract class AbstractOrgController
extends AbstractBasedataController {
    protected static final Log log = LogFactory.getLog(AbstractOrgController.class);
    private String orgViewType;
    private String orgViewNumber;
    private IFormView formView = null;
    private IPageCache pageCache;
    private static final String KEY_BIZFREEZE_ORGUNIT_IDS = "AbstractOrgController.getBizFreezeOrgUnitIds";

    public void buildBaseDataCoreFilter(BaseDataCustomControllerEvent event) {
        this.formView = BaseUtils.getFormViewByControllerEvent((BaseDataCustomControllerEvent)event);
        if (this.formView != null) {
            this.pageCache = this.formView.getPageCache();
        }
        ArrayList<QFilter> billListFilters = new ArrayList<QFilter>();
        ListShowParameter listShowParameter = event.getListShowParameter();
        this.initOrgView(listShowParameter, this.pageCache);
        OrgControllerFilter fixedFilter = new OrgControllerFilter(listShowParameter, this.pageCache, this.getOrgViewNumber());
        Set<Long> orgIdFilterSet = fixedFilter.getOrgIdFilterSet();
        if (orgIdFilterSet != null) {
            log.info("\u3010\u7ec4\u7ec7\u8fc7\u6ee4\u63a7\u5236\u5668\u3011\u751f\u6210\u7684\u8fc7\u6ee4\u7ec4\u7ec7\u6570\u91cf\uff1a" + orgIdFilterSet.size());
            QFilter idFilter = new QFilter(this.getOrgFilterPropertyName(), "in", orgIdFilterSet);
            billListFilters.add(idFilter);
        }
        event.addQFilters(billListFilters);
        this.buildBaseDataCoreOtherFilter(event);
        log.info("\u3010\u7ec4\u7ec7\u8fc7\u6ee4\u63a7\u5236\u5668\u3011\u751f\u6210\u7684\u8fc7\u6ee4\u6761\u4ef6\uff1a" + event.getQfilters());
    }

    protected Boolean isIncludeFreeze(BaseDataCustomControllerEvent event) {
        if (event.getSourceEnum() == BasedataControllerSourceEnum.FUZZY) {
            return Boolean.FALSE;
        }
        if (this.formView != null) {
            return OrgBillListCommon.isIncludeFreeze((IDataModel)this.formView.getModel());
        }
        return Boolean.TRUE;
    }

    protected boolean isOnlyDisplayOrgLeaves(ListShowParameter listShowParameter) {
        Object isOnlyDisplayOrgLeavesObj = listShowParameter.getCustomParams().get("isOnlyDisplayOrgLeaves");
        boolean isOnlyDisplayOrgLeaves = false;
        if (StringUtils.isNotBlank(isOnlyDisplayOrgLeavesObj)) {
            isOnlyDisplayOrgLeaves = Boolean.parseBoolean(isOnlyDisplayOrgLeavesObj.toString());
        }
        return isOnlyDisplayOrgLeaves;
    }

    public void buildBaseDataCoreOtherFilter(BaseDataCustomControllerEvent event) {
    }

    private void initOrgView(ListShowParameter listShowParameter, IPageCache pageCache) {
        if (StringUtils.isNotBlank((CharSequence)this.orgViewType) && StringUtils.isNotBlank((CharSequence)this.orgViewNumber)) {
            return;
        }
        String orgViewTypeParam = null;
        String orgViewNumberParam = null;
        if (pageCache != null) {
            orgViewTypeParam = pageCache.get("orgFuncId");
            if (StringUtils.isBlank((CharSequence)orgViewTypeParam)) {
                orgViewTypeParam = (String)listShowParameter.getCustomParam("orgFuncId");
            }
            if (StringUtils.isBlank((CharSequence)(orgViewNumberParam = pageCache.get("orgViewSchemeNumber")))) {
                orgViewNumberParam = (String)listShowParameter.getCustomParam("orgViewSchemeNumber");
            }
        }
        if (StringUtils.isBlank(orgViewTypeParam) || StringUtils.isBlank(orgViewNumberParam)) {
            Map initializeOrgView = OrgBillListCommon.getInitializeOrgView((FormShowParameter)listShowParameter, (String)this.getDefaultOrgViewType());
            orgViewTypeParam = (String)initializeOrgView.get("orgFuncId");
            orgViewNumberParam = (String)initializeOrgView.get("orgViewSchemeNumber");
        }
        this.setOrgViewType(orgViewTypeParam);
        listShowParameter.setCustomParam("orgFuncId", (Object)orgViewTypeParam);
        this.setOrgViewNumber(orgViewNumberParam);
        listShowParameter.setCustomParam("orgViewSchemeNumber", (Object)orgViewNumberParam);
    }

    protected List<Long> getBizFreezeOrgUnitIds() {
        String idsCache;
        ArrayList<Long> orgIds = new ArrayList<Long>(64);
        if (this.pageCache != null && StringUtils.isNotBlank((CharSequence)(idsCache = this.pageCache.get(KEY_BIZFREEZE_ORGUNIT_IDS)))) {
            List cacheOrgIds = (List)SerializationUtils.fromJsonString((String)idsCache, List.class);
            for (Object orgId : cacheOrgIds) {
                orgIds.add(Long.valueOf(orgId.toString()));
            }
            return orgIds;
        }
        BizViewQueryParam bizViewQueryParam = new BizViewQueryParam();
        bizViewQueryParam.setCategory("1");
        Map bizObjMap = OrgUnitServiceHelper.getBiz((BizViewQueryParam)bizViewQueryParam);
        bizViewQueryParam = new BizViewQueryParam();
        bizViewQueryParam.setOnlyDefault(true);
        bizViewQueryParam.setCustomFilter(new QFilter("treetypeid", "in", bizObjMap.keySet()));
        Map viewObjMap = OrgUnitServiceHelper.getView((BizViewQueryParam)bizViewQueryParam);
        QFilter viewFilter = new QFilter("view", "in", viewObjMap.keySet());
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{viewFilter, freezeFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)KEY_BIZFREEZE_ORGUNIT_IDS, (String)"bos_org_structure", (String)"org", (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                orgIds.add(row.getLong("org"));
            }
        }
        if (this.pageCache != null) {
            this.pageCache.put(KEY_BIZFREEZE_ORGUNIT_IDS, SerializationUtils.toJsonString(orgIds));
        }
        return orgIds;
    }

    protected String getDefaultOrgViewType() {
        return "15";
    }

    protected String getDefaultOrgViewNumber() {
        return "15";
    }

    public String getOrgFilterPropertyName() {
        return "id";
    }

    public String getOrgViewType() {
        return this.orgViewType;
    }

    public void setOrgViewType(String orgViewType) {
        this.orgViewType = orgViewType;
    }

    public String getOrgViewNumber() {
        return this.orgViewNumber;
    }

    public void setOrgViewNumber(String orgViewNumber) {
        this.orgViewNumber = orgViewNumber;
    }
}

