/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.controller.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.controller.filter.OrgFilterCacheKey;
import kd.bos.org.controller.filter.OrgRelationFilter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class OrgControllerFilter {
    private static final Log log = LogFactory.getLog(OrgControllerFilter.class);
    private ListShowParameter listShowParameter;
    private Set<Long> orgIdFilterSet;
    private Map<String, Object> customParams;
    private String orgViewNumber;
    private IPageCache pageCache;
    private static final String CACHEKEY_CUSTOM_PARAM = "key_custom_param";

    public OrgControllerFilter(ListShowParameter listShowParameter) {
        this.initParam(listShowParameter, null, null);
    }

    public OrgControllerFilter(ListShowParameter listShowParameter, IPageCache pageCache) {
        this.initParam(listShowParameter, pageCache, (String)listShowParameter.getCustomParam("orgViewSchemeNumber"));
    }

    public OrgControllerFilter(ListShowParameter listShowParameter, IPageCache pageCache, String orgViewNumber) {
        this.initParam(listShowParameter, pageCache, orgViewNumber);
    }

    private void initParam(ListShowParameter listShowParameter, IPageCache pageCache, String orgViewNumber) {
        this.listShowParameter = listShowParameter;
        this.pageCache = pageCache;
        this.orgViewNumber = orgViewNumber;
        this.customParams = listShowParameter.getCustomParams();
        if (this.orgViewNumber == null) {
            this.orgViewNumber = (String)listShowParameter.getCustomParam("orgViewSchemeNumber");
        }
        this.addOrgFilterFromCache();
    }

    public Set<Long> getOrgIdFilterSet() {
        return this.orgIdFilterSet;
    }

    private void retainOrgIdFilterSet(Collection<Long> orgIdSet) {
        if (orgIdSet == null) {
            return;
        }
        if (this.orgIdFilterSet == null) {
            this.orgIdFilterSet = new HashSet<Long>(orgIdSet.size());
            this.orgIdFilterSet.addAll(orgIdSet);
        } else {
            this.orgIdFilterSet.retainAll(orgIdSet);
        }
    }

    private void addOrgFilterFromCache() {
        String customParamsCacheValue;
        String customParamsValue = SerializationUtils.toJsonString(new TreeMap<String, Object>(this.customParams));
        OrgFilterCacheKey keyObj = new OrgFilterCacheKey(this.orgViewNumber);
        String cacheKey = keyObj.getKey();
        String orgFilterSetCache = null;
        if (this.pageCache != null && StringUtils.equals((CharSequence)(customParamsCacheValue = this.pageCache.get(CACHEKEY_CUSTOM_PARAM)), (CharSequence)customParamsValue)) {
            orgFilterSetCache = this.pageCache.get(cacheKey);
        }
        if (orgFilterSetCache == null) {
            this.addOrgFixedFilter();
            if (this.pageCache != null) {
                if (this.orgIdFilterSet == null) {
                    this.pageCache.put(cacheKey, "");
                } else {
                    this.pageCache.put(cacheKey, SerializationUtils.toJsonString(this.orgIdFilterSet));
                }
                this.pageCache.put(CACHEKEY_CUSTOM_PARAM, customParamsValue);
            }
        } else if (StringUtils.isNotBlank(orgFilterSetCache)) {
            Set cacheSet = (Set)SerializationUtils.fromJsonString(orgFilterSetCache, Set.class);
            this.retainOrgIdFilterSet(cacheSet);
        }
    }

    private void addOrgFixedFilter() {
        this.getCustomParamFilter();
        if (this.orgIdFilterSet != null && this.orgIdFilterSet.isEmpty()) {
            return;
        }
        OrgRelationFilter relationFilter = new OrgRelationFilter(this.listShowParameter);
        List<Long> relationFilterOrgIds = relationFilter.getOrgIds();
        if (!CollectionUtils.isEmpty(relationFilterOrgIds)) {
            this.retainOrgIdFilterSet(relationFilterOrgIds);
        }
        this.getPermOrgsFilter();
    }

    private void getCustomParamFilter() {
        QFilter customFilter = null;
        Object rootId = this.customParams.get("rootId");
        if (StringUtils.isNotBlank((Object)rootId)) {
            long customRootId = Long.parseLong(rootId.toString());
            QFilter viewFilter = new QFilter("view.number", "=", (Object)this.orgViewNumber);
            viewFilter = viewFilter.and(new QFilter("org", "=", (Object)customRootId));
            QFilter[] filters = new QFilter[]{viewFilter};
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgControllerFilter.getCustomParamFilter,rootId", (String)"bos_org_structure", (String)"longnumber", (QFilter[])filters, (String)"");){
                if (dataSet.hasNext()) {
                    Row structObj = dataSet.next();
                    String longNumber = structObj.getString("longnumber");
                    QFilter longnumberFilter = new QFilter("longnumber", "like", (Object)(longNumber + "!" + "%"));
                    customFilter = longnumberFilter = longnumberFilter.or(new QFilter("org", "=", (Object)customRootId));
                }
            }
        }
        customFilter = this.getStructureFilters(customFilter);
        this.getOrgIdsByCustomFilter(customFilter);
    }

    private void getOrgIdsByCustomFilter(QFilter customFilter) {
        if (customFilter == null) {
            return;
        }
        Object rangeOrgList = this.customParams.get("range");
        if (rangeOrgList != null) {
            QFilter rangeFilter = new QFilter("org", "in", rangeOrgList);
            customFilter = customFilter.and(rangeFilter);
        }
        QFilter viewFilter = new QFilter("view.number", "=", (Object)this.orgViewNumber);
        QFilter[] filters = new QFilter[]{customFilter, viewFilter};
        ArrayList<Long> orgIds = new ArrayList<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgControllerFilter.getOrgIdsByCustomFilter", (String)"bos_org_structure", (String)"org", (QFilter[])filters, (String)"");){
            for (Row structureObj : dataSet) {
                orgIds.add(structureObj.getLong("org"));
            }
        }
        log.info("\u3010\u7ec4\u7ec7\u67e5\u8be2\u3011\u7ec4\u7ec7\u63a7\u5236\u5668\u81ea\u5b9a\u4e49\u53c2\u6570\u8fc7\u6ee4\u6761\u4ef6\uff1a" + orgIds);
        this.retainOrgIdFilterSet(orgIds);
    }

    private QFilter getStructureFilters(QFilter customFilter) {
        QFilter structureFilter;
        Object structureFilterObj = this.customParams.get("structureFilter");
        if (StringUtils.isBlank((Object)structureFilterObj)) {
            return customFilter;
        }
        try {
            structureFilter = QFilter.fromSerializedString((String)structureFilterObj.toString());
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790\u53c2\u6570\u201cstructureFilter\u201d\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u4e1a\u52a1\u5f00\u53d1\u4eba\u5458\u786e\u8ba4\u53c2\u6570\u503c\u662f\u5426\u5df2\u7ecf\u6267\u884c\u5e8f\u5217\u5316\u3002", (String)"OrgControllerFilter_0", (String)"bos-org-formplugin", (Object[])new Object[0]));
        }
        customFilter = customFilter == null ? structureFilter : customFilter.and(structureFilter);
        return customFilter;
    }

    private void getPermOrgsFilter() {
        long userId = RequestContext.get().getCurrUserId();
        Object isAddChargeOrgFilter = this.customParams.get("isOrgBaseAdmin");
        if (isAddChargeOrgFilter != null && Boolean.parseBoolean(isAddChargeOrgFilter.toString())) {
            HasPermOrgResult hasPermOrgResult;
            if (PermissionServiceHelper.isAdminUser((long)userId) && !(hasPermOrgResult = PermissionServiceHelper.getAdminChargeOrg((Long)userId, (String)this.orgViewNumber, (boolean)false)).hasAllOrgPerm()) {
                this.retainOrgIdFilterSet(hasPermOrgResult.getHasPermOrgs());
                log.info("\u3010\u7ec4\u7ec7\u67e5\u8be2\u3011\u7ec4\u7ec7\u63a7\u5236\u5668\u7ba1\u7406\u5458\u7ba1\u8f96\u8303\u56f4\u8fc7\u6ee4\u6761\u4ef6\uff1a" + hasPermOrgResult.getHasPermOrgs());
            }
        } else {
            Object isAddUserPermOrgFilter = this.customParams.get("isAddUserPermOrgFilter");
            if (isAddUserPermOrgFilter != null && Boolean.parseBoolean(isAddUserPermOrgFilter.toString())) {
                this.getUserHasPermOrgs();
            }
        }
    }

    private void getUserHasPermOrgs() {
        String appId = "";
        String entityNum = "";
        if (StringUtils.isNotBlank((Object)this.customParams.get("permEntityNumber"))) {
            entityNum = this.customParams.get("permEntityNumber").toString();
            appId = BizAppServiceHelp.getAppIdByFormNum((String)entityNum);
        }
        long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult permOrg = StringUtils.isBlank((CharSequence)entityNum) ? PermissionServiceHelper.getUserHasPermOrgs((long)userId, (boolean)false) : PermissionServiceHelper.getAllPermOrgs((long)userId, (String)this.orgViewNumber, (String)appId, (String)entityNum, (String)"47150e89000000ac", (boolean)false);
        if (permOrg != null && !permOrg.hasAllOrgPerm()) {
            this.retainOrgIdFilterSet(permOrg.getHasPermOrgs());
            log.info("\u3010\u7ec4\u7ec7\u67e5\u8be2\u3011\u7ec4\u7ec7\u63a7\u5236\u5668\u4eba\u5458\u6743\u9650\u8303\u56f4\u8fc7\u6ee4\u6761\u4ef6\uff1a" + permOrg.getHasPermOrgs());
        }
    }
}

