/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.controller.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrgRelationFilter {
    private static final Log log = LogFactory.getLog(OrgRelationFilter.class);
    private final ListShowParameter listShowParameter;
    private final List<Long> orgIds = new ArrayList<Long>();
    private static final String RELATION_ORG_ID = "orgpkid";
    private static final String RELATION_DIRECT_TYPE = "directtype";

    public OrgRelationFilter(ListShowParameter listShowParameter) {
        this.listShowParameter = listShowParameter;
        this.parseOrgRelationFilter();
    }

    public List<Long> getOrgIds() {
        log.info("\u3010\u7ec4\u7ec7\u67e5\u8be2\u3011\u7ec4\u7ec7\u59d4\u6258\u8fc7\u6ee4\u6761\u4ef6\uff1a" + this.orgIds);
        return this.orgIds;
    }

    private void parseOrgRelationFilter() {
        Map relationParams = (Map)this.listShowParameter.getCustomParam("orgRelation");
        log.info("\u3010\u7ec4\u7ec7\u67e5\u8be2\u3011\u7ec4\u7ec7\u534f\u4f5c\u5173\u7cfb\u53c2\u6570\uff1a" + relationParams);
        if (relationParams == null) {
            return;
        }
        Object orgPkId = relationParams.get(RELATION_ORG_ID);
        if (StringUtils.isBlank(orgPkId)) {
            return;
        }
        try {
            long orgId = Long.parseLong(orgPkId.toString());
            if (orgId == 0L) {
                return;
            }
            String relationTypeNumber = String.valueOf(relationParams.get("number"));
            String directtype = String.valueOf(relationParams.get(RELATION_DIRECT_TYPE));
            String fromtype = String.valueOf(relationParams.get("fromtype"));
            String totype = String.valueOf(relationParams.get("totype"));
            OrgRelationParam param = new OrgRelationParam();
            param.setOrgId(orgId);
            param.setNumber(relationTypeNumber);
            param.setToViewType(totype);
            param.setFromViewType(fromtype);
            param.setDirectViewType(directtype);
            this.orgIds.addAll(OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param));
            if (!this.orgIds.isEmpty()) {
                this.addSelfToRelationOrg(!"toorg".equals(directtype), fromtype, totype, orgId);
            }
        }
        catch (Exception e) {
            log.info("\u3010\u7ec4\u7ec7\u67e5\u8be2\u3011\u751f\u6210\u4e1a\u52a1\u5355\u5143\u95f4\u534f\u4f5c\u7684\u8fc7\u6ee4\u6761\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private void addSelfToRelationOrg(boolean isGetFromOrg, String fromtype, String totype, long orgId) {
        if (isGetFromOrg) {
            if (StringUtils.isBlank((CharSequence)fromtype) || !"01".equals(fromtype) && OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)fromtype)) {
                this.orgIds.add(orgId);
            }
        } else if (!"01".equals(totype) && OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)totype)) {
            this.orgIds.add(orgId);
        }
    }
}

