/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.duty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public abstract class AbstractOrgRelationSettingFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    protected static final String KEY_TYPERELATION = Long.toString(585511977942548480L);
    protected static final String ENTITY_ORG_ORGRELATION = "bos_org_orgrelation";
    protected static final String ENTITY_ORG_ORGRELATION_DEPT = "bos_org_orgrelation_dept";
    protected static final String ENTITY_ORG_RELATION_DEPTUNIT = "bos_org_relation_deptunit";
    protected static final String FIELD_IS_DEFAULT_TO_ORG = "isdefaulttoorg";
    protected static final String FIELD_IS_DEFAULT_FROM_ORG = "isdefaultfromorg";
    protected static final String CALLBACK_CONFIRM_OVERRIDE = "confirmOverride";
    private DynamicObject unitDeptTypeRelationObj;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Toolbar mainToolBar = (Toolbar)this.getControl("toolbarap");
        mainToolBar.addItemClickListener(new ItemClickListener(){

            public void beforeItemClick(BeforeItemClickEvent evt) {
                String itemKey = evt.getItemKey();
                if ("btadd".equals(itemKey)) {
                    AbstractOrgRelationSettingFormPlugin.this.beforeSaveDuty(evt);
                }
            }

            public void itemClick(ItemClickEvent evt) {
                if ("btadd".equals(evt.getItemKey())) {
                    AbstractOrgRelationSettingFormPlugin.this.saveOrgDuty();
                }
            }
        });
    }

    protected void beforeSaveDuty(BeforeItemClickEvent evt) {
        long currUserId = RequestContext.get().getCurrUserId();
        String appId = this.getView().getFormShowParameter().getAppId();
        boolean hasPerm = PermissionServiceHelper.checkPermission((Long)currUserId, (String)appId, (String)ENTITY_ORG_ORGRELATION_DEPT, (String)"47156aff000000ac");
        if (!hasPerm) {
            DynamicObject permItem;
            evt.setCancel(true);
            String entityName = "";
            String permItemName = "";
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)ENTITY_ORG_ORGRELATION_DEPT);
            if (!ObjectUtils.isEmpty((Object)dataEntityType)) {
                entityName = dataEntityType.getDisplayName().getLocaleValue();
            }
            if (!ObjectUtils.isEmpty((Object)(permItem = BusinessDataServiceHelper.loadSingle((Object)"47156aff000000ac", (String)"perm_permitem")))) {
                permItemName = permItem.getLocaleString("name").getLocaleValue();
            }
            String message = String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OrgDepDutySettingPlugin_6", (String)"bos-org-formplugin", (Object[])new Object[0]), entityName, permItemName);
            this.getView().showErrorNotification(message);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if ("org".equals(evt.getProperty().getName())) {
            DynamicObjectCollection entryEntity;
            Object orgNodeId = this.getView().getFormShowParameter().getCustomParam("orgNodeId");
            if (StringUtils.isBlank((Object)orgNodeId)) {
                return;
            }
            HashSet<Long> exceptOrgIds = new HashSet<Long>();
            Long orgMemberId = Long.valueOf(orgNodeId.toString());
            Set<Long> toOrgIds = this.getToOrgsByFromOrg(KEY_TYPERELATION, orgMemberId);
            if (toOrgIds != null && !toOrgIds.isEmpty()) {
                exceptOrgIds.addAll(toOrgIds);
            }
            if (Utils.isListNotEmpty((List)(entryEntity = this.getModel().getEntryEntity("entryentity")))) {
                for (DynamicObject row : entryEntity) {
                    DynamicObject orgObj = row.getDynamicObject("org");
                    if (orgObj == null) continue;
                    exceptOrgIds.add(orgObj.getLong("id"));
                }
            }
            if (!exceptOrgIds.isEmpty()) {
                ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
                QFilter filter = new QFilter("id", "not in", exceptOrgIds);
                param.getListFilterParameter().getQFilters().add(filter);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (FIELD_IS_DEFAULT_TO_ORG.equals(name)) {
            ChangeData changeData = e.getChangeSet()[0];
            if (!((Boolean)changeData.getNewValue()).booleanValue()) {
                return;
            }
            Object rootNodeId = this.getView().getFormShowParameter().getCustomParam("orgNodeId");
            if (ObjectUtils.isEmpty((Object)rootNodeId) || !(rootNodeId instanceof String)) {
                this.getView().showErrorNotification(this.buildSelectAgainMsg());
                return;
            }
            int row = changeData.getRowIndex();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            int rowIndex = 0;
            for (DynamicObject rowObj : entryEntity) {
                if (rowObj.getBoolean(FIELD_IS_DEFAULT_TO_ORG) && rowIndex != row) {
                    this.getModel().setValue(FIELD_IS_DEFAULT_TO_ORG, (Object)Boolean.FALSE, rowIndex);
                }
                ++rowIndex;
            }
        }
    }

    protected Boolean defaultToOrgSetted(Long fromOrgId, DynamicObjectCollection doc) {
        QFilter[] qFilters = new QFilter[]{new QFilter("fromorg", "=", (Object)fromOrgId), new QFilter("typerelation", "=", (Object)585511977942548480L), new QFilter(FIELD_IS_DEFAULT_TO_ORG, "=", (Object)"1")};
        DynamicObjectCollection settedFromDb = QueryServiceHelper.query((String)ENTITY_ORG_ORGRELATION_DEPT, (String)"fromorg", (QFilter[])qFilters);
        long count = doc.stream().filter(obj -> obj.getBoolean(FIELD_IS_DEFAULT_TO_ORG)).count();
        return !CollectionUtils.isEmpty((Collection)settedFromDb) && count > 0L;
    }

    protected Set<Long> getToOrgsByFromOrg(String typeRelation, Long orgId) {
        HashSet<Long> toOrgs = new HashSet<Long>(16);
        String selFields = "id,typerelation,toorg,fromorg";
        QFilter typerelationFilter = new QFilter("typerelation", "=", (Object)Long.valueOf(typeRelation));
        QFilter fromorgFilter = new QFilter("fromorg", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{typerelationFilter, fromorgFilter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)ENTITY_ORG_ORGRELATION, (String)selFields, (QFilter[])filters);
        dcs.forEach(p -> toOrgs.add(p.getLong("toorg")));
        return toOrgs;
    }

    protected void saveOrgDuty() {
        DynamicObjectCollection doc = this.getModel().getEntryEntity("entryentity");
        if (doc == null || doc.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u6dfb\u52a0\u4e00\u884c\u6570\u636e\u3002", (String)"OrgDepDutySettingPlugin_0", (String)"bos-org-formplugin", (Object[])new Object[0]));
            return;
        }
        String validateMsg = this.validateDatas(doc);
        if (!StringUtils.isBlank((CharSequence)validateMsg)) {
            this.getView().showErrorNotification(validateMsg);
            return;
        }
        Long orgNodeId = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("orgNodeId"));
        if (this.defaultToOrgSetted(orgNodeId, doc).booleanValue()) {
            this.getView().showConfirm(this.buildConfirmOverrideMsg(), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACK_CONFIRM_OVERRIDE, (IFormPlugin)this));
            return;
        }
        this.saveOrgDuty(doc);
    }

    protected void saveOrgDuty(DynamicObjectCollection doc) {
        DynamicObject orgUnitObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("orgNodeId")), (String)"bos_org");
        DynamicObject unitDeptTypeRelationObj = this.getUnitDeptTypeRelationObj();
        ArrayList<DynamicObject> relationDataEntities = new ArrayList<DynamicObject>(doc.size());
        for (DynamicObject obj : doc) {
            DynamicObject org = obj.getDynamicObject("org");
            if (org == null) continue;
            DynamicObject orgRelation = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ORG_ORGRELATION_DEPT);
            orgRelation.set("typerelation", (Object)unitDeptTypeRelationObj);
            orgRelation.set("toorg", (Object)org);
            orgRelation.set("fromorg", (Object)orgUnitObj);
            orgRelation.set("orgduty", (Object)obj.getDynamicObject("orgduty"));
            orgRelation.set(FIELD_IS_DEFAULT_TO_ORG, obj.get(FIELD_IS_DEFAULT_TO_ORG));
            relationDataEntities.add(orgRelation);
        }
        if (relationDataEntities.isEmpty()) {
            this.getView().showTipNotification(this.buildAtLeastSelectOneMsg());
            return;
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("source", "addnew");
        operateOption.setVariableValue("appnumber", this.getView().getFormShowParameter().getAppId());
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)ENTITY_ORG_ORGRELATION_DEPT, (DynamicObject[])relationDataEntities.toArray(new DynamicObject[relationDataEntities.size()]), (OperateOption)operateOption);
        if (operationResult.isSuccess()) {
            String pageId = this.getView().getFormShowParameter().getParentPageId();
            IFormView parentView = this.getView().getViewNoPlugin(pageId);
            if (null != parentView) {
                parentView.showSuccessNotification(BaseMessage.getMessage((String)"M00021"));
                this.getView().sendFormAction(parentView);
            }
            this.getView().returnDataToParent((Object)"success");
            this.getView().close();
        } else {
            this.getView().showOperationResult(operationResult);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if (CALLBACK_CONFIRM_OVERRIDE.equals(callBackId) && mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
            DynamicObjectCollection doc = this.getModel().getEntryEntity("entryentity");
            this.saveOrgDuty(doc);
        }
    }

    protected String validateDatas(DynamicObjectCollection doc) {
        for (int i = 0; i < doc.size(); ++i) {
            DynamicObject object = (DynamicObject)doc.get(i);
            if (!object.getBoolean(FIELD_IS_DEFAULT_TO_ORG) || object.getDynamicObject("org") != null) continue;
            return String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u7b2c%s\u884c\u9009\u62e9\u4e00\u4e2a\u9ed8\u8ba4\u7684\u7ec4\u7ec7\u3002", (String)"AbstractOrgRelationSettingFormPlugin_0", (String)"bos-org-formplugin", (Object[])new Object[0]), i + 1);
        }
        return "";
    }

    protected String buildSelectAgainMsg() {
        return ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\u4e1a\u52a1\u5355\u5143\u3002", (String)"OrgDepDutySettingPlugin_4", (String)"bos-org-formplugin", (Object[])new Object[0]);
    }

    protected String buildConfirmOverrideMsg() {
        return ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u5355\u5143\u5b58\u5728\u9ed8\u8ba4\u90e8\u95e8\uff0c\u662f\u5426\u8986\u76d6\uff1f", (String)"OrgDepDutySettingPlugin_5", (String)"bos-org-formplugin", (Object[])new Object[0]);
    }

    protected String buildAtLeastSelectOneMsg() {
        return ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u884c\u653f\u7ec4\u7ec7\u3002", (String)"OrgDepDutySettingPlugin_1", (String)"bos-org-formplugin", (Object[])new Object[0]);
    }

    public DynamicObject getUnitDeptTypeRelationObj() {
        if (this.unitDeptTypeRelationObj == null) {
            this.unitDeptTypeRelationObj = BusinessDataServiceHelper.loadSingleFromCache((Object)585511977942548480L, (String)"bos_org_typerelation");
        }
        return this.unitDeptTypeRelationObj;
    }
}

