/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.duty;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.utils.msg.BaseMessageUtils;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.org.model.OrgTreeSearchParam;
import kd.bos.org.utils.OrgTreeUtils;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public abstract class AbstractOrgRelationTreeListPlugin
extends StandardTreeListPlugin
implements ListRowClickListener {
    private static final Log log = LogFactory.getLog(AbstractOrgRelationTreeListPlugin.class);
    protected boolean isFilterContainerSearchClick;
    protected static final String COTROL_TREEVIEW = "treeview";
    protected static final String ACTION_BOS_REFRESH = "refresh";
    protected static final String PRO_ORGID = "toorg_id";
    protected static final String SET_DEFAULT_TO_ORG = "setdefaulttoorg";
    protected static final String BILLLISTAP = "billlistap";
    protected static final String IS_DEFAULT_TO_ORG = "isdefaulttoorg";
    protected static final String IS_DEFAULT_FROM_ORG = "isdefaultfromorg";
    protected static final String ENTITY_ORG_ORGRELATION_DEPT = "bos_org_orgrelation_dept";
    protected static final String ENTITY_ORG_ORGRELATION = "bos_org_orgrelation";
    protected static final String ENTITY_ORG_ORGRELATION_DEPTUNIT = "bos_org_relation_deptunit";
    protected static final String CALLBACK_CONFIRM_OVERRIDE = "confirmOverride";
    protected static final String OPERATE_CANCEL_DEFAULTTOORG = "canceldefaulttoorg";

    String getOrgViewType() {
        return "15";
    }

    long getSchemaId() {
        return 15L;
    }

    String getAssignOrgField() {
        return "fromorg";
    }

    String getDefaultOrgField() {
        return IS_DEFAULT_TO_ORG;
    }

    String buildConfirmOverrideMsg() {
        return ResManager.loadKDString((String)"\u5f53\u524d\u59d4\u6258\u7ec4\u7ec7\u5b58\u5728\u9ed8\u8ba4\u53d7\u6258\u7ec4\u7ec7\uff0c\u662f\u5426\u8986\u76d6\uff1f", (String)"OrgDeptTreeListPlugin_3", (String)"bos-org-formplugin", (Object[])new Object[0]);
    }

    String buildCurrOrgIsDefaultMsg() {
        return ResManager.loadKDString((String)"\u8be5\u53d7\u6258\u7ec4\u7ec7\u5df2\u662f\u9ed8\u8ba4\u53d7\u6258\u7ec4\u7ec7\u3002", (String)"OrgDeptTreeListPlugin_2", (String)"bos-org-formplugin", (Object[])new Object[0]);
    }

    String getJumpBillFormId() {
        return ENTITY_ORG_ORGRELATION_DEPTUNIT;
    }

    String getJumpTreeListFormId() {
        return "bos_org_detpunit_treelist";
    }

    String buildDefaultOrgSuccessMsg() {
        return ResManager.loadKDString((String)"\u8bbe\u7f6e\u9ed8\u8ba4\u53d7\u6258\u7ec4\u7ec7\u6210\u529f\u3002", (String)"OrgDeptTreeListPlugin_4", (String)"bos-org-formplugin", (Object[])new Object[0]);
    }

    String buildCancelDefaultOrgSuccessMsg() {
        return ResManager.loadKDString((String)"\u53d6\u6d88\u9ed8\u8ba4\u53d7\u6258\u7ec4\u7ec7\u6210\u529f\u3002", (String)"OrgDeptTreeListPlugin_5", (String)"bos-org-formplugin", (Object[])new Object[0]);
    }

    String buildNoDefaultOrgToCancelMsg() {
        return ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4ee5\u53d6\u6d88\u7684\u9ed8\u8ba4\u53d7\u6258\u7ec4\u7ec7\u3002", (String)"OrgDeptTreeListPlugin_6", (String)"bos-org-formplugin", (Object[])new Object[0]);
    }

    String getNewBatchFormId() {
        return "bos_org_deptscopeset";
    }

    public void initializeTree(EventObject e) {
        HashMap customParams = this.getView().getFormShowParameter().getCustomParams();
        log.info("\u3010\u4e1a\u52a1\u5355\u5143\u5206\u914d\u90e8\u95e8\u67e5\u8be2\u3011\u521d\u59cb\u5316\u53c2\u6570\uff1a" + customParams);
        if (customParams == null) {
            customParams = new HashMap(0);
        }
        this.initRootNode(customParams);
    }

    public void afterCreateNewData(EventObject e) {
        TreeNode root = this.getTreeModel().getRoot();
        if (root != null) {
            this.getTreeListView().getTreeView().focusNode(root);
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        e.setCancel(true);
        if (this.isFilterContainerSearchClick) {
            return;
        }
        String nodeId = e.getNodeId().toString();
        QFilter treeListFilter = null;
        long orgId = Long.parseLong(nodeId);
        if (Boolean.parseBoolean(this.getModel().getValue("chkincludechild").toString())) {
            if (OrgUnitServiceHelper.getRootOrgId() != orgId) {
                treeListFilter = this.getNotRootNodeFilter(orgId);
            }
        } else {
            treeListFilter = new QFilter(this.getAssignOrgField(), "=", (Object)orgId);
        }
        if (treeListFilter != null) {
            e.addQFilter(treeListFilter);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        this.isFilterContainerSearchClick = true;
    }

    public void treeNodeClick(TreeNodeEvent e) {
        this.treeListView.getTreeView().queryTreeNodeChildren(String.valueOf(e.getParentNodeId()), String.valueOf(e.getNodeId()));
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        e.setChildNodes(this.refreshNodeChildren(nodeId, this.getOrgUnitTreeParam(), nodeId.equals(this.getTreeModel().getRoot().getId())));
    }

    public void expendTreeNode(TreeNodeEvent e) {
        this.treeListView.getTreeView().expand(e.getNodeId().toString());
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        if (StringUtils.isBlank((CharSequence)searchEnterEvent.getText())) {
            return;
        }
        OrgTreeSearchParam searchParam = new OrgTreeSearchParam(searchEnterEvent.getText(), (ListView)this.getView(), this.getOrgViewType());
        searchParam.setClickNode(true);
        OrgTreeUtils.searchFromLazyOrgTree((OrgTreeSearchParam)searchParam);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("newbatch".equals(operateKey)) {
            this.showDeptScopeSet();
        } else if ("jumptopage".equals(operateKey)) {
            this.showJumpToPage();
        } else if (SET_DEFAULT_TO_ORG.equals(operateKey)) {
            this.setDefaultToOrg();
        } else if (OPERATE_CANCEL_DEFAULTTOORG.equals(operateKey)) {
            this.cancelDefaultToOrg();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        if ("chkincludechild".equals(proName)) {
            BaseMessageUtils.showLoading((IFormView)this.getView(), () -> {
                TreeView tv = this.treeListView.getTreeView();
                Map focusMap = tv.getTreeState().getFocusNode();
                if (focusMap != null) {
                    tv.treeNodeClick(String.valueOf(focusMap.get("parentid")), String.valueOf(focusMap.get("id")));
                }
            });
        }
    }

    private void showDeptScopeSet() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss style = new StyleCss();
        parameter.getOpenStyle().setInlineStyleCss(style);
        parameter.setFormId(this.getNewBatchFormId());
        TreeView tvLeft = (TreeView)this.getControl(COTROL_TREEVIEW);
        String currNodeId = tvLeft.getTreeState().getFocusNodeId();
        parameter.setCustomParam("orgNodeId", (Object)currNodeId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_BOS_REFRESH));
        this.getView().showForm(parameter);
    }

    private void showJumpToPage() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setBillFormId(this.getJumpBillFormId());
        listShowParameter.setFormId(this.getJumpTreeListFormId());
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if (ACTION_BOS_REFRESH.equals(actionId) && this.getView() instanceof ListView) {
            ((ListView)this.getView()).refresh();
        }
    }

    private QFilter getNotRootNodeFilter(long orgId) {
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        orgIds.add(orgId);
        List orgIncludeSubs = OrgViewUtils.getSubOrgIdIncludeGrand((String)this.getOrgViewType(), orgIds, (boolean)true, null);
        if (Objects.isNull(orgIncludeSubs)) {
            orgIncludeSubs = Collections.emptyList();
        }
        QFilter treeListFilter = new QFilter(this.getAssignOrgField(), "in", orgIncludeSubs);
        return treeListFilter;
    }

    private void initRootNode(Map<String, Object> customParams) {
        long rootOrgId = 0L;
        OrgTreeParam param = this.getOrgUnitTreeParam();
        param.setId(rootOrgId);
        TreeNode root = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        this.initRootNode(root, param);
    }

    private void initRootNode(TreeNode root, OrgTreeParam param) {
        if (root == null) {
            root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"AbstractOrgRelationTreeListPlugin_0", (String)"bos-org-formplugin", (Object[])new Object[0]));
        }
        root.setChildren(new ArrayList());
        String rootId = root.getId();
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)rootId);
        log.debug("\u5de6\u6811\u6839\u8282\u70b9ID\u4e3a\uff1a" + rootId);
    }

    private List<TreeNode> refreshNodeChildren(String nodeId, OrgTreeParam param, boolean isRootNode) {
        if (param == null) {
            return null;
        }
        param.setId(Long.parseLong(nodeId));
        List treeNodes = OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param);
        return treeNodes;
    }

    protected OrgTreeParam getOrgUnitTreeParam() {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewId(this.getSchemaId());
        return param;
    }

    private void setDefaultToOrg() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows.isEmpty()) {
            return;
        }
        if (rows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u8bbe\u4e3a\u9ed8\u8ba4\u3002", (String)"AbstractOrgRelationTreeListPlugin_1", (String)"bos-org-formplugin", (Object[])new Object[0]));
            return;
        }
        long pkId = Long.parseLong(rows.get(0).getPrimaryKeyValue().toString());
        long fromOrgId = Long.parseLong(this.getTreeModel().getCurrentNodeId().toString());
        QFilter[] qFilters = new QFilter[]{new QFilter(this.getAssignOrgField(), "=", (Object)fromOrgId), new QFilter(this.getDefaultOrgField(), "=", (Object)"1"), new QFilter("typerelation", "=", (Object)585511977942548480L)};
        Map doc = BusinessDataServiceHelper.loadFromCache((String)ENTITY_ORG_ORGRELATION_DEPT, (String)"id", (QFilter[])qFilters);
        if (!doc.isEmpty() && doc.get(pkId) == null) {
            this.getView().showConfirm(this.buildConfirmOverrideMsg(), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACK_CONFIRM_OVERRIDE, (IFormPlugin)this));
            return;
        }
        this.setOrCancelDefaultToOrg(true, this.buildCurrOrgIsDefaultMsg(), this.buildDefaultOrgSuccessMsg());
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if (CALLBACK_CONFIRM_OVERRIDE.equals(callBackId) && mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.setOrCancelDefaultToOrg(true, this.buildCurrOrgIsDefaultMsg(), this.buildDefaultOrgSuccessMsg());
        }
    }

    private void setOrCancelDefaultToOrg(boolean isSetDefault, String noOrgMessage, String successMessage) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows.isEmpty()) {
            return;
        }
        ArrayList pks = new ArrayList(rows.size());
        rows.forEach(row -> pks.add(row.getPrimaryKeyValue()));
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", pks)};
        Map doc = BusinessDataServiceHelper.loadFromCache((String)ENTITY_ORG_ORGRELATION_DEPT, (QFilter[])qFilters);
        ArrayList<DynamicObject> orgRelationObjs = new ArrayList<DynamicObject>();
        for (Map.Entry entry : doc.entrySet()) {
            DynamicObject orgRelationObj = (DynamicObject)entry.getValue();
            if (isSetDefault) {
                if (orgRelationObj.getBoolean(this.getDefaultOrgField())) continue;
                orgRelationObj.set(this.getDefaultOrgField(), (Object)Boolean.TRUE);
                orgRelationObjs.add(orgRelationObj);
                continue;
            }
            if (!orgRelationObj.getBoolean(this.getDefaultOrgField())) continue;
            orgRelationObj.set(this.getDefaultOrgField(), (Object)Boolean.FALSE);
            orgRelationObjs.add(orgRelationObj);
        }
        if (CollectionUtils.isEmpty(orgRelationObjs)) {
            this.getView().showTipNotification(noOrgMessage);
            return;
        }
        this.saveAndRefresh(orgRelationObjs, successMessage);
    }

    private void cancelDefaultToOrg() {
        this.setOrCancelDefaultToOrg(false, this.buildNoDefaultOrgToCancelMsg(), this.buildCancelDefaultOrgSuccessMsg());
    }

    private void saveAndRefresh(List<DynamicObject> orgRelationObjs, String successMsg) {
        if (CollectionUtils.isEmpty(orgRelationObjs)) {
            return;
        }
        log.info("\u8c03\u7528\u4e1a\u52a1\u5355\u5143\u5206\u914d\u90e8\u95e8\u4fdd\u5b58\u64cd\u4f5c");
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("source", "update");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)ENTITY_ORG_ORGRELATION_DEPT, (DynamicObject[])orgRelationObjs.toArray(new DynamicObject[orgRelationObjs.size()]), (OperateOption)operateOption);
        if (operationResult.isSuccess()) {
            this.getView().showSuccessNotification(successMsg);
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            billList.refresh();
        } else {
            this.getView().showOperationResult(operationResult);
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        evt.setCancel(true);
        if (!OrgTreeUtils.focusTreeNodeAfterListRowClick((ListRowClickEvent)evt, (IPageCache)this.getPageCache())) {
            return;
        }
        ListSelectedRow row = evt.getCurrentListSelectedRow();
        if (row == null) {
            return;
        }
        DynamicObject orgDeptObj = BusinessDataServiceHelper.loadSingleFromCache((Object)row.getPrimaryKeyValue(), (String)ENTITY_ORG_ORGRELATION, (String)this.getAssignOrgField());
        if (orgDeptObj == null || orgDeptObj.getDynamicObject(this.getAssignOrgField()) == null) {
            return;
        }
        DynamicObject orgObj = orgDeptObj.getDynamicObject(this.getAssignOrgField());
        OrgTreeSearchParam searchParam = new OrgTreeSearchParam(orgObj.getString("id"), (ListView)this.getView(), this.getOrgViewType());
        searchParam.setSearchById(true);
        OrgTreeUtils.searchFromLazyOrgTree((OrgTreeSearchParam)searchParam);
    }
}

