/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.duty;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldDefValue;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.org.duty.AbstractOrgRelationSettingFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class OrgDepDutySettingPlugin
extends AbstractOrgRelationSettingFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    public static final String KEY_TYPERELATION = Long.toString(585511977942548480L);
    private static final String ENTITY_ORG_ORGRELATION = "bos_org_orgrelation";
    private static final String ENTITY_ORG_ORGRELATION_DEPT = "bos_org_orgrelation_dept";
    private static final String FIELD_IS_DEFAULT_TO_ORG = "isdefaulttoorg";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void afterF7Select(AfterF7SelectEvent event) {
        if (event.getSource() instanceof OrgEdit) {
            this.fillBackDuty(event);
        }
    }

    private void fillBackDuty(AfterF7SelectEvent event) {
        ListSelectedRowCollection selectedRows = event.getListSelectedRowCollection();
        ArrayList<Long> orgIds = new ArrayList<Long>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            orgIds.add((Long)row.getPrimaryKeyValue());
        }
        if (event.getInputValue() != null) {
            orgIds.add(Long.parseLong(event.getInputValue().toString()));
        }
        Object defaultOrgDutyId = this.getDefaultOrgDutyId();
        if (CollectionUtils.isEmpty(orgIds)) {
            this.getModel().setValue("orgduty", defaultOrgDutyId, event.getCurrentRowIndex());
            this.getView().setEnable(Boolean.TRUE, event.getCurrentRowIndex(), new String[]{"orgduty"});
            return;
        }
        Map<Long, DynamicObject> orgDutyMap = this.getOrgDuty(orgIds);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        int index = 0;
        for (DynamicObject entryObj : entryEntity) {
            DynamicObject orgObj = entryObj.getDynamicObject("org");
            if (orgObj != null && orgDutyMap.containsKey(orgObj.getLong("id"))) {
                Object orgDuty = orgDutyMap.get(orgObj.getLong("id")) == null ? defaultOrgDutyId : orgDutyMap.get(orgObj.getLong("id"));
                this.getModel().setValue("orgduty", orgDuty, index);
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"orgduty"});
            } else {
                if (entryObj.getDynamicObject("orgduty") == null) {
                    this.getModel().setValue("orgduty", defaultOrgDutyId, index);
                }
                this.getView().setEnable(Boolean.valueOf(true), index, new String[]{"orgduty"});
            }
            ++index;
        }
    }

    private Object getDefaultOrgDutyId() {
        DynamicProperty entryEntityProp = this.getModel().getDataEntityType().getProperty("entryentity");
        if (!(entryEntityProp instanceof EntryProp)) {
            return null;
        }
        DynamicProperty orgDutyProp = ((EntryProp)entryEntityProp).getDynamicCollectionItemPropertyType().getProperty("orgduty");
        if (!(orgDutyProp instanceof BasedataProp)) {
            return null;
        }
        FieldDefValue fieldDefValue = ((BasedataProp)orgDutyProp).getDefValue2();
        if (fieldDefValue != null) {
            JSONObject jsonObject = JSONObject.parseObject((String)fieldDefValue.getFuncParameter());
            return jsonObject.get((Object)"id");
        }
        return null;
    }

    private Map<Long, DynamicObject> getOrgDuty(List<Long> orgIds) {
        HashMap<Long, DynamicObject> orgDutyMap = new HashMap<Long, DynamicObject>(orgIds.size());
        QFilter filter = new QFilter("org", "in", orgIds);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject[] orgDutyObjArr = BusinessDataServiceHelper.load((String)"bos_org_dutyrelation", (String)"org,orgduty", (QFilter[])filters);
        if (orgDutyObjArr == null || orgDutyObjArr.length == 0) {
            return orgDutyMap;
        }
        for (DynamicObject orgDutyObj : orgDutyObjArr) {
            DynamicObject orgObj = orgDutyObj.getDynamicObject("org");
            if (orgObj == null) continue;
            orgDutyMap.put(orgObj.getLong("id"), orgDutyObj.getDynamicObject("orgduty"));
        }
        return orgDutyMap;
    }

    @Override
    protected String validateDatas(DynamicObjectCollection doc) {
        String msg = super.validateDatas(doc);
        if (!StringUtils.isBlank((CharSequence)msg)) {
            return msg;
        }
        StringBuilder sbErrMsg = new StringBuilder();
        int i = 1;
        for (DynamicObject obj : doc) {
            DynamicObject org = obj.getDynamicObject("org");
            if (org != null) {
                this.checkOrgDuty(i, obj, sbErrMsg);
            }
            ++i;
        }
        if (StringUtils.isBlank((CharSequence)sbErrMsg)) {
            return "";
        }
        sbErrMsg.append(']');
        return String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4e1a\u52a1\u5c5e\u6027\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002\r\n", (String)"OrgDepDutySettingPlugin_3", (String)"bos-org-formplugin", (Object[])new Object[0]), sbErrMsg);
    }

    private void checkOrgDuty(int i, DynamicObject obj, StringBuilder sbErrMsg) {
        DynamicObject duty = obj.getDynamicObject("orgduty");
        if (duty == null) {
            if (i == 1) {
                sbErrMsg.append('[');
                sbErrMsg.append(i);
            } else {
                sbErrMsg.append('\u3001');
                sbErrMsg.append(i);
            }
        }
    }
}

