/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.duty;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class OrgDeptDutyEditPlugin
extends AbstractFormPlugin
implements ClickListener {
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok", "tbmain"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button btn = (Button)evt.getSource();
        String key = btn.getKey().toLowerCase();
        if ("btnok".equals(key)) {
            List orgMemberId = (List)this.getView().getFormShowParameter().getCustomParam("lstOrgs");
            DynamicObject dutyObj = (DynamicObject)this.getModel().getValue("duty");
            if (dutyObj == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u5e94\u7684\u90e8\u95e8\u5c5e\u6027\u3002", (String)"OrgDeptDutyEditPlugin_0", (String)"bos-org-formplugin", (Object[])new Object[0]));
                return;
            }
            Long dutyId = Long.valueOf(String.valueOf(dutyObj.getPkValue()));
            this.updateDutyByOrgs(orgMemberId, dutyId);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f!", (String)"OrgDeptDutyEditPlugin_1", (String)"bos-org-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK, new ConfirmCallBackListener("comfirm_save", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        int result = mbce.getResult().getValue();
        switch (callBackId) {
            case "comfirm_save": {
                if (result != 2) break;
                this.getView().close();
                break;
            }
        }
    }

    private void updateDutyByOrgs(List<Long> pkIds, Long dutyId) {
        if (pkIds == null || pkIds.size() <= 0) {
            return;
        }
        StringBuilder idStr = new StringBuilder("Update t_org_dutyrelation set FORGDUTYID = ? where FORGID in (");
        for (Long id : pkIds) {
            idStr.append(String.format("'%s'", id));
        }
        idStr.setCharAt(idStr.length() - 1, ')');
        Object[] updateParam = new SqlParameter[]{new SqlParameter(":FORGDUTYID", -5, (Object)dutyId)};
        DB.update((DBRoute)DBRoute.basedata, (String)idStr.toString(), (Object[])updateParam);
    }
}

