/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.duty;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;

public class OrgDeptDutySaveOperatePlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(OrgDeptDutySaveOperatePlugin.class);
    private static final String ENTITY_ORG_ORGRELATION_DEPT = "bos_org_orgrelation_dept";
    private static final String FIELD_ISDEFAULTTOORG = "isdefaulttoorg";
    private static final String PARAM_SOURCE = "source";
    public static final String ENTITY_BOS_ORG_ORGRELATION_DEPT = "bos_org_orgrelation_dept";

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new OrgDeptDutySaveOperateValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        this.cancelDefaultToOrg(e);
        this.saveOrgDutyRelation(e);
    }

    private void saveOrgDutyRelation(BeginOperationTransactionArgs e) {
        List<Long> lstOrgdutySetted = this.getOrgRepeatDutyDatas(e.getDataEntities());
        ArrayList<DynamicObject> dutyDatas = new ArrayList<DynamicObject>(e.getDataEntities().length);
        for (DynamicObject obj : e.getDataEntities()) {
            if (lstOrgdutySetted.contains(this.getId(obj, "toorg")) || this.getId(obj, "toorg") <= 0L || this.getId(obj, "orgduty") <= 0L) continue;
            DynamicObject orgDuty = BusinessDataServiceHelper.newDynamicObject((String)"bos_org_dutyrelation");
            orgDuty.set("org", obj.get("toorg"));
            orgDuty.set("orgduty", obj.get("orgduty"));
            OrgViewUtils.genCommonField((DynamicObject)orgDuty, (boolean)true);
            dutyDatas.add(orgDuty);
        }
        if (!dutyDatas.isEmpty()) {
            ORM orm = ORM.create();
            long[] ids = orm.genLongIds("bos_org_dutyrelation", dutyDatas.size());
            for (int i = 0; i < dutyDatas.size(); ++i) {
                ((DynamicObject)dutyDatas.get(i)).set("id", (Object)ids[i]);
            }
            OperationResult operationResult = SaveServiceHelper.saveOperate((String)"bos_org_dutyrelation", (DynamicObject[])dutyDatas.toArray(new DynamicObject[dutyDatas.size()]), (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess() || !CollectionUtils.isEmpty((Collection)operationResult.getAllErrorInfo())) {
                logger.info("OrgDeptDutySaveOperatePlugin#saveOrgDutyRelation fail Message is {},AllErrorInfo is {}", (Object)operationResult.getMessage(), (Object)operationResult.getAllErrorInfo());
            }
        }
    }

    private void cancelDefaultToOrg(BeginOperationTransactionArgs e) {
        if (this.needValidate().booleanValue()) {
            return;
        }
        Set<Long> fromOrgIds = Arrays.stream(e.getDataEntities()).filter(obj -> obj.getBoolean(FIELD_ISDEFAULTTOORG)).map(obj -> this.getId((DynamicObject)obj, "fromorg")).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(fromOrgIds)) {
            return;
        }
        List<Long> list = this.getCancelFromOrgList(e, fromOrgIds);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.cancelBySql(e, list);
    }

    private void cancelBySql(BeginOperationTransactionArgs e, List<Long> list) {
        DynamicObject obj = e.getDataEntities()[0];
        DBRoute dbRoute = DBRoute.of((String)obj.getDataEntityType().getDBRouteKey());
        StringBuilder updateSQL = new StringBuilder();
        updateSQL.append("update ");
        updateSQL.append(obj.getDataEntityType().getAlias());
        updateSQL.append(" set fisdefaulttoorg = '0' ");
        updateSQL.append(" where ffromorgid = ?");
        updateSQL.append(" and ftyperelationid = ?");
        ArrayList<Object[]> params = new ArrayList<Object[]>(10);
        for (Long fromOrgId : list) {
            params.add(new Object[]{fromOrgId, 585511977942548480L});
        }
        DB.executeBatch((DBRoute)dbRoute, (String)updateSQL.toString(), params);
    }

    private List<Long> getCancelFromOrgList(BeginOperationTransactionArgs e, Set<Long> fromOrgIds) {
        DynamicObject obj;
        DynamicObjectCollection doc;
        List<Long> list = new ArrayList<Long>(10);
        if ("update".equals(this.getOption().getVariableValue(PARAM_SOURCE)) && !CollectionUtils.isEmpty((Collection)(doc = this.queryDefaultToOrgSettedFromOrg(obj = e.getDataEntities()[0])))) {
            list.add(this.getId(obj, "fromorg"));
        }
        if ("addnew".equals(this.getOption().getVariableValue(PARAM_SOURCE))) {
            list = this.queryDefaultToOrgSettedFromOrgList(fromOrgIds);
        }
        return list;
    }

    private DynamicObjectCollection queryDefaultToOrgSettedFromOrg(DynamicObject obj) {
        QFilter[] qFilters = new QFilter[]{new QFilter("fromorg", "=", (Object)this.getId(obj, "fromorg")), new QFilter("toorg", "!=", (Object)this.getId(obj, "toorg")), new QFilter(FIELD_ISDEFAULTTOORG, "=", (Object)"1"), new QFilter("typerelation", "=", (Object)585511977942548480L)};
        return QueryServiceHelper.query((String)"bos_org_orgrelation_dept", (String)"id", (QFilter[])qFilters);
    }

    private List<Long> getOrgRepeatDutyDatas(DynamicObject[] doc) {
        ArrayList<Long> lstReaptOrg = new ArrayList<Long>();
        HashSet<Long> orgIdSet = new HashSet<Long>();
        for (DynamicObject entry : doc) {
            Long toOrgId = this.getId(entry, "toorg");
            if (toOrgId <= 0L) continue;
            orgIdSet.add(toOrgId);
        }
        if (orgIdSet.isEmpty()) {
            return lstReaptOrg;
        }
        QFilter orgFilter = new QFilter("org", "in", orgIdSet);
        QFilter[] filters = new QFilter[]{orgFilter};
        String selectFields = "org,orgduty";
        DynamicObjectCollection orgDutyCol = QueryServiceHelper.query((String)"bos_org_dutyrelation", (String)selectFields, (QFilter[])filters);
        orgDutyCol.forEach(p -> lstReaptOrg.add(p.getLong("org")));
        return lstReaptOrg;
    }

    private Long getId(DynamicObject obj, String field) {
        if (obj.get(field) instanceof DynamicObject) {
            return ((DynamicObject)obj.get(field)).getLong("id");
        }
        if (obj.get(field) instanceof Long) {
            return obj.getLong(field);
        }
        return 0L;
    }

    private List<Long> queryDefaultToOrgSettedFromOrgList(ExtendedDataEntity[] dataEntities) {
        Set<Long> set = Arrays.stream(dataEntities).map(ext -> this.getId(ext.getDataEntity(), "fromorg")).collect(Collectors.toSet());
        return this.queryDefaultToOrgSettedFromOrgList(set);
    }

    private List<Long> queryDefaultToOrgSettedFromOrgList(Set<Long> fromOrgIds) {
        QFilter[] filters = this.newQFilters(fromOrgIds);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bos_org_orgrelation_dept", (String)"fromorg", (QFilter[])filters);
        return CollectionUtils.isEmpty((Collection)doc) ? new ArrayList<Long>() : doc.stream().map(e -> e.getLong("fromorg")).collect(Collectors.toList());
    }

    private Set<String> queryFromOrg_toOrgSet(ExtendedDataEntity[] dataEntities) {
        Set<Long> set = Arrays.stream(dataEntities).map(ext -> this.getId(ext.getDataEntity(), "fromorg")).collect(Collectors.toSet());
        QFilter[] filters = this.newQFilters(set);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bos_org_orgrelation_dept", (String)"fromorg,toorg", (QFilter[])filters);
        return CollectionUtils.isEmpty((Collection)doc) ? new HashSet<String>() : doc.stream().map(e -> e.getLong("fromorg") + "_" + e.getLong("toorg")).collect(Collectors.toSet());
    }

    private QFilter[] newQFilters(Set<Long> fromOrgIds) {
        QFilter[] filters = new QFilter[]{new QFilter("fromorg", "in", fromOrgIds), new QFilter(FIELD_ISDEFAULTTOORG, "=", (Object)"1"), new QFilter("typerelation", "=", (Object)585511977942548480L)};
        return filters;
    }

    private Boolean needValidate() {
        return !this.getOption().containsVariable(PARAM_SOURCE);
    }

    private class OrgDeptDutySaveOperateValidator
    extends AbstractValidator {
        private OrgDeptDutySaveOperateValidator() {
        }

        public void validate() {
            this.checkEmpty();
            this.validateUnique();
            this.validateDefaultDept();
        }

        private void checkEmpty() {
            StringBuilder sb = new StringBuilder();
            for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                DynamicObject orgDeptDutyObj = extendedDataEntity.getDataEntity();
                if (ObjectUtils.isEmpty((Object)orgDeptDutyObj.get("fromorg"))) {
                    sb.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143\u4e3a\u7a7a\u3002", (String)"OrgDeptDutySaveOperatePlugin_1", (String)"bos-org-formplugin", (Object[])new Object[0]));
                }
                if (ObjectUtils.isEmpty((Object)orgDeptDutyObj.get("toorg"))) {
                    sb.append(ResManager.loadKDString((String)"\u90e8\u95e8\u4e3a\u7a7a\u3002", (String)"OrgDeptDutySaveOperatePlugin_2", (String)"bos-org-formplugin", (Object[])new Object[0]));
                }
                if (sb.length() <= 0) continue;
                this.addErrorMessage(extendedDataEntity, sb.toString());
                sb.delete(0, sb.length());
            }
        }

        private void validateUnique() {
            HashSet<Long> primaryIdsInDB;
            HashMap<String, Long> fromOrg_toOrg2idMap;
            if (this.getOption().containsVariable(OrgDeptDutySaveOperatePlugin.PARAM_SOURCE) && "update".equals(this.getOption().getVariableValue(OrgDeptDutySaveOperatePlugin.PARAM_SOURCE))) {
                return;
            }
            try (DataSet rows = this.queryDataSet();){
                fromOrg_toOrg2idMap = new HashMap<String, Long>();
                primaryIdsInDB = new HashSet<Long>();
                rows.forEach(data -> {
                    fromOrg_toOrg2idMap.put(data.get("fromorg") + "_" + data.get("toorg"), data.getLong("id"));
                    primaryIdsInDB.add(data.getLong("id"));
                });
            }
            this.validateUniqueWithCurr(primaryIdsInDB);
            this.validateUniqueWithDB(fromOrg_toOrg2idMap);
        }

        private void validateUniqueWithDB(Map<String, Long> fromOrg_toOrg2idMap) {
            if (fromOrg_toOrg2idMap == null || fromOrg_toOrg2idMap.size() <= 0) {
                return;
            }
            if (this.getOption().containsVariable(OrgDeptDutySaveOperatePlugin.PARAM_SOURCE) && "addnew".equals(this.getOption().getVariableValue(OrgDeptDutySaveOperatePlugin.PARAM_SOURCE))) {
                StringJoiner sb = new StringJoiner("\uff0c");
                for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                    DynamicObject orgDeptDutyObj = extendedDataEntity.getDataEntity();
                    if (!this.existInDdWithId(orgDeptDutyObj, fromOrg_toOrg2idMap).booleanValue()) continue;
                    sb.add(orgDeptDutyObj.getDynamicObject("toorg").getString("number"));
                }
                if (sb.length() > 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u5355\u5143\u5df2\u5b58\u5728\u90e8\u95e8%s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgDeptDutySaveOperatePlugin_3", (String)"bos-org-formplugin", (Object[])new Object[0]), sb.toString()));
                }
            } else {
                for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                    DynamicObject orgDeptDutyObj = extendedDataEntity.getDataEntity();
                    if (!this.existInDdWithId(orgDeptDutyObj, fromOrg_toOrg2idMap).booleanValue() || fromOrg_toOrg2idMap.get(OrgDeptDutySaveOperatePlugin.this.getId(orgDeptDutyObj, "fromorg") + "_" + OrgDeptDutySaveOperatePlugin.this.getId(orgDeptDutyObj, "toorg")).toString().equals(extendedDataEntity.getBillPkId().toString())) continue;
                    String message = this.buildMessage(orgDeptDutyObj);
                    this.addErrorMessage(extendedDataEntity, message);
                }
            }
        }

        private void validateUniqueWithCurr(Set<Long> primaryIdsInDB) {
            HashMap<Long, Set> fromOrg2DataEntity = new HashMap<Long, Set>(this.getDataEntities().length);
            for (ExtendedDataEntity currExtendedDataEntity : this.getDataEntities()) {
                DynamicObject orgDeptDutyObj = currExtendedDataEntity.getDataEntity();
                if (primaryIdsInDB.contains(orgDeptDutyObj.getLong("id"))) continue;
                Long fromOrgId = OrgDeptDutySaveOperatePlugin.this.getId(orgDeptDutyObj, "fromorg");
                Long toOrgId = OrgDeptDutySaveOperatePlugin.this.getId(orgDeptDutyObj, "toorg");
                Set toOrgIds = fromOrg2DataEntity.computeIfAbsent(fromOrgId, k -> new HashSet());
                if (toOrgIds.contains(toOrgId)) {
                    String message = this.buildMessage(orgDeptDutyObj);
                    this.addErrorMessage(currExtendedDataEntity, message);
                    continue;
                }
                toOrgIds.add(toOrgId);
            }
        }

        private String buildMessage(DynamicObject orgDeptDutyObj) {
            return String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143%1$s\u5df2\u5b58\u5728\u90e8\u95e8%2$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgDeptDutySaveOperatePlugin_4", (String)"bos-org-formplugin", (Object[])new Object[0]), ObjectUtils.isEmpty((Object)orgDeptDutyObj.getDynamicObject("fromorg")) ? "" : orgDeptDutyObj.getDynamicObject("fromorg").getString("number"), ObjectUtils.isEmpty((Object)orgDeptDutyObj.getDynamicObject("toorg")) ? "" : orgDeptDutyObj.getDynamicObject("toorg").getString("number"));
        }

        private DataSet queryDataSet() {
            HashSet<Long> formOrgIds = new HashSet<Long>(this.getDataEntities().length);
            HashSet<Long> toOrgIds = new HashSet<Long>(this.getDataEntities().length);
            for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                DynamicObject obj = extendedDataEntity.getDataEntity();
                formOrgIds.add(OrgDeptDutySaveOperatePlugin.this.getId(obj, "fromorg"));
                toOrgIds.add(OrgDeptDutySaveOperatePlugin.this.getId(obj, "toorg"));
            }
            QFilter[] qFilters = new QFilter[]{new QFilter("fromorg", "in", formOrgIds), new QFilter("toorg", "in", toOrgIds), new QFilter("typerelation", "=", (Object)585511977942548480L)};
            ORM orm = ORM.create();
            return orm.queryDataSet("kd.bos.org.duty.OrgDeptDutySaveOperatePlugin", "bos_org_orgrelation_dept", "id,fromorg,toorg", qFilters);
        }

        private Boolean existInDdWithId(DynamicObject orgDeptDutyObj, Map<String, Long> fromOrg_toOrg2idMap) {
            String fromOrg_toOrg = OrgDeptDutySaveOperatePlugin.this.getId(orgDeptDutyObj, "fromorg") + "_" + OrgDeptDutySaveOperatePlugin.this.getId(orgDeptDutyObj, "toorg");
            return fromOrg_toOrg2idMap.containsKey(fromOrg_toOrg);
        }

        private void validateDefaultDept() {
            Boolean needValidate = OrgDeptDutySaveOperatePlugin.this.needValidate();
            if (!needValidate.booleanValue()) {
                return;
            }
            if (this.defaultCounts(Arrays.asList(this.getDataEntities())) <= 0L) {
                return;
            }
            Map<Long, List<ExtendedDataEntity>> fromOrg2toExtendedDataEntityMap = this.filterAndGroupByFromOrg();
            if (fromOrg2toExtendedDataEntityMap.size() <= 0) {
                return;
            }
            List list = OrgDeptDutySaveOperatePlugin.this.queryDefaultToOrgSettedFromOrgList(this.getDataEntities());
            Set fromOrg_toOrgSet = OrgDeptDutySaveOperatePlugin.this.queryFromOrg_toOrgSet(this.getDataEntities());
            for (Map.Entry<Long, List<ExtendedDataEntity>> next : fromOrg2toExtendedDataEntityMap.entrySet()) {
                DynamicObject orgDeptDutyObj;
                Long fromOrgId = next.getKey();
                List<ExtendedDataEntity> extendedDataEntities = next.getValue();
                if (list.contains(fromOrgId)) {
                    if (extendedDataEntities.size() <= 0) continue;
                    for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                        orgDeptDutyObj = extendedDataEntity.getDataEntity();
                        if (!orgDeptDutyObj.getBoolean(OrgDeptDutySaveOperatePlugin.FIELD_ISDEFAULTTOORG) || fromOrg_toOrgSet.contains(OrgDeptDutySaveOperatePlugin.this.getId(orgDeptDutyObj, "fromorg") + "_" + OrgDeptDutySaveOperatePlugin.this.getId(orgDeptDutyObj, "toorg"))) continue;
                        String message = orgDeptDutyObj.getDynamicObject("fromorg").getString("number");
                        this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143\u201c%s\u201d\u5df2\u5206\u914d\u4e86\u9ed8\u8ba4\u90e8\u95e8\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgDeptDutySaveOperatePlugin_0", (String)"bos-org-formplugin", (Object[])new Object[]{message}), new Object[0]));
                    }
                    continue;
                }
                if (extendedDataEntities.size() <= 1) continue;
                int index = 0;
                for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                    orgDeptDutyObj = extendedDataEntity.getDataEntity();
                    if (!orgDeptDutyObj.getBoolean(OrgDeptDutySaveOperatePlugin.FIELD_ISDEFAULTTOORG) || index++ < 1) continue;
                    String message = orgDeptDutyObj.getDynamicObject("fromorg").getString("number");
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143\u201c%s\u201d\u5df2\u5206\u914d\u4e86\u9ed8\u8ba4\u90e8\u95e8\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgDeptDutySaveOperatePlugin_0", (String)"bos-org-formplugin", (Object[])new Object[]{message}), new Object[0]));
                }
            }
        }

        private Map<Long, List<ExtendedDataEntity>> filterAndGroupByFromOrg() {
            HashMap<Long, List<ExtendedDataEntity>> fromOrg2toExtendedDataEntityMap = new HashMap<Long, List<ExtendedDataEntity>>(16);
            for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                DynamicObject orgDeptDutyObj = extendedDataEntity.getDataEntity();
                if (!orgDeptDutyObj.getBoolean(OrgDeptDutySaveOperatePlugin.FIELD_ISDEFAULTTOORG)) continue;
                List extendedDataEntities = fromOrg2toExtendedDataEntityMap.computeIfAbsent(OrgDeptDutySaveOperatePlugin.this.getId(orgDeptDutyObj, "fromorg"), k -> new ArrayList());
                extendedDataEntities.add(extendedDataEntity);
            }
            return fromOrg2toExtendedDataEntityMap;
        }

        private long defaultCounts(List<ExtendedDataEntity> extendedDataEntities) {
            return extendedDataEntities.stream().filter(ext -> ext.getDataEntity().getBoolean(OrgDeptDutySaveOperatePlugin.FIELD_ISDEFAULTTOORG)).count();
        }
    }
}

