/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.duty;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.org.model.OrgTreeSearchParam;
import kd.bos.org.utils.OrgTreeUtils;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class OrgDeptListPlugin
extends AbstractListPlugin
implements IFormPlugin,
ClickListener,
TreeNodeQueryListener,
TreeNodeClickListener,
SearchEnterListener {
    public static final Log log = LogFactory.getLog(OrgDeptListPlugin.class);
    public static final String KEY_TREE = "treeviewap";
    public static final String ENTITY_ORG_ORGRELATION = "bos_org_orgrelation";
    private static final String BOS_REFRESH = "bos_refresh";
    private static final String TYPE_RELATION = "typerelation";
    private static final String FROM_ORG = "fromorg";
    private static final String TO_ORG = "toorg";
    private static final String IS_DEFAULT_TO_ORG = "isdefaulttoorg";
    private static final String ROOT_NODE_CACHE_KEY = "root_node_cache_key";
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"OrgDeptListPlugin.ThreadPools", (int)4);
    private static final String SAVE_DEFAULT_ORG_EVENT = "saveDefaultOrgEvent";

    public void initialize() {
        super.initialize();
        TreeView tvLeft = (TreeView)this.getControl(KEY_TREE);
        tvLeft.addTreeNodeClickListener((TreeNodeClickListener)this);
        tvLeft.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void afterBindData(EventObject e) {
        boolean hasDelPerm;
        this.initTree();
        TreeView treev = (TreeView)this.getView().getControl(KEY_TREE);
        String currNodeId = treev.getTreeState().getFocusNodeId();
        this.loadDataEntity(currNodeId);
        this.getView().getModel().setDataChanged(false);
        boolean hasNewPerm = PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getView().getFormShowParameter().getAppId(), (String)"bos_org_dept", (String)"0=KX5+RHU1BB");
        if (!hasNewPerm) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblnew"});
        }
        if (!(hasDelPerm = PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getView().getFormShowParameter().getAppId(), (String)"bos_org_dept", (String)"0=KX5+RLFFVN"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tbldel"});
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        TreeView treeView = (TreeView)evt.getSource();
        treeView.expand(evt.getNodeId().toString());
        treeView.queryTreeNodeChildren(evt.getParentNodeId().toString(), evt.getNodeId().toString());
        this.loadDataEntity(evt.getNodeId().toString());
    }

    public void itemClick(ItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "tblnew": {
                this.showDeptScopeSet();
                break;
            }
            case "edit": {
                this.showDeptEdit();
                break;
            }
            case "tbldel": {
                this.removeDept();
                break;
            }
            case "btrefresh": {
                this.refresh();
                break;
            }
            case "btn_search": {
                this.showSearchForm();
                break;
            }
        }
    }

    private void showDeptScopeSet() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss style = new StyleCss();
        style.setHeight("500");
        style.setWidth("800");
        parameter.getOpenStyle().setInlineStyleCss(style);
        parameter.setFormId("bos_org_deptscopeset");
        TreeView tvLeft = (TreeView)this.getControl(KEY_TREE);
        String currNodeId = tvLeft.getTreeState().getFocusNodeId();
        parameter.setCustomParam("orgNodeId", (Object)currNodeId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BOS_REFRESH));
        this.getView().showForm(parameter);
    }

    private void showDeptEdit() {
        FormShowParameter dutyOpenParam = new FormShowParameter();
        dutyOpenParam.getOpenStyle().setShowType(ShowType.Modal);
        dutyOpenParam.setFormId("bos_org_deptedit");
        EntryGrid eg = (EntryGrid)this.getControl("entryentity");
        int[] rows = eg.getSelectRows();
        ArrayList<Long> lstOrg = new ArrayList<Long>();
        if (rows.length > 0) {
            for (int i : rows) {
                lstOrg.add(Long.valueOf(String.valueOf(((DynamicObject)this.getModel().getValue("org", i)).getPkValue())));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"OrgDeptListPlugin_0", (String)"bos-org-formplugin", (Object[])new Object[0]));
            return;
        }
        dutyOpenParam.setCustomParam("lstOrgs", lstOrg);
        dutyOpenParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BOS_REFRESH));
        this.getView().showForm(dutyOpenParam);
    }

    private void removeDept() {
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        int[] rowIndex = entryentity.getSelectRows();
        if (rowIndex.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"OrgDeptListPlugin_1", (String)"bos-org-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u79fb\u9664\u9009\u4e2d\u7684\u884c\u653f\u7ec4\u7ec7\u5417\uff1f", (String)"OrgDeptListPlugin_2", (String)"bos-org-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete"));
    }

    private void refresh() {
        TreeView treev = (TreeView)this.getView().getControl(KEY_TREE);
        String currNodeId = treev.getTreeState().getFocusNodeId();
        if (StringUtils.isNotBlank((CharSequence)currNodeId)) {
            treev.treeNodeClick("", currNodeId);
        }
    }

    private void showSearchForm() {
        String formId = "bos_org_orgrelation_dept";
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId(formId);
        para.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        para.getOpenStyle().setInlineStyleCss(css);
        FormConfig formConfig = FormMetadataCache.getListFormConfig((String)formId);
        para.setFormId(formConfig.getListFormId());
        para.setShowTitle(false);
        para.setHasRight(true);
        this.getView().showForm((FormShowParameter)para);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if (BOS_REFRESH.equals(actionId)) {
            TreeView tvLeft = (TreeView)this.getControl(KEY_TREE);
            String currNodeId = tvLeft.getTreeState().getFocusNodeId();
            this.loadDataEntity(currNodeId);
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent arg0) {
        String nodeId = arg0.getNodeId().toString();
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return;
        }
        TreeView tvLeft = (TreeView)this.getControl(KEY_TREE);
        OrgTreeParam param = new OrgTreeParam();
        param.setId(Long.parseLong(nodeId));
        param.setOrgViewId(15L);
        List treeChildren = OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param);
        tvLeft.addNodes(treeChildren);
        this.updateRootNodeCache(treeChildren);
    }

    private void updateRootNodeCache(List<TreeNode> treeChildren) {
        String rootNodeCache = this.getPageCache().get(ROOT_NODE_CACHE_KEY);
        if (StringUtils.isBlank((CharSequence)rootNodeCache)) {
            return;
        }
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeCache, TreeNode.class);
        rootNode.addChildren(treeChildren);
        this.getPageCache().put(ROOT_NODE_CACHE_KEY, SerializationUtils.toJsonString((Object)rootNode));
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        evt.getResult();
        if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            return;
        }
        String callBackId = evt.getCallBackId();
        if (!"delete".equals(callBackId)) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                TreeView tv = (TreeView)this.getControl(KEY_TREE);
                String orgId = tv.getTreeState().getFocusNodeId();
                this.deleteDutyRelation(orgId);
            }
            catch (Exception e) {
                h.markRollback();
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u79fb\u9664\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a%1$s", (String)"OrgDeptListPlugin_3", (String)"bos-org-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
        }
    }

    private void loadDataEntity(String currNodeId) {
        Map dutyMap;
        Map fullnameMap;
        this.getModel().deleteEntryData("entryentity");
        if (StringUtils.isBlank((CharSequence)currNodeId)) {
            return;
        }
        QFilter orgFilter = new QFilter(FROM_ORG, "=", (Object)Long.valueOf(currNodeId));
        QFilter typerelationFilter = new QFilter(TYPE_RELATION, "=", (Object)585511977942548480L);
        String selectFields = "toorg,typerelation,isdefaulttoorg";
        QFilter[] filters = new QFilter[]{orgFilter, typerelationFilter};
        DynamicObject[] relationObjArr = BusinessDataServiceHelper.load((String)ENTITY_ORG_ORGRELATION, (String)selectFields, (QFilter[])filters, (String)"isdefaulttoorg desc, toorg.number");
        if (relationObjArr == null) {
            return;
        }
        int count = relationObjArr.length;
        if (count == 0) {
            return;
        }
        ArrayList<Long> adminOrgIds = new ArrayList<Long>(count);
        for (DynamicObject relationObj : relationObjArr) {
            DynamicObject orgObj = relationObj.getDynamicObject(TO_ORG);
            if (orgObj == null) continue;
            adminOrgIds.add(orgObj.getLong("id"));
        }
        Future fullNameFuture = threadPool.submit(() -> this.getAdminOrgFullnameMap(adminOrgIds));
        Future dutyFuture = threadPool.submit(() -> this.getAdminOrgDutyMap(adminOrgIds));
        int row = 0;
        try {
            fullnameMap = (Map)fullNameFuture.get();
            dutyMap = (Map)dutyFuture.get();
        }
        catch (InterruptedException e) {
            log.error("\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
            return;
        }
        catch (ExecutionException e) {
            log.error("\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
            return;
        }
        this.getModel().beginInit();
        int[] newIndexArr = this.getModel().batchCreateNewEntryRow("entryentity", count);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject relationObj : relationObjArr) {
            DynamicObject rowObj = (DynamicObject)entryEntity.get(newIndexArr[row++]);
            DynamicObject orgObj = relationObj.getDynamicObject(TO_ORG);
            if (orgObj == null) continue;
            Long orgId = orgObj.getLong("id");
            rowObj.set("org", (Object)orgObj);
            rowObj.set(IS_DEFAULT_TO_ORG, relationObj.get(IS_DEFAULT_TO_ORG));
            rowObj.set("fullname", fullnameMap.get(orgId));
            rowObj.set("duty", dutyMap.get(orgId));
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private Map<Long, String> getAdminOrgFullnameMap(List<Long> adminOrgIds) {
        String selectFields = "id,org,fullname";
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter((String)"01");
        QFilter orgFilter = new QFilter("org", "in", adminOrgIds);
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter};
        HashMap<Long, String> fullnameMap = new HashMap<Long, String>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.bos.org.duty.OrgDeptListPlugin.getAdminOrgFullname", (String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"");){
            for (Row row : ds) {
                fullnameMap.put(row.getLong("org"), row.getString("fullname"));
            }
        }
        return fullnameMap;
    }

    private Map<Long, DynamicObject> getAdminOrgDutyMap(List<Long> adminOrgIds) {
        QFilter toorgFilter = new QFilter("org", "in", adminOrgIds);
        QFilter[] filters = new QFilter[]{toorgFilter};
        String selectFields = "org,orgduty";
        HashMap<Long, DynamicObject> dutyMap = new HashMap<Long, DynamicObject>(adminOrgIds.size());
        Map bizObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_duty", null);
        if (bizObjMap == null) {
            log.error("\u83b7\u53d6\u90e8\u95e8\u5c5e\u6027\u5931\u8d25\u3002");
            return dutyMap;
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.bos.org.duty.OrgDeptListPlugin.getAdminOrgDutyMap", (String)"bos_org_dutyrelation", (String)selectFields, (QFilter[])filters, (String)"");){
            for (Row row : ds) {
                dutyMap.put(row.getLong("org"), (DynamicObject)bizObjMap.get(row.getLong("orgduty")));
            }
        }
        return dutyMap;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search searchap = (Search)this.getView().getControl("searchap");
        if (searchap != null) {
            searchap.addEnterListener((SearchEnterListener)this);
        }
    }

    private void initTree() {
        TreeView tvLeft = (TreeView)this.getControl(KEY_TREE);
        tvLeft.deleteAllNodes();
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewId(15L);
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        if (rootNode == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u4e1a\u52a1\u5355\u5143\u6839\u7ec4\u7ec7\u5931\u8d25\u3002", (String)"OrgDeptListPlugin_4", (String)"bos-org-formplugin", (Object[])new Object[0]));
        }
        this.getPageCache().put(ROOT_NODE_CACHE_KEY, SerializationUtils.toJsonString((Object)rootNode));
        tvLeft.addNode(rootNode);
        tvLeft.focusNode(rootNode);
        tvLeft.queryTreeNodeChildren("", rootNode.getId());
    }

    private void deleteDutyRelation(String currNodeId) {
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        int[] rowIndex = entryentity.getSelectRows();
        ArrayList<Long> lstOrgs = new ArrayList<Long>();
        for (int i : rowIndex) {
            DynamicObject adminOrg = (DynamicObject)this.getModel().getValue("org", i);
            if (adminOrg == null) continue;
            lstOrgs.add(adminOrg.getLong("id"));
        }
        if (!lstOrgs.isEmpty()) {
            QFilter typerelationFilter = new QFilter(TYPE_RELATION, "=", (Object)585511977942548480L);
            QFilter fromorgFilter = new QFilter(FROM_ORG, "=", (Object)Long.valueOf(currNodeId));
            QFilter toorgFilter = new QFilter(TO_ORG, "in", lstOrgs);
            QFilter[] qFilter = new QFilter[]{typerelationFilter, fromorgFilter, toorgFilter};
            DeleteServiceHelper.delete((String)ENTITY_ORG_ORGRELATION, (QFilter[])qFilter);
        }
        this.getModel().deleteEntryRows("entryentity", rowIndex);
        entryentity.clearEntryState();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u79fb\u9664\u6210\u529f\u3002", (String)"OrgDeptListPlugin_5", (String)"bos-org-formplugin", (Object[])new Object[0]));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        if (IS_DEFAULT_TO_ORG.equals(proName)) {
            if ("1".equals(this.getPageCache().get(SAVE_DEFAULT_ORG_EVENT))) {
                this.getPageCache().remove(SAVE_DEFAULT_ORG_EVENT);
            } else {
                ChangeData changeData = e.getChangeSet()[0];
                int row = changeData.getRowIndex();
                this.setDefaultToOrg(row);
            }
        }
    }

    private void setDefaultToOrg(int row) {
        QFilter typerelationFilter;
        QFilter fromOrgFilter;
        DynamicObject selObj = this.getModel().getEntryRowEntity("entryentity", row);
        if (selObj == null) {
            return;
        }
        TreeView treev = (TreeView)this.getView().getControl(KEY_TREE);
        String currNodeId = treev.getTreeState().getFocusNodeId();
        boolean isDefault = selObj.getBoolean(IS_DEFAULT_TO_ORG);
        long toOrgId = selObj.getLong("org.id");
        QFilter isdefaulttoorgFilter = new QFilter(IS_DEFAULT_TO_ORG, "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{isdefaulttoorgFilter = isdefaulttoorgFilter.or(TO_ORG, "=", (Object)toOrgId), fromOrgFilter = new QFilter(FROM_ORG, "=", (Object)Long.valueOf(currNodeId)), typerelationFilter = new QFilter(TYPE_RELATION, "=", (Object)585511977942548480L)};
        DynamicObject[] lastDefaultOrg = BusinessDataServiceHelper.load((String)ENTITY_ORG_ORGRELATION, (String)"toorg,isdefaulttoorg", (QFilter[])filters);
        if (lastDefaultOrg == null || lastDefaultOrg.length == 0) {
            return;
        }
        try (TXHandle h = TX.required();){
            try {
                this.saveDefaultOrg(row, lastDefaultOrg, toOrgId, isDefault);
            }
            catch (Exception e) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38\uff1a%1$s", (String)"OrgDeptListPlugin_6", (String)"bos-org-formplugin", (Object[])new Object[0]), e.getMessage()));
                h.markRollback();
            }
        }
    }

    private void saveDefaultOrg(int row, DynamicObject[] lastDefaultOrg, long toOrgId, boolean isDefault) {
        for (DynamicObject dynamicObject : lastDefaultOrg) {
            DynamicObject toorgObj = dynamicObject.getDynamicObject(TO_ORG);
            if (toorgObj == null) continue;
            if (toOrgId == toorgObj.getLong("id")) {
                dynamicObject.set(IS_DEFAULT_TO_ORG, (Object)isDefault);
                continue;
            }
            dynamicObject.set(IS_DEFAULT_TO_ORG, (Object)Boolean.FALSE);
        }
        SaveServiceHelper.save((DynamicObject[])lastDefaultOrg);
        if (isDefault) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            int rowIndex = 0;
            for (DynamicObject rowObj : entryentity) {
                if (rowIndex != row && rowObj.getBoolean(IS_DEFAULT_TO_ORG)) {
                    this.getPageCache().put(SAVE_DEFAULT_ORG_EVENT, "1");
                    this.getModel().setValue(IS_DEFAULT_TO_ORG, (Object)Boolean.FALSE, rowIndex);
                }
                ++rowIndex;
            }
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        TreeView treeView = (TreeView)this.getControl(KEY_TREE);
        OrgTreeSearchParam searchParam = new OrgTreeSearchParam(searchEnterEvent.getText(), this.getView(), treeView, ROOT_NODE_CACHE_KEY, "15");
        searchParam.setClickNode(true);
        OrgTreeUtils.searchFromLazyOrgTree((OrgTreeSearchParam)searchParam);
    }
}

