/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.duty;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.duty.AbstractOrgRelationTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class OrgDeptTreeListPlugin
extends AbstractOrgRelationTreeListPlugin {
    private static final Log log = LogFactory.getLog(OrgDeptTreeListPlugin.class);
    public static final String BILLLISTAP = "billlistap";
    public static final String IS_DEFAULT_TO_ORG = "isdefaulttoorg";
    private Map<Long, DynamicObject> orgId2OrgDuty;

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        DynamicObject[] rows = e.getQueryValues();
        if (rows == null || rows[0] == null || rows.length < 1) {
            return;
        }
        DataEntityPropertyCollection properties = rows[0].getDynamicObjectType().getProperties();
        if (properties == null) {
            return;
        }
        if (properties.get((Object)"toorg_id") == null) {
            return;
        }
        if (properties.get((Object)"orgduty") == null) {
            return;
        }
        Map<Object, Object> adminOrgDutyMap = new HashMap(rows.length);
        List<Long> toOrgIds = Arrays.stream(rows).map(item -> item.getLong("toorg_id")).collect(Collectors.toList());
        if (!toOrgIds.isEmpty()) {
            adminOrgDutyMap = this.getAdminOrgDutyMap(toOrgIds);
        }
        for (DynamicObject row : rows) {
            row.set("orgduty", adminOrgDutyMap.get(row.getLong("toorg_id")));
        }
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection rows = e.getPageData();
        if (rows.getDynamicObjectType().getProperties().containsKey((Object)"toorg_id")) {
            ArrayList<Long> orgIds = new ArrayList<Long>();
            rows.forEach(obj -> orgIds.add(obj.getLong("toorg_id")));
            this.orgId2OrgDuty = this.getAdminOrgDutyMap(orgIds);
        }
        super.beforePackageData(e);
    }

    public void packageData(PackageDataEvent e) {
        AbstractColumnDesc source = (AbstractColumnDesc)e.getSource();
        if ("orgduty.name".equalsIgnoreCase(source.getFieldKey())) {
            if (null == this.orgId2OrgDuty || this.orgId2OrgDuty.size() <= 0) {
                return;
            }
            DynamicObject rowData = e.getRowData();
            DynamicObject orgDutyObj = this.orgId2OrgDuty.get(rowData.getLong("toorg_id"));
            if (null != orgDutyObj) {
                e.setFormatValue(orgDutyObj.get("name"));
            }
        }
        super.packageData(e);
    }

    private Map<Long, DynamicObject> getAdminOrgDutyMap(List<Long> adminOrgIds) {
        QFilter toorgFilter = new QFilter("org", "in", adminOrgIds);
        QFilter[] filters = new QFilter[]{toorgFilter};
        String selectFields = "org,orgduty";
        HashMap<Long, DynamicObject> dutyMap = new HashMap<Long, DynamicObject>(adminOrgIds.size());
        Map bizObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_duty", null);
        if (bizObjMap == null) {
            log.error("\u83b7\u53d6\u90e8\u95e8\u5c5e\u6027\u5931\u8d25\u3002");
            return dutyMap;
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.bos.org.duty.OrgDeptListPlugin.getAdminOrgDutyMap", (String)"bos_org_dutyrelation", (String)selectFields, (QFilter[])filters, (String)"");){
            for (Row row : ds) {
                dutyMap.put(row.getLong("org"), (DynamicObject)bizObjMap.get(row.getLong("orgduty")));
            }
        }
        return dutyMap;
    }
}

