/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.duty;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class OrgDutyRelationListPlugin
extends StandardTreeListPlugin {
    private static final Log logger = LogFactory.getLog(OrgDutyRelationListPlugin.class);

    public void refreshNode(RefreshNodeEvent e) {
        List<TreeNode> childNodes = null;
        String nodeId = e.getNodeId().toString();
        childNodes = this.getTreeModel().getRoot().getId().equals(nodeId) ? this.getOrgDutyGroup() : this.getOrgDuty(nodeId);
        e.setChildNodes(childNodes);
    }

    public void expendTreeNode(TreeNodeEvent e) {
        String nodeId = (String)e.getNodeId();
        TreeNode node = this.getTreeListView().getTreeModel().refreshNode((Object)nodeId);
        node.setIsOpened(true);
        e.setExpandedNode(node);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String groupNodeId = e.getNodeId().toString();
        this.treeListView.getTreeView().queryTreeNodeChildren(e.getParentNodeId().toString(), groupNodeId);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        e.setCancel(true);
        String nodeId = e.getNodeId().toString();
        if (!nodeId.equals(this.getTreeModel().getRoot().getId())) {
            e.addQFilter(OrgDutyRelationListPlugin.getFilterByNodeId(nodeId));
        }
    }

    private static QFilter getFilterByNodeId(String nodeId) {
        QFilter qFilter = null;
        String idSplit = "group_";
        if (nodeId.startsWith(idSplit)) {
            String groupId = nodeId.substring(idSplit.length());
            qFilter = new QFilter("orgduty.group", "=", (Object)Long.valueOf(groupId));
        } else {
            qFilter = new QFilter("orgduty", "=", (Object)Long.valueOf(nodeId));
        }
        return qFilter;
    }

    private boolean hasNewPermission() {
        return PermissionServiceHelper.hasNewPermission((long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)"bos_org_dutyrelation");
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (this.hasNewPermission() && "tblnew".equals(evt.getItemKey())) {
            boolean isNotSelectedDuty = false;
            Map<String, Object> focusNode = this.getFocusNode();
            if (focusNode == null) {
                isNotSelectedDuty = true;
            } else {
                Object nodeParentId = focusNode.get("parentid");
                if (StringUtils.isBlank((Object)nodeParentId) || "0".equals(nodeParentId.toString())) {
                    isNotSelectedDuty = true;
                }
            }
            if (isNotSelectedDuty) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ece\u5de6\u6811\u7684\u53f6\u5b50\u8282\u70b9\u4e2d\uff0c\u9009\u62e9\u4e1a\u52a1\u5c5e\u6027\u3002", (String)"OrgDutyRelationListPlugin_0", (String)"bos-org-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if (this.hasNewPermission() && "tblnew".equals(evt.getItemKey())) {
            this.showOrgF7();
        }
    }

    private void showOrgF7() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"bos_adminorg", (boolean)true);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bos_adminorg"));
        Map<String, Object> focusNode = this.getFocusNode();
        if (focusNode == null) {
            return;
        }
        Object nodeParentId = focusNode.get("parentid");
        if (StringUtils.isNotBlank((Object)nodeParentId)) {
            String selectFields = "org";
            String idSplit = "group_";
            String groupId = nodeParentId.toString().substring(idSplit.length());
            QFilter[] filters = new QFilter[]{new QFilter("orgduty.group", "=", (Object)Long.valueOf(groupId))};
            DynamicObjectCollection orgDutyCol = QueryServiceHelper.query((String)"bos_org_dutyrelation", (String)selectFields, (QFilter[])filters);
            if (Utils.isListNotEmpty((List)orgDutyCol)) {
                ArrayList<Long> orgIds = new ArrayList<Long>(orgDutyCol.size());
                for (DynamicObject orgDuty : orgDutyCol) {
                    orgIds.add(orgDuty.getLong("org"));
                }
                QFilter qFilter = new QFilter("id", "not in", orgIds);
                listShowParameter.getListFilterParameter().getQFilters().add(qFilter);
            }
        }
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if ("bos_adminorg".equals(evt.getActionId())) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)evt.getReturnData();
            this.addOrg(selectedRows);
        }
    }

    private void addOrg(ListSelectedRowCollection selectedRows) {
        if (selectedRows == null || selectedRows.isEmpty()) {
            return;
        }
        Map<String, Object> focusNode = this.getFocusNode();
        if (focusNode == null) {
            return;
        }
        Object orgDutyId = focusNode.get("id");
        DynamicObject[] dataEntities = new DynamicObject[selectedRows.size()];
        int index = 0;
        QFilter orgFilter = new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues());
        QFilter orgDutyFilter = new QFilter("id", "in", orgDutyId);
        Map id2orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_adminorg", (String)"org", (QFilter[])new QFilter[]{orgFilter});
        Map orgDutyIds = BusinessDataServiceHelper.loadFromCache((String)"bos_org_duty", (QFilter[])new QFilter[]{orgDutyFilter});
        for (ListSelectedRow row : selectedRows) {
            DynamicObject orgDuty = BusinessDataServiceHelper.newDynamicObject((String)"bos_org_dutyrelation");
            orgDuty.set("org", id2orgMap.get(row.getPrimaryKeyValue()));
            orgDuty.set("orgduty", orgDutyIds.get(Long.parseLong(orgDutyId.toString())));
            OrgViewUtils.genCommonField((DynamicObject)orgDuty, (boolean)true);
            dataEntities[index++] = orgDuty;
        }
        logger.info("\u8c03\u7528\u90e8\u95e8\u5c5e\u6027\u7ba1\u7406\u4fdd\u5b58\u64cd\u4f5c");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"bos_org_dutyrelation", (DynamicObject[])dataEntities, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65b0\u589e\u6210\u529f\u3002", (String)"OrgDutyRelationListPlugin_3", (String)"bos-org-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showOperationResult(operationResult);
        }
        this.treeListView.getTreeView().treeNodeClick(String.valueOf(focusNode.get("parentid")), String.valueOf(orgDutyId));
    }

    public void beforeShowBill(BeforeShowBillFormEvent arg0) {
        QFilter orgFilter;
        QFilter viewFilter;
        QFilter freezeFilter;
        QFilter[] qFilters;
        super.beforeShowBill(arg0);
        Object pkId = arg0.getParameter().getPkId();
        QFilter idFilter = new QFilter("id", "=", pkId);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject[] dutyObj = BusinessDataServiceHelper.load((String)"bos_org_dutyrelation", (String)"org", (QFilter[])filters);
        if (dutyObj == null || dutyObj.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"OrgDutyRelationListPlugin_1", (String)"bos-org-formplugin", (Object[])new Object[0]));
            arg0.setCancel(true);
            return;
        }
        DynamicObject orgObj = dutyObj[0].getDynamicObject("org");
        if (orgObj != null && QueryServiceHelper.exists((String)"bos_org_structure", (QFilter[])(qFilters = new QFilter[]{freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.TRUE), viewFilter = new QFilter("view", "=", (Object)1L), orgFilter = new QFilter("org", "=", orgObj.get("id"))}))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u95e8\u5df2\u5c01\u5b58\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"OrgDutyRelationListPlugin_2", (String)"bos-org-formplugin", (Object[])new Object[0]));
            arg0.setCancel(true);
        }
    }

    private Map<String, Object> getFocusNode() {
        Map focusNode = this.treeListView.getTreeView().getTreeState().getFocusNode();
        return focusNode;
    }

    private List<TreeNode> getOrgDutyGroup() {
        ArrayList<TreeNode> groupNodes = new ArrayList<TreeNode>();
        String selectFields = "id,name";
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{enableFilter};
        DynamicObjectCollection orgDutyGroupCol = QueryServiceHelper.query((String)"bos_org_dutygroup", (String)selectFields, (QFilter[])filters);
        if (Utils.isListEmpty((List)orgDutyGroupCol)) {
            return groupNodes;
        }
        String idSplit = "group_";
        for (DynamicObject group : orgDutyGroupCol) {
            TreeNode groupNode = new TreeNode();
            groupNode.setParentid("0");
            groupNode.setId(idSplit + group.getString("id"));
            groupNode.setText(group.getString("name"));
            groupNode.setChildren(new ArrayList());
            groupNode.setIsOpened(false);
            groupNodes.add(groupNode);
        }
        return groupNodes;
    }

    private List<TreeNode> getOrgDuty(String groupNodeId) {
        ArrayList<TreeNode> dutyNodes = new ArrayList<TreeNode>();
        String selectFields = "id,name";
        if (StringUtils.isBlank((CharSequence)groupNodeId)) {
            return dutyNodes;
        }
        String idSplit = "group_";
        if (!groupNodeId.startsWith(idSplit)) {
            return dutyNodes;
        }
        String groupId = groupNodeId.substring(idSplit.length());
        QFilter groupFilter = new QFilter("group", "=", (Object)Long.valueOf(groupId));
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{groupFilter, enableFilter};
        DynamicObjectCollection orgDutyCol = QueryServiceHelper.query((String)"bos_org_duty", (String)selectFields, (QFilter[])filters);
        if (Utils.isListEmpty((List)orgDutyCol)) {
            return dutyNodes;
        }
        for (DynamicObject dutyObj : orgDutyCol) {
            TreeNode dutyNode = new TreeNode();
            dutyNode.setParentid(groupNodeId);
            dutyNode.setId(dutyObj.getString("id"));
            dutyNode.setText(dutyObj.getString("name"));
            dutyNodes.add(dutyNode);
        }
        return dutyNodes;
    }
}

