/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.duty;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class OrgDutySaveValidator
extends AbstractValidator {
    private static final String GROUP = "orgduty.group";
    private static final String GROUP_NAME = "orgduty.group.name";
    private static final Log logger = LogFactory.getLog(OrgDutySaveValidator.class);

    public void validate() {
        HashMap<Long, Map<Long, ExtendedDataEntity>> orgDutyMap = new HashMap<Long, Map<Long, ExtendedDataEntity>>(this.dataEntities.length);
        this.validateData(orgDutyMap);
        this.validateDataBase(orgDutyMap);
    }

    private void validateData(Map<Long, Map<Long, ExtendedDataEntity>> orgDutyMap) {
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject groupObj;
            DynamicObject orgDutyObj = extendedDataEntity.getDataEntity();
            DynamicObject orgObj = orgDutyObj.getDynamicObject("org");
            if (orgObj == null) continue;
            long orgId = orgObj.getLong("id");
            DynamicObject existsdutyObj = orgDutyObj.getDynamicObject("orgduty");
            if (existsdutyObj == null || (groupObj = existsdutyObj.getDynamicObject("group")) == null) continue;
            long groupId = groupObj.getLong("id");
            Map orgDataEntityMap = orgDutyMap.computeIfAbsent(groupId, k -> new HashMap(this.dataEntities.length));
            ExtendedDataEntity dataEntity = (ExtendedDataEntity)orgDataEntityMap.get(orgId);
            if (dataEntity != null) {
                DynamicObject existsOrgDutyObj = dataEntity.getDataEntity();
                this.validateUnique(extendedDataEntity, existsOrgDutyObj);
                continue;
            }
            orgDataEntityMap.put(orgId, extendedDataEntity);
            orgDutyMap.put(groupId, orgDataEntityMap);
        }
    }

    private void validateDataBase(Map<Long, Map<Long, ExtendedDataEntity>> orgDutyMap) {
        for (Map.Entry<Long, Map<Long, ExtendedDataEntity>> entry : orgDutyMap.entrySet()) {
            QFilter orgFilter = new QFilter("org", "in", entry.getValue().keySet());
            QFilter groupFilter = new QFilter(GROUP, "in", (Object)entry.getKey());
            QFilter[] filters = new QFilter[]{groupFilter, orgFilter};
            String selectFields = "id,org,orgduty.name,orgduty.group.name";
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bos_org_dutyrelation", (String)selectFields, (QFilter[])filters);
            for (DynamicObject orgDutyObj : dynamicObjectCollection) {
                logger.info("OrgDutySaveValidator#validateDataBase,orgduty.name is {},orgduty.group.name is {}, org is {}", new Object[]{orgDutyObj.get("orgduty.name"), orgDutyObj.get(GROUP_NAME), orgDutyObj.get("org")});
                ExtendedDataEntity extendedDataEntity = entry.getValue().get(orgDutyObj.getLong("org"));
                this.validateUnique(extendedDataEntity, orgDutyObj);
            }
        }
    }

    private void validateUnique(ExtendedDataEntity extendedDataEntity, DynamicObject orgDutyObj) {
        long existsId = orgDutyObj.getLong("id");
        long id = extendedDataEntity.getDataEntity().getLong("id");
        logger.info("OrgDutySaveValidator#validateUnique:id is {},existsId is {}", (Object)id, (Object)existsId);
        if (existsId != id) {
            Object number = extendedDataEntity.getDataEntity().getDynamicObject("org").get("number");
            Object groupName = orgDutyObj.get(GROUP_NAME);
            String msg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c%2$s\u201d\u5206\u7ec4\u4e0b\u5df2\u5b58\u5728\u8be5\u7ec4\u7ec7\u3002", (String)"OrgDutySaveValidator_0", (String)"bos-org-formplugin", (Object[])new Object[0]), number, groupName);
            this.addErrorMessage(extendedDataEntity, msg);
        }
    }
}

