/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.duty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.duty.OrgRelationSaveValidator;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;

public class OrgRelationSaveOperatePlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(OrgRelationSaveOperatePlugin.class);
    private Map<Long, Map<Long, DynamicObject>> typeRelation2FromOrg2DefaultToOrgObj = new HashMap<Long, Map<Long, DynamicObject>>();
    private Map<Long, Map<Long, DynamicObject>> typeRelation2ToOrg2DefaultFromOrgObj = new HashMap<Long, Map<Long, DynamicObject>>();
    private Map<Object, DynamicObject> id2ExistDefaultToOrgObj;
    private Map<Object, DynamicObject> id2ExistDefaultFromOrgObj;
    private static final String FIELD_ISDEFAULTTOORG = "isdefaulttoorg";
    private static final String FIELD_ISDEFAULTFROMORG = "isdefaultfromorg";
    private static final String ENTITY_ORG_ORGRELATION_DEPT = "bos_org_orgrelation_dept";

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new OrgRelationSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        this.queryByTypeRelationFromOrgToOrg(e);
        this.retainOneDefaultToOrg(e);
        this.retainOneDefaultFromOrg(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        this.saveOrgDutyRelation(e);
    }

    private void queryByTypeRelationFromOrgToOrg(BeginOperationTransactionArgs e) {
        long fromOrgId;
        long typeRelationId;
        HashSet<Long> typeRelationIds = new HashSet<Long>(16);
        HashSet<Long> fromOrgIds = new HashSet<Long>(16);
        HashSet<Long> toOrgIds = new HashSet<Long>(16);
        for (DynamicObject orgRelationObj : e.getDataEntities()) {
            long relationId = this.getId(orgRelationObj, "typerelation");
            typeRelationIds.add(relationId);
            long fromOrgId2 = this.getId(orgRelationObj, "fromorg");
            fromOrgIds.add(fromOrgId2);
            long toOrgId = this.getId(orgRelationObj, "toorg");
            toOrgIds.add(toOrgId);
        }
        QFilter[] typeRelationFromOrgDefaultToOrgFilters = new QFilter[]{new QFilter("typerelation", "in", typeRelationIds), new QFilter("fromorg", "in", fromOrgIds), new QFilter(FIELD_ISDEFAULTTOORG, "=", (Object)"1")};
        QFilter[] typeRelationToOrgDefaultFromOrgFilters = new QFilter[]{new QFilter("typerelation", "in", typeRelationIds), new QFilter("toorg", "in", toOrgIds), new QFilter(FIELD_ISDEFAULTFROMORG, "=", (Object)"1")};
        this.id2ExistDefaultToOrgObj = BusinessDataServiceHelper.loadFromCache((String)ENTITY_ORG_ORGRELATION_DEPT, (QFilter[])typeRelationFromOrgDefaultToOrgFilters);
        for (Map.Entry<Object, DynamicObject> entry : this.id2ExistDefaultToOrgObj.entrySet()) {
            DynamicObject orgRelationObj = entry.getValue();
            typeRelationId = this.getId(orgRelationObj, "typerelation");
            fromOrgId = this.getId(orgRelationObj, "fromorg");
            Map fromOrg2DefaultToOrgObj = this.typeRelation2FromOrg2DefaultToOrgObj.computeIfAbsent(typeRelationId, v -> new HashMap(16));
            fromOrg2DefaultToOrgObj.put(fromOrgId, orgRelationObj);
        }
        this.id2ExistDefaultFromOrgObj = BusinessDataServiceHelper.loadFromCache((String)ENTITY_ORG_ORGRELATION_DEPT, (QFilter[])typeRelationToOrgDefaultFromOrgFilters);
        for (Map.Entry<Object, DynamicObject> entry : this.id2ExistDefaultFromOrgObj.entrySet()) {
            DynamicObject orgRelationObj = entry.getValue();
            typeRelationId = this.getId(orgRelationObj, "typerelation");
            fromOrgId = this.getId(orgRelationObj, "toorg");
            Map toOrg2DefaultFromOrgObj = this.typeRelation2ToOrg2DefaultFromOrgObj.computeIfAbsent(typeRelationId, v -> new HashMap(16));
            toOrg2DefaultFromOrgObj.put(fromOrgId, orgRelationObj);
        }
    }

    private void retainOneDefaultToOrg(BeginOperationTransactionArgs e) {
        HashMap<Long, Map<Long, DynamicObject>> typeRelation2FromOrg2Entity = new HashMap<Long, Map<Long, DynamicObject>>(16);
        this.retainOneDefaultToOrgInData(e, typeRelation2FromOrg2Entity);
        this.cancelOtherDefaultToOrgInDb(e, typeRelation2FromOrg2Entity);
    }

    private void retainOneDefaultToOrgInData(BeginOperationTransactionArgs e, Map<Long, Map<Long, DynamicObject>> typeRelation2FromOrg2Entity) {
        DynamicObject[] dataEntities;
        for (DynamicObject orgRelationObj : dataEntities = e.getDataEntities()) {
            boolean isDefaultToOrg = orgRelationObj.getBoolean(FIELD_ISDEFAULTTOORG);
            if (!isDefaultToOrg) continue;
            long typeRelationId = this.getId(orgRelationObj, "typerelation");
            long fromOrgId = this.getId(orgRelationObj, "fromorg");
            Map fromOrg2DynObjs = typeRelation2FromOrg2Entity.computeIfAbsent(typeRelationId, v -> new HashMap(16));
            DynamicObject duplicateDefaultToOrgObj = (DynamicObject)fromOrg2DynObjs.get(fromOrgId);
            if (duplicateDefaultToOrgObj != null) {
                duplicateDefaultToOrgObj.set(FIELD_ISDEFAULTTOORG, (Object)Boolean.FALSE);
            }
            fromOrg2DynObjs.put(fromOrgId, orgRelationObj);
        }
    }

    private void cancelOtherDefaultToOrgInDb(BeginOperationTransactionArgs e, Map<Long, Map<Long, DynamicObject>> typeRelation2ToOrg2Entity) {
        ArrayList<DynamicObject> defaultToOrgObjsInDb = new ArrayList<DynamicObject>();
        for (Map.Entry<Object, DynamicObject> id2DefaultToOrgObjEntry : this.id2ExistDefaultToOrgObj.entrySet()) {
            long fromOrgId;
            DynamicObject entity;
            DynamicObject existDefaultToOrgObj = id2DefaultToOrgObjEntry.getValue();
            long typeRelationId = this.getId(existDefaultToOrgObj, "typerelation");
            Map<Long, DynamicObject> fromOrg2Entity = typeRelation2ToOrg2Entity.get(typeRelationId);
            if (fromOrg2Entity == null || fromOrg2Entity.size() == 0 || (entity = fromOrg2Entity.get(fromOrgId = this.getId(existDefaultToOrgObj, "fromorg"))) == null || entity.getLong("id") == existDefaultToOrgObj.getLong("id")) continue;
            existDefaultToOrgObj.set(FIELD_ISDEFAULTTOORG, (Object)Boolean.FALSE);
            defaultToOrgObjsInDb.add(existDefaultToOrgObj);
        }
        if (defaultToOrgObjsInDb.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])defaultToOrgObjsInDb.toArray(new DynamicObject[defaultToOrgObjsInDb.size()]));
        }
    }

    private void retainOneDefaultFromOrg(BeginOperationTransactionArgs e) {
        HashMap<Long, Map<Long, DynamicObject>> typeRelation2ToOrg2Entity = new HashMap<Long, Map<Long, DynamicObject>>(16);
        this.retainOneDefaultFromOrgInData(e, typeRelation2ToOrg2Entity);
        this.cancelOtherDefaultFromOrgInDb(e, typeRelation2ToOrg2Entity);
    }

    private void retainOneDefaultFromOrgInData(BeginOperationTransactionArgs e, Map<Long, Map<Long, DynamicObject>> typeRelation2ToOrg2Entity) {
        DynamicObject[] dataEntities;
        for (DynamicObject orgRelationObj : dataEntities = e.getDataEntities()) {
            boolean isDefaultFromOrg = orgRelationObj.getBoolean(FIELD_ISDEFAULTFROMORG);
            if (!isDefaultFromOrg) continue;
            long typeRelationId = this.getId(orgRelationObj, "typerelation");
            long toOrgId = this.getId(orgRelationObj, "toorg");
            Map toOrg2Entity = typeRelation2ToOrg2Entity.computeIfAbsent(typeRelationId, v -> new HashMap(16));
            DynamicObject duplicateDefaultFromOrgObj = (DynamicObject)toOrg2Entity.get(toOrgId);
            if (duplicateDefaultFromOrgObj != null) {
                duplicateDefaultFromOrgObj.set(FIELD_ISDEFAULTFROMORG, (Object)Boolean.FALSE);
            }
            toOrg2Entity.put(toOrgId, orgRelationObj);
        }
    }

    private void cancelOtherDefaultFromOrgInDb(BeginOperationTransactionArgs e, Map<Long, Map<Long, DynamicObject>> typeRelation2ToOrg2Entity) {
        ArrayList<DynamicObject> defaultFromOrgObjsInDb = new ArrayList<DynamicObject>();
        for (Map.Entry<Object, DynamicObject> id2DefaultToOrgObjEntry : this.id2ExistDefaultFromOrgObj.entrySet()) {
            long toOrgId;
            DynamicObject entity;
            DynamicObject existDefaultFromOrgObj = id2DefaultToOrgObjEntry.getValue();
            long typeRelationId = this.getId(existDefaultFromOrgObj, "typerelation");
            Map<Long, DynamicObject> toOrg2Entity = typeRelation2ToOrg2Entity.get(typeRelationId);
            if (toOrg2Entity == null || toOrg2Entity.size() == 0 || (entity = toOrg2Entity.get(toOrgId = this.getId(existDefaultFromOrgObj, "toorg"))) == null || entity.getLong("id") == existDefaultFromOrgObj.getLong("id")) continue;
            existDefaultFromOrgObj.set(FIELD_ISDEFAULTFROMORG, (Object)Boolean.FALSE);
            defaultFromOrgObjsInDb.add(existDefaultFromOrgObj);
        }
        if (defaultFromOrgObjsInDb.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])defaultFromOrgObjsInDb.toArray(new DynamicObject[defaultFromOrgObjsInDb.size()]));
        }
    }

    private void saveOrgDutyRelation(EndOperationTransactionArgs e) {
        if (!this.isSaveOrgDutyRelation(e)) {
            return;
        }
        List<Long> lstOrgdutySetted = this.getOrgRepeatDutyDatas(e.getDataEntities());
        ArrayList<DynamicObject> dutyDatas = new ArrayList<DynamicObject>(e.getDataEntities().length);
        for (DynamicObject obj : e.getDataEntities()) {
            if (lstOrgdutySetted.contains(this.getId(obj, "toorg")) || this.getId(obj, "toorg") <= 0L || this.getId(obj, "orgduty") <= 0L) continue;
            DynamicObject orgDuty = BusinessDataServiceHelper.newDynamicObject((String)"bos_org_dutyrelation");
            orgDuty.set("org", obj.get("toorg"));
            orgDuty.set("orgduty", obj.get("orgduty"));
            OrgViewUtils.genCommonField((DynamicObject)orgDuty, (boolean)true);
            dutyDatas.add(orgDuty);
        }
        if (!dutyDatas.isEmpty()) {
            ORM orm = ORM.create();
            long[] ids = orm.genLongIds("bos_org_dutyrelation", dutyDatas.size());
            for (int i = 0; i < dutyDatas.size(); ++i) {
                ((DynamicObject)dutyDatas.get(i)).set("id", (Object)ids[i]);
            }
            OperationResult operationResult = SaveServiceHelper.saveOperate((String)"bos_org_dutyrelation", (DynamicObject[])dutyDatas.toArray(new DynamicObject[dutyDatas.size()]), (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess() || !CollectionUtils.isEmpty((Collection)operationResult.getAllErrorInfo())) {
                logger.info("OrgRelationSaveOperatePlugin#saveOrgDutyRelation fail Message is {},AllErrorInfo is {}", (Object)operationResult.getMessage(), (Object)operationResult.getAllErrorInfo());
            }
        }
    }

    private boolean isSaveOrgDutyRelation(EndOperationTransactionArgs e) {
        DynamicObject orgRelationObj = e.getDataEntities()[0];
        DynamicProperty property = orgRelationObj.getDynamicObjectType().getProperty("orgduty");
        if (property == null) {
            return false;
        }
        DynamicObject orgDutyObj = orgRelationObj.getDynamicObject("orgduty");
        return orgDutyObj != null;
    }

    private List<Long> getOrgRepeatDutyDatas(DynamicObject[] doc) {
        ArrayList<Long> lstReaptOrg = new ArrayList<Long>();
        HashSet<Long> orgIdSet = new HashSet<Long>();
        for (DynamicObject entry : doc) {
            Long toOrgId = this.getId(entry, "toorg");
            if (toOrgId <= 0L) continue;
            orgIdSet.add(toOrgId);
        }
        if (orgIdSet.isEmpty()) {
            return lstReaptOrg;
        }
        QFilter orgFilter = new QFilter("org", "in", orgIdSet);
        QFilter[] filters = new QFilter[]{orgFilter};
        String selectFields = "org,orgduty";
        DynamicObjectCollection orgDutyCol = QueryServiceHelper.query((String)"bos_org_dutyrelation", (String)selectFields, (QFilter[])filters);
        orgDutyCol.forEach(p -> lstReaptOrg.add(p.getLong("org")));
        return lstReaptOrg;
    }

    private long getId(Object obj, String field) {
        if (obj instanceof DynamicObject) {
            if (((DynamicObject)obj).get(field) instanceof DynamicObject) {
                return ((DynamicObject)((DynamicObject)obj).get(field)).getLong("id");
            }
            if (((DynamicObject)obj).get(field) instanceof Long) {
                return ((DynamicObject)obj).getLong(field);
            }
            return 0L;
        }
        if (obj instanceof Row) {
            return ((Row)obj).getLong(field);
        }
        return 0L;
    }
}

