/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.duty;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.CollectionUtils;

public class OrgRelationSaveValidator
extends AbstractValidator {
    protected static final String ENTITY_ORG_ORGRELATION = "bos_org_orgrelation";
    protected static final String FIELD_ISDEFAULTTOORG = "isdefaulttoorg";
    protected static final String FIELD_ISDEFAULTFROMORG = "isdefaultfromorg";
    protected static final String PARAM_SOURCE = "source";
    private Map<String, Long> typeRelationFromOrgToOrg2RelationIdMap = new HashMap<String, Long>();
    private Set<Long> relationPksInDB = new HashSet<Long>();
    private Map<Long, Map<Long, Map<Long, ExtendedDataEntity>>> typeRelationFromOrgToOrgExtDataEntityMap = new HashMap<Long, Map<Long, Map<Long, ExtendedDataEntity>>>(16);
    private Map<String, List<Long>> fromType2HasDutyOrgIds = new HashMap<String, List<Long>>();
    private Map<String, List<Long>> toType2HasDutyOrgIds = new HashMap<String, List<Long>>();
    private Map<String, DynamicObject> number2FunctionObj = new HashMap<String, DynamicObject>();

    public void validate() {
        this.beforeValidate();
        this.validateUnique();
        this.validateOrgDuty();
    }

    private void validateUnique() {
        this.validateUniqueWithCurr();
        this.validateUniqueWithDB();
    }

    private void beforeValidate() {
        HashMap<String, Set<Long>> fromType2DutyOrgIds = new HashMap<String, Set<Long>>(8);
        HashMap<String, Set<Long>> toType2DutyOrgIds = new HashMap<String, Set<Long>>(8);
        HashSet<Long> typeRelationIds = new HashSet<Long>(16);
        HashSet<Long> fromOrgIds = new HashSet<Long>(16);
        HashSet<Long> toOrgIds = new HashSet<Long>(16);
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject orgRelationObj = extendedDataEntity.getDataEntity();
            long relationId = this.getId(orgRelationObj, "typerelation");
            long fromOrgId = this.getId(orgRelationObj, "fromorg");
            long toOrgId = this.getId(orgRelationObj, "toorg");
            if (this.isEmpty(relationId, fromOrgId, toOrgId)) continue;
            typeRelationIds.add(relationId);
            fromOrgIds.add(fromOrgId);
            toOrgIds.add(toOrgId);
            DynamicObject typeRelationObj = orgRelationObj.getDynamicObject("typerelation");
            this.putMap(fromType2DutyOrgIds, typeRelationObj.getString("fromtype"), fromOrgId);
            this.putMap(toType2DutyOrgIds, typeRelationObj.getString("totype"), toOrgId);
        }
        this.queryByTypeRelationFromOrgToOrg(typeRelationIds, fromOrgIds, toOrgIds);
        this.queryDutyOrgIds(fromType2DutyOrgIds, toType2DutyOrgIds);
    }

    private void putMap(Map<String, Set<Long>> fromType2DutyOrgIds, String key, long orgId) {
        Set dutyFromOrgIds = fromType2DutyOrgIds.computeIfAbsent(key, v -> new HashSet());
        dutyFromOrgIds.add(orgId);
    }

    private void queryByTypeRelationFromOrgToOrg(Set<Long> typeRelationIds, Set<Long> fromOrgIds, Set<Long> toOrgIds) {
        QFilter[] qFilters = new QFilter[]{new QFilter("fromorg", "in", fromOrgIds), new QFilter("toorg", "in", toOrgIds), new QFilter("typerelation", "in", typeRelationIds)};
        ORM orm = ORM.create();
        try (DataSet dataSet = orm.queryDataSet("kd.bos.org.duty.OrgDeptDutySaveOperatePlugin", ENTITY_ORG_ORGRELATION, "id,typerelation,fromorg,toorg", qFilters);){
            dataSet.forEach(row -> {
                this.relationPksInDB.add(row.getLong("id"));
                this.typeRelationFromOrgToOrg2RelationIdMap.put(this.getCombinationFiledId(row, "typerelation", "fromorg", "toorg"), row.getLong("id"));
            });
        }
    }

    private void queryDutyOrgIds(Map<String, Set<Long>> fromType2OrgIds, Map<String, Set<Long>> toType2OrgIds) {
        HashSet<String> functionNumbers = new HashSet<String>(16);
        for (Map.Entry<String, Set<Long>> fromType2OrgIdsEntry : fromType2OrgIds.entrySet()) {
            String fromType = fromType2OrgIdsEntry.getKey();
            List dutyFromOrgIds = OrgUnitServiceHelper.filterOrgDuty(new ArrayList(fromType2OrgIdsEntry.getValue()), (String)fromType);
            this.fromType2HasDutyOrgIds.put(fromType2OrgIdsEntry.getKey(), dutyFromOrgIds);
            functionNumbers.add(fromType);
        }
        for (Map.Entry<String, Set<Long>> toType2OrgIdsEntry : toType2OrgIds.entrySet()) {
            String toType = toType2OrgIdsEntry.getKey();
            List dutyToOrgIds = OrgUnitServiceHelper.filterOrgDuty(new ArrayList(toType2OrgIdsEntry.getValue()), (String)toType);
            this.toType2HasDutyOrgIds.put(toType2OrgIdsEntry.getKey(), dutyToOrgIds);
            functionNumbers.add(toType);
        }
        DynamicObjectCollection bizObjDoc = QueryServiceHelper.query((String)"bos_org_biz", (String)"fnumber,fname", (QFilter[])new QFilter[]{new QFilter("fnumber", "in", functionNumbers)});
        for (DynamicObject bizObj : bizObjDoc) {
            this.number2FunctionObj.put(bizObj.getString("fnumber"), bizObj);
        }
    }

    private void validateUniqueWithDB() {
        if (this.typeRelationFromOrgToOrgExtDataEntityMap == null || this.typeRelationFromOrgToOrgExtDataEntityMap.size() <= 0) {
            return;
        }
        if ("addnew".equals(this.getOption().getVariableValue(PARAM_SOURCE, ""))) {
            this.validateUniqueWithDBWhenNewBatch();
        } else {
            for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                DynamicObject orgDeptDutyObj = extendedDataEntity.getDataEntity();
                if (!this.existInDdWithId(orgDeptDutyObj).booleanValue() || this.typeRelationFromOrgToOrg2RelationIdMap.get(this.getCombinationFiledId(orgDeptDutyObj, "typerelation", "fromorg", "toorg")).toString().equals(orgDeptDutyObj.getPkValue().toString())) continue;
                String message = this.buildDuplicateErrorMsg(orgDeptDutyObj);
                this.addErrorMessage(extendedDataEntity, message);
            }
        }
    }

    protected void validateUniqueWithDBWhenNewBatch() {
        StringJoiner sj = new StringJoiner(System.getProperty("line.separator"));
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject orgDeptDutyObj = extendedDataEntity.getDataEntity();
            if (!this.existInDdWithId(orgDeptDutyObj).booleanValue()) continue;
            sj.add(this.buildDuplicateErrorMsg(orgDeptDutyObj));
        }
        if (sj.length() > 0) {
            throw new KDBizException(sj.toString());
        }
    }

    protected Boolean existInDdWithId(DynamicObject orgRelationObj) {
        String combinationFieldId = this.getCombinationFiledId(orgRelationObj, "typerelation", "fromorg", "toorg");
        return this.typeRelationFromOrgToOrg2RelationIdMap.containsKey(combinationFieldId);
    }

    private void validateUniqueWithCurr() {
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject orgRelationObj = extendedDataEntity.getDataEntity();
            long relationId = orgRelationObj.getLong("id");
            if (this.relationPksInDB.contains(relationId)) continue;
            long typeRelationId = this.getId(orgRelationObj, "typerelation");
            long fromOrgId = this.getId(orgRelationObj, "fromorg");
            long toOrgId = this.getId(orgRelationObj, "toorg");
            if (this.isEmpty(typeRelationId, fromOrgId, toOrgId)) continue;
            Map fromOrgToOrgExtDataEntityMap = this.typeRelationFromOrgToOrgExtDataEntityMap.computeIfAbsent(typeRelationId, k -> new HashMap(16));
            Map toOrgExtDataEntityMap = fromOrgToOrgExtDataEntityMap.computeIfAbsent(fromOrgId, k -> new HashMap(16));
            ExtendedDataEntity existExtendedDataEntity = (ExtendedDataEntity)toOrgExtDataEntityMap.get(toOrgId);
            if (existExtendedDataEntity != null) {
                this.addErrorMessage(extendedDataEntity, this.buildDuplicateErrorMsg(orgRelationObj));
                continue;
            }
            toOrgExtDataEntityMap.put(toOrgId, extendedDataEntity);
            fromOrgToOrgExtDataEntityMap.put(fromOrgId, toOrgExtDataEntityMap);
            this.typeRelationFromOrgToOrgExtDataEntityMap.put(typeRelationId, fromOrgToOrgExtDataEntityMap);
        }
    }

    private void validateOrgDuty() {
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject orgRelationObj = extendedDataEntity.getDataEntity();
            long typeRelationId = this.getId(orgRelationObj, "typerelation");
            long fromOrgId = this.getId(orgRelationObj, "fromorg");
            long toOrgId = this.getId(orgRelationObj, "toorg");
            if (this.isEmpty(typeRelationId, fromOrgId, toOrgId)) continue;
            if (!this.isOrgHasDuty(this.fromType2HasDutyOrgIds, orgRelationObj, "fromtype", fromOrgId)) {
                this.addErrorMessage(extendedDataEntity, this.buildOrgNoFunctionErrorMsg("fromorg", orgRelationObj));
            }
            if (this.isOrgHasDuty(this.toType2HasDutyOrgIds, orgRelationObj, "totype", toOrgId)) continue;
            this.addErrorMessage(extendedDataEntity, this.buildOrgNoFunctionErrorMsg("toorg", orgRelationObj));
        }
    }

    private boolean isOrgHasDuty(Map<String, List<Long>> type2HasDutyOrgIds, DynamicObject orgRelationObj, String typeFiled, long fromOrgId) {
        DynamicObject typeRelationObj = orgRelationObj.getDynamicObject("typerelation");
        String type = typeRelationObj.getString(typeFiled);
        List<Long> dutyOrgIds = type2HasDutyOrgIds.get(type);
        if (CollectionUtils.isEmpty(dutyOrgIds)) {
            return false;
        }
        return dutyOrgIds.contains(fromOrgId);
    }

    private String buildOrgNoFunctionErrorMsg(String type, DynamicObject orgRelationObj) {
        DynamicObject org = orgRelationObj.getDynamicObject(type);
        String orgNumber = org != null ? org.getString("number") : "";
        DynamicObject typeRelationObj = orgRelationObj.getDynamicObject("typerelation");
        if ("fromorg".equals(type)) {
            String functionName = this.getFunctionNameByType(typeRelationObj, "fromtype");
            return String.format(ResManager.loadKDString((String)"\u59d4\u6258\u7ec4\u7ec7\u201c%1$s\u201d\u6ca1\u6709\u201c%2$s\u201d\u804c\u80fd\u3002", (String)"OrgRelationSaveValidator_2", (String)"bos-org-formplugin", (Object[])new Object[0]), orgNumber, functionName);
        }
        if ("toorg".equals(type)) {
            String functionName = this.getFunctionNameByType(typeRelationObj, "totype");
            return String.format(ResManager.loadKDString((String)"\u53d7\u6258\u7ec4\u7ec7\u201c%1$s\u201d\u6ca1\u6709\u201c%2$s\u201d\u804c\u80fd\u3002", (String)"OrgRelationSaveValidator_3", (String)"bos-org-formplugin", (Object[])new Object[0]), orgNumber, functionName);
        }
        return "";
    }

    private String getFunctionNameByType(DynamicObject typeRelationObj, String type) {
        String functionNumber = typeRelationObj != null ? typeRelationObj.getString(type) : "";
        DynamicObject functionObj = this.number2FunctionObj.get(functionNumber);
        return functionObj != null ? functionObj.getString("fname") : "";
    }

    private String buildDuplicateErrorMsg(DynamicObject orgRelationObj) {
        String toOrgNumber;
        Long id = this.getId(orgRelationObj, "typerelation");
        String fromOrgNumber = orgRelationObj.getDynamicObject("fromorg") != null ? orgRelationObj.getDynamicObject("fromorg").getString("number") : "";
        String string = toOrgNumber = orgRelationObj.getDynamicObject("toorg") != null ? orgRelationObj.getDynamicObject("toorg").getString("number") : "";
        if (id.compareTo(585511977942548480L) == 0) {
            return String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143\u201c%1$s\u201d\u548c\u90e8\u95e8\u201c%2$s\u201d\u7684\u7ec4\u5408\u503c\u5df2\u5b58\u5728\u3002", (String)"OrgRelationSaveValidator_1", (String)"bos-org-formplugin", (Object[])new Object[0]), fromOrgNumber, toOrgNumber);
        }
        String typeRelationName = orgRelationObj.getDynamicObject("typerelation") != null ? orgRelationObj.getDynamicObject("typerelation").getLocaleString("name").getLocaleValue() : "";
        return String.format(ResManager.loadKDString((String)"\u5728\u534f\u4f5c\u5173\u7cfb\u7c7b\u578b\u201c%1$s\u201d\u4e2d\uff0c\u59d4\u6258\u7ec4\u7ec7\u201c%2$s\u201d\u548c\u53d7\u6258\u7ec4\u7ec7\u201c%3$s\u201d\u7684\u7ec4\u5408\u503c\u5df2\u5b58\u5728\u3002", (String)"OrgRelationSaveValidator_0", (String)"bos-org-formplugin", (Object[])new Object[0]), typeRelationName, fromOrgNumber, toOrgNumber);
    }

    private String getCombinationFiledId(Object orgRelationObj, String ... fields) {
        StringJoiner sj = new StringJoiner("_");
        for (String field : fields) {
            sj.add(this.getId(orgRelationObj, field) + "");
        }
        return sj.toString();
    }

    private Long getId(Object obj, String field) {
        if (obj instanceof DynamicObject) {
            if (((DynamicObject)obj).get(field) instanceof DynamicObject) {
                return ((DynamicObject)((DynamicObject)obj).get(field)).getLong("id");
            }
            if (((DynamicObject)obj).get(field) instanceof Long) {
                return ((DynamicObject)obj).getLong(field);
            }
            return 0L;
        }
        if (obj instanceof Row) {
            return ((Row)obj).getLong(field);
        }
        return 0L;
    }

    private boolean isEmpty(long ... ids) {
        for (long id : ids) {
            if (id != 0L) continue;
            return true;
        }
        return false;
    }
}

