/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin.check;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgSeparation;
import kd.bos.org.opplugin.IOrgOpValidatorHandler;
import kd.bos.org.opplugin.model.OrgOpContext;
import kd.bos.org.opplugin.save.OrgValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class OrgHealthCheckValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(OrgHealthCheckValidator.class);
    private final OrgOpContext orgOpContext;
    private Map<Long, ExtendedDataEntity> dataEntityMap;
    private final IOrgOpValidatorHandler validatorHandler;
    private StringBuilder inIdFilterSql;
    private Object[] inIdFilterParams;

    public OrgHealthCheckValidator(OrgOpContext orgOpContext) {
        this.orgOpContext = orgOpContext;
        this.validatorHandler = (dataEntity, errorMsg) -> this.addErrorMessage(dataEntity, errorMsg);
        this.orgOpContext.setValidatorHandler(this.validatorHandler);
    }

    public void validate() {
        logger.info("\u3010\u7ec4\u7ec7\u5065\u5eb7\u68c0\u67e5\u3011\u6267\u884c\u7ec4\u7ec7\u5065\u5eb7\u68c0\u67e5\uff1a" + this.dataEntities.length);
        this.initOrgDataEntity();
        this.validateHealthCheckRule();
        OrgValidator validator = new OrgValidator(this.orgOpContext, this.dataEntities, false);
        validator.validate();
    }

    private void initOrgDataEntity() {
        this.dataEntityMap = new HashMap<Long, ExtendedDataEntity>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.dataEntityMap.put(dataEntity.getDataEntity().getLong("id"), dataEntity);
        }
        Set<Long> ids = this.dataEntityMap.keySet();
        Map orgObjMap = BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(new Object[ids.size()]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_adminorg"));
        if (CollectionUtils.isEmpty((Map)orgObjMap)) {
            throw new KDBizException(BaseMessage.getMessage((String)"M00062"));
        }
        this.getValidateResult().setBillCount(orgObjMap.size());
        int index = 0;
        this.inIdFilterSql = new StringBuilder(" in (");
        this.inIdFilterParams = new Object[this.dataEntityMap.size()];
        for (Map.Entry orgEntry : orgObjMap.entrySet()) {
            DynamicObject orgObj = (DynamicObject)orgEntry.getValue();
            long orgId = orgObj.getLong("id");
            ExtendedDataEntity dataEntity = this.dataEntityMap.get(orgId);
            if (dataEntity == null) {
                throw new KDBizException(BaseMessage.getMessage((String)"M00062"));
            }
            dataEntity.setDataEntity(orgObj);
            if (index > 0) {
                this.inIdFilterSql.append(",");
            }
            this.inIdFilterSql.append("?");
            this.inIdFilterParams[index++] = orgId;
        }
        this.inIdFilterSql.append(") ");
    }

    private void validateHealthCheckRule() {
        this.validateBizProperty();
        this.validateLeaf();
        this.validateStructureProperty();
        this.validateFullNameUnique();
    }

    private void validateBizProperty() {
        Map viewDynamicObjectMap = this.orgOpContext.getDataProvider().getViewDynamicObjectMap();
        Map<String, DynamicObject> allBizPropertyMap = this.getAllBizPropertyMap(viewDynamicObjectMap);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject orgObj = dataEntity.getDataEntity();
            HashMap<String, DynamicObject> checkedPropertyMap = new HashMap<String, DynamicObject>(allBizPropertyMap.size());
            for (Map.Entry<String, DynamicObject> entry : allBizPropertyMap.entrySet()) {
                if (!orgObj.getBoolean(entry.getKey())) continue;
                DynamicObject viewObj = entry.getValue();
                checkedPropertyMap.put(entry.getKey(), viewObj);
            }
            Boolean isBizOrg = Boolean.FALSE;
            DynamicObjectCollection structureObjCol = orgObj.getDynamicObjectCollection("structure");
            HashSet<String> checkedProperties = new HashSet<String>(checkedPropertyMap.size());
            for (DynamicObject structureObj : structureObjCol) {
                String propertyName;
                DynamicObject viewObj = structureObj.getDynamicObject("view");
                if (viewObj == null) {
                    this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00002"));
                    continue;
                }
                if ((viewObj = (DynamicObject)viewDynamicObjectMap.get(viewObj.getPkValue())) == null) {
                    this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00016"));
                    continue;
                }
                DynamicObject bizObj = viewObj.getDynamicObject("treetypeid");
                if (bizObj == null) {
                    this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00155", (Object[])new Object[]{viewObj.getString("name")}));
                    continue;
                }
                if (!isBizOrg.booleanValue()) {
                    isBizOrg = bizObj != null && "1".equals(bizObj.getString("category"));
                }
                if (StringUtils.isBlank((CharSequence)(propertyName = bizObj.getString("propertyname"))) || checkedProperties.contains(propertyName)) continue;
                if (checkedPropertyMap.remove(propertyName) == null) {
                    this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00156", (Object[])new Object[]{viewObj.getString("name"), bizObj.getString("fname")}));
                    continue;
                }
                checkedProperties.add(propertyName);
            }
            for (Map.Entry entry : checkedPropertyMap.entrySet()) {
                this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00157", (Object[])new Object[]{((DynamicObject)entry.getValue()).getString("name"), ((DynamicObject)entry.getValue()).getDynamicObject("treetypeid").getString("fname")}));
            }
            this.validateBizOrg(dataEntity, isBizOrg);
        }
    }

    private void validateBizOrg(ExtendedDataEntity dataEntity, Boolean isBizOrg) {
        if (isBizOrg.equals(dataEntity.getDataEntity().getBoolean("isbizorg"))) {
            return;
        }
        if (isBizOrg.booleanValue()) {
            this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00158"));
        } else {
            this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00159"));
        }
    }

    private Map<String, DynamicObject> getAllBizPropertyMap(Map<Object, DynamicObject> viewDynamicObjectMap) {
        HashMap<String, DynamicObject> propertiesMap = new HashMap<String, DynamicObject>(viewDynamicObjectMap.size());
        DataEntityPropertyCollection orgProperties = this.dataEntities[0].getDataEntity().getDynamicObjectType().getProperties();
        for (Map.Entry<Object, DynamicObject> viewEntry : viewDynamicObjectMap.entrySet()) {
            String propertyName;
            DynamicObject bizObj = viewEntry.getValue().getDynamicObject("treetypeid");
            if (bizObj == null || !StringUtils.isNotBlank((CharSequence)(propertyName = bizObj.getString("propertyname"))) || orgProperties.get((Object)propertyName) == null) continue;
            propertiesMap.put(propertyName, viewEntry.getValue());
        }
        return propertiesMap;
    }

    private void validateLeaf() {
        try {
            StringBuilder whereSql = new StringBuilder(" where p.forgid");
            whereSql.append((CharSequence)this.inIdFilterSql);
            String leafSql = "select p.fviewid viewId,p.forgid org from t_org_structure p " + whereSql + " and  p.fisleaf = '0' and not EXISTS(select fparentid from (select c.fparentid,c.FVIEWID from t_org_structure c) as tmp where tmp.fviewid = p.fviewid and p.forgid = tmp.fparentid)";
            this.validateLeaf(leafSql, this.inIdFilterParams, true);
            leafSql = "select p.fviewid viewId,p.forgid org from t_org_structure p " + whereSql + " and p.fisleaf = '1' and EXISTS(select fparentid from (select c.fparentid,c.FVIEWID from t_org_structure c) as tmp where tmp.fviewid = p.fviewid and p.forgid = tmp.fparentid)";
            this.validateLeaf(leafSql, this.inIdFilterParams, false);
        }
        catch (Exception e) {
            logger.error("\u3010\u7ec4\u7ec7\u5065\u5eb7\u68c0\u67e5\u3011\u6821\u9a8c\u7ec4\u7ec7\u53f6\u5b50\u8282\u70b9\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    private void validateLeaf(String sql, Object[] params, boolean isLeaf) {
        Map viewDynamicObjectMap = this.orgOpContext.getDataProvider().getViewDynamicObjectMap();
        DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, resultSet -> {
            while (resultSet.next()) {
                long viewId;
                DynamicObject viewObj;
                long orgId = resultSet.getLong("org");
                ExtendedDataEntity dataEntity = this.dataEntityMap.get(orgId);
                if (dataEntity == null || (viewObj = (DynamicObject)viewDynamicObjectMap.get(viewId = resultSet.getLong("viewId"))) == null) continue;
                if (isLeaf) {
                    this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00160", (Object[])new Object[]{dataEntity.getDataEntity().getString("name"), viewObj.getString("name")}));
                    continue;
                }
                this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00161", (Object[])new Object[]{dataEntity.getDataEntity().getString("name"), viewObj.getString("name")}));
            }
            return null;
        });
    }

    private void validateStructureProperty() {
        OrgSeparation orgSeparation = this.orgOpContext.getConfigProvider().getOrgSeparation();
        String longNumberSep = orgSeparation.getLongNumberSep();
        String fullNameSep = orgSeparation.getFullNameSep();
        Map languageNameMap = this.orgOpContext.getDataProvider().getLanguageNameMap();
        for (Map.Entry<Long, ExtendedDataEntity> entry : this.dataEntityMap.entrySet()) {
            ExtendedDataEntity dataEntity = entry.getValue();
            DynamicObject orgObj = dataEntity.getDataEntity();
            String number = orgObj.getString("number");
            ILocaleString nameLocale = orgObj.getLocaleString("name");
            DynamicObjectCollection structureObjCol = orgObj.getDynamicObjectCollection("structure");
            for (DynamicObject structureObj : structureObjCol) {
                DynamicObject viewObj = structureObj.getDynamicObject("view");
                if (viewObj == null) continue;
                this.validateLongNumber(number, dataEntity, structureObj, longNumberSep);
                this.validateFullName(nameLocale, dataEntity, structureObj, fullNameSep, languageNameMap);
            }
        }
    }

    private void validateLongNumber(String number, ExtendedDataEntity dataEntity, DynamicObject structureObj, String longNumberSep) {
        String longNumber = structureObj.getString("longnumber");
        boolean isValid = true;
        if (StringUtils.isBlank((CharSequence)longNumber)) {
            isValid = false;
        } else {
            DynamicObject parentObj = structureObj.getDynamicObject("viewparent");
            if (parentObj == null) {
                if (!number.equals(longNumber)) {
                    isValid = false;
                }
            } else if (!longNumber.endsWith(parentObj.getString("number") + longNumberSep + number)) {
                isValid = false;
            }
        }
        if (!isValid) {
            DynamicObject viewObj = structureObj.getDynamicObject("view");
            this.validatorHandler.handle(dataEntity, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5728\u201c%1$s\u201d\u4e2d\u7684\u957f\u7f16\u7801\u4e0d\u6b63\u786e\uff1a%2$s\u3002", (String)"OrgHealthCheckValidator_0", (String)"bos-org-formplugin", (Object[])new Object[0]), viewObj.getString("name"), longNumber));
        }
    }

    private void validateFullName(ILocaleString nameLocale, ExtendedDataEntity dataEntity, DynamicObject structureObj, String fullNameSep, Map<String, String> languageNameMap) {
        ILocaleString fullNameLocale = structureObj.getLocaleString("fullname");
        if (fullNameLocale == null) {
            return;
        }
        DynamicObject parentObj = structureObj.getDynamicObject("viewparent");
        ILocaleString parentNameLocale = parentObj == null ? null : parentObj.getLocaleString("name");
        for (Map.Entry<String, String> langEntry : languageNameMap.entrySet()) {
            String lang = langEntry.getKey();
            String name = (String)nameLocale.get((Object)lang);
            String fullName = (String)fullNameLocale.get((Object)lang);
            if (name == null || fullName == null || StringUtils.isBlank((CharSequence)name) && StringUtils.isBlank((CharSequence)fullName)) continue;
            boolean isValid = true;
            if (parentNameLocale == null) {
                if (!name.equals(fullName)) {
                    isValid = false;
                }
            } else {
                String parentName = (String)parentNameLocale.get((Object)lang);
                if (StringUtils.isBlank((CharSequence)parentName)) continue;
                if (!fullName.endsWith(parentName + fullNameSep + name)) {
                    isValid = false;
                }
            }
            if (isValid) continue;
            DynamicObject viewObj = structureObj.getDynamicObject("view");
            this.validatorHandler.handle(dataEntity, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5728\u201c%1$s\u201d\u4e2d\uff0c\u201c%2$s\u201d\u8bed\u79cd\u7684\u957f\u540d\u79f0\u4e0d\u6b63\u786e\uff1a%3$s\u3002", (String)"OrgHealthCheckValidator_1", (String)"bos-org-formplugin", (Object[])new Object[0]), viewObj.getString("name"), langEntry.getValue(), fullName));
        }
    }

    private void validateFullNameUnique() {
        Map<Long, String> structureLangMap = this.getDuplicateFullNameStructure();
        if (structureLangMap.isEmpty()) {
            return;
        }
        Map viewDynamicObjectMap = this.orgOpContext.getDataProvider().getViewDynamicObjectMap();
        Map enableLangMap = this.orgOpContext.getDataProvider().getLanguageNameMap();
        QFilter idFilter = new QFilter("id", "in", structureLangMap.keySet());
        QFilter orgFilter = new QFilter("org", "in", this.dataEntityMap.keySet());
        QFilter[] filters = new QFilter[]{idFilter, orgFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgHealthCheckValidator.validateFullNameUnique", (String)"bos_org_structure", (String)"id,org,view", (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                DynamicObject viewObj = (DynamicObject)viewDynamicObjectMap.get(row.getLong("view"));
                if (viewObj == null) continue;
                String lang = structureLangMap.get(row.getLong("id"));
                String langName = (String)enableLangMap.get(lang);
                langName = langName == null ? lang : langName;
                ExtendedDataEntity dataEntity = this.dataEntityMap.get(row.getLong("org"));
                this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00205", (Object[])new Object[]{viewObj.getString("name"), langName}));
            }
        }
    }

    private Map<Long, String> getDuplicateFullNameStructure() {
        HashMap<Long, String> structureLangMap = new HashMap<Long, String>(this.dataEntityMap.size());
        String sql = "select fid,flocaleid from t_org_structure_l group by fid,flocaleid having count(fid) > 1";
        try {
            DB.query((DBRoute)DBRoute.basedata, (String)sql, null, resultSet -> {
                while (resultSet.next()) {
                    structureLangMap.put(resultSet.getLong("fid"), resultSet.getString("flocaleid"));
                }
                return null;
            });
        }
        catch (Exception e) {
            logger.error("\u3010\u7ec4\u7ec7\u5065\u5eb7\u68c0\u67e5\u3011\u83b7\u53d6\u957f\u540d\u79f0\u591a\u8bed\u8a00\u8868\u91cd\u590d\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        return structureLangMap;
    }
}

