/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import kd.bos.base.utils.BaseUtils;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgSeparation;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class OrgConfigSaveOpValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(OrgConfigSaveOpValidator.class);
    private String fullNameSep;
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"kd.bos.org.opplugin.config.OrgConfigSaveOpValidator", (int)8);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        ExtendedDataEntity dataEntity = dataEntities[0];
        this.fullNameSep = dataEntity.getDataEntity().getString("fullnamesep");
        if (!this.validateFullNameSep(dataEntity)) {
            return;
        }
        if (!this.validateOrgName(dataEntity)) {
            return;
        }
        this.updateFullNameSeparation(dataEntity);
    }

    private boolean validateFullNameSep(ExtendedDataEntity dataEntity) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        if (StringUtils.isBlank((CharSequence)this.fullNameSep)) {
            DynamicProperty fullNameSepProp = dynamicObject.getDynamicObjectType().getProperty("fullnamesep");
            this.addErrorMessage(dataEntity, BaseMessage.getMessage((String)"M00001", (Object[])new Object[]{fullNameSepProp.getDisplayName().getLocaleValue()}));
            return false;
        }
        List orgNameReserveChar = OrgViewUtils.getOrgNameReserveChar((String)this.fullNameSep, (String)this.fullNameSep, (boolean)false);
        if (!CollectionUtils.isEmpty((Collection)orgNameReserveChar)) {
            this.addErrorMessage(dataEntity, OrgMessage.getMessage((String)"M00198", (Object[])new Object[]{orgNameReserveChar.get(0)}));
            return false;
        }
        return true;
    }

    private boolean validateOrgName(ExtendedDataEntity dataEntity) {
        DynamicObject[] orgObjArr = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,number,name,isbizorg", null);
        if (orgObjArr == null || orgObjArr.length == 0) {
            return true;
        }
        Map enableLangMap = BaseUtils.getEnableLangMap();
        for (DynamicObject orgObj : orgObjArr) {
            Map langSeparationMap = OrgViewUtils.getOrgNameReserveChar((ILocaleString)orgObj.getLocaleString("name"), (Map)enableLangMap, (String)this.fullNameSep, (boolean)true);
            Iterator iterator = langSeparationMap.entrySet().iterator();
            if (!iterator.hasNext()) continue;
            Map.Entry entry = iterator.next();
            String langName = (String)enableLangMap.get(entry.getKey());
            if (langName == null && !((List)entry.getValue()).isEmpty()) {
                langName = (String)((List)entry.getValue()).get(0);
            }
            String messageCode = orgObj.getBoolean("isbizorg") ? "M00196" : "M00197";
            this.addErrorMessage(dataEntity, OrgMessage.getMessage((String)messageCode, (Object[])new Object[]{orgObj.getString("number"), orgObj.getString("name"), langName}));
            return false;
        }
        return true;
    }

    private void updateFullNameSeparation(ExtendedDataEntity dataEntity) {
        logger.info("\u66f4\u65b0\u7ec4\u7ec7\u7ed3\u6784\u957f\u540d\u79f0\u5206\u9694\u7b26\uff1a" + this.fullNameSep);
        OrgSeparation orgSeparation = OrgUnitServiceHelper.getOrgSeparation();
        String oldFullNameSep = orgSeparation.getFullNameSep();
        if (this.fullNameSep.equals(oldFullNameSep)) {
            return;
        }
        Map viewObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_viewschema", (String)"id", null);
        if (viewObjMap == null || viewObjMap.isEmpty()) {
            return;
        }
        ArrayList<Future> updateTasks = new ArrayList<Future>(viewObjMap.size());
        for (Map.Entry entry : viewObjMap.entrySet()) {
            updateTasks.add(threadPool.submit(() -> this.updateFullNameSeparation(entry.getKey(), this.fullNameSep, oldFullNameSep)));
        }
        try {
            for (Future updateTask : updateTasks) {
                updateTask.get();
            }
        }
        catch (Exception e) {
            this.addErrorMessage(dataEntity, BaseMessage.getMessage((String)"M00048", (Object[])new Object[]{e.getMessage()}));
        }
        logger.info("\u66f4\u65b0\u7ec4\u7ec7\u7ed3\u6784\u957f\u540d\u79f0\u5206\u9694\u7b26\uff1a" + this.fullNameSep);
    }

    private int updateFullNameSeparation(Object viewId, String fullNameSep, String oldFullNameSep) {
        logger.info(viewId + "\uff1a\u6839\u636e\u89c6\u56fe\u65b9\u6848\u5206\u522b\u66f4\u65b0\u7ec4\u7ec7\u7ed3\u6784\u957f\u540d\u79f0\u5206\u9694\u7b26\uff1a" + fullNameSep);
        QFilter viewFilter = new QFilter("view", "=", viewId);
        QFilter[] filters = new QFilter[]{viewFilter};
        DynamicObject[] structureObjArr = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)"fullname", (QFilter[])filters);
        if (structureObjArr == null || structureObjArr.length == 0) {
            return 0;
        }
        for (DynamicObject structureObj : structureObjArr) {
            ILocaleString localeString = structureObj.getLocaleString("fullname");
            Set toEntries = localeString.entrySet();
            for (Map.Entry entry : toEntries) {
                if (!StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
                localeString.put(entry.getKey(), (Object)((String)entry.getValue()).replace(oldFullNameSep, fullNameSep));
            }
        }
        int count = SaveServiceHelper.save((DynamicObject[])structureObjArr).length;
        logger.info(viewId + "\uff1a\u6839\u636e\u89c6\u56fe\u65b9\u6848\u5206\u522b\u66f4\u65b0\u7ec4\u7ec7\u7ed3\u6784\u957f\u540d\u79f0\u5206\u9694\u7b26\uff1a" + fullNameSep);
        return count;
    }
}

