/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin.freeze;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.org.opplugin.AbstractOrgOpPlugin;
import kd.bos.org.opplugin.common.OrgSorter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public abstract class AbstractAdminOrgFreezeOpPlugin
extends AbstractOrgOpPlugin {
    private long currentUserId;
    private Date currentTime;

    protected abstract boolean isFreeze();

    protected abstract AbstractValidator getAbstractValidator();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("fyzjorgid");
        fieldKeys.add("fyzjimorted");
        fieldKeys.add("enable");
        fieldKeys.add("modifier");
        fieldKeys.add("modifytime");
        fieldKeys.add("structure.view");
        fieldKeys.add("structure.vieworg");
        fieldKeys.add("structure.viewparent");
        fieldKeys.add("structure.isfreeze");
        fieldKeys.add("structure.sealuptime");
        fieldKeys.add("structure.yzjorgid");
        fieldKeys.add("structure.viewmodifier");
        fieldKeys.add("structure.viewmodifytime");
        fieldKeys.add("structure.yzjparentorgid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                HashSet<Long> validateViewIds = new HashSet<Long>(1);
                validateViewIds.add(1L);
                OrgSorter orgSorter = new OrgSorter(AbstractAdminOrgFreezeOpPlugin.this.orgOpContext, this.dataEntities, validateViewIds, false);
                orgSorter.sort();
            }
        });
        e.addValidator(this.getAbstractValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        this.currentUserId = RequestContext.get().getCurrUserId();
        this.currentTime = new Date();
        DynamicObject[] dataEntities = e.getDataEntities();
        HashMap<Long, String> orgYzjIdMap = new HashMap<Long, String>(dataEntities.length);
        block0: for (DynamicObject orgObj : dataEntities) {
            this.updateYzjOrgId(orgObj, orgYzjIdMap);
            DynamicObjectCollection structureObjCol = orgObj.getDynamicObjectCollection("structure");
            for (DynamicObject structureObj : structureObjCol) {
                DynamicObject viewObj = structureObj.getDynamicObject("view");
                if (viewObj == null || 1L != viewObj.getLong("id")) continue;
                this.updateFreezeState(orgObj, structureObj);
                continue block0;
            }
        }
        this.updateYzjParentOrgId(orgYzjIdMap);
        SaveServiceHelper.save((DynamicObject[])e.getDataEntities());
    }

    private void updateFreezeState(DynamicObject orgObj, DynamicObject structureObj) {
        structureObj.set("yzjorgid", (Object)orgObj.getString("fyzjorgid"));
        if (this.isFreeze()) {
            structureObj.set("isfreeze", (Object)Boolean.TRUE);
            structureObj.set("sealuptime", (Object)new Date());
        } else {
            structureObj.set("isfreeze", (Object)Boolean.FALSE);
            structureObj.set("sealuptime", null);
        }
        structureObj.set("viewmodifier", (Object)this.currentUserId);
        structureObj.set("viewmodifytime", (Object)this.currentTime);
    }

    private void updateYzjOrgId(DynamicObject orgObj, Map<Long, String> orgYzjIdMap) {
        if (!this.orgOpContext.getConfigProvider().getYzjConfig().isEnable()) {
            return;
        }
        long id = orgObj.getLong("id");
        String yzjOrgId = orgObj.getString("fyzjorgid");
        orgYzjIdMap.put(id, yzjOrgId);
        orgObj.set("fyzjorgid", (Object)yzjOrgId);
        orgObj.set("fyzjimorted", (Object)StringUtils.isNotBlank((CharSequence)yzjOrgId));
        orgObj.set("modifier", (Object)this.currentUserId);
        orgObj.set("modifytime", (Object)this.currentTime);
    }

    private void updateYzjParentOrgId(Map<Long, String> orgYzjIdMap) {
        QFilter parentFilter;
        if (orgYzjIdMap.isEmpty()) {
            return;
        }
        QFilter viewFilter = new QFilter("view", "=", (Object)1L);
        QFilter[] filters = new QFilter[]{viewFilter, parentFilter = new QFilter("parent", "in", orgYzjIdMap.keySet())};
        DynamicObject[] objArr = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)"id,parent,yzjparentorgid", (QFilter[])filters);
        if (objArr == null || objArr.length == 0) {
            return;
        }
        for (DynamicObject obj : objArr) {
            DynamicObject parentObj = obj.getDynamicObject("parent");
            if (parentObj == null) continue;
            obj.set("yzjparentorgid", (Object)orgYzjIdMap.get(parentObj.getPkValue()));
        }
        SaveServiceHelper.save((DynamicObject[])objArr);
    }
}

