/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin.freeze;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.opplugin.AbstractOrgOpValidator;
import kd.bos.org.opplugin.model.OrgOpContext;
import kd.bos.org.service.common.OrgFreezeCheckerExecutor;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.yzj.model.YzjConfig;
import kd.bos.yzj.model.org.YzjOrgParam;
import kd.bos.yzj.service.YzjServiceFactory;

public class AdminOrgFreezeOpValidator
extends AbstractOrgOpValidator {
    private static final Log logger = LogFactory.getLog(AdminOrgFreezeOpValidator.class);

    public AdminOrgFreezeOpValidator(OrgOpContext orgOpContext) {
        super(orgOpContext);
    }

    public void validate() {
        Long rootOrgId = this.orgOpContext.getDataProvider().getRootOrgId();
        ArrayList<Long> checkSubOrgIds = new ArrayList<Long>(this.dataEntities.length);
        HashMap<Long, String> orgLongNumberMap = new HashMap<Long, String>(this.dataEntities.length);
        ArrayList<Long> frozeOrgIds = new ArrayList<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject orgObj = dataEntity.getDataEntity();
            long orgId = orgObj.getLong("id");
            if (Objects.equals(rootOrgId, orgId)) {
                this.addErrorMessage(dataEntity, OrgMessage.getMessage((String)"M00078"));
                continue;
            }
            this.orgOpContext.getDataEntityMap().put(orgId, dataEntity);
            DynamicObject adminStructureObj = this.validateAdminOrgStructure(dataEntity);
            if (adminStructureObj == null) continue;
            orgLongNumberMap.put(orgId, adminStructureObj.getString("longnumber"));
            if (adminStructureObj.getBoolean("isfreeze")) {
                frozeOrgIds.add(orgId);
                this.addErrorMessage(dataEntity, OrgMessage.getMessage((String)"M00212"));
                continue;
            }
            OrgFreezeCheckerExecutor checker = new OrgFreezeCheckerExecutor(orgId);
            String msg = checker.check();
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                this.addErrorMessage(dataEntity, msg);
                continue;
            }
            if (adminStructureObj.getBoolean("isleaf")) continue;
            checkSubOrgIds.add(orgId);
        }
        this.validateSubOrg(checkSubOrgIds);
        this.deleteFromYzj();
        this.checkSubError(orgLongNumberMap, frozeOrgIds);
    }

    private void validateSubOrg(List<Long> orgIds) {
        if (orgIds.isEmpty()) {
            return;
        }
        Set allOrgIds = this.orgOpContext.getDataEntityMap().keySet();
        Map subOrgMap = OrgUnitServiceHelper.getAllSubordinateOrgMap((long)1L, orgIds, (boolean)false);
        for (Map.Entry entry : subOrgMap.entrySet()) {
            List subOrgIds = (List)entry.getValue();
            subOrgIds.removeAll(allOrgIds);
            if (subOrgIds.isEmpty()) continue;
            ExtendedDataEntity dataEntity = (ExtendedDataEntity)this.orgOpContext.getDataEntityMap().get(entry.getKey());
            this.addErrorMessage(dataEntity, OrgMessage.getMessage((String)"M00214"));
        }
    }

    private void deleteFromYzj() {
        String doSyncToYunzhijiaOperation = this.getOption().getVariableValue("doSyncToYunzhijiaOperation", Boolean.TRUE.toString());
        if (!Boolean.parseBoolean(doSyncToYunzhijiaOperation)) {
            logger.info("\u3010\u7ec4\u7ec7\u4fdd\u5b58\u64cd\u4f5c\u3011\u53c2\u6570\u914d\u7f6e\u4e86\u4e0d\u6267\u884c\u540c\u6b65\u4e91\u4e4b\u5bb6\u3002");
            return;
        }
        YzjConfig yzjConfig = this.orgOpContext.getConfigProvider().getYzjConfig();
        if (3 != yzjConfig.getSyncMode()) {
            return;
        }
        Map dataEntityMap = this.orgOpContext.getDataEntityMap();
        ArrayList<YzjOrgParam> orgModelList = new ArrayList<YzjOrgParam>(dataEntityMap.size());
        for (Map.Entry entity : dataEntityMap.entrySet()) {
            String yzjOrgId;
            if (this.orgOpContext.getErrorIds().contains(entity.getKey()) || !StringUtils.isNotBlank((CharSequence)(yzjOrgId = ((ExtendedDataEntity)entity.getValue()).getDataEntity().getString("fyzjorgid")))) continue;
            YzjOrgParam orgModel = new YzjOrgParam();
            orgModel.setId(((Long)entity.getKey()).longValue());
            orgModel.setYzjOrgId(yzjOrgId);
            orgModelList.add(orgModel);
        }
        if (orgModelList.isEmpty()) {
            return;
        }
        YzjServiceFactory.getOrgService((YzjConfig)yzjConfig).deleteById(orgModelList);
        for (YzjOrgParam yzjOrgParam : orgModelList) {
            if (yzjOrgParam.isSuccess()) {
                ((ExtendedDataEntity)dataEntityMap.get(yzjOrgParam.getId())).getDataEntity().set("fyzjorgid", (Object)"");
                continue;
            }
            ExtendedDataEntity dataEntity = (ExtendedDataEntity)this.orgOpContext.getDataEntityMap().get(yzjOrgParam.getId());
            this.addOrgErrorMessage(dataEntity, yzjOrgParam.getMsg());
        }
    }

    private void checkSubError(Map<Long, String> orgLongNumberMap, List<Long> frozeOrgIds) {
        if (this.orgOpContext.getErrorIds().isEmpty()) {
            return;
        }
        HashSet errorIds = new HashSet(this.orgOpContext.getErrorIds());
        Map dataEntityMap = this.orgOpContext.getDataEntityMap();
        String longNumberSep = this.orgOpContext.getConfigProvider().getOrgSeparation().getLongNumberSep();
        errorIds.removeAll(frozeOrgIds);
        for (Long id : errorIds) {
            String longNumber = orgLongNumberMap.remove(id) + longNumberSep;
            for (Map.Entry<Long, String> entry : orgLongNumberMap.entrySet()) {
                if (!longNumber.startsWith(entry.getValue()) || errorIds.contains(entry.getKey())) continue;
                ExtendedDataEntity dataEntity = (ExtendedDataEntity)dataEntityMap.get(id);
                this.addErrorMessage((ExtendedDataEntity)dataEntityMap.get(entry.getKey()), OrgMessage.getMessage((String)"M00215", (Object[])new Object[]{dataEntity.getDataEntity().getString("name")}));
            }
        }
    }
}

