/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin.freeze;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.org.opplugin.AbstractOrgOpValidator;
import kd.bos.org.opplugin.common.OrgFullNameValidator;
import kd.bos.org.opplugin.model.OrgOpContext;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class AdminOrgUnFreezeOpValidator
extends AbstractOrgOpValidator {
    public AdminOrgUnFreezeOpValidator(OrgOpContext orgOpContext) {
        super(orgOpContext);
    }

    public void validate() {
        int count = this.dataEntities.length;
        HashMap<Long, List<Long>> parentOrgMap = new HashMap<Long, List<Long>>(count);
        ArrayList<ExtendedDataEntity> validDataEntities = new ArrayList<ExtendedDataEntity>(count);
        ArrayList<Long> unFrozeOrgIds = new ArrayList<Long>();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject orgObj = dataEntity.getDataEntity();
            long id = orgObj.getLong("id");
            this.orgOpContext.getDataEntityMap().put(id, dataEntity);
            if (!orgObj.getBoolean("enable")) {
                this.addOrgErrorMessage(dataEntity, OrgMessage.getMessage((String)"M00090"));
                continue;
            }
            DynamicObject adminStructureObj = this.validateAdminOrgStructure(dataEntity);
            if (adminStructureObj == null) continue;
            if (!adminStructureObj.getBoolean("isfreeze")) {
                unFrozeOrgIds.add(id);
                this.addErrorMessage(dataEntity, OrgMessage.getMessage((String)"M00213"));
                continue;
            }
            validDataEntities.add(dataEntity);
            DynamicObject parentObj = adminStructureObj.getDynamicObject("viewparent");
            if (parentObj == null) continue;
            parentOrgMap.computeIfAbsent(parentObj.getLong("id"), v -> new ArrayList(count)).add(id);
        }
        OrgFullNameValidator fullNameValidator = new OrgFullNameValidator(this.orgOpContext, false);
        fullNameValidator.validate(validDataEntities.toArray(new ExtendedDataEntity[0]));
        this.validateParentFreezeStatus(parentOrgMap, unFrozeOrgIds);
    }

    private void validateParentFreezeStatus(Map<Long, List<Long>> parentOrgMap, List<Long> unFrozeOrgIds) {
        this.removeValidatedParent(parentOrgMap, unFrozeOrgIds);
        if (parentOrgMap.isEmpty()) {
            return;
        }
        QFilter viewFilter = new QFilter("view", "=", (Object)1L);
        QFilter orgFilter = new QFilter("org", "in", parentOrgMap.keySet());
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter, freezeFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AdminOrgUnFreezeOpValidator.validateParentFreezeStatus", (String)"bos_org_structure", (String)"org", (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                Long orgId = row.getLong("org");
                List<Long> orgIds = parentOrgMap.get(orgId);
                for (Long currentOrgId : orgIds) {
                    this.addOrgErrorMessage((ExtendedDataEntity)this.orgOpContext.getDataEntityMap().get(currentOrgId), OrgMessage.getMessage((String)"M00216"));
                }
            }
        }
    }

    private void removeValidatedParent(Map<Long, List<Long>> parentOrgMap, List<Long> unFrozeOrgIds) {
        Iterator<Map.Entry<Long, List<Long>>> iterator = parentOrgMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, List<Long>> entry = iterator.next();
            Long parentOrgId = entry.getKey();
            if (this.orgOpContext.getErrorIds().contains(parentOrgId)) {
                this.validateErrorParentFreezeStatus(parentOrgId, entry.getValue(), unFrozeOrgIds);
                iterator.remove();
                continue;
            }
            if (!this.orgOpContext.getDataEntityMap().containsKey(parentOrgId)) continue;
            iterator.remove();
        }
    }

    private void validateErrorParentFreezeStatus(long parentOrgId, List<Long> orgIds, List<Long> unFrozeOrgIds) {
        if (unFrozeOrgIds.contains(parentOrgId)) {
            return;
        }
        for (Long orgId : orgIds) {
            if (this.orgOpContext.getErrorIds().contains(orgId)) continue;
            this.addOrgErrorMessage((ExtendedDataEntity)this.orgOpContext.getDataEntityMap().get(orgId), OrgMessage.getMessage((String)"M00216"));
        }
    }
}

