/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin.freezebiz;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.org.opplugin.AbstractOrgChangeOpPlugin;
import kd.bos.org.utils.OrgChangeType;
import kd.bos.orm.util.CollectionUtils;

public abstract class AbstractOrgBizFreezeOpServicePlugin
extends AbstractOrgChangeOpPlugin {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("orgbizfunction");
        e.getFieldKeys().add("structure.view");
        e.getFieldKeys().add("structure.isfreeze");
        e.getFieldKeys().add("structure.sealuptime");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        boolean isFreeze = Objects.equals(OrgChangeType.BIZFREEZE, this.getOrgChangeType());
        Date currentTime = Calendar.getInstance().getTime();
        for (DynamicObject orgObj : dataEntities) {
            long id = orgObj.getLong("id");
            Map bizHandoverOrgMap = (Map)this.orgBizHandoverMap.get(id);
            if (CollectionUtils.isEmpty((Map)bizHandoverOrgMap)) continue;
            DynamicObjectCollection structureObjCol = orgObj.getDynamicObjectCollection("structure");
            for (DynamicObject structureObj : structureObjCol) {
                DynamicObject viewBizObj;
                DynamicObject viewObj = structureObj.getDynamicObject("view");
                if (viewObj == null || (viewBizObj = viewObj.getDynamicObject("treetypeid")) == null || !bizHandoverOrgMap.containsKey(viewBizObj.getPkValue())) continue;
                if (isFreeze) {
                    structureObj.set("isfreeze", (Object)Boolean.TRUE);
                    structureObj.set("sealuptime", (Object)currentTime);
                    continue;
                }
                structureObj.set("isfreeze", (Object)Boolean.FALSE);
                structureObj.set("sealuptime", null);
            }
        }
    }
}

