/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin.freezebiz;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.org.opplugin.AbstractOrgOpValidator;
import kd.bos.org.opplugin.model.OrgOpContext;
import kd.bos.orm.util.CollectionUtils;

public abstract class AbstractOrgBizFreezeOpValidator
extends AbstractOrgOpValidator {
    protected Map<Long, Map<Long, Long>> orgBizHandoverMap;
    protected final Map<Long, Map<Long, Set<String>>> orgViewErrorMap;

    public AbstractOrgBizFreezeOpValidator(OrgOpContext orgOpContext, Map<Long, Map<Long, Long>> orgBizHandoverMap, Map<Long, Map<Long, Set<String>>> orgViewErrorMap) {
        super(orgOpContext);
        this.orgBizHandoverMap = orgBizHandoverMap;
        this.orgViewErrorMap = orgViewErrorMap;
    }

    public final void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject orgObj = dataEntity.getDataEntity();
            long orgId = orgObj.getLong("id");
            Map<Long, Long> bizHandoverOrgMap = this.orgBizHandoverMap.get(orgId);
            if (CollectionUtils.isEmpty(bizHandoverOrgMap)) continue;
            DynamicObjectCollection structureCol = orgObj.getDynamicObjectCollection("structure");
            for (DynamicObject structureObj : structureCol) {
                long bizId;
                Long handoverOrgId;
                DynamicObject bizObj;
                DynamicObject viewObj = structureObj.getDynamicObject("view");
                if (viewObj == null || (bizObj = viewObj.getDynamicObject("treetypeid")) == null || (handoverOrgId = bizHandoverOrgMap.get(bizId = bizObj.getLong("id"))) == null) continue;
                this.validateBizStructure(dataEntity, structureObj, bizId, handoverOrgId);
            }
        }
        this.customValidate();
    }

    protected void customValidate() {
    }

    protected abstract void validateBizStructure(ExtendedDataEntity var1, DynamicObject var2, long var3, long var5);

    protected void addViewError(String error, ExtendedDataEntity dataEntity, long viewId) {
        this.addErrorMessage(dataEntity, error);
        Map viewErrorMap = this.orgViewErrorMap.computeIfAbsent(dataEntity.getDataEntity().getLong("id"), v -> new HashMap(64));
        viewErrorMap.computeIfAbsent(viewId, v -> new LinkedHashSet()).add(error);
    }

    protected void addFreezeStatusError(String errorCode, ExtendedDataEntity dataEntity, DynamicObject structureObj) {
        DynamicObject viewObj = structureObj.getDynamicObject("view");
        long viewId = 0L;
        String bizName = "";
        if (viewObj != null) {
            viewId = viewObj.getLong("id");
            DynamicObject bizObj = viewObj.getDynamicObject("treetypeid");
            if (bizObj != null) {
                bizName = bizObj.getString("fname");
            }
        }
        String error = OrgMessage.getMessage((String)errorCode, (Object[])new Object[]{bizName});
        this.addViewError(error, dataEntity, viewId);
    }
}

