/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin.freezebiz;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.org.opplugin.freezebiz.AbstractOrgBizFreezeOpValidator;
import kd.bos.org.opplugin.model.OrgOpContext;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class OrgBizFreezeOpValidator
extends AbstractOrgBizFreezeOpValidator {
    private Map<Long, Map<Long, List<Long>>> allBizHandoverOrgMap = new HashMap<Long, Map<Long, List<Long>>>(64);
    private Set<Long> allHandoverOrgIds = new HashSet<Long>(64);

    public OrgBizFreezeOpValidator(OrgOpContext orgOpContext, Map<Long, Map<Long, Long>> orgBizHandoverMap, Map<Long, Map<Long, Set<String>>> orgViewErrorMap) {
        super(orgOpContext, orgBizHandoverMap, orgViewErrorMap);
    }

    @Override
    protected void validateBizStructure(ExtendedDataEntity dataEntity, DynamicObject structureObj, long bizId, long handoverOrgId) {
        if (!Objects.equals(handoverOrgId, 0L)) {
            this.allHandoverOrgIds.add(handoverOrgId);
            Map allHandoverOrgMap = this.allBizHandoverOrgMap.computeIfAbsent(bizId, v -> new HashMap(this.dataEntities.length));
            long orgId = dataEntity.getDataEntity().getLong("id");
            allHandoverOrgMap.computeIfAbsent(handoverOrgId, v -> new ArrayList(this.dataEntities.length)).add(orgId);
        }
        if (1L == bizId) {
            this.addErrorMessage(dataEntity, OrgMessage.getMessage((String)"M00184"));
        } else if (15L == bizId) {
            this.addErrorMessage(dataEntity, OrgMessage.getMessage((String)"M00228"));
        } else if (16L == bizId) {
            this.addErrorMessage(dataEntity, OrgMessage.getMessage((String)"M00229"));
        }
        if (Objects.equals(structureObj.getBoolean("isfreeze"), Boolean.TRUE)) {
            this.addFreezeStatusError("M00200", dataEntity, structureObj);
        }
    }

    @Override
    protected void customValidate() {
        super.customValidate();
        this.handoverOrgValidate();
    }

    private void handoverOrgValidate() {
        if (this.allBizHandoverOrgMap.isEmpty()) {
            return;
        }
        String selectFields = "id,number,name,enable,structure.view view,structure.view.treetypeid treetypeid,structure.isfreeze isfreeze";
        QFilter bizFilter = new QFilter("structure.view.treetypeid", "in", this.allBizHandoverOrgMap.keySet());
        QFilter idFilter = new QFilter("id", "in", this.allHandoverOrgIds);
        QFilter[] filters = new QFilter[]{bizFilter, idFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgChangeOpBaseValidator.handoverOrgValidate", (String)"bos_org", (String)selectFields, (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                List<Long> orgIds;
                Long handoverOrgId = row.getLong("id");
                Long viewId = row.getLong("view");
                Long bizId = row.getLong("treetypeid");
                Boolean enable = row.getBoolean("enable");
                Boolean isFreeze = row.getBoolean("isfreeze");
                Map<Long, List<Long>> allHandoverOrgMap = this.allBizHandoverOrgMap.get(bizId);
                if (CollectionUtils.isEmpty(allHandoverOrgMap) || CollectionUtils.isEmpty(orgIds = allHandoverOrgMap.get(handoverOrgId))) continue;
                String handoverOrgName = row.getString("name");
                this.handoverEnableValidate(viewId, enable, handoverOrgName, orgIds);
                this.handoverFreezeValidate(viewId, isFreeze, handoverOrgName, orgIds);
                allHandoverOrgMap.remove(handoverOrgId);
                if (allHandoverOrgMap.isEmpty()) {
                    this.allBizHandoverOrgMap.remove(bizId);
                }
                if (!this.allBizHandoverOrgMap.isEmpty()) continue;
                break;
            }
        }
        this.handoverOrgNotExistsError();
    }

    private void handoverOrgNotExistsError() {
        for (Map.Entry<Long, Map<Long, List<Long>>> bizEntry : this.allBizHandoverOrgMap.entrySet()) {
            Map bizMap = this.orgOpContext.getDataProvider().getBizMap();
            DynamicObject bizObj = (DynamicObject)bizMap.get(bizEntry.getKey());
            if (bizObj == null) continue;
            Map<Long, List<Long>> allHandoverOrgMap = bizEntry.getValue();
            Map orgObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", allHandoverOrgMap.keySet())});
            for (Map.Entry<Long, List<Long>> orgEntry : allHandoverOrgMap.entrySet()) {
                DynamicObject handoverOrgObj = (DynamicObject)orgObjMap.get(orgEntry.getKey());
                String handoverOrgName = handoverOrgObj == null ? null : handoverOrgObj.getString("name");
                for (Long orgId : orgEntry.getValue()) {
                    ExtendedDataEntity dataEntity = (ExtendedDataEntity)this.orgOpContext.getDataEntityMap().get(orgId);
                    if (dataEntity == null) continue;
                    String error = handoverOrgName == null ? OrgMessage.getMessage((String)"M00230", (Object[])new Object[]{bizObj.getString("fname")}) : OrgMessage.getMessage((String)"M00230", (Object[])new Object[]{handoverOrgName, bizObj.getString("fname")});
                    List viewObjList = this.orgOpContext.getDataProvider().getViewDynamicObjectByBizId(bizObj.getLong("id"));
                    for (DynamicObject viewObj : viewObjList) {
                        this.addViewError(error, dataEntity, viewObj.getLong("id"));
                    }
                }
            }
        }
    }

    private boolean handoverEnableValidate(Long viewId, boolean enable, String handoverOrgName, List<Long> orgIds) {
        if (enable) {
            return true;
        }
        for (Long orgId : orgIds) {
            ExtendedDataEntity dataEntity = (ExtendedDataEntity)this.orgOpContext.getDataEntityMap().get(orgId);
            if (dataEntity == null) continue;
            this.addViewError(OrgMessage.getMessage((String)"M00230", (Object[])new Object[]{handoverOrgName}), dataEntity, viewId);
        }
        return false;
    }

    private boolean handoverFreezeValidate(Long viewId, boolean freeze, String handoverOrgName, List<Long> orgIds) {
        if (!freeze) {
            return true;
        }
        for (Long orgId : orgIds) {
            ExtendedDataEntity dataEntity = (ExtendedDataEntity)this.orgOpContext.getDataEntityMap().get(orgId);
            if (dataEntity == null) continue;
            this.addViewError(OrgMessage.getMessage((String)"M00230", (Object[])new Object[]{handoverOrgName}), dataEntity, viewId);
        }
        return false;
    }
}

