/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin.save;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.org.opplugin.IOrgOpValidatorHandler;
import kd.bos.org.opplugin.model.OrgDataProvider;
import kd.bos.org.opplugin.model.OrgOpContext;

public class OrgPatternValidator {
    private final OrgOpContext orgOpContext;
    private final IOrgOpValidatorHandler validatorHandler;
    private final ExtendedDataEntity dataEntity;
    private final Map<Long, DynamicObject> viewStructureMap;
    private final OrgDataProvider dataProvider;

    public OrgPatternValidator(OrgOpContext orgOpContext, ExtendedDataEntity dataEntity, Map<Long, DynamicObject> viewStructureMap) {
        this.orgOpContext = orgOpContext;
        this.dataEntity = dataEntity;
        this.viewStructureMap = viewStructureMap;
        this.validatorHandler = this.orgOpContext.getValidatorHandler();
        this.dataProvider = this.orgOpContext.getDataProvider();
    }

    public void validate() {
        if (this.orgOpContext.getConfigProvider().isGalaxyUltimate().booleanValue()) {
            this.validateInGalaxy();
        } else {
            this.validateInCosmic();
        }
    }

    private void validateInCosmic() {
        DynamicObject orgObj = this.dataEntity.getDataEntity();
        DynamicObject patternObj = orgObj.getDynamicObject("orgpattern");
        if (patternObj == null) {
            if (orgObj.getDataEntityState().getFromDatabase()) {
                return;
            }
            DynamicObject orgUnitStructObj = this.viewStructureMap.get(15L);
            long patternId = orgUnitStructObj == null ? 4L : 1L;
            orgObj.set("orgpattern", (Object)this.dataProvider.getPatternObject(patternId, orgObj));
        }
    }

    private void validateInGalaxy() {
        DynamicObject orgObj = this.dataEntity.getDataEntity();
        DynamicObject patternObj = orgObj.getDynamicObject("orgpattern");
        if (patternObj == null) {
            if (orgObj.getDataEntityState().getFromDatabase()) {
                return;
            }
            this.setDefaultInGalaxy(orgObj);
        } else {
            String errorMsg = this.validateInGalaxy(orgObj, patternObj);
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                this.validatorHandler.handle(this.dataEntity, errorMsg);
            }
        }
    }

    private void setDefaultInGalaxy(DynamicObject orgObj) {
        long patternId;
        DynamicObject orgUnitStructObj = this.viewStructureMap.get(15L);
        if (orgUnitStructObj == null) {
            patternId = 4L;
        } else {
            DynamicObject parentObj = orgUnitStructObj.getDynamicObject("viewparent");
            if (parentObj == null) {
                patternId = 7L;
            } else {
                long parentId = parentObj.getLong("id");
                if (this.dataProvider.getRootOrgId() == parentId) {
                    Set corporateOrgIds = this.dataProvider.getCorporateOrgIds();
                    if (corporateOrgIds.size() < this.orgOpContext.getConfigProvider().getCorporateLimitCountOfGalaxy()) {
                        patternId = 1L;
                        corporateOrgIds.add(orgObj.getLong("id"));
                    } else {
                        patternId = 4L;
                    }
                } else {
                    patternId = 4L;
                }
            }
        }
        orgObj.set("orgpattern", (Object)this.dataProvider.getPatternObject(patternId, orgObj));
    }

    private String validateInGalaxy(DynamicObject orgObj, DynamicObject patternObj) {
        Long rootOrgId;
        long orgPatternId = patternObj.getLong("id");
        String patternType = patternObj.getString("patterntype");
        boolean isCorporateType = "1".equals(patternType);
        long orgId = orgObj.getLong("id");
        if (orgId == (rootOrgId = this.dataProvider.getRootOrgId())) {
            if (7L != orgPatternId && 8L != orgPatternId) {
                return OrgMessage.getMessage((String)"M00148", (Object[])new Object[]{orgObj.getString("name")});
            }
        } else {
            if (7L == orgPatternId || 8L == orgPatternId) {
                return OrgMessage.getMessage((String)"M00149", (Object[])new Object[]{orgObj.getString("name")});
            }
            if (isCorporateType) {
                DynamicObject orgUnitStructObj = this.viewStructureMap.get(15L);
                if (orgUnitStructObj == null) {
                    return "";
                }
                DynamicObject parentObj = orgUnitStructObj.getDynamicObject("viewparent");
                if (parentObj != null && parentObj.getLong("id") != rootOrgId.longValue()) {
                    return OrgMessage.getMessage((String)"M00150", (Object[])new Object[]{orgObj.getString("name")});
                }
            }
        }
        if (isCorporateType) {
            return this.validateCorporateLimitCountInGalaxy(orgObj);
        }
        return "";
    }

    private String validateCorporateLimitCountInGalaxy(DynamicObject orgObj) {
        HashSet corporateOrgIds = new HashSet(this.dataProvider.getCorporateOrgIds());
        corporateOrgIds.remove(orgObj.getLong("id"));
        int corporateOrgCount = corporateOrgIds.size();
        Integer corporateLimitCount = this.orgOpContext.getConfigProvider().getCorporateLimitCountOfGalaxy();
        if (corporateOrgCount >= corporateLimitCount) {
            return OrgMessage.getMessage((String)"M00152", (Object[])new Object[]{corporateLimitCount, corporateOrgCount - corporateLimitCount + 1});
        }
        return "";
    }
}

