/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin.save;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.org.opplugin.model.OrgChangeData;
import kd.bos.org.opplugin.model.OrgOpContext;
import kd.bos.org.opplugin.save.AbstractOrgSaveOpService;

public class OrgSaveOpPropertyChangeService
extends AbstractOrgSaveOpService {
    public OrgSaveOpPropertyChangeService(OrgOpContext orgOpContext, DynamicObject[] dataEntities) {
        this(orgOpContext, dataEntities, new HashMap<String, Object>(8));
    }

    public OrgSaveOpPropertyChangeService(OrgOpContext orgOpContext, DynamicObject[] dataEntities, Map<String, Object> changedDataMap) {
        super(orgOpContext, dataEntities, changedDataMap);
    }

    @Override
    public void execute() {
        this.entityConversion();
        this.filterPropertyChangedData();
    }

    private void entityConversion() {
        int count = this.dataEntities.length;
        List<String> allBizProperties = this.getAllBizProperties();
        Map viewDynamicObjectMap = this.orgOpContext.getDataProvider().getViewDynamicObjectMap();
        ArrayList<Long> orgIds = new ArrayList<Long>(count);
        Map orgYzjOrgIdMap = (Map)this.changedDataMap.get("yzjChanged");
        Map timezoneMap = (Map)this.changedDataMap.get("timezoneChanged");
        for (DynamicObject orgObj : this.dataEntities) {
            DynamicObject timeZoneObj;
            long id = orgObj.getLong("id");
            orgIds.add(id);
            this.setBizProperty(orgObj, allBizProperties, viewDynamicObjectMap);
            if (orgObj.getDataEntityState().getFromDatabase()) continue;
            String yzjOrgId = orgObj.getString("fyzjorgid");
            if (StringUtils.isNotBlank((CharSequence)yzjOrgId)) {
                orgYzjOrgIdMap.put(id, yzjOrgId);
            }
            if ((timeZoneObj = orgObj.getDynamicObject("timezone")) == null) continue;
            timezoneMap.put(id, (Long)timeZoneObj.getPkValue());
        }
        Map data = this.changeDataProvider.getData();
        data.keySet().removeIf(k -> !orgIds.contains(k));
        orgIds.clear();
    }

    private List<String> getAllBizProperties() {
        Map bizMap = this.orgOpContext.getDataProvider().getBizMap();
        ArrayList<String> allBizProperties = new ArrayList<String>(bizMap.size());
        DataEntityPropertyCollection orgProperties = this.dataEntities[0].getDynamicObjectType().getProperties();
        for (Map.Entry entry : bizMap.entrySet()) {
            String propertyName = ((DynamicObject)entry.getValue()).getString("propertyname");
            if (!StringUtils.isNotBlank((CharSequence)propertyName) || orgProperties.get((Object)propertyName) == null) continue;
            allBizProperties.add(propertyName);
        }
        return allBizProperties;
    }

    private void setBizProperty(DynamicObject orgObj, List<String> allBizProperties, Map<Object, DynamicObject> viewDynamicObjectMap) {
        boolean isBizOrg = false;
        DynamicObjectCollection structureCol = orgObj.getDynamicObjectCollection("structure");
        ArrayList<String> checkedBizProperties = new ArrayList<String>(structureCol.size());
        String yzjOrgId = orgObj.getString("fyzjorgid");
        Iterator iterator = structureCol.iterator();
        while (iterator.hasNext()) {
            String propertyName;
            DynamicObject structureObj = (DynamicObject)iterator.next();
            DynamicObject structureViewObj = structureObj.getDynamicObject("view");
            if (structureViewObj == null) {
                iterator.remove();
                continue;
            }
            DynamicObject viewObj = viewDynamicObjectMap.get(structureViewObj.getPkValue());
            if (viewObj == null) {
                iterator.remove();
                continue;
            }
            DynamicObject bizObj = viewObj.getDynamicObject("treetypeid");
            if (bizObj == null) continue;
            if (!isBizOrg && "1".equals(bizObj.getString("category"))) {
                isBizOrg = true;
            }
            if (StringUtils.isNotBlank((CharSequence)(propertyName = bizObj.getString("propertyname")))) {
                checkedBizProperties.add(propertyName);
                orgObj.set(propertyName, (Object)Boolean.TRUE);
            }
            if (!StringUtils.isNotBlank((CharSequence)yzjOrgId)) continue;
            structureObj.set("yzjorgid", (Object)yzjOrgId);
        }
        orgObj.set("isbizorg", (Object)isBizOrg);
        for (String propertyName : allBizProperties) {
            if (checkedBizProperties.contains(propertyName)) continue;
            orgObj.set(propertyName, (Object)Boolean.FALSE);
        }
    }

    private void filterPropertyChangedData() {
        Map data = this.changeDataProvider.getData();
        for (Map.Entry dataEntry : data.entrySet()) {
            long id = (Long)dataEntry.getKey();
            Map dataMap = (Map)dataEntry.getValue();
            this.filterOrgChangeData(id, dataMap);
            this.filterStructureChangeData(id, dataMap);
        }
    }

    private void filterOrgChangeData(long id, Map<String, Map<String, Map<Long, Map<String, OrgChangeData>>>> dataMap) {
        OrgChangeData yzjOrgIdChangeData;
        Map<String, Map<Long, Map<String, OrgChangeData>>> orgMap = dataMap.get("org");
        if (orgMap == null) {
            return;
        }
        Map<Long, Map<String, OrgChangeData>> viewMap = orgMap.get("property");
        if (viewMap == null) {
            return;
        }
        Map orgViewPropertyChangedMap = (Map)this.changedDataMap.get("propertyChanged");
        Map<String, OrgChangeData> proMap = viewMap.get(0L);
        OrgChangeData timeZoneChangeData = proMap.get("timezone");
        if (timeZoneChangeData != null) {
            Map timezoneMap = (Map)this.changedDataMap.get("timezoneChanged");
            timezoneMap.put(id, (Long)timeZoneChangeData.getNewValue());
        }
        if (proMap.containsKey("number") || proMap.containsKey("name")) {
            orgViewPropertyChangedMap.put(id, viewMap);
            return;
        }
        ExtendedDataEntity dataEntity = (ExtendedDataEntity)this.orgOpContext.getDataEntityMap().get(id);
        if (dataEntity == null) {
            return;
        }
        Map orgYzjOrgIdMap = (Map)this.changedDataMap.get("yzjChanged");
        DynamicObject orgObj = dataEntity.getDataEntity();
        if (orgObj.getBoolean("fisadministrative") && (yzjOrgIdChangeData = proMap.get("fyzjorgid")) != null && StringUtils.isNotBlank((Object)yzjOrgIdChangeData.getNewValue())) {
            orgYzjOrgIdMap.put(id, yzjOrgIdChangeData.getNewValue().toString());
        }
    }

    private void filterStructureChangeData(long id, Map<String, Map<String, Map<Long, Map<String, OrgChangeData>>>> dataMap) {
        Map<String, Map<Long, Map<String, OrgChangeData>>> structureMap = dataMap.get("structure");
        if (structureMap == null) {
            return;
        }
        Map orgViewDeletedMap = (Map)this.changedDataMap.get("viewChanged");
        Map orgViewPropertyChangedMap = (Map)this.changedDataMap.get("propertyChanged");
        Map viewOrgMap = (Map)this.changedDataMap.get("leafChanged");
        this.filterStructureChangeData(id, structureMap.get("property"), orgViewPropertyChangedMap, viewOrgMap);
        this.filterStructureChangeData(id, structureMap.get("add"), orgViewPropertyChangedMap, viewOrgMap);
        this.filterStructureChangeData(id, structureMap.get("delete"), orgViewDeletedMap, viewOrgMap);
    }

    private void filterStructureChangeData(long id, Map<Long, Map<String, OrgChangeData>> viewMap, Map<Long, Map<Long, Map<String, OrgChangeData>>> propertyChangedMap, Map<Long, Set<Long>> viewOrgMap) {
        if (viewMap == null) {
            return;
        }
        for (Map.Entry<Long, Map<String, OrgChangeData>> viewEntry : viewMap.entrySet()) {
            OrgChangeData parentChange = viewEntry.getValue().get("viewparent");
            if (parentChange == null) continue;
            propertyChangedMap.put(id, viewMap);
            Set updatedLeafOrgIds = viewOrgMap.computeIfAbsent(viewEntry.getKey(), v -> new HashSet(64));
            if (parentChange.getOldValue() != null) {
                updatedLeafOrgIds.add((Long)parentChange.getOldValue());
            }
            if (parentChange.getNewValue() == null) continue;
            updatedLeafOrgIds.add((Long)parentChange.getNewValue());
        }
    }
}

