/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin.save;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.BaseBatchHandler;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.org.opplugin.OrgOperationUtils;
import kd.bos.org.opplugin.model.OrgChangeData;
import kd.bos.org.opplugin.model.OrgOpContext;
import kd.bos.org.opplugin.save.AbstractOrgSaveOpService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class OrgSaveOpServiceAfterTrans
extends AbstractOrgSaveOpService {
    private static final int BATCH_LIMIT = 10000;
    private static final int QUERY_LIMIT = 100000;

    public OrgSaveOpServiceAfterTrans(OrgOpContext orgOpContext, DynamicObject[] dataEntities, Map<String, Object> changedDataMap) {
        super(orgOpContext, dataEntities, changedDataMap);
    }

    @Override
    public void execute() {
        this.updateAfterViewDeleted();
        this.updateSubStructure();
        this.updateStructureLeaf();
        this.updateYzjOrgId();
        this.updateTimeZone();
    }

    private void updateSubStructure() {
        Map orgViewPropertyChangedMap = (Map)this.changedDataMap.get("propertyChanged");
        if (CollectionUtils.isEmpty((Map)orgViewPropertyChangedMap)) {
            return;
        }
        HashMap<Long, Map<Long, DynamicObject>> viewOrgStructureMap = new HashMap<Long, Map<Long, DynamicObject>>(64);
        for (DynamicObject orgObj : this.dataEntities) {
            DynamicObjectCollection structureCol = orgObj.getDynamicObjectCollection("structure");
            for (DynamicObject structureObj : structureCol) {
                DynamicObject viewObj = structureObj.getDynamicObject("view");
                if (viewObj == null) continue;
                Map orgStructureMap = viewOrgStructureMap.computeIfAbsent(viewObj.getLong("id"), k -> new HashMap(64));
                orgStructureMap.put(orgObj.getLong("id"), structureObj);
            }
        }
        this.updateSubStructure(orgViewPropertyChangedMap, viewOrgStructureMap);
        logger.info("\u3010\u7ec4\u7ec7\u4fdd\u5b58\u64cd\u4f5c\u3011\u66f4\u65b0\u7ec4\u7ec7\u7684\u4e0b\u7ea7\uff1a" + this.changeDataProvider.getData().keySet());
    }

    private void updateAfterViewDeleted() {
        Map orgViewDeletedMap = (Map)this.changedDataMap.get("viewChanged");
        logger.info("\u3010\u7ec4\u7ec7\u4fdd\u5b58\u64cd\u4f5c\u3011\u6267\u884c\u4e0b\u7ea7\u7ec4\u7ec7\u5f80\u539f\u7956\u7236\u8282\u70b9\u79fb\u52a8\uff1a" + orgViewDeletedMap.keySet());
        if (CollectionUtils.isEmpty((Map)orgViewDeletedMap)) {
            return;
        }
        int count = orgViewDeletedMap.size();
        HashMap<Long, Map<Long, List<Long>>> viewParentOrgMap = new HashMap<Long, Map<Long, List<Long>>>(count);
        HashMap<Long, Map<Long, Long>> viewOrgParentMap = new HashMap<Long, Map<Long, Long>>(count);
        HashSet<Long> parentIds = new HashSet<Long>(count);
        this.filterDeletedView(orgViewDeletedMap, viewParentOrgMap, viewOrgParentMap, parentIds);
        if (CollectionUtils.isEmpty((Map)orgViewDeletedMap)) {
            return;
        }
        HashMap<Long, Map<Long, DynamicObject>> viewOrgStructureMap = new HashMap<Long, Map<Long, DynamicObject>>(count);
        this.getParentStructureOfDeleted(viewOrgParentMap, parentIds, viewOrgStructureMap);
        if (viewOrgStructureMap.isEmpty()) {
            return;
        }
        HashMap<Long, Map<Long, DynamicObject>> viewOrgParentStructureMap = new HashMap<Long, Map<Long, DynamicObject>>(viewOrgStructureMap.size());
        for (Map.Entry viewEntry : viewParentOrgMap.entrySet()) {
            Long viewId = (Long)viewEntry.getKey();
            Map dbOrgStructureMap = (Map)viewOrgStructureMap.get(viewId);
            Map dbOrgParentMap = (Map)viewOrgParentMap.get(viewId);
            if (dbOrgStructureMap == null || dbOrgParentMap == null) continue;
            for (Map.Entry parentEntry : ((Map)viewEntry.getValue()).entrySet()) {
                DynamicObject parentStructureObj = this.getParentStructureObj((Long)parentEntry.getKey(), dbOrgStructureMap, dbOrgParentMap);
                if (parentStructureObj == null) continue;
                Map orgStructureMap = viewOrgParentStructureMap.computeIfAbsent(viewId, k -> new HashMap(64));
                for (Long orgIdKey : (List)parentEntry.getValue()) {
                    orgStructureMap.put(orgIdKey, parentStructureObj);
                }
            }
        }
        this.updateSubStructure(orgViewDeletedMap, viewOrgParentStructureMap);
    }

    private void getParentStructureOfDeleted(Map<Long, Map<Long, Long>> viewOrgParentMap, Set<Long> parentIds, Map<Long, Map<Long, DynamicObject>> viewOrgStructureMap) {
        QFilter idFilter = new QFilter("id", "in", parentIds);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject[] orgObjArr = OrgOperationUtils.getOrderOrgObject((QFilter[])filters);
        if (orgObjArr == null || orgObjArr.length == 0) {
            return;
        }
        for (DynamicObject orgObj : orgObjArr) {
            long id = orgObj.getLong("id");
            DynamicObjectCollection structureCol = orgObj.getDynamicObjectCollection("structure");
            for (DynamicObject structureObj : structureCol) {
                long viewId;
                DynamicObject viewObj = structureObj.getDynamicObject("view");
                if (viewObj == null || !viewOrgParentMap.containsKey(viewId = viewObj.getLong("id"))) continue;
                viewOrgStructureMap.computeIfAbsent(viewId, v -> new HashMap(parentIds.size())).put(id, structureObj);
            }
        }
    }

    private DynamicObject getParentStructureObj(Long parentId, Map<Long, DynamicObject> orgStructureMap, Map<Long, Long> orgParentMap) {
        DynamicObject parentStructureObj = orgStructureMap.get(parentId);
        if (parentStructureObj == null) {
            Long grandParentId = orgParentMap.get(parentId);
            if (grandParentId == null || grandParentId == 0L) {
                return null;
            }
            return this.getParentStructureObj(grandParentId, orgStructureMap, orgParentMap);
        }
        return parentStructureObj;
    }

    private void filterDeletedView(Map<Long, Map<Long, Map<String, OrgChangeData>>> orgViewPropertyChangedMap, Map<Long, Map<Long, List<Long>>> viewParentOrgMap, Map<Long, Map<Long, Long>> viewOrgParentMap, Set<Long> parentIds) {
        Iterator<Map.Entry<Long, Map<Long, Map<String, OrgChangeData>>>> iterator = orgViewPropertyChangedMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, Map<Long, Map<String, OrgChangeData>>> orgEntry = iterator.next();
            Long id = orgEntry.getKey();
            if (!this.orgOpContext.getDataEntityMap().containsKey(id)) {
                iterator.remove();
                continue;
            }
            for (Map.Entry<Long, Map<String, OrgChangeData>> viewEntry : orgEntry.getValue().entrySet()) {
                Long viewId = viewEntry.getKey();
                Map parentOrgMap = viewParentOrgMap.computeIfAbsent(viewId, k -> new HashMap(((Map)orgEntry.getValue()).size()));
                Map<String, OrgChangeData> propertyMap = viewEntry.getValue();
                OrgChangeData parentChange = propertyMap.get("viewparent");
                if (parentChange == null) continue;
                Long parentId = (Long)parentChange.getNewValue();
                parentOrgMap.computeIfAbsent(parentId, k -> new ArrayList()).add(id);
                viewOrgParentMap.computeIfAbsent(viewId, v -> new HashMap(((Map)orgEntry.getValue()).size())).put(id, parentId);
                if (parentId == 0L) continue;
                parentIds.add(parentId);
            }
        }
    }

    private void updateSubStructure(Map<Long, Map<Long, Map<String, OrgChangeData>>> orgViewPropertyChangedMap, Map<Long, Map<Long, DynamicObject>> viewOrgStructureMap) {
        if (viewOrgStructureMap.isEmpty()) {
            return;
        }
        logger.info("\u3010\u7ec4\u7ec7\u4fdd\u5b58\u64cd\u4f5c\u3011\u6267\u884c\u4e0b\u7ea7\u7ec4\u7ec7\u66f4\u65b0\uff1a" + viewOrgStructureMap.keySet());
        HashMap<String, Set> longNumberViewMap = new HashMap<String, Set>(64);
        String longNumberSep = this.orgOpContext.getConfigProvider().getOrgSeparation().getLongNumberSep();
        for (Map.Entry<Long, Map<Long, DynamicObject>> entry : viewOrgStructureMap.entrySet()) {
            Long viewId = entry.getKey();
            HashMap<Long, DynamicObject> topOrgPropertyMap = new HashMap<Long, DynamicObject>(entry.getValue());
            TreeSet<String> longNumberSet = new TreeSet<String>();
            for (Map.Entry structureEntry : topOrgPropertyMap.entrySet()) {
                OrgChangeData leafChangeData;
                DynamicObject structureObj = (DynamicObject)structureEntry.getValue();
                Long id = (Long)structureEntry.getKey();
                Map<String, OrgChangeData> changedPropertyMap = this.getChangedPropertyMap(viewId, orgViewPropertyChangedMap.get(id));
                if (changedPropertyMap == null || (leafChangeData = changedPropertyMap.get("isleaf")) != null && ((Boolean)leafChangeData.getOldValue()).booleanValue()) continue;
                longNumberSet.add(this.getOriginalLongNumber(changedPropertyMap, structureObj));
            }
            String parentLongNumber = null;
            for (String longNumber : longNumberSet) {
                if (parentLongNumber != null && longNumber.startsWith(parentLongNumber + longNumberSep)) continue;
                parentLongNumber = longNumber;
                longNumberViewMap.computeIfAbsent(longNumber, v -> new HashSet(64)).add(viewId);
            }
        }
        for (Map.Entry<Long, Map<Long, Object>> entry : longNumberViewMap.entrySet()) {
            String longNumber = (String)((Object)entry.getKey());
            Set viewIds = (Set)((Object)entry.getValue());
            this.updateSubStructure(viewIds, longNumber, longNumberSep, viewOrgStructureMap);
        }
    }

    private void updateSubStructure(Set<Long> viewIds, String longNumber, String longNumberSep, Map<Long, Map<Long, DynamicObject>> viewOrgStructureMap) {
        QFilter viewFilter = new QFilter("view", "in", viewIds);
        QFilter longNumberFilter = QFilter.like((String)"longnumber", (String)(longNumber + longNumberSep + "%"));
        QFilter[] filters = new QFilter[]{viewFilter, longNumberFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgSaveOpServiceAfterTrans.updateSubStructure.getOrgLikeLongNumber", (String)"bos_org_structure", (String)"view,org", (QFilter[])filters, (String)"level");){
            HashMap<Long, Set<Long>> orgViewMap = new HashMap<Long, Set<Long>>(100000);
            for (Row row : dataSet) {
                orgViewMap.computeIfAbsent(row.getLong("org"), v -> new HashSet(64)).add(row.getLong("view"));
                if (orgViewMap.size() < 100000) continue;
                this.saveSubStructure(orgViewMap, viewOrgStructureMap);
                orgViewMap.clear();
            }
            this.saveSubStructure(orgViewMap, viewOrgStructureMap);
        }
    }

    private void saveSubStructure(Map<Long, Set<Long>> orgViewMap, Map<Long, Map<Long, DynamicObject>> viewOrgStructureMap) {
        if (orgViewMap.isEmpty()) {
            return;
        }
        QFilter idFilter = new QFilter("id", "in", orgViewMap.keySet());
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject[] orgObjArr = OrgOperationUtils.getOrgObject((QFilter[])filters);
        if (orgObjArr == null || orgObjArr.length == 0) {
            return;
        }
        ArrayList<DynamicObject> updateObjList = new ArrayList<DynamicObject>(orgObjArr.length);
        HashMap<Long, TreeMap> viewLongNumberObjectTreeMap = new HashMap<Long, TreeMap>(64);
        for (DynamicObject orgObj : orgObjArr) {
            updateObjList.add(orgObj);
            Set<Long> viewIds = orgViewMap.get(orgObj.getPkValue());
            if (viewIds == null) continue;
            DynamicObjectCollection structureCol = orgObj.getDynamicObjectCollection("structure");
            for (DynamicObject structureObj : structureCol) {
                long viewId;
                DynamicObject viewObj = structureObj.getDynamicObject("view");
                if (viewObj == null || !viewIds.contains(viewId = viewObj.getLong("id"))) continue;
                HashMap<String, DynamicObject> objectMap = new HashMap<String, DynamicObject>(2);
                objectMap.put("org", orgObj);
                objectMap.put("structure", structureObj);
                viewLongNumberObjectTreeMap.computeIfAbsent(viewId, v -> new TreeMap()).put(structureObj.getString("longnumber"), objectMap);
            }
        }
        for (Map.Entry entry : viewLongNumberObjectTreeMap.entrySet()) {
            Long viewId = (Long)entry.getKey();
            Map<Long, DynamicObject> orgStructureMap = viewOrgStructureMap.get(viewId);
            if (orgStructureMap == null) continue;
            TreeMap longNumberObjectTreeMap = (TreeMap)entry.getValue();
            for (Map.Entry entry2 : longNumberObjectTreeMap.entrySet()) {
                Map objMap = (Map)entry2.getValue();
                DynamicObject orgObj = (DynamicObject)objMap.get("org");
                long id = orgObj.getLong("id");
                DynamicObject structureObj = (DynamicObject)objMap.get("structure");
                DynamicObject parentObj = structureObj.getDynamicObject("viewparent");
                long oldParentId = 0L;
                if (parentObj != null) {
                    oldParentId = parentObj.getLong("id");
                }
                String oldLongNumber = structureObj.getString("longnumber");
                OrgOperationUtils.generateStructureEntry((DynamicObject)orgObj, (DynamicObject)structureObj, orgStructureMap, null);
                parentObj = structureObj.getDynamicObject("viewparent");
                long newParentId = 0L;
                if (parentObj != null) {
                    newParentId = parentObj.getLong("id");
                }
                String newLongNumber = structureObj.getString("longnumber");
                this.changeDataProvider.putStructureChangeData(id, viewId.longValue(), "viewparent", (Object)oldParentId, (Object)newParentId);
                this.changeDataProvider.putStructureChangeData(id, viewId.longValue(), "longnumber", (Object)oldLongNumber, (Object)newLongNumber);
            }
        }
        this.save(updateObjList);
    }

    private Map<String, OrgChangeData> getChangedPropertyMap(long viewId, Map<Long, Map<String, OrgChangeData>> changedViewPropertyMap) {
        if (changedViewPropertyMap == null) {
            return null;
        }
        Map<String, OrgChangeData> propertyMap = changedViewPropertyMap.get(viewId);
        if (propertyMap == null) {
            propertyMap = changedViewPropertyMap.get(0L);
        }
        return propertyMap;
    }

    private String getOriginalLongNumber(Map<String, OrgChangeData> changedPropertyMap, DynamicObject structureObj) {
        String longNumber = structureObj.getString("longnumber");
        OrgChangeData changedLongNumber = changedPropertyMap.get("longnumber");
        if (changedLongNumber == null) {
            OrgChangeData number = changedPropertyMap.get("number");
            if (number != null) {
                longNumber = longNumber == null || longNumber.indexOf("!") < 0 ? String.valueOf(number.getOldValue()) : StringUtils.substringBeforeLast((String)longNumber, (String)"!") + "!" + number.getOldValue();
            }
        } else {
            longNumber = (String)changedLongNumber.getOldValue();
        }
        return longNumber;
    }

    private void updateStructureLeaf() {
        Map viewOrgMap = (Map)this.changedDataMap.get("leafChanged");
        HashSet<Long> changedViewIds = new HashSet<Long>(64);
        HashSet<Long> changedParentIds = new HashSet<Long>(64);
        Map<Long, Set<Long>> updatedLeafViewOrgMap = this.getTopParentNode(viewOrgMap);
        Iterator<Map.Entry<Long, Set<Long>>> iterator = updatedLeafViewOrgMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, Set<Long>> leafEntry = iterator.next();
            Set<Long> orgIds = leafEntry.getValue();
            if (orgIds.isEmpty()) {
                iterator.remove();
                continue;
            }
            changedViewIds.add(leafEntry.getKey());
            changedParentIds.addAll(orgIds);
        }
        this.updateStructureLeaf(updatedLeafViewOrgMap, changedViewIds, changedParentIds);
    }

    private Map<Long, Set<Long>> getTopParentNode(Map<Long, Set<Long>> viewOrgMap) {
        Map viewSortedOrgMap = this.orgOpContext.getViewSortedOrgMap();
        for (Map.Entry viewEntry : viewSortedOrgMap.entrySet()) {
            Long viewId = (Long)viewEntry.getKey();
            Set updatedLeafOrgIds = viewOrgMap.computeIfAbsent(viewId, v -> new HashSet(64));
            Map sortedOrgMap = (Map)viewEntry.getValue();
            for (Map.Entry orgEntry : sortedOrgMap.entrySet()) {
                Map orgMap = (Map)orgEntry.getValue();
                long parentId = (Long)orgMap.get("parentId");
                if (parentId != 0L) {
                    updatedLeafOrgIds.add(parentId);
                }
                this.getUpdatedLeafOrg(orgMap, updatedLeafOrgIds);
            }
        }
        return viewOrgMap;
    }

    private void getUpdatedLeafOrg(Map<String, Object> orgMap, Set<Long> updatedLeafOrgIds) {
        DynamicObject structureObj = (DynamicObject)orgMap.get("structure");
        if (structureObj.getBoolean("isleaf")) {
            return;
        }
        Map childrenMap = (Map)orgMap.get("children");
        if (CollectionUtils.isEmpty((Map)childrenMap)) {
            updatedLeafOrgIds.add((Long)orgMap.get("id"));
            return;
        }
        boolean hasChild = false;
        for (Map.Entry subOrgEntry : childrenMap.entrySet()) {
            Map subOrgMap = (Map)subOrgEntry.getValue();
            this.getUpdatedLeafOrg(subOrgMap, updatedLeafOrgIds);
            if (hasChild || !this.orgOpContext.getDataEntityMap().containsKey(subOrgMap.get("id"))) continue;
            hasChild = true;
        }
        if (hasChild) {
            updatedLeafOrgIds.remove(orgMap.get("id"));
        } else {
            updatedLeafOrgIds.add((Long)orgMap.get("id"));
        }
    }

    private void updateStructureLeaf(Map<Long, Set<Long>> updatedLeafViewOrgMap, Set<Long> changedViewIds, Set<Long> changedParentIds) {
        logger.info("\u3010\u7ec4\u7ec7\u4fdd\u5b58\u64cd\u4f5c\u3011\u66f4\u65b0\u4e0a\u7ea7\u7ec4\u7ec7\u53f6\u5b50\u8282\u70b9\u6807\u5fd7\uff1a" + updatedLeafViewOrgMap);
        if (updatedLeafViewOrgMap.isEmpty()) {
            return;
        }
        Map<Long, Map<Long, DynamicObject>> viewOrgStructureMap = this.getUpdatedLeafOrgDynamicObject(changedViewIds, changedParentIds);
        if (viewOrgStructureMap.isEmpty()) {
            return;
        }
        Map<Long, Set<Long>> viewOrgMap = this.getUpdatedLeafSubOrgDynamicObject(changedViewIds, changedParentIds);
        ArrayList<DynamicObject> updateObjList = new ArrayList<DynamicObject>(viewOrgStructureMap.size());
        for (Map.Entry<Long, Map<Long, DynamicObject>> viewEntry : viewOrgStructureMap.entrySet()) {
            Long viewId = viewEntry.getKey();
            Set<Long> notLeafOrgIds = viewOrgMap.get(viewId);
            Map<Long, DynamicObject> orgStructureMap = viewEntry.getValue();
            for (Map.Entry<Long, DynamicObject> orgEntry : orgStructureMap.entrySet()) {
                boolean isLeaf;
                Long orgId = orgEntry.getKey();
                DynamicObject structureObj = orgEntry.getValue();
                boolean dbIsLeaf = structureObj.getBoolean("isleaf");
                if (dbIsLeaf == (isLeaf = notLeafOrgIds == null || !notLeafOrgIds.contains(orgId))) continue;
                OrgOperationUtils.setStructureLeaf((DynamicObject)structureObj, (Boolean)isLeaf);
                updateObjList.add(structureObj);
                this.putStructureLeafChangeData(orgId, viewId, dbIsLeaf, isLeaf);
            }
        }
        this.save(updateObjList);
    }

    private void putStructureLeafChangeData(long id, long viewId, Boolean dbIsLeaf, Boolean currentIsLeaf) {
        OrgChangeData leafChangeData = this.changeDataProvider.getStructureProperty(id, viewId, "isleaf");
        if (leafChangeData == null) {
            leafChangeData = new OrgChangeData((Object)dbIsLeaf, (Object)currentIsLeaf);
            this.changeDataProvider.putStructureChangeData(id, viewId, "isleaf", leafChangeData);
        }
    }

    private Map<Long, Map<Long, DynamicObject>> getUpdatedLeafOrgDynamicObject(Set<Long> changedViewIds, Set<Long> changedParentIds) {
        QFilter viewFilter = new QFilter("view", "in", changedViewIds);
        QFilter idFilter = new QFilter("org", "in", changedParentIds);
        QFilter[] filters = new QFilter[]{viewFilter, idFilter};
        String selectFields = "id,view,org,isleaf,isbizunit,isstatsum";
        Map structureObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        HashMap<Long, Map<Long, DynamicObject>> viewOrgStructureMap = new HashMap<Long, Map<Long, DynamicObject>>(structureObjMap.size());
        for (Map.Entry entry : structureObjMap.entrySet()) {
            DynamicObject structureObj = (DynamicObject)entry.getValue();
            DynamicObject viewObj = structureObj.getDynamicObject("view");
            DynamicObject orgObj = structureObj.getDynamicObject("org");
            if (viewObj == null || orgObj == null) continue;
            Map orgStructureMap = viewOrgStructureMap.computeIfAbsent(viewObj.getLong("id"), v -> new HashMap(structureObjMap.size()));
            orgStructureMap.put(orgObj.getLong("id"), structureObj);
        }
        return viewOrgStructureMap;
    }

    private Map<Long, Set<Long>> getUpdatedLeafSubOrgDynamicObject(Set<Long> changedViewIds, Set<Long> changedParentIds) {
        QFilter viewFilter = new QFilter("view", "in", changedViewIds);
        QFilter idFilter = new QFilter("parent", "in", changedParentIds);
        QFilter[] filters = new QFilter[]{viewFilter, idFilter};
        String selectFields = "view,parent";
        HashMap<Long, Set<Long>> viewOrgMap = new HashMap<Long, Set<Long>>(changedViewIds.size());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgSaveOpPropertyChangeService.getUpdatedLeafSubOrgDynamicObject", (String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                Set orgIds = viewOrgMap.computeIfAbsent(row.getLong("view"), v -> new HashSet(changedParentIds.size()));
                orgIds.add(row.getLong("parent"));
            }
        }
        return viewOrgMap;
    }

    private void updateYzjOrgId() {
        QFilter idFilter;
        Map orgYzjorgIdMap = (Map)this.changedDataMap.get("yzjChanged");
        logger.info("\u3010\u7ec4\u7ec7\u4fdd\u5b58\u64cd\u4f5c\u3011\u66f4\u65b0\u4e91\u4e4b\u5bb6\u7ec4\u7ec7ID\uff1a" + orgYzjorgIdMap);
        if (orgYzjorgIdMap.isEmpty()) {
            return;
        }
        String selectFields = "id,parent,yzjparentorgid";
        QFilter viewFilter = new QFilter("view", "=", (Object)1L);
        QFilter[] filters = new QFilter[]{viewFilter, idFilter = new QFilter("parent", "in", orgYzjorgIdMap.keySet())};
        DynamicObject[] structureObjArr = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (structureObjArr == null || structureObjArr.length == 0) {
            return;
        }
        for (DynamicObject structureObj : structureObjArr) {
            DynamicObject parentObj = structureObj.getDynamicObject("parent");
            if (parentObj == null) continue;
            structureObj.set("yzjparentorgid", orgYzjorgIdMap.get(parentObj.getPkValue()));
        }
        SaveServiceHelper.save((DynamicObject[])structureObjArr);
    }

    private boolean save(List<DynamicObject> dynamicObjectList) {
        if (dynamicObjectList.isEmpty()) {
            return false;
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("orm_removeDataCache", "false");
        int[] count = new int[]{0};
        if (dynamicObjectList.size() <= 10000) {
            Object[] updatedObjArr = SaveServiceHelper.save((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]), (OperateOption)operateOption);
            count[0] = count[0] + (updatedObjArr == null ? 0 : updatedObjArr.length);
        } else {
            BaseBatchHandler.handle(dynamicObjectList, (int)10000, batchList -> {
                Object[] updatedObjArr = SaveServiceHelper.save((DynamicObject[])batchList.toArray(new DynamicObject[batchList.size()]), (OperateOption)operateOption);
                count[0] = count[0] + (updatedObjArr == null ? 0 : updatedObjArr.length);
            });
        }
        logger.info("\u3010\u7ec4\u7ec7\u4fdd\u5b58\u64cd\u4f5c\u3011\u6267\u884c\u53d8\u66f4\u5c5e\u6027\u7684\u66f4\u65b0\u4fdd\u5b58\uff1a" + count[0]);
        return count[0] > 0;
    }

    private void updateTimeZone() {
        Map timezoneIdMap = (Map)this.changedDataMap.get("timezoneChanged");
        if (CollectionUtils.isEmpty((Map)timezoneIdMap)) {
            return;
        }
        Map timeZoneObjMap = BusinessDataServiceHelper.loadFromCache((Object[])timezoneIdMap.values().toArray(new Object[0]), (String)"inte_timezone");
        HashMap orgTimezoneObjMap = new HashMap(timezoneIdMap.size());
        for (Map.Entry entry : timezoneIdMap.entrySet()) {
            orgTimezoneObjMap.put(entry.getKey(), timeZoneObjMap.get(entry.getValue()));
        }
        InteServiceHelper.saveOrgTimezone(orgTimezoneObjMap);
    }
}

