/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin.save;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.opplugin.AbstractOrgOpValidator;
import kd.bos.org.opplugin.IOrgOpValidatorHandler;
import kd.bos.org.opplugin.model.OrgOpContext;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.yzj.interfaces.IYzjOrgService;
import kd.bos.yzj.model.YzjConfig;
import kd.bos.yzj.model.org.YzjOrgParam;
import kd.bos.yzj.service.YzjServiceFactory;

public class OrgSaveOpSyncYunzhijiaValidator
extends AbstractOrgOpValidator {
    private static final Log logger = LogFactory.getLog(OrgSaveOpSyncYunzhijiaValidator.class);
    private IYzjOrgService yzjOrgService;
    private IOrgOpValidatorHandler validatorHandler;

    public OrgSaveOpSyncYunzhijiaValidator(OrgOpContext orgOpContext) {
        super(orgOpContext);
    }

    public void validate() {
        String doSyncToYunzhijiaOperation = this.getOption().getVariableValue("doSyncToYunzhijiaOperation", Boolean.TRUE.toString());
        if (!Boolean.parseBoolean(doSyncToYunzhijiaOperation)) {
            logger.info("\u3010\u7ec4\u7ec7\u4fdd\u5b58\u64cd\u4f5c\u3011\u53c2\u6570\u914d\u7f6e\u4e86\u4e0d\u6267\u884c\u540c\u6b65\u4e91\u4e4b\u5bb6\u3002");
            return;
        }
        YzjConfig yzjConfig = this.orgOpContext.getConfigProvider().getYzjConfig();
        if (3 == yzjConfig.getSyncMode()) {
            this.yzjOrgService = YzjServiceFactory.getOrgService((YzjConfig)yzjConfig);
            this.validatorHandler = this.orgOpContext.getValidatorHandler();
            this.sync();
        }
    }

    private void sync() {
        int count = this.dataEntities.length;
        TreeMap<String, ExtendedDataEntity> fullNameEntityMap = new TreeMap<String, ExtendedDataEntity>();
        TreeMap<String, DynamicObject> fullNameStructureMap = new TreeMap<String, DynamicObject>();
        HashMap<String, ExtendedDataEntity> yzjOrgIdEntityMap = new HashMap<String, ExtendedDataEntity>(count);
        HashMap<String, DynamicObject> yzjOrgIdStructureMap = new HashMap<String, DynamicObject>(count);
        block0: for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject orgObj = dataEntity.getDataEntity();
            long orgId = orgObj.getLong("id");
            if (this.orgOpContext.getErrorIds().contains(orgId)) continue;
            DynamicObjectCollection structureObjCol = orgObj.getDynamicObjectCollection("structure");
            for (DynamicObject structureObj : structureObjCol) {
                DynamicObject viewObj = structureObj.getDynamicObject("view");
                if (viewObj == null || 1L != viewObj.getLong("id")) continue;
                String yzjOrgId = orgObj.getString("fyzjorgid");
                if (StringUtils.isBlank((CharSequence)yzjOrgId)) {
                    String fullName = structureObj.getString("fullname");
                    fullNameEntityMap.put(fullName, dataEntity);
                    fullNameStructureMap.put(fullName, structureObj);
                    continue block0;
                }
                yzjOrgIdEntityMap.put(yzjOrgId, dataEntity);
                yzjOrgIdStructureMap.put(yzjOrgId, structureObj);
                continue block0;
            }
        }
        this.add(fullNameEntityMap, fullNameStructureMap);
        this.update(yzjOrgIdEntityMap, yzjOrgIdStructureMap);
    }

    private void add(TreeMap<String, ExtendedDataEntity> fullNameEntityMap, TreeMap<String, DynamicObject> fullNameStructureMap) {
        logger.info("\u3010\u7ec4\u7ec7\u4fdd\u5b58\u64cd\u4f5c\u3011\u6267\u884c\u540c\u6b65\u65b0\u589e\u7ec4\u7ec7\u5230\u4e91\u4e4b\u5bb6\uff1a" + fullNameEntityMap.keySet());
        if (fullNameEntityMap.isEmpty()) {
            return;
        }
        this.fillExistsYzjOrgId(fullNameEntityMap, fullNameStructureMap);
        if (fullNameEntityMap.isEmpty()) {
            return;
        }
        List<YzjOrgParam> fullNameOrgParamList = this.getSyncOrgParamList(fullNameEntityMap, true, fullNameStructureMap);
        this.yzjOrgService.add(fullNameOrgParamList);
        for (YzjOrgParam yzjOrgParam : fullNameOrgParamList) {
            ExtendedDataEntity dataEntity = fullNameEntityMap.get(yzjOrgParam.getFullname());
            if (dataEntity == null) continue;
            if (yzjOrgParam.isSuccess()) {
                DynamicObject orgObj = dataEntity.getDataEntity();
                String oldYzjOrgId = orgObj.getString("fyzjorgid");
                orgObj.set("fyzjorgid", (Object)yzjOrgParam.getYzjOrgId());
                orgObj.set("fyzjimorted", (Object)"1");
                if (!orgObj.getDataEntityState().getFromDatabase()) continue;
                this.orgOpContext.getChangeDataProvider().putOrgChangeData(orgObj.getLong("id"), "fyzjorgid", (Object)oldYzjOrgId, (Object)yzjOrgParam.getYzjOrgId());
                continue;
            }
            this.addSyncError(dataEntity, yzjOrgParam);
        }
        logger.info("\u3010\u7ec4\u7ec7\u4fdd\u5b58\u64cd\u4f5c\u3011\u6267\u884c\u540c\u6b65\u65b0\u589e\u7ec4\u7ec7\u5230\u4e91\u4e4b\u5bb6");
    }

    private void fillExistsYzjOrgId(TreeMap<String, ExtendedDataEntity> fullNameEntityMap, TreeMap<String, DynamicObject> fullNameStructureMap) {
        List<YzjOrgParam> fullNameOrgParamList = this.getSyncOrgParamList(fullNameEntityMap, true, fullNameStructureMap);
        List yzjOrgList = this.yzjOrgService.getByFullname(1, fullNameOrgParamList);
        if (CollectionUtils.isEmpty((Collection)yzjOrgList)) {
            return;
        }
        HashMap<String, String> departmentFullNameMap = new HashMap<String, String>(fullNameOrgParamList.size());
        for (YzjOrgParam yzjOrgParam : fullNameOrgParamList) {
            departmentFullNameMap.put(yzjOrgParam.getDepartment(), yzjOrgParam.getFullname());
        }
        HashMap<String, String> departmentYzjOrgIdMap = new HashMap<String, String>(yzjOrgList.size());
        HashMap<String, String> yzjOrgIdDepartmentMap = new HashMap<String, String>(yzjOrgList.size());
        for (Map dataMap : yzjOrgList) {
            String department = String.valueOf(dataMap.get("department"));
            String yzjOrgId = String.valueOf(dataMap.get("id"));
            departmentYzjOrgIdMap.put(department, yzjOrgId);
            yzjOrgIdDepartmentMap.put(yzjOrgId, department);
        }
        QFilter yzjOrgIdFilter = new QFilter("fyzjorgid", "in", departmentYzjOrgIdMap.keySet());
        QFilter[] filters = new QFilter[]{yzjOrgIdFilter};
        Map existsOrgObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,number,fyzjorgid", (QFilter[])filters);
        if (!CollectionUtils.isEmpty((Map)existsOrgObjMap)) {
            for (Map.Entry orgEntry : existsOrgObjMap.entrySet()) {
                ExtendedDataEntity dataEntity;
                String department;
                String fullName;
                DynamicObject orgObj = (DynamicObject)orgEntry.getValue();
                String yzjOrgId = orgObj.getString("fyzjorgid");
                if (yzjOrgId == null || (fullName = (String)departmentFullNameMap.get(department = (String)yzjOrgIdDepartmentMap.get(yzjOrgId))) == null || (dataEntity = fullNameEntityMap.remove(fullName)) == null) continue;
                this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00179", (Object[])new Object[]{orgObj.getString("number")}));
                departmentYzjOrgIdMap.remove(yzjOrgId);
            }
        }
        if (departmentYzjOrgIdMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : departmentYzjOrgIdMap.entrySet()) {
            ExtendedDataEntity dataEntity;
            String fullName = (String)departmentFullNameMap.get(entry.getKey());
            if (fullName == null || (dataEntity = fullNameEntityMap.remove(fullName)) == null) continue;
            DynamicObject orgObj = dataEntity.getDataEntity();
            orgObj.set("fyzjorgid", entry.getValue());
        }
    }

    private List<YzjOrgParam> getSyncOrgParamList(Map<String, ExtendedDataEntity> entityMap, boolean isFullName, TreeMap<String, DynamicObject> fullNameStructureMap) {
        ArrayList<YzjOrgParam> fullNameOrgParamList = new ArrayList<YzjOrgParam>(entityMap.size());
        for (Map.Entry<String, ExtendedDataEntity> entry : entityMap.entrySet()) {
            YzjOrgParam yzjOrgParam = new YzjOrgParam();
            if (isFullName) {
                String fullName = entry.getKey();
                yzjOrgParam.setFullname(fullName);
                DynamicObject structureObj = fullNameStructureMap.get(fullName);
                yzjOrgParam.setSortCode(this.yzjOrgService.getConfig().isSyncOrgSortNumberToYzj() ? structureObj.getString("sortnumber") : null);
            } else {
                yzjOrgParam.setYzjOrgId(entry.getValue().getDataEntity().getString("fyzjorgid"));
            }
            fullNameOrgParamList.add(yzjOrgParam);
        }
        return fullNameOrgParamList;
    }

    private void update(Map<String, ExtendedDataEntity> yzjOrgIdEntityMap, Map<String, DynamicObject> yzjOrgIdStructureMap) {
        logger.info("\u3010\u7ec4\u7ec7\u4fdd\u5b58\u64cd\u4f5c\u3011\u6267\u884c\u540c\u6b65\u66f4\u65b0\u7ec4\u7ec7\u5230\u4e91\u4e4b\u5bb6\uff1a" + yzjOrgIdEntityMap.keySet());
        if (yzjOrgIdEntityMap.isEmpty()) {
            return;
        }
        List<YzjOrgParam> orgParamList = this.getSyncOrgParamList(yzjOrgIdEntityMap, false, null);
        List yzjOrgList = this.yzjOrgService.get(0, orgParamList);
        ArrayList<YzjOrgParam> newParentParamList = new ArrayList<YzjOrgParam>(orgParamList.size());
        ArrayList<YzjOrgParam> newSortNumberParamList = new ArrayList<YzjOrgParam>(orgParamList.size());
        ArrayList<YzjOrgParam> newNameParamList = new ArrayList<YzjOrgParam>(orgParamList.size());
        for (Map yzjOrgMap : yzjOrgList) {
            DynamicObject orgObj;
            String name;
            String yzjOrgName;
            ExtendedDataEntity dataEntity;
            String yzjOrgId = String.valueOf(yzjOrgMap.get("id"));
            String yzjParentId = String.valueOf(yzjOrgMap.get("parentId"));
            DynamicObject structureObj = yzjOrgIdStructureMap.remove(yzjOrgId);
            if (structureObj != null) {
                String currentYzjParentId = structureObj.getString("yzjparentorgid");
                if (StringUtils.isBlank((CharSequence)currentYzjParentId)) {
                    structureObj.set("yzjparentorgid", (Object)yzjParentId);
                } else if (!currentYzjParentId.equals(yzjParentId)) {
                    YzjOrgParam yzjOrgParam = new YzjOrgParam();
                    yzjOrgParam.setYzjOrgId(yzjOrgId);
                    yzjOrgParam.setMoveToYzjOrgId(currentYzjParentId);
                    newParentParamList.add(yzjOrgParam);
                }
                String yzjSortNumber = yzjOrgMap.get("weights").toString();
                String currentSortNumber = structureObj.getString("sortnumber");
                if (!currentSortNumber.equals(yzjSortNumber)) {
                    YzjOrgParam yzjOrgParam = new YzjOrgParam();
                    yzjOrgParam.setYzjOrgId(yzjOrgId);
                    yzjOrgParam.setSortCode(currentSortNumber);
                    newSortNumberParamList.add(yzjOrgParam);
                }
            }
            if ((dataEntity = yzjOrgIdEntityMap.get(yzjOrgId)) == null || (yzjOrgName = String.valueOf(yzjOrgMap.get("name"))).equals(name = (orgObj = dataEntity.getDataEntity()).getString("name"))) continue;
            YzjOrgParam yzjOrgParam = new YzjOrgParam();
            yzjOrgParam.setYzjOrgId(yzjOrgId);
            yzjOrgParam.setName(name);
            newNameParamList.add(yzjOrgParam);
        }
        this.addSyncError(yzjOrgIdEntityMap, newParentParamList, newSortNumberParamList, newNameParamList);
        if (!yzjOrgIdStructureMap.isEmpty()) {
            TreeMap<String, ExtendedDataEntity> fullNameEntityMap = new TreeMap<String, ExtendedDataEntity>();
            TreeMap<String, DynamicObject> fullNameStructureMap = new TreeMap<String, DynamicObject>();
            for (Map.Entry<String, DynamicObject> entry : yzjOrgIdStructureMap.entrySet()) {
                String yzjOrgId = entry.getKey();
                DynamicObject structureObj = entry.getValue();
                String fullName = structureObj.getString("fullname");
                fullNameEntityMap.put(fullName, yzjOrgIdEntityMap.get(yzjOrgId));
                fullNameStructureMap.put(fullName, structureObj);
            }
            this.add(fullNameEntityMap, fullNameStructureMap);
        }
    }

    private void addSyncError(Map<String, ExtendedDataEntity> yzjOrgIdEntityMap, List<YzjOrgParam> newParentParamList, List<YzjOrgParam> newSortNumberParamList, List<YzjOrgParam> newNameParamList) {
        this.yzjOrgService.move(newParentParamList);
        for (YzjOrgParam yzjOrgParam : newParentParamList) {
            if (yzjOrgParam.isSuccess()) continue;
            this.addSyncError(yzjOrgIdEntityMap.get(yzjOrgParam.getYzjOrgId()), yzjOrgParam);
        }
        this.yzjOrgService.updateNameById(newNameParamList);
        for (YzjOrgParam yzjOrgParam : newNameParamList) {
            if (yzjOrgParam.isSuccess()) continue;
            this.addSyncError(yzjOrgIdEntityMap.get(yzjOrgParam.getYzjOrgId()), yzjOrgParam);
        }
        if (this.yzjOrgService.getConfig().isSyncOrgSortNumberToYzj()) {
            this.yzjOrgService.updateWeightById(newSortNumberParamList);
            for (YzjOrgParam yzjOrgParam : newSortNumberParamList) {
                if (yzjOrgParam.isSuccess()) continue;
                this.addSyncError(yzjOrgIdEntityMap.get(yzjOrgParam.getYzjOrgId()), yzjOrgParam);
            }
        }
    }

    private void addSyncError(ExtendedDataEntity dataEntity, YzjOrgParam yzjOrgParam) {
        this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00123", (Object[])new Object[]{yzjOrgParam.getMsg()}));
    }
}

