/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin.save;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.opplugin.IOrgOpValidatorHandler;
import kd.bos.org.opplugin.OrgOperationUtils;
import kd.bos.org.opplugin.common.OrgFieldLengthValidator;
import kd.bos.org.opplugin.common.OrgFullNameValidator;
import kd.bos.org.opplugin.model.OrgChangeData;
import kd.bos.org.opplugin.model.OrgChangeDataProvider;
import kd.bos.org.opplugin.model.OrgOpContext;
import kd.bos.org.utils.OrgChangeType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class OrgStructureValidator {
    private static final Log logger = LogFactory.getLog(OrgStructureValidator.class);
    private final OrgOpContext orgOpContext;
    private final Map<Long, ExtendedDataEntity> dataEntityMap;
    private final boolean validateAndSave;
    private final IOrgOpValidatorHandler validatorHandler;
    private final OrgChangeDataProvider changeDataProvider;
    private final OrgFullNameValidator orgFullNameValidator;
    private final OrgFieldLengthValidator orgFieldLengthValidator;

    public OrgStructureValidator(OrgOpContext orgOpContext, boolean validateAndSave) {
        this.orgOpContext = orgOpContext;
        this.validateAndSave = validateAndSave;
        this.validatorHandler = this.orgOpContext.getValidatorHandler();
        this.changeDataProvider = this.orgOpContext.getChangeDataProvider();
        this.dataEntityMap = this.orgOpContext.getDataEntityMap();
        this.orgFullNameValidator = new OrgFullNameValidator(orgOpContext, true);
        this.orgFieldLengthValidator = new OrgFieldLengthValidator(this.orgOpContext);
    }

    public void validate() {
        Map viewSortedOrgMap = this.orgOpContext.getViewSortedOrgMap();
        HashMap<Long, Map<Object, Map<String, Object>>> viewRootOrgMap = new HashMap<Long, Map<Object, Map<String, Object>>>(64);
        for (Map.Entry viewEntry : viewSortedOrgMap.entrySet()) {
            Long viewId = (Long)viewEntry.getKey();
            Map sortedOrgMap = (Map)viewEntry.getValue();
            for (Map.Entry orgEntry : sortedOrgMap.entrySet()) {
                Map orgMap = (Map)orgEntry.getValue();
                long parentId = (Long)orgMap.get("parentId");
                if (parentId == 0L) {
                    viewRootOrgMap.computeIfAbsent(viewId, v -> new HashMap(64)).put(orgEntry.getKey(), orgMap);
                    continue;
                }
                long id = (Long)orgMap.get("id");
                this.validateDefaultRootOrg(this.dataEntityMap.get(id), viewId, id);
            }
        }
        this.validateRootOrg(viewRootOrgMap);
        TreeMap<Long, Map<Long, List<ExtendedDataEntity>>> checkFullNameViewParentOrgMap = new TreeMap<Long, Map<Long, List<ExtendedDataEntity>>>();
        for (Map.Entry viewEntry : viewSortedOrgMap.entrySet()) {
            Long viewId = (Long)viewEntry.getKey();
            Map sortedOrgMap = (Map)viewEntry.getValue();
            HashMap<Long, Map<String, Map<String, List<Long>>>> parentLangNameOrgMap = new HashMap<Long, Map<String, Map<String, List<Long>>>>(sortedOrgMap.size());
            for (Map.Entry orgEntry : sortedOrgMap.entrySet()) {
                Map orgMap = (Map)orgEntry.getValue();
                this.validateStructure(viewId, orgMap, parentLangNameOrgMap, checkFullNameViewParentOrgMap);
            }
        }
        this.orgFullNameValidator.validate(checkFullNameViewParentOrgMap);
        this.orgFullNameValidator.validateAfterDelete();
        this.validateBizFreeze();
        this.orgFieldLengthValidator.validateSubStructureField();
        this.setSortCode();
    }

    private void setSortCode() {
        for (ExtendedDataEntity dataEntity : this.dataEntityMap.values()) {
            DynamicObject orgObj = dataEntity.getDataEntity();
            if (!orgObj.getDataEntityState().getFromDatabase()) continue;
            DynamicObjectCollection structureObjs = orgObj.getDynamicObjectCollection("structure");
            for (DynamicObject structureObj : structureObjs) {
                DynamicObject viewObj = structureObj.getDynamicObject("view");
                OrgOperationUtils.setSortNumber((DynamicObject)orgObj, (DynamicObject)structureObj, (DynamicObject)viewObj);
            }
        }
    }

    private void validateStructure(long viewId, Map<String, Object> orgMap, Map<Long, Map<String, Map<String, List<Long>>>> parentLangNameOrgMap, Map<Long, Map<Long, List<ExtendedDataEntity>>> checkFullNameViewParentOrgMap) {
        Object id = orgMap.get("id");
        if (this.validateAndSave && this.orgOpContext.getErrorIds().contains(id)) {
            return;
        }
        ExtendedDataEntity dataEntity = this.dataEntityMap.get(id);
        long parentId = (Long)orgMap.get("parentId");
        DynamicObject parentStructObj = (DynamicObject)orgMap.get("structure.viewparent");
        this.filterNeedToCheckFullNameOrg(dataEntity, checkFullNameViewParentOrgMap, viewId, parentStructObj, orgMap);
        this.validateParent(dataEntity, viewId, orgMap, parentStructObj);
        this.orgFullNameValidator.validate(dataEntity, Long.valueOf(viewId), parentLangNameOrgMap, Long.valueOf(parentId));
        this.validateFreeze(dataEntity, viewId);
        this.validateCtrlUnit(dataEntity, viewId, orgMap);
        this.validateEnable(dataEntity, orgMap);
        this.validateStatus(dataEntity, orgMap);
        this.validateSubOrg(viewId, orgMap);
    }

    private void filterNeedToCheckFullNameOrg(ExtendedDataEntity dataEntity, Map<Long, Map<Long, List<ExtendedDataEntity>>> checkFullNameViewParentOrgMap, long viewId, DynamicObject parentStructObj, Map<String, Object> orgMap) {
        boolean checkNameDuplicate;
        if (checkFullNameViewParentOrgMap == null || parentStructObj == null || !parentStructObj.getDataEntityState().getFromDatabase()) {
            return;
        }
        if (this.validateAndSave) {
            DynamicObject orgObj = dataEntity.getDataEntity();
            long id = orgObj.getLong("id");
            if (orgObj.getDataEntityState().getFromDatabase()) {
                OrgChangeData changeData = this.changeDataProvider.getOrgProperty(id, "name");
                if (changeData == null) {
                    changeData = this.changeDataProvider.getStructureProperty(id, viewId, "viewparent");
                }
                boolean bl = checkNameDuplicate = changeData != null;
                if (!checkNameDuplicate) {
                    Map viewChangeData = this.changeDataProvider.getViewChangeData(id, "add");
                    checkNameDuplicate = viewChangeData.containsKey(viewId);
                }
            } else {
                checkNameDuplicate = true;
            }
        } else {
            checkNameDuplicate = true;
        }
        if (checkNameDuplicate) {
            Map parentOrgMap = checkFullNameViewParentOrgMap.computeIfAbsent(viewId, k -> new HashMap(64));
            long parentId = (Long)orgMap.get("parentId");
            List orgObjList = parentOrgMap.computeIfAbsent(parentId, k -> new ArrayList(64));
            orgObjList.add(dataEntity);
        }
    }

    private void validateSubOrg(long viewId, Map<String, Object> orgMap) {
        Map childrenMap = (Map)orgMap.get("children");
        if (CollectionUtils.isEmpty((Map)childrenMap)) {
            return;
        }
        HashMap<Long, Map<String, Map<String, List<Long>>>> parentLangNameOrgMap = new HashMap<Long, Map<String, Map<String, List<Long>>>>(childrenMap.size());
        for (Map.Entry subOrgEntry : childrenMap.entrySet()) {
            Map subOrgMap = (Map)subOrgEntry.getValue();
            this.validateStructure(viewId, subOrgMap, parentLangNameOrgMap, null);
        }
    }

    private void validateDefaultRootOrg(ExtendedDataEntity dataEntity, long viewId, long orgId) {
        if (this.orgOpContext.getDataProvider().getRootOrgId() != orgId) {
            return;
        }
        if (OrgChangeType.RESETROOT.getChangeType().equals(this.orgOpContext.getOperationKey())) {
            return;
        }
        if (1L == viewId) {
            this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00098"));
        } else if (15L == viewId) {
            this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00097"));
        }
    }

    private void validateRootOrg(Map<Long, Map<Object, Map<String, Object>>> viewRootOrgMap) {
        logger.info("\u3010\u7ec4\u7ec7\u4fdd\u5b58\u64cd\u4f5c\u3011\u6267\u884c\u6839\u7ec4\u7ec7\u6821\u9a8c\uff1a" + viewRootOrgMap);
        Map<Long, Long> deletedRootOrgMap = this.validateDeleteRootOrg(viewRootOrgMap);
        if (viewRootOrgMap.isEmpty()) {
            return;
        }
        QFilter viewFilter = new QFilter("view", "in", viewRootOrgMap.keySet());
        QFilter parentFilter = new QFilter("parent", "=", (Object)0L);
        QFilter levelFilter = new QFilter("level", "=", (Object)1);
        QFilter[] filters = new QFilter[]{viewFilter, parentFilter, levelFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgStructureValidator.validateRootOrg.query", (String)"bos_org_structure", (String)"org,org.name name,view,view.name", (QFilter[])filters, (String)"view");){
            for (Row row : dataSet) {
                this.validateRootOrg(viewRootOrgMap, deletedRootOrgMap, row);
            }
        }
    }

    private Map<Long, Long> validateDeleteRootOrg(Map<Long, Map<Object, Map<String, Object>>> viewRootOrgMap) {
        HashMap<Long, List<Long>> allDeletedViewOrgMap = new HashMap<Long, List<Long>>(64);
        HashMap<Long, Long> deletedRootOrgMap = new HashMap<Long, Long>(64);
        this.filterDeletedOrgFromView(allDeletedViewOrgMap, deletedRootOrgMap);
        for (Map.Entry viewEntry : deletedRootOrgMap.entrySet()) {
            QFilter[] filters;
            Long viewId = (Long)viewEntry.getKey();
            if (viewRootOrgMap.containsKey(viewId)) continue;
            QFilter viewFilter = new QFilter("view", "=", (Object)viewId);
            List orgIds = (List)allDeletedViewOrgMap.get(viewId);
            if (!CollectionUtils.isEmpty((Collection)orgIds)) {
                QFilter orgFilter = new QFilter("org", "not in", (Object)orgIds);
                viewFilter = viewFilter.and(orgFilter);
            }
            if (!QueryServiceHelper.exists((String)"bos_org_structure", (QFilter[])(filters = new QFilter[]{viewFilter}))) continue;
            DynamicObject viewObj = (DynamicObject)this.orgOpContext.getDataProvider().getViewDynamicObjectMap().get(viewId);
            String viewName = viewObj == null ? Long.toString(viewId) : viewObj.getString("name");
            this.validatorHandler.handle(this.dataEntityMap.get(viewEntry.getValue()), OrgMessage.getMessage((String)"M00226", (Object[])new Object[]{viewName}));
        }
        return deletedRootOrgMap;
    }

    private void filterDeletedOrgFromView(Map<Long, List<Long>> allDeletedViewOrgMap, Map<Long, Long> deletedRootOrgMap) {
        Map data = this.changeDataProvider.getData();
        for (Map.Entry orgEntry : data.entrySet()) {
            Map deleteMap;
            Map structureMap = (Map)((Map)orgEntry.getValue()).get("structure");
            if (structureMap == null || (deleteMap = (Map)structureMap.get("delete")) == null) continue;
            for (Map.Entry viewEntry : deleteMap.entrySet()) {
                allDeletedViewOrgMap.computeIfAbsent((Long)viewEntry.getKey(), (Function<Long, List<Long>>)((Function<Long, List>)v -> new ArrayList(data.size()))).add(orgEntry.getKey());
                OrgChangeData orgChangeData = (OrgChangeData)((Map)viewEntry.getValue()).get("viewparent");
                if (orgChangeData == null || !Objects.equals(0L, orgChangeData.getNewValue())) continue;
                deletedRootOrgMap.put((Long)viewEntry.getKey(), (Long)orgEntry.getKey());
            }
        }
    }

    private void validateRootOrg(Map<Long, Map<Object, Map<String, Object>>> viewRootOrgMap, Map<Long, Long> deletedRootOrgMap, Row row) {
        Long viewId = row.getLong("view");
        Long oldRootOrgId = row.getLong("org");
        boolean isRootOrgChanged = this.isRootOrgChanged(deletedRootOrgMap, oldRootOrgId, viewId);
        Map<Object, Map<String, Object>> rootOrgMap = viewRootOrgMap.get(viewId);
        for (Map.Entry<Object, Map<String, Object>> orgEntry : rootOrgMap.entrySet()) {
            Map<String, Object> orgMap = orgEntry.getValue();
            long newRootOrgId = (Long)orgMap.get("id");
            if (newRootOrgId == oldRootOrgId) continue;
            if (isRootOrgChanged) {
                this.orgOpContext.getChangeDataProvider().getRootChangeDataList().add(new OrgChangeData((Object)oldRootOrgId, (Object)newRootOrgId));
                continue;
            }
            ExtendedDataEntity dataEntity = this.dataEntityMap.get(newRootOrgId);
            this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00132", (Object[])new Object[]{row.getString("view.name")}));
        }
    }

    private boolean isRootOrgChanged(Map<Long, Long> deletedRootOrgMap, long rootOrgId, long viewId) {
        if (Objects.equals(rootOrgId, deletedRootOrgMap.get(viewId))) {
            return true;
        }
        OrgChangeData parentData = this.changeDataProvider.getStructureProperty(rootOrgId, viewId, "viewparent");
        if (parentData == null) {
            return false;
        }
        return (Long)parentData.getNewValue() > 0L;
    }

    private void validateParent(ExtendedDataEntity dataEntity, Long viewId, Map<String, Object> orgMap, DynamicObject parentStructObj) {
        DynamicObject structureObj = (DynamicObject)orgMap.get("structure");
        DynamicObject viewObj = structureObj.getDynamicObject("view");
        if (viewObj == null && (viewObj = (DynamicObject)this.orgOpContext.getDataProvider().getViewDynamicObjectMap().get(viewId)) == null) {
            return;
        }
        this.validateLevel(dataEntity, viewObj, structureObj, parentStructObj);
        DynamicObject parentObj = structureObj.getDynamicObject("viewparent");
        if (parentObj == null) {
            this.validateLevel(dataEntity, viewObj, structureObj, null);
            return;
        }
        if (parentStructObj == null) {
            this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00164", (Object[])new Object[]{parentObj.getString("name"), viewObj.getString("name")}));
            return;
        }
        this.validateLevel(dataEntity, viewObj, structureObj, parentStructObj);
        if (1L == viewId && !structureObj.getBoolean("isfreeze") && parentStructObj.getBoolean("isfreeze")) {
            this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00167", (Object[])new Object[]{viewObj.getString("name")}));
            return;
        }
        this.validateParent(structureObj, parentStructObj, viewObj, dataEntity);
    }

    private void validateLevel(ExtendedDataEntity dataEntity, DynamicObject viewObj, DynamicObject structureObj, DynamicObject parentStructObj) {
        if (this.validateAndSave) {
            return;
        }
        int level = structureObj.getInt("level");
        int correctLevel = 1;
        if (parentStructObj != null) {
            correctLevel += parentStructObj.getInt("level");
        }
        if (level != correctLevel) {
            this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00210", (Object[])new Object[]{viewObj.getString("name"), level, correctLevel}));
        }
    }

    private void validateParent(DynamicObject structureObj, DynamicObject parentStructObj, DynamicObject viewObj, ExtendedDataEntity dataEntity) {
        DynamicObject parentObj;
        long parentId;
        DynamicObject orgObj = dataEntity.getDataEntity();
        long id = orgObj.getLong("id");
        if (id == (parentId = (parentObj = structureObj.getDynamicObject("viewparent")).getLong("id"))) {
            this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00165", (Object[])new Object[]{viewObj.getString("name")}));
            return;
        }
        String longNumber = structureObj.getString("longnumber");
        if (StringUtils.isBlank((CharSequence)longNumber)) {
            this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00169", (Object[])new Object[]{orgObj.getString("name")}));
            return;
        }
        if (parentStructObj.getString("longnumber").startsWith(longNumber + "!")) {
            this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00166", (Object[])new Object[]{viewObj.getString("name")}));
            return;
        }
        String[] numbers = longNumber.split("!");
        ArrayList<String> numberList = new ArrayList<String>(numbers.length);
        for (String number : numbers) {
            if (numberList.contains(number)) {
                this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00166", (Object[])new Object[]{viewObj.getString("name")}));
                return;
            }
            numberList.add(number);
        }
    }

    private void validateEnable(ExtendedDataEntity dataEntity, Map<String, Object> orgMap) {
        if (this.validateAndSave) {
            return;
        }
        DynamicObject structureObj = (DynamicObject)orgMap.get("structure");
        if (!structureObj.getBoolean("viewenable")) {
            this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00171", (Object[])new Object[]{structureObj.getDynamicObject("view").getString("name")}));
        }
    }

    private void validateStatus(ExtendedDataEntity dataEntity, Map<String, Object> orgMap) {
        if (this.validateAndSave) {
            return;
        }
        DynamicObject structureObj = (DynamicObject)orgMap.get("structure");
        if (!"C".equals(structureObj.get("viewstatus"))) {
            this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00172", (Object[])new Object[]{structureObj.getDynamicObject("view").getString("name")}));
        }
    }

    private void validateFreeze(ExtendedDataEntity dataEntity, Long viewId) {
        DynamicObject orgObj = dataEntity.getDataEntity();
        OrgChangeData changeData = this.changeDataProvider.getStructureProperty(orgObj.getLong("id"), viewId.longValue(), "isfreeze");
        if (changeData == null) {
            return;
        }
        this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)((Boolean)changeData.getNewValue() != false ? "M00184" : "M00185")));
    }

    private void validateCtrlUnit(ExtendedDataEntity dataEntity, Long viewId, Map<String, Object> orgMap) {
        DynamicObject structureObj = (DynamicObject)orgMap.get("structure");
        DynamicObject viewObj = structureObj.getDynamicObject("view");
        if (viewObj == null) {
            return;
        }
        DynamicObject orgObj = dataEntity.getDataEntity();
        if (!"16".equals(viewObj.getString("treetype"))) {
            if (!structureObj.getBoolean("isctrlunit")) {
                this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00173", (Object[])new Object[]{viewObj.getString("name"), orgObj.getString("name")}));
            }
            return;
        }
        if (structureObj.getBoolean("isctrlunit")) {
            DynamicObject parentObj = structureObj.getDynamicObject("viewparent");
            long parentId = 0L;
            DynamicObject parentStructureObj = null;
            if (parentObj != null) {
                parentId = parentObj.getLong("id");
                parentStructureObj = (DynamicObject)orgMap.get("structure.viewparent");
            }
            if (this.orgOpContext.getErrorIds().contains(parentId) || parentStructureObj != null && !parentStructureObj.getBoolean("isctrlunit")) {
                this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00174", (Object[])new Object[]{viewObj.getString("name"), orgObj.getString("name")}));
            }
        } else if (orgObj.getDataEntityState().getFromDatabase()) {
            this.validateCancelCtrlUnit(dataEntity, viewId, orgMap);
        }
    }

    private void validateCancelCtrlUnit(ExtendedDataEntity dataEntity, Long viewId, Map<String, Object> orgMap) {
        DynamicObject orgObj = dataEntity.getDataEntity();
        DynamicObject structureObj = (DynamicObject)orgMap.get("structure");
        if (structureObj.getDynamicObject("viewparent") == null) {
            this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00175", (Object[])new Object[]{orgObj.getString("name")}));
            return;
        }
        if (structureObj.getBoolean("isleaf")) {
            return;
        }
        long id = orgObj.getLong("id");
        OrgChangeData orgChangeData = this.changeDataProvider.getStructureProperty(id, viewId.longValue(), "isctrlunit");
        if (orgChangeData == null) {
            return;
        }
        QFilter viewFilter = new QFilter("view", "=", (Object)viewId);
        QFilter ctrlUnitFilter = new QFilter("isctrlunit", "=", (Object)Boolean.TRUE);
        QFilter longNumberFilter = QFilter.like((String)"longnumber", (String)(structureObj.getString("longnumber") + "!" + "%"));
        QFilter[] filters = new QFilter[]{viewFilter, ctrlUnitFilter, longNumberFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgStructureValidator.validateCancelCtrlUnit", (String)"bos_org_structure", (String)"org,org.name name,parent,isctrlunit", (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                Long subOrgId = row.getLong("org");
                Map viewDeletedMap = this.changeDataProvider.getViewChangeData(subOrgId.longValue(), "delete");
                if (viewDeletedMap.containsKey(viewId) || this.isParentChanged(viewId, subOrgId, id) || (orgChangeData = this.changeDataProvider.getStructureProperty(subOrgId.longValue(), viewId.longValue(), "isctrlunit")) != null && !((Boolean)orgChangeData.getNewValue()).booleanValue()) continue;
                this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00176", (Object[])new Object[]{structureObj.getDynamicObject("view").getString("name"), orgObj.getString("name"), row.getString("name")}));
                break;
            }
        }
    }

    private boolean isParentChanged(Long viewId, long id, long parentId) {
        OrgChangeData orgChangeData = this.changeDataProvider.getStructureProperty(id, viewId.longValue(), "viewparent");
        if (orgChangeData == null) {
            return false;
        }
        return parentId != (Long)orgChangeData.getNewValue();
    }

    private void validateBizFreeze() {
        Map data = this.orgOpContext.getChangeDataProvider().getData();
        for (Map.Entry entry : data.entrySet()) {
            Map deleteMap;
            Map structureMap = (Map)((Map)entry.getValue()).get("structure");
            if (structureMap == null || (deleteMap = (Map)structureMap.get("delete")) == null) continue;
            for (Map.Entry viewEntry : deleteMap.entrySet()) {
                Map changeMap;
                OrgChangeData orgChangeData;
                DynamicObject bizObj;
                DynamicObject viewObj = (DynamicObject)this.orgOpContext.getDataProvider().getViewDynamicObjectMap().get(viewEntry.getKey());
                if (viewObj == null || !viewObj.getBoolean("isdefault") || (bizObj = viewObj.getDynamicObject("treetypeid")) == null || (orgChangeData = (OrgChangeData)(changeMap = (Map)viewEntry.getValue()).get("isfreeze")) == null || !((Boolean)orgChangeData.getOldValue()).booleanValue()) continue;
                this.validatorHandler.handle(this.dataEntityMap.get(entry.getKey()), OrgMessage.getMessage((String)"M00206", (Object[])new Object[]{bizObj.getString("fname"), viewObj.getString("name")}));
            }
        }
    }
}

