/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin.save;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgSeparation;
import kd.bos.org.opplugin.IOrgOpValidatorHandler;
import kd.bos.org.opplugin.model.OrgChangeData;
import kd.bos.org.opplugin.model.OrgOpContext;
import kd.bos.org.opplugin.save.OrgPatternValidator;
import kd.bos.org.opplugin.save.OrgStructureValidator;
import kd.bos.org.opplugin.save.OrgValidatorPreparation;
import kd.bos.org.opplugin.save.OrgViewValidator;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

public class OrgValidator {
    private static final Log logger = LogFactory.getLog(OrgValidator.class);
    private final OrgOpContext orgOpContext;
    private final ExtendedDataEntity[] dataEntities;
    private final boolean validateAndSave;
    private final IOrgOpValidatorHandler validatorHandler;

    public OrgValidator(OrgOpContext orgOpContext, ExtendedDataEntity[] dataEntities, boolean validateAndSave) {
        this.orgOpContext = orgOpContext;
        this.dataEntities = dataEntities;
        this.validateAndSave = validateAndSave;
        this.validatorHandler = this.orgOpContext.getValidatorHandler();
    }

    public void validate() {
        logger.info("\u3010\u7ec4\u7ec7\u4fdd\u5b58\u64cd\u4f5c\u3011\u6267\u884c\u7ec4\u7ec7\u5408\u6cd5\u6027\u6821\u9a8c\uff1a" + this.dataEntities.length);
        OrgValidatorPreparation prepare = new OrgValidatorPreparation(this.orgOpContext, this.dataEntities, this.validateAndSave);
        prepare.execute();
        HashMap<String, Long> numberOrgMap = new HashMap<String, Long>(this.dataEntities.length);
        OrgSeparation orgSeparation = this.orgOpContext.getConfigProvider().getOrgSeparation();
        String longNumberSep = orgSeparation.getLongNumberSep();
        String fullNameSep = orgSeparation.getFullNameSep();
        Map enableLangMap = this.orgOpContext.getDataProvider().getLanguageNameMap();
        Lang currentLang = RequestContext.get().getLang();
        boolean isValidateOrgProperty = this.orgOpContext.isOrgApiBuildView() == false;
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            if (isValidateOrgProperty) {
                this.numberValidate(dataEntity, numberOrgMap, longNumberSep);
                this.nameValidate(dataEntity, fullNameSep, enableLangMap, currentLang);
                this.statusValidate(dataEntity);
                this.businessTermValidate(dataEntity);
            }
            OrgViewValidator viewValidator = new OrgViewValidator(this.orgOpContext, dataEntity);
            Map<Long, DynamicObject> viewStructureMap = viewValidator.validate();
            OrgPatternValidator patternValidator = new OrgPatternValidator(this.orgOpContext, dataEntity, viewStructureMap);
            patternValidator.validate();
        }
        this.numberUniqueValidate(numberOrgMap);
        OrgStructureValidator structureValidator = new OrgStructureValidator(this.orgOpContext, this.validateAndSave);
        structureValidator.validate();
    }

    private void numberValidate(ExtendedDataEntity dataEntity, Map<String, Long> numberOrgMap, String longNumberSep) {
        OrgChangeData orgChangeData;
        DynamicObject orgObj = dataEntity.getDataEntity();
        long id = orgObj.getLong("id");
        if (this.validateAndSave && orgObj.getDataEntityState().getFromDatabase() && (orgChangeData = this.orgOpContext.getChangeDataProvider().getOrgProperty(id, "number")) == null) {
            return;
        }
        String number = orgObj.getString("number");
        if (StringUtils.isBlank((CharSequence)number)) {
            this.validatorHandler.handle(dataEntity, BaseMessage.getMessage((String)"M00003"));
        } else {
            String errorMsg = OrgViewUtils.isOrgNumberValid((String)number, (String)longNumberSep);
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                this.validatorHandler.handle(dataEntity, errorMsg);
                return;
            }
            Long existsOrgId = numberOrgMap.get(number);
            if (existsOrgId == null || existsOrgId.equals(id)) {
                numberOrgMap.put(number, id);
            } else {
                this.validatorHandler.handle(dataEntity, BaseMessage.getMessage((String)"M00012"));
            }
        }
    }

    private void numberUniqueValidate(Map<String, Long> numberOrgMap) {
        logger.info("\u3010\u7ec4\u7ec7\u4fdd\u5b58\u64cd\u4f5c\u3011\u6267\u884c\u7f16\u7801\u552f\u4e00\u6027\u6821\u9a8c\uff1a" + numberOrgMap);
        if (CollectionUtils.isEmpty(numberOrgMap)) {
            return;
        }
        Object numberOrgCompareMap = this.orgOpContext.isNameCaseInsensitive() != false ? new CaseInsensitiveMap(numberOrgMap) : new HashMap<String, Long>(numberOrgMap);
        QFilter numberFilter = new QFilter("number", "in", numberOrgMap.keySet());
        QFilter[] filters = new QFilter[]{numberFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgValidator.numberUniqueValidate", (String)"bos_org", (String)"id,number,fisadministrative,isbizorg", (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                String number;
                Long numberOrgId;
                Long id = row.getLong("id");
                if (Objects.equals(id, numberOrgId = (Long)numberOrgCompareMap.get(number = row.getString("number")))) continue;
                ExtendedDataEntity dataEntity = (ExtendedDataEntity)this.orgOpContext.getDataEntityMap().get(numberOrgId);
                if (this.orgOpContext.isFromAdminOrg()) {
                    if (row.getBoolean("fisadministrative").booleanValue()) {
                        this.validatorHandler.handle(dataEntity, BaseMessage.getMessage((String)"M00012"));
                        continue;
                    }
                    this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00203"));
                    continue;
                }
                if (row.getBoolean("isbizorg").booleanValue()) {
                    this.validatorHandler.handle(dataEntity, BaseMessage.getMessage((String)"M00012"));
                    continue;
                }
                this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00204"));
            }
        }
    }

    private void nameValidate(ExtendedDataEntity dataEntity, String fullNameSep, Map<String, String> enableLangMap, Lang currentLang) {
        OrgChangeData orgChangeData;
        DynamicObject orgObj = dataEntity.getDataEntity();
        long id = orgObj.getLong("id");
        if (this.validateAndSave && orgObj.getDataEntityState().getFromDatabase() && (orgChangeData = this.orgOpContext.getChangeDataProvider().getOrgProperty(id, "name")) == null) {
            return;
        }
        String errorMsg = OrgViewUtils.isOrgNameValid((ILocaleString)orgObj.getLocaleString("name"), (String)fullNameSep, enableLangMap, (Lang)currentLang);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            this.validatorHandler.handle(dataEntity, errorMsg);
        }
    }

    private void statusValidate(ExtendedDataEntity dataEntity) {
        String status = dataEntity.getDataEntity().getString("status");
        if (StringUtils.isBlank((CharSequence)status) || !this.validateAndSave && !"C".equals(status)) {
            this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00162"));
        }
    }

    private void businessTermValidate(ExtendedDataEntity dataEntity) {
        DynamicObject orgObj = dataEntity.getDataEntity();
        Date businessTerm = orgObj.getDate("businessterm");
        if (businessTerm == null) {
            return;
        }
        Date establishmentDate = orgObj.getDate("establishmentdate");
        if (establishmentDate == null) {
            return;
        }
        if (businessTerm.compareTo(establishmentDate) <= 0) {
            this.validatorHandler.handle(dataEntity, OrgMessage.getMessage((String)"M00163"));
        }
    }
}

