/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin.save;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.opplugin.common.OrgComparator;
import kd.bos.org.opplugin.common.OrgSorter;
import kd.bos.org.opplugin.model.OrgChangeDataProvider;
import kd.bos.org.opplugin.model.OrgOpContext;

public class OrgValidatorPreparation {
    private static final Log logger = LogFactory.getLog(OrgValidatorPreparation.class);
    private final OrgOpContext orgOpContext;
    private final ExtendedDataEntity[] dataEntities;
    private final boolean validateAndSave;
    private final OrgChangeDataProvider changeDataProvider;

    public OrgValidatorPreparation(OrgOpContext orgOpContext, ExtendedDataEntity[] dataEntities, boolean validateAndSave) {
        this.orgOpContext = orgOpContext;
        this.dataEntities = dataEntities;
        this.validateAndSave = validateAndSave;
        this.changeDataProvider = this.orgOpContext.getChangeDataProvider();
    }

    public void execute() {
        this.prepareSave();
        Set validateViewIds = this.changeDataProvider.getChangedViewIds();
        this.addValidateViewIds(validateViewIds);
        logger.info("\u3010\u7ec4\u7ec7\u4fdd\u5b58\u64cd\u4f5c\u3011\u9700\u8981\u6821\u9a8c\u7684\u89c6\u56fe\u65b9\u6848ID\uff1a" + validateViewIds);
        OrgSorter orgSorter = new OrgSorter(this.orgOpContext, this.dataEntities, validateViewIds, this.validateAndSave);
        orgSorter.sort();
    }

    private void prepareSave() {
        if (!this.orgOpContext.isCompared().booleanValue()) {
            ArrayList<DynamicObject> compareOrgList = new ArrayList<DynamicObject>(this.dataEntities.length);
            ExtendedDataEntity[] extendedDataEntityArray = this.dataEntities;
            int n = extendedDataEntityArray.length;
            for (int i = 0; i < n; ++i) {
                ExtendedDataEntity dataEntity = extendedDataEntityArray[i];
                compareOrgList.add(dataEntity.getDataEntity());
            }
            OrgComparator orgComparator = new OrgComparator(this.orgOpContext, new HashMap(compareOrgList.size()), compareOrgList);
            orgComparator.compare();
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject orgObj = dataEntity.getDataEntity();
            long id = orgObj.getLong("id");
            this.orgOpContext.getDataEntityMap().put(id, dataEntity);
        }
    }

    private void addValidateViewIds(Set<Long> validateViewIds) {
        Long viewTypeId = null;
        Map viewObjMap = this.orgOpContext.getDataProvider().getViewDynamicObjectMap();
        Set changedViewIds = this.changeDataProvider.getChangedViewIds();
        if (this.validateAndSave) {
            if (changedViewIds.isEmpty()) {
                return;
            }
            viewTypeId = this.getChangedViewType(changedViewIds, viewObjMap);
        }
        for (Map.Entry viewEntry : viewObjMap.entrySet()) {
            DynamicObject viewObj = (DynamicObject)viewEntry.getValue();
            DynamicObject bizObj = viewObj.getDynamicObject("treetypeid");
            if (bizObj == null) continue;
            long viewId = viewObj.getLong("id");
            if (viewTypeId == null) {
                validateViewIds.add(viewId);
                continue;
            }
            if (!viewTypeId.equals(bizObj.getPkValue())) continue;
            boolean validate = false;
            if (changedViewIds.contains(viewId)) {
                validate = true;
            } else if (viewObj.getBoolean("isdefault") && 16L != viewTypeId) {
                validate = true;
            }
            if (!validate) continue;
            validateViewIds.add(viewId);
        }
    }

    private Long getChangedViewType(Set<Long> changedViewIds, Map<Object, DynamicObject> viewObjMap) {
        Long viewTypeId = null;
        for (Long viewId : changedViewIds) {
            DynamicObject bizObj;
            if (0L == viewId) {
                viewTypeId = null;
                break;
            }
            if (15L == viewId) {
                viewTypeId = null;
                break;
            }
            DynamicObject viewObj = viewObjMap.get(viewId);
            if (viewObj == null || (bizObj = viewObj.getDynamicObject("treetypeid")) == null) continue;
            if (viewTypeId == null) {
                viewTypeId = bizObj.getLong("id");
                continue;
            }
            if (viewTypeId.longValue() == bizObj.getLong("id")) continue;
            viewTypeId = null;
            break;
        }
        return viewTypeId;
    }
}

