/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.opplugin.save;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.org.opplugin.IOrgOpValidatorHandler;
import kd.bos.org.opplugin.model.OrgChangeData;
import kd.bos.org.opplugin.model.OrgOpContext;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class OrgViewValidator {
    private final OrgOpContext orgOpContext;
    private final IOrgOpValidatorHandler validatorHandler;
    private final ExtendedDataEntity dataEntity;
    private Map<Long, DynamicObject> viewStructureMap;
    private Map<Long, Map<String, OrgChangeData>> viewDeletedMap;

    public OrgViewValidator(OrgOpContext orgOpContext, ExtendedDataEntity dataEntity) {
        this.orgOpContext = orgOpContext;
        this.dataEntity = dataEntity;
        this.validatorHandler = this.orgOpContext.getValidatorHandler();
        this.viewDeletedMap = this.orgOpContext.getChangeDataProvider().getViewChangeData(this.dataEntity.getDataEntity().getLong("id"), "delete");
    }

    public Map<Long, DynamicObject> validate() {
        this.viewStructureMap = this.getValidViewStructureMap();
        if (this.viewStructureMap.isEmpty()) {
            this.validateDeleteView(new ArrayList<Long>(0));
            return this.viewStructureMap;
        }
        Set validateViewIds = this.orgOpContext.getChangeDataProvider().getChangedViewIds();
        if (validateViewIds.isEmpty()) {
            return this.viewStructureMap;
        }
        int count = this.viewStructureMap.size();
        HashMap<String, DynamicObject> defaultViewObjMap = new HashMap<String, DynamicObject>(count);
        ArrayList<Long> defaultViewIds = new ArrayList<Long>(count);
        HashMap<String, List<DynamicObject>> customViewObjMap = new HashMap<String, List<DynamicObject>>(count);
        this.parseViewStructure(defaultViewObjMap, defaultViewIds, customViewObjMap);
        this.validateDeleteView(defaultViewIds);
        this.validateInOrgManageMode(defaultViewIds);
        this.validateCustomView(defaultViewObjMap, customViewObjMap);
        return this.viewStructureMap;
    }

    private Map<Long, DynamicObject> getValidViewStructureMap() {
        boolean isAddOrg;
        DynamicObject orgObj = this.dataEntity.getDataEntity();
        DynamicObjectCollection structureObjCol = orgObj.getDynamicObjectCollection("structure");
        int viewCount = structureObjCol.size();
        HashMap<Long, DynamicObject> validViewStructureMap = new HashMap<Long, DynamicObject>(viewCount);
        boolean bl = isAddOrg = !this.dataEntity.getDataEntity().getDataEntityState().getFromDatabase();
        if (isAddOrg && 0 == viewCount) {
            this.validatorHandler.handle(this.dataEntity, OrgMessage.getMessage((String)"M00002"));
        }
        for (DynamicObject structureObj : structureObjCol) {
            DynamicObject viewObj = this.getValidateView(structureObj);
            if (viewObj == null) continue;
            long viewId = viewObj.getLong("id");
            if (validViewStructureMap.containsKey(viewId)) {
                this.validatorHandler.handle(this.dataEntity, OrgMessage.getMessage((String)"M00177", (Object[])new Object[]{orgObj.getString("name"), viewObj.getString("name")}));
                continue;
            }
            validViewStructureMap.put(viewId, structureObj);
            this.setFunctionProperty(orgObj, viewObj);
        }
        return validViewStructureMap;
    }

    private void validateDeleteView(List<Long> defaultViewIds) {
        if (!this.viewDeletedMap.isEmpty()) {
            this.validateDeleteAdminOrg();
            this.validateDeleteOrgUnit(defaultViewIds);
        }
    }

    private DynamicObject getValidateView(DynamicObject structureObj) {
        DynamicObject viewObj = structureObj.getDynamicObject("view");
        if (viewObj == null) {
            this.validatorHandler.handle(this.dataEntity, OrgMessage.getMessage((String)"M00002"));
            return null;
        }
        viewObj = (DynamicObject)this.orgOpContext.getDataProvider().getViewDynamicObjectMap().get(viewObj.getPkValue());
        if (viewObj == null) {
            this.validatorHandler.handle(this.dataEntity, OrgMessage.getMessage((String)"M00016"));
            return null;
        }
        if (viewObj.getDynamicObject("treetypeid") == null) {
            this.validatorHandler.handle(this.dataEntity, OrgMessage.getMessage((String)"M00001"));
            return null;
        }
        return viewObj;
    }

    private void setFunctionProperty(DynamicObject orgObj, DynamicObject viewObj) {
        if (!viewObj.getBoolean("isdefault")) {
            return;
        }
        DynamicObject bizObj = viewObj.getDynamicObject("treetypeid");
        String propertyName = bizObj.getString("propertyname");
        if (StringUtils.isNotBlank((CharSequence)propertyName)) {
            orgObj.set(propertyName, (Object)Boolean.TRUE);
        }
    }

    private void validateDeleteAdminOrg() {
        if (!this.dataEntity.getDataEntity().getBoolean("isbizorg") && this.viewDeletedMap.containsKey(1L)) {
            this.validatorHandler.handle(this.dataEntity, OrgMessage.getMessage((String)"M00089"));
        }
    }

    private void validateDeleteOrgUnit(List<Long> defaultViewIds) {
        if (!this.viewDeletedMap.containsKey(15L)) {
            return;
        }
        if (!defaultViewIds.contains(1L)) {
            this.validatorHandler.handle(this.dataEntity, OrgMessage.getMessage((String)"M00108"));
            return;
        }
        for (Long viewId : defaultViewIds) {
            if (viewId == 1L || viewId == 15L || viewId == 16L) continue;
            this.validatorHandler.handle(this.dataEntity, OrgMessage.getMessage((String)"M00107"));
            return;
        }
    }

    private void validateInOrgManageMode(List<Long> defaultViewIds) {
        int orgManageMode = this.orgOpContext.getConfigProvider().getOrgManageMode();
        if (1 != orgManageMode) {
            return;
        }
        ArrayList<Long> checkViewIds = new ArrayList<Long>(defaultViewIds);
        checkViewIds.remove(1L);
        checkViewIds.remove(15L);
        checkViewIds.remove(16L);
        DynamicObject orgObj = this.dataEntity.getDataEntity();
        long orgId = orgObj.getLong("id");
        QFilter enableFilter = new QFilter("org.enable", "=", (Object)Boolean.TRUE);
        QFilter viewFilter = new QFilter("view", "in", checkViewIds);
        enableFilter = enableFilter.and(viewFilter);
        QFilter orgFilter = new QFilter("org", "!=", (Object)orgId);
        QFilter[] qFilters = new QFilter[]{enableFilter, orgFilter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"OrgViewValidator.validateInOrgManageMode", (String)"bos_org_structure", (String)"view", (QFilter[])qFilters, (String)"");){
            ArrayList<Long> errorVewIds = new ArrayList<Long>(checkViewIds.size());
            for (Row row : ds) {
                Long viewId = row.getLong("view");
                if (errorVewIds.contains(viewId)) continue;
                errorVewIds.add(viewId);
                DynamicObject viewObj = (DynamicObject)this.orgOpContext.getDataProvider().getViewDynamicObjectMap().get(viewId);
                String viewName = "";
                if (viewObj != null) {
                    viewName = viewObj.getString("name");
                }
                this.validatorHandler.handle(this.dataEntity, OrgMessage.getMessage((String)"M00105", (Object[])new Object[]{viewName}));
                checkViewIds.remove(viewId);
                if (!checkViewIds.isEmpty()) continue;
                break;
            }
        }
    }

    private void validateCustomView(Map<String, DynamicObject> defaultViewObjMap, Map<String, List<DynamicObject>> customViewObjMap) {
        for (Map.Entry<String, List<DynamicObject>> viewEntry : customViewObjMap.entrySet()) {
            DynamicObject defaultViewObj;
            String viewType = viewEntry.getKey();
            if ("16".equals(viewType) || (defaultViewObj = defaultViewObjMap.get(viewType)) != null) continue;
            defaultViewObj = this.orgOpContext.getDataProvider().getDefaultViewDynamicObject(viewType);
            if (defaultViewObj == null) {
                this.validatorHandler.handle(this.dataEntity, OrgMessage.getMessage((String)"M00194", (Object[])new Object[]{viewType}));
                continue;
            }
            boolean isDeleteDefaultView = this.viewDeletedMap.containsKey(defaultViewObj.getLong("id"));
            List<DynamicObject> customViewList = viewEntry.getValue();
            String orgName = this.dataEntity.getDataEntity().getString("name");
            DynamicObject defaultViewDynamicObject = this.orgOpContext.getDataProvider().getDefaultViewDynamicObject(viewType);
            String defaultViewName = defaultViewDynamicObject == null ? "" : defaultViewDynamicObject.getString("name");
            for (DynamicObject customViewObj : customViewList) {
                if (isDeleteDefaultView) {
                    this.validatorHandler.handle(this.dataEntity, OrgMessage.getMessage((String)"M00109", (Object[])new Object[]{orgName, defaultViewName, customViewObj.getString("name")}));
                    continue;
                }
                this.validatorHandler.handle(this.dataEntity, OrgMessage.getMessage((String)"M00103", (Object[])new Object[]{orgName, customViewObj.getString("name"), defaultViewName}));
            }
        }
    }

    private void parseViewStructure(Map<String, DynamicObject> defaultViewObjMap, List<Long> defaultViewIds, Map<String, List<DynamicObject>> customViewObjMap) {
        Map viewDynamicObjectMap = this.orgOpContext.getDataProvider().getViewDynamicObjectMap();
        for (Map.Entry<Long, DynamicObject> viewStructEntry : this.viewStructureMap.entrySet()) {
            DynamicObject structureObj = viewStructEntry.getValue();
            DynamicObject viewObj = structureObj.getDynamicObject("view");
            if (this.validateViewChanged(viewObj = (DynamicObject)viewDynamicObjectMap.get(viewObj.getPkValue()))) continue;
            String viewType = viewObj.getString("treetype");
            if (viewObj.getBoolean("isdefault")) {
                defaultViewObjMap.put(viewType, viewObj);
                defaultViewIds.add(viewStructEntry.getKey());
                continue;
            }
            customViewObjMap.computeIfAbsent(viewType, k -> new ArrayList(this.viewStructureMap.size())).add(viewObj);
        }
    }

    private boolean validateViewChanged(DynamicObject viewObj) {
        long id = this.dataEntity.getDataEntity().getLong("id");
        long viewId = viewObj.getLong("id");
        OrgChangeData changeData = this.orgOpContext.getChangeDataProvider().getStructureProperty(id, viewId, "view");
        if (changeData == null) {
            return false;
        }
        this.validatorHandler.handle(this.dataEntity, OrgMessage.getMessage((String)"M00178", (Object[])new Object[]{((DynamicObject)changeData.getOldValue()).getString("name"), viewObj.getString("name")}));
        return true;
    }
}

