/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.yunzhijia.diff.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.Utils;
import kd.bos.org.yunzhijia.model.SyncReport;
import kd.bos.org.yunzhijia.model.SyncReportEntry;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class YzjSyncReport {
    private static final Log log = LogFactory.getLog(YzjSyncReport.class);
    private static final int LIMIT_COUNT = 1000;

    public static void add(SyncReport report) {
        if (report == null) {
            return;
        }
        YzjSyncReport.add(Collections.singletonList(report));
    }

    public static void add(List<SyncReport> reportList) {
        if (Utils.isListEmpty(reportList)) {
            return;
        }
        log.info("\u5f53\u524d\u8bb0\u5f55\u7684\u5dee\u5f02\u62a5\u544a\u6761\u6570\uff1a" + reportList.size());
        ArrayList<DynamicObject> saveEntryList = new ArrayList<DynamicObject>(1000);
        String userId = RequestContext.get().getUserId();
        Date time = new Date();
        int currentCount = 0;
        for (SyncReport report : reportList) {
            DynamicObject reportObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_yzj_syncreport");
            ++currentCount;
            reportObj.set("task", (Object)report.getTaskId());
            reportObj.set("yzjdataid", (Object)report.getYzjDataId());
            reportObj.set("erpdataid", (Object)report.getErpDataId());
            reportObj.set("datatype", (Object)report.getDataType());
            reportObj.set("syncobject", (Object)report.getSyncObject());
            reportObj.set("creator", (Object)userId);
            reportObj.set("createtime", (Object)time);
            reportObj.set("status", (Object)report.getStatus());
            DynamicObjectCollection reportEntryCol = reportObj.getDynamicObjectCollection("entryentity");
            if (reportEntryCol != null) {
                DynamicObjectType reportEntryType = reportEntryCol.getDynamicObjectType();
                int seq = 1;
                for (SyncReportEntry reportEntry : report.getEntryList()) {
                    DynamicObject reportEntryObj = new DynamicObject(reportEntryType);
                    reportEntryObj.set("seq", (Object)seq++);
                    reportEntryObj.set("operation", (Object)reportEntry.getOperation());
                    reportEntryObj.set("property", (Object)reportEntry.getProperty());
                    reportEntryObj.set("yzjvalue", (Object)reportEntry.getYzjValue());
                    reportEntryObj.set("erpvalue", (Object)reportEntry.getErpValue());
                    reportEntryObj.set("description", (Object)reportEntry.getNote());
                    reportEntryCol.add((Object)reportEntryObj);
                    ++currentCount;
                }
            }
            saveEntryList.add(reportObj);
            if (currentCount < 1000) continue;
            SaveServiceHelper.save((DynamicObject[])saveEntryList.toArray(new DynamicObject[saveEntryList.size()]));
            currentCount = 0;
            saveEntryList.clear();
        }
        if (!saveEntryList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saveEntryList.toArray(new DynamicObject[saveEntryList.size()]));
        }
    }

    public static void update(SyncReport report) {
    }
}

