/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.yunzhijia.diff.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.Utils;
import kd.bos.org.yunzhijia.diff.impl.YzjSyncTaskClear;
import kd.bos.org.yunzhijia.diff.impl.org.OrgSyncImpl;
import kd.bos.org.yunzhijia.diff.impl.org.OrgSyncOperation;
import kd.bos.org.yunzhijia.diff.impl.user.UserSyncImpl;
import kd.bos.org.yunzhijia.diff.impl.user.UserSyncOperation;
import kd.bos.org.yunzhijia.diff.impl.utils.YzjSyncCache;
import kd.bos.org.yunzhijia.diff.impl.utils.YzjSyncImplUtils;
import kd.bos.org.yunzhijia.model.SyncContextParam;
import kd.bos.org.yunzhijia.model.SyncTask;
import kd.bos.org.yunzhijia.model.SyncTaskStatus;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.yzj.model.YzjConfig;
import org.apache.commons.lang.time.DateFormatUtils;

public class YzjSyncTaskAction {
    private static final Log log = LogFactory.getLog(YzjSyncTaskAction.class);

    public static String start(YzjConfig yzjConfig) {
        String resultMsg = YzjSyncImplUtils.checkTaskRunning();
        if (StringUtils.isNotBlank((CharSequence)resultMsg)) {
            return resultMsg;
        }
        try {
            YzjSyncCache.startTaskProgress();
            resultMsg = YzjSyncTaskAction.startAction(yzjConfig);
            if (StringUtils.isBlank((CharSequence)resultMsg)) {
                YzjSyncCache.finishTaskProgress();
            } else {
                log.info(resultMsg);
                YzjSyncCache.updateTaskFailProgress(resultMsg);
            }
        }
        catch (Exception e) {
            resultMsg = e.getMessage() == null ? BaseMessage.getMessage((String)"M00035") : BaseMessage.getMessage((String)"M00036") + e.getMessage();
            log.warn("\u4e91\u4e4b\u5bb6\u5dee\u5f02\u5bf9\u6bd4\u4efb\u52a1\u5f02\u5e38: " + resultMsg, (Throwable)e);
            YzjSyncCache.updateTaskFailProgress(resultMsg);
        }
        finally {
            YzjSyncCache.removeTaskStatus();
        }
        return resultMsg;
    }

    private static String startAction(YzjConfig yzjConfig) {
        UserSyncImpl userSync;
        log.info("\u5f00\u59cb\u6267\u884c\u4e91\u4e4b\u5bb6\u5dee\u5f02\u5bf9\u6bd4");
        String resultMsg = "";
        if (yzjConfig == null) {
            resultMsg = BaseMessage.getMessage((String)"M00037");
            return resultMsg;
        }
        if (!yzjConfig.isSuccess()) {
            resultMsg = yzjConfig.getMsg();
            if (StringUtils.isBlank((CharSequence)resultMsg)) {
                resultMsg = BaseMessage.getMessage((String)"M00038");
            }
            return resultMsg;
        }
        if (2 != yzjConfig.getSyncMode()) {
            resultMsg = BaseMessage.getMessage((String)"M00039");
            return resultMsg;
        }
        int startModel = yzjConfig.getStartModel();
        boolean isAutomatic = yzjConfig.isAutoSync();
        String msg = yzjConfig.getMsg();
        long taskId = 0L;
        YzjSyncTaskAction.updateOldTaskStatus();
        YzjSyncCache.updateTaskProgress(ResManager.loadKDString((String)"\u6b63\u5728\u521b\u5efa\u4e91\u4e4b\u5bb6\u5dee\u5f02\u5bf9\u6bd4\u4efb\u52a1\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"YzjSyncTaskAction_0", (String)"bos-org-formplugin", (Object[])new Object[0]));
        taskId = YzjSyncTaskAction.addTask(startModel, isAutomatic, yzjConfig);
        if (!yzjConfig.isSuccess()) {
            return msg;
        }
        log.info("\u5f00\u59cb\u6267\u884c\u4e91\u4e4b\u5bb6\u5dee\u5f02\u5bf9\u6bd4\u4efb\u52a1\u3002");
        SyncTask task = new SyncTask();
        task.setId(taskId);
        SyncContextParam contextParam = new SyncContextParam();
        contextParam.setTaskId(taskId);
        contextParam.setYzjConfig(yzjConfig);
        if (startModel == 0 || startModel == 1) {
            OrgSyncImpl orgSync = new OrgSyncImpl(contextParam);
            if (!orgSync.execute()) {
                msg = BaseMessage.getMessage((String)"M00040");
                task.setStatus(SyncTaskStatus.ERROR.value());
                task.setNote(msg);
                YzjSyncTaskAction.updateTask(task);
                return msg;
            }
            UserSyncImpl userSync2 = new UserSyncImpl(contextParam);
            if (!userSync2.execute()) {
                msg = BaseMessage.getMessage((String)"M00041");
                task.setStatus(SyncTaskStatus.ERROR.value());
                task.setNote(msg);
                YzjSyncTaskAction.updateTask(task);
                return msg;
            }
        } else if (startModel == 2 && !(userSync = new UserSyncImpl(contextParam)).checkOpenId()) {
            msg = BaseMessage.getMessage((String)"M00041");
            task.setStatus(SyncTaskStatus.ERROR.value());
            task.setNote(msg);
            YzjSyncTaskAction.updateTask(task);
            return msg;
        }
        YzjSyncCache.updateTaskProgress(ResManager.loadKDString((String)"\u6b63\u5728\u66f4\u65b0\u4e91\u4e4b\u5bb6\u5dee\u5f02\u5bf9\u6bd4\u4efb\u52a1\u4fe1\u606f\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"YzjSyncTaskAction_1", (String)"bos-org-formplugin", (Object[])new Object[0]));
        task.setStatus(isAutomatic ? SyncTaskStatus.AUTOMATIC_SYNC.value() : SyncTaskStatus.MANUAL_SYNC.value());
        YzjSyncTaskAction.updateTask(task);
        if (isAutomatic) {
            YzjSyncTaskAction.updateSyncCount(taskId);
        }
        YzjSyncCache.updateTaskProgress(ResManager.loadKDString((String)"\u6b63\u5728\u6e05\u7406\u4e91\u4e4b\u5bb6\u5dee\u5f02\u5bf9\u6bd4\u5386\u53f2\u62a5\u544a\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"YzjSyncTaskAction_2", (String)"bos-org-formplugin", (Object[])new Object[0]));
        YzjSyncTaskClear.execute(yzjConfig.getKeepSyncTaskCount());
        log.info("\u7ed3\u675f\u6267\u884c\u4e91\u4e4b\u5bb6\u5dee\u5f02\u5bf9\u6bd4");
        return resultMsg;
    }

    public static void syncAll(long taskId) {
        String resultMsg = YzjSyncImplUtils.checkTaskRunning();
        if (StringUtils.isNotBlank((CharSequence)resultMsg)) {
            throw new KDBizException(resultMsg);
        }
        try {
            SyncContextParam contextParam = new SyncContextParam();
            contextParam.setTaskId(taskId);
            OrgSyncOperation orgSync = new OrgSyncOperation(contextParam);
            orgSync.sync();
            UserSyncOperation userSync = new UserSyncOperation(contextParam);
            userSync.sync();
            YzjSyncTaskAction.updateSyncCount(taskId);
        }
        catch (Exception e) {
            YzjSyncCache.updateTaskFailProgress(e.getMessage());
            throw new KDBizException(e.getMessage());
        }
        finally {
            YzjSyncCache.removeTaskStatus();
        }
    }

    public static void syncByReportId(long taskId, List<Long> reportIds) {
        String resultMsg = YzjSyncImplUtils.checkTaskRunning();
        if (StringUtils.isNotBlank((CharSequence)resultMsg)) {
            throw new KDBizException(resultMsg);
        }
        try {
            SyncContextParam contextParam = new SyncContextParam();
            contextParam.setTaskId(taskId);
            OrgSyncOperation orgSync = new OrgSyncOperation(contextParam);
            orgSync.syncByReportId(reportIds);
            UserSyncOperation userSync = new UserSyncOperation(contextParam);
            userSync.syncByReportId(reportIds);
            YzjSyncTaskAction.updateSyncCount(taskId);
        }
        catch (Exception e) {
            YzjSyncCache.updateTaskFailProgress(e.getMessage());
            throw new KDBizException(e.getMessage());
        }
        finally {
            YzjSyncCache.removeTaskStatus();
        }
    }

    private static void updateSyncCount(long taskId) {
        String selectProperties = "count(1) total";
        QFilter taskFilter = new QFilter("task", "=", (Object)taskId);
        QFilter statusFilter = new QFilter("status", "=", (Object)Integer.toString(1));
        QFilter[] filters = new QFilter[]{taskFilter, statusFilter};
        DynamicObjectCollection reportCol = QueryServiceHelper.query((String)"bos_yzj_syncreport", (String)selectProperties, (QFilter[])filters);
        int updatedCount = 0;
        if (Utils.isListNotEmpty((List)reportCol)) {
            updatedCount = ((DynamicObject)reportCol.get(0)).getInt("total");
        }
        if (updatedCount == 0) {
            return;
        }
        selectProperties = "id,normalcount,synccount,unsynccount";
        QFilter idFilter = new QFilter("id", "=", (Object)taskId);
        filters = new QFilter[]{idFilter};
        DynamicObject[] taskArr = BusinessDataServiceHelper.load((String)"bos_yzj_synctask", (String)selectProperties, (QFilter[])filters);
        if (taskArr == null || taskArr.length == 0) {
            return;
        }
        for (DynamicObject taskObj : taskArr) {
            int normalCount = taskObj.getInt("normalcount");
            taskObj.set("synccount", (Object)updatedCount);
            taskObj.set("unsynccount", (Object)(normalCount - updatedCount));
        }
        SaveServiceHelper.save((DynamicObject[])taskArr);
    }

    private static void updateOldTaskStatus() {
        log.info("\u5f00\u59cb\u66f4\u65b0\u65e7\u4efb\u52a1\u7684\u201c\u6700\u65b0\u201d\u6807\u5fd7\u3002");
        int oldTaskStatus = SyncTaskStatus.MANUAL_SYNC.value();
        QFilter statusFilter = new QFilter("status", "=", (Object)Integer.toString(oldTaskStatus));
        QFilter islastFilter = new QFilter("islatest", "=", (Object)Boolean.TRUE);
        statusFilter.or(islastFilter);
        QFilter[] filters = new QFilter[]{statusFilter};
        String selectProperties = "status,islatest";
        DynamicObject[] taskArr = BusinessDataServiceHelper.load((String)"bos_yzj_synctask", (String)selectProperties, (QFilter[])filters);
        if (taskArr != null && taskArr.length > 0) {
            for (DynamicObject task : taskArr) {
                if (task.getInt("status") == oldTaskStatus) {
                    task.set("status", (Object)SyncTaskStatus.OUTMODED.value());
                }
                task.set("islatest", (Object)Boolean.FALSE);
            }
            SaveServiceHelper.save((DynamicObject[])taskArr);
            log.info("\u5b8c\u6210\u66f4\u65b0\u65e7\u4efb\u52a1\u7684\u201c\u6700\u65b0\u201d\u6807\u5fd7\u3002");
        }
    }

    private static long addTask(int startModel, boolean isAutomatic, YzjConfig yzjConfig) {
        log.info("\u5f00\u59cb\u8bb0\u5f55\u4e91\u4e4b\u5bb6\u5dee\u5f02\u5bf9\u6bd4\u4efb\u52a1\u4fe1\u606f\u3002");
        SyncTask task = new SyncTask();
        Calendar cal = Calendar.getInstance();
        String taskName = DateFormatUtils.format((Calendar)cal, (String)"yyyyMMddHHmmss");
        taskName = startModel == 1 ? "Manual-" + taskName : (startModel == 2 ? "Account-" + taskName : "Automatic-" + taskName);
        task.setNumber(taskName);
        task.setName(taskName);
        long userId = RequestContext.get().getCurrUserId();
        task.setExecutor(userId);
        task.setStartTime(cal.getTime());
        if (yzjConfig.isSuccess()) {
            task.setStatus(isAutomatic ? SyncTaskStatus.AUTOMATIC_SYNC.value() : SyncTaskStatus.MANUAL_SYNC.value());
        } else {
            task.setStatus(SyncTaskStatus.ERROR.value());
            task.setNote(yzjConfig.getMsg());
        }
        return YzjSyncTaskAction.addTask(task);
    }

    public static long addTask(SyncTask task) {
        DynamicObject taskObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_yzj_synctask");
        if (task.getId() > 0L && !QueryServiceHelper.exists((String)"bos_yzj_synctask", (Object)task.getId())) {
            taskObj.set("id", (Object)task.getId());
        }
        taskObj.set("number", (Object)task.getNumber());
        taskObj.set("name", (Object)task.getName());
        taskObj.set("executor", (Object)task.getExecutor());
        taskObj.set("starttime", (Object)task.getStartTime());
        taskObj.set("status", (Object)task.getStatus());
        taskObj.set("islatest", (Object)Boolean.TRUE);
        taskObj.set("description", (Object)task.getNote());
        DynamicObject[] result = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskObj});
        if (result == null || result.length == 0) {
            log.error("\u8bb0\u5f55\u4e91\u4e4b\u5bb6\u5dee\u5f02\u5bf9\u6bd4\u4efb\u52a1\u4fe1\u606f\u5931\u8d25\u3002");
            return 0L;
        }
        log.info("\u5b8c\u6210\u8bb0\u5f55\u4e91\u4e4b\u5bb6\u5dee\u5f02\u5bf9\u6bd4\u4efb\u52a1\u4fe1\u606f\u3002");
        return result[0].getLong("id");
    }

    private static void updateTask(SyncTask task) {
        String selectProperties = "id,status,description,endtime,total,normalcount,unsynccount,exceptioncount";
        QFilter idFilter = new QFilter("id", "=", (Object)task.getId());
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject[] taskArr = BusinessDataServiceHelper.load((String)"bos_yzj_synctask", (String)selectProperties, (QFilter[])filters);
        if (taskArr == null || taskArr.length == 0) {
            return;
        }
        YzjSyncTaskAction.countTask(task);
        for (DynamicObject taskObj : taskArr) {
            taskObj.set("status", (Object)task.getStatus());
            taskObj.set("description", (Object)task.getNote());
            taskObj.set("endtime", (Object)new Date());
            taskObj.set("total", (Object)task.getTotal());
            taskObj.set("normalcount", (Object)task.getNormalCount());
            taskObj.set("unsynccount", (Object)task.getNormalCount());
            taskObj.set("exceptioncount", (Object)task.getExceptionCount());
        }
        SaveServiceHelper.save((DynamicObject[])taskArr);
    }

    private static void countTask(SyncTask task) {
        String selectProperties = "count(1) total";
        QFilter taskFilter = new QFilter("task", "=", (Object)task.getId());
        QFilter[] filters = new QFilter[]{taskFilter};
        DynamicObjectCollection reportCol = QueryServiceHelper.query((String)"bos_yzj_syncreport", (String)selectProperties, (QFilter[])filters);
        if (Utils.isListEmpty((List)reportCol)) {
            return;
        }
        int total = ((DynamicObject)reportCol.get(0)).getInt("total");
        task.setTotal(total);
        QFilter statusFilter = new QFilter("status", "=", (Object)Integer.toString(3));
        filters = new QFilter[]{taskFilter, statusFilter};
        reportCol = QueryServiceHelper.query((String)"bos_yzj_syncreport", (String)selectProperties, (QFilter[])filters);
        int exceptionCount = 0;
        if (Utils.isListNotEmpty((List)reportCol)) {
            exceptionCount = ((DynamicObject)reportCol.get(0)).getInt("total");
        }
        task.setExceptionCount(exceptionCount);
        task.setNormalCount(total - exceptionCount);
    }
}

