/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.yunzhijia.diff.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class YzjSyncTaskClear {
    private static final int BATCH_PER_COUNT = 1000;

    public static void execute(int keepDays) {
        Date date = Utils.getDate((int)(-keepDays));
        QFilter createtimeFilter = new QFilter("starttime", "<", (Object)date);
        QFilter[] filters = new QFilter[]{createtimeFilter};
        ArrayList<Long> taskIds = new ArrayList<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.bos.org.yunzhijia.diff.impl.YzjSyncTaskClear.execute", (String)"bos_yzj_synctask", (String)"id", (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                taskIds.add(row.getLong("id"));
            }
        }
        YzjSyncTaskClear.execute(taskIds);
    }

    public static void execute(List<Long> taskIds) {
        if (Utils.isListEmpty(taskIds)) {
            return;
        }
        for (long taskId : taskIds) {
            YzjSyncTaskClear.delete(taskId);
        }
    }

    public static void delete(long taskId) {
        try (TXHandle tx = TX.required();){
            try {
                QFilter idFilter = new QFilter("id", "=", (Object)taskId);
                QFilter[] filters = new QFilter[]{idFilter};
                DeleteServiceHelper.delete((String)"bos_yzj_synctask", (QFilter[])filters);
                QFilter taskFilter = new QFilter("task", "=", (Object)taskId);
                QFilter[] taskFilters = new QFilter[]{taskFilter};
                DeleteServiceHelper.delete((String)"bos_yzj_syncreport", (QFilter[])taskFilters);
                YzjSyncTaskClear.deleteUser(taskFilters);
                QFilter orgFilter = new QFilter("org.task", "=", (Object)taskId);
                QFilter[] orgstruFilters = new QFilter[]{orgFilter};
                DeleteServiceHelper.delete((String)"bos_yzj_orgstructure", (QFilter[])orgstruFilters);
                DeleteServiceHelper.delete((String)"bos_yzj_org", (QFilter[])taskFilters);
            }
            catch (Exception e) {
                tx.markRollback();
            }
        }
    }

    private static void deleteUser(QFilter[] taskFilters) {
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.bos.org.yunzhijia.diff.impl.YzjSyncTaskClear.deleteUser", (String)"bos_yzj_user", (String)"id", (QFilter[])taskFilters, (String)"", (int)1000);){
            if (ds.hasNext()) {
                ArrayList<Long> ids = new ArrayList<Long>();
                for (Row row : ds) {
                    ids.add(row.getLong("id"));
                }
                QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
                DeleteServiceHelper.delete((String)"bos_yzj_user", (QFilter[])filters);
                YzjSyncTaskClear.deleteUser(taskFilters);
            }
        }
    }
}

